package com.armedia.acm.plugins.ecm.service;

/*-
 * #%L
 * ACM Service: Enterprise Content Management
 * %%
 * Copyright (C) 2014 - 2018 ArkCase LLC
 * %%
 * This file is part of the ArkCase software. 
 * 
 * If the software was purchased under a paid ArkCase license, the terms of 
 * the paid license agreement will prevail.  Otherwise, the software is 
 * provided under the following open source license terms:
 * 
 * ArkCase is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *  
 * ArkCase is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License
 * along with ArkCase. If not, see <http://www.gnu.org/licenses/>.
 * #L%
 */

import com.armedia.acm.plugins.ecm.model.AcmFolder;
import com.armedia.acm.plugins.ecm.model.EcmFile;
import com.armedia.acm.plugins.ecm.model.event.AcmFolderMovedEvent;
import com.armedia.acm.plugins.ecm.model.event.EcmFileMovedEvent;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.ApplicationEventPublisherAware;
import org.springframework.security.core.Authentication;

public class RecycleBinItemEventPublisher implements ApplicationEventPublisherAware
{

    private transient final Logger log = LogManager.getLogger(getClass());
    private ApplicationEventPublisher eventPublisher;

    @Override
    public void setApplicationEventPublisher(ApplicationEventPublisher applicationEventPublisher)
    {
        eventPublisher = applicationEventPublisher;
    }

    public void publishFileMovedToRecycleBinEvent(EcmFile source, Authentication auth, String ipAddress, boolean succeeded)
    {
        log.debug("Publishing a file {} moved to recycle bin event.", source.getFileId());
        EcmFileMovedEvent fileMovedEvent = new EcmFileMovedEvent(source, auth.getName(), ipAddress);
        fileMovedEvent.setSucceeded(succeeded);

        eventPublisher.publishEvent(fileMovedEvent);
    }

    public void publishFolderMovedToRecycleBinEvent(AcmFolder source, Authentication auth, String ipAddress, boolean succeeded)
    {
        log.debug("Publishing a folder {} moved to recycle bin event.", source.getId());
        AcmFolderMovedEvent folderMovedEvent = new AcmFolderMovedEvent(source, auth.getName(), ipAddress);
        folderMovedEvent.setSucceeded(succeeded);

        eventPublisher.publishEvent(folderMovedEvent);
    }
}
