<?php

/**
 * @package CRM
 * @copyright CiviCRM LLC https://civicrm.org/licensing
 *
 * Generated from xml/schema/CRM/Campaign/Survey.xml
 * DO NOT EDIT.  Generated by CRM_Core_CodeGen
 * (GenCodeChecksum:18f75c5ca402c23c569b37f7a2438b12)
 */

/**
 * Database access object for the Survey entity.
 */
class CRM_Campaign_DAO_Survey extends CRM_Core_DAO {
  const EXT = 'civicrm';
  const TABLE_ADDED = '3.2';
  const COMPONENT = 'CiviCampaign';

  /**
   * Static instance to hold the table name.
   *
   * @var string
   */
  public static $_tableName = 'civicrm_survey';

  /**
   * Icon associated with this entity.
   *
   * @var string
   */
  public static $_icon = 'fa-clipboard';

  /**
   * Field to show when displaying a record.
   *
   * @var string
   */
  public static $_labelField = 'title';

  /**
   * Should CiviCRM log any modifications to this table in the civicrm_log table.
   *
   * @var bool
   */
  public static $_log = FALSE;

  /**
   * Paths for accessing this entity in the UI.
   *
   * @var string[]
   */
  protected static $_paths = [
    'add' => 'civicrm/survey/add?reset=1',
    'update' => 'civicrm/survey/configure/main?reset=1&action=update&id=[id]',
    'delete' => 'civicrm/survey/delete?reset=1&id=[id]',
  ];

  /**
   * Survey id.
   *
   * @var int|string|null
   *   (SQL type: int unsigned)
   *   Note that values will be retrieved from the database as a string.
   */
  public $id;

  /**
   * Title of the Survey.
   *
   * @var string
   *   (SQL type: varchar(255))
   *   Note that values will be retrieved from the database as a string.
   */
  public $title;

  /**
   * Foreign key to the Campaign.
   *
   * @var int|string|null
   *   (SQL type: int unsigned)
   *   Note that values will be retrieved from the database as a string.
   */
  public $campaign_id;

  /**
   * Implicit FK to civicrm_option_value where option_group = activity_type
   *
   * @var int|string|null
   *   (SQL type: int unsigned)
   *   Note that values will be retrieved from the database as a string.
   */
  public $activity_type_id;

  /**
   * Script instructions for volunteers to use for the survey.
   *
   * @var string|null
   *   (SQL type: text)
   *   Note that values will be retrieved from the database as a string.
   */
  public $instructions;

  /**
   * Number of days for recurrence of release.
   *
   * @var int|string|null
   *   (SQL type: int unsigned)
   *   Note that values will be retrieved from the database as a string.
   */
  public $release_frequency;

  /**
   * Maximum number of contacts to allow for survey.
   *
   * @var int|string|null
   *   (SQL type: int unsigned)
   *   Note that values will be retrieved from the database as a string.
   */
  public $max_number_of_contacts;

  /**
   * Default number of contacts to allow for survey.
   *
   * @var int|string|null
   *   (SQL type: int unsigned)
   *   Note that values will be retrieved from the database as a string.
   */
  public $default_number_of_contacts;

  /**
   * Is this survey enabled or disabled/cancelled?
   *
   * @var bool|string
   *   (SQL type: tinyint)
   *   Note that values will be retrieved from the database as a string.
   */
  public $is_active;

  /**
   * Is this default survey?
   *
   * @var bool|string
   *   (SQL type: tinyint)
   *   Note that values will be retrieved from the database as a string.
   */
  public $is_default;

  /**
   * FK to civicrm_contact, who created this Survey.
   *
   * @var int|string|null
   *   (SQL type: int unsigned)
   *   Note that values will be retrieved from the database as a string.
   */
  public $created_id;

  /**
   * Date and time that Survey was created.
   *
   * @var string|null
   *   (SQL type: datetime)
   *   Note that values will be retrieved from the database as a string.
   */
  public $created_date;

  /**
   * FK to civicrm_contact, who recently edited this Survey.
   *
   * @var int|string|null
   *   (SQL type: int unsigned)
   *   Note that values will be retrieved from the database as a string.
   */
  public $last_modified_id;

  /**
   * Date and time that Survey was edited last time.
   *
   * @var string|null
   *   (SQL type: datetime)
   *   Note that values will be retrieved from the database as a string.
   */
  public $last_modified_date;

  /**
   * Used to store option group id.
   *
   * @var int|string|null
   *   (SQL type: int unsigned)
   *   Note that values will be retrieved from the database as a string.
   */
  public $result_id;

  /**
   * Bypass the email verification.
   *
   * @var bool|string
   *   (SQL type: tinyint)
   *   Note that values will be retrieved from the database as a string.
   */
  public $bypass_confirm;

  /**
   * Title for Thank-you page (header title tag, and display at the top of the page).
   *
   * @var string|null
   *   (SQL type: varchar(255))
   *   Note that values will be retrieved from the database as a string.
   */
  public $thankyou_title;

  /**
   * text and html allowed. displayed above result on success page
   *
   * @var string|null
   *   (SQL type: text)
   *   Note that values will be retrieved from the database as a string.
   */
  public $thankyou_text;

  /**
   * Can people share the petition through social media?
   *
   * @var bool|string
   *   (SQL type: tinyint)
   *   Note that values will be retrieved from the database as a string.
   */
  public $is_share;

  /**
   * Class constructor.
   */
  public function __construct() {
    $this->__table = 'civicrm_survey';
    parent::__construct();
  }

  /**
   * Returns localized title of this entity.
   *
   * @param bool $plural
   *   Whether to return the plural version of the title.
   */
  public static function getEntityTitle($plural = FALSE) {
    return $plural ? ts('Surveys') : ts('Survey');
  }

  /**
   * Returns all the column names of this table
   *
   * @return array
   */
  public static function &fields() {
    if (!isset(Civi::$statics[__CLASS__]['fields'])) {
      Civi::$statics[__CLASS__]['fields'] = [
        'id' => [
          'name' => 'id',
          'type' => CRM_Utils_Type::T_INT,
          'title' => ts('Survey ID'),
          'description' => ts('Survey id.'),
          'required' => TRUE,
          'usage' => [
            'import' => FALSE,
            'export' => FALSE,
            'duplicate_matching' => FALSE,
            'token' => FALSE,
          ],
          'where' => 'civicrm_survey.id',
          'table_name' => 'civicrm_survey',
          'entity' => 'Survey',
          'bao' => 'CRM_Campaign_BAO_Survey',
          'localizable' => 0,
          'html' => [
            'type' => 'Number',
          ],
          'readonly' => TRUE,
          'add' => '3.3',
        ],
        'title' => [
          'name' => 'title',
          'type' => CRM_Utils_Type::T_STRING,
          'title' => ts('Survey Title'),
          'description' => ts('Title of the Survey.'),
          'required' => TRUE,
          'maxlength' => 255,
          'size' => CRM_Utils_Type::HUGE,
          'usage' => [
            'import' => TRUE,
            'export' => TRUE,
            'duplicate_matching' => TRUE,
            'token' => FALSE,
          ],
          'import' => TRUE,
          'where' => 'civicrm_survey.title',
          'export' => TRUE,
          'table_name' => 'civicrm_survey',
          'entity' => 'Survey',
          'bao' => 'CRM_Campaign_BAO_Survey',
          'localizable' => 1,
          'html' => [
            'type' => 'Text',
          ],
          'add' => '3.3',
        ],
        'campaign_id' => [
          'name' => 'campaign_id',
          'type' => CRM_Utils_Type::T_INT,
          'title' => ts('Campaign ID'),
          'description' => ts('Foreign key to the Campaign.'),
          'usage' => [
            'import' => FALSE,
            'export' => FALSE,
            'duplicate_matching' => FALSE,
            'token' => FALSE,
          ],
          'where' => 'civicrm_survey.campaign_id',
          'default' => NULL,
          'table_name' => 'civicrm_survey',
          'entity' => 'Survey',
          'bao' => 'CRM_Campaign_BAO_Survey',
          'localizable' => 0,
          'FKClassName' => 'CRM_Campaign_DAO_Campaign',
          'FKColumnName' => 'id',
          'html' => [
            'type' => 'EntityRef',
            'label' => ts("Campaign"),
          ],
          'pseudoconstant' => [
            'table' => 'civicrm_campaign',
            'keyColumn' => 'id',
            'labelColumn' => 'title',
            'prefetch' => 'disabled',
          ],
          'add' => '3.3',
        ],
        'activity_type_id' => [
          'name' => 'activity_type_id',
          'type' => CRM_Utils_Type::T_INT,
          'title' => ts('Activity Type'),
          'description' => ts('Implicit FK to civicrm_option_value where option_group = activity_type'),
          'usage' => [
            'import' => TRUE,
            'export' => TRUE,
            'duplicate_matching' => TRUE,
            'token' => FALSE,
          ],
          'import' => TRUE,
          'where' => 'civicrm_survey.activity_type_id',
          'export' => TRUE,
          'default' => NULL,
          'table_name' => 'civicrm_survey',
          'entity' => 'Survey',
          'bao' => 'CRM_Campaign_BAO_Survey',
          'localizable' => 0,
          'html' => [
            'type' => 'Select',
          ],
          'pseudoconstant' => [
            'optionGroupName' => 'activity_type',
            'optionEditPath' => 'civicrm/admin/options/activity_type',
          ],
          'add' => '3.3',
        ],
        'instructions' => [
          'name' => 'instructions',
          'type' => CRM_Utils_Type::T_TEXT,
          'title' => ts('Instructions'),
          'description' => ts('Script instructions for volunteers to use for the survey.'),
          'rows' => 20,
          'cols' => 80,
          'usage' => [
            'import' => FALSE,
            'export' => FALSE,
            'duplicate_matching' => FALSE,
            'token' => FALSE,
          ],
          'where' => 'civicrm_survey.instructions',
          'table_name' => 'civicrm_survey',
          'entity' => 'Survey',
          'bao' => 'CRM_Campaign_BAO_Survey',
          'localizable' => 1,
          'html' => [
            'type' => 'RichTextEditor',
          ],
          'add' => '3.3',
        ],
        'release_frequency' => [
          'name' => 'release_frequency',
          'type' => CRM_Utils_Type::T_INT,
          'title' => ts('Survey Hold Duration'),
          'description' => ts('Number of days for recurrence of release.'),
          'usage' => [
            'import' => FALSE,
            'export' => FALSE,
            'duplicate_matching' => FALSE,
            'token' => FALSE,
          ],
          'where' => 'civicrm_survey.release_frequency',
          'default' => NULL,
          'table_name' => 'civicrm_survey',
          'entity' => 'Survey',
          'bao' => 'CRM_Campaign_BAO_Survey',
          'localizable' => 0,
          'add' => '3.3',
        ],
        'max_number_of_contacts' => [
          'name' => 'max_number_of_contacts',
          'type' => CRM_Utils_Type::T_INT,
          'title' => ts('Maximum number of contacts'),
          'description' => ts('Maximum number of contacts to allow for survey.'),
          'usage' => [
            'import' => FALSE,
            'export' => FALSE,
            'duplicate_matching' => FALSE,
            'token' => FALSE,
          ],
          'where' => 'civicrm_survey.max_number_of_contacts',
          'default' => NULL,
          'table_name' => 'civicrm_survey',
          'entity' => 'Survey',
          'bao' => 'CRM_Campaign_BAO_Survey',
          'localizable' => 0,
          'add' => '3.3',
        ],
        'default_number_of_contacts' => [
          'name' => 'default_number_of_contacts',
          'type' => CRM_Utils_Type::T_INT,
          'title' => ts('Default number of contacts'),
          'description' => ts('Default number of contacts to allow for survey.'),
          'usage' => [
            'import' => FALSE,
            'export' => FALSE,
            'duplicate_matching' => FALSE,
            'token' => FALSE,
          ],
          'where' => 'civicrm_survey.default_number_of_contacts',
          'default' => NULL,
          'table_name' => 'civicrm_survey',
          'entity' => 'Survey',
          'bao' => 'CRM_Campaign_BAO_Survey',
          'localizable' => 0,
          'add' => '3.3',
        ],
        'is_active' => [
          'name' => 'is_active',
          'type' => CRM_Utils_Type::T_BOOLEAN,
          'title' => ts('Survey Is Active'),
          'description' => ts('Is this survey enabled or disabled/cancelled?'),
          'required' => TRUE,
          'usage' => [
            'import' => FALSE,
            'export' => FALSE,
            'duplicate_matching' => FALSE,
            'token' => FALSE,
          ],
          'where' => 'civicrm_survey.is_active',
          'default' => '1',
          'table_name' => 'civicrm_survey',
          'entity' => 'Survey',
          'bao' => 'CRM_Campaign_BAO_Survey',
          'localizable' => 0,
          'html' => [
            'type' => 'CheckBox',
            'label' => ts("Enabled"),
          ],
          'add' => '3.3',
        ],
        'is_default' => [
          'name' => 'is_default',
          'type' => CRM_Utils_Type::T_BOOLEAN,
          'title' => ts('Is Default Survey'),
          'description' => ts('Is this default survey?'),
          'required' => TRUE,
          'usage' => [
            'import' => FALSE,
            'export' => FALSE,
            'duplicate_matching' => FALSE,
            'token' => FALSE,
          ],
          'where' => 'civicrm_survey.is_default',
          'default' => '0',
          'table_name' => 'civicrm_survey',
          'entity' => 'Survey',
          'bao' => 'CRM_Campaign_BAO_Survey',
          'localizable' => 0,
          'html' => [
            'type' => 'CheckBox',
            'label' => ts("Default"),
          ],
          'add' => '3.3',
        ],
        'created_id' => [
          'name' => 'created_id',
          'type' => CRM_Utils_Type::T_INT,
          'title' => ts('Created By Contact ID'),
          'description' => ts('FK to civicrm_contact, who created this Survey.'),
          'usage' => [
            'import' => FALSE,
            'export' => FALSE,
            'duplicate_matching' => FALSE,
            'token' => FALSE,
          ],
          'where' => 'civicrm_survey.created_id',
          'table_name' => 'civicrm_survey',
          'entity' => 'Survey',
          'bao' => 'CRM_Campaign_BAO_Survey',
          'localizable' => 0,
          'FKClassName' => 'CRM_Contact_DAO_Contact',
          'FKColumnName' => 'id',
          'html' => [
            'label' => ts("Created By"),
          ],
          'add' => '3.3',
        ],
        'created_date' => [
          'name' => 'created_date',
          'type' => CRM_Utils_Type::T_DATE + CRM_Utils_Type::T_TIME,
          'title' => ts('Campaign Created Date'),
          'description' => ts('Date and time that Survey was created.'),
          'usage' => [
            'import' => FALSE,
            'export' => FALSE,
            'duplicate_matching' => FALSE,
            'token' => FALSE,
          ],
          'where' => 'civicrm_survey.created_date',
          'table_name' => 'civicrm_survey',
          'entity' => 'Survey',
          'bao' => 'CRM_Campaign_BAO_Survey',
          'localizable' => 0,
          'add' => '3.3',
        ],
        'last_modified_id' => [
          'name' => 'last_modified_id',
          'type' => CRM_Utils_Type::T_INT,
          'title' => ts('Modified By Contact ID'),
          'description' => ts('FK to civicrm_contact, who recently edited this Survey.'),
          'usage' => [
            'import' => FALSE,
            'export' => FALSE,
            'duplicate_matching' => FALSE,
            'token' => FALSE,
          ],
          'where' => 'civicrm_survey.last_modified_id',
          'table_name' => 'civicrm_survey',
          'entity' => 'Survey',
          'bao' => 'CRM_Campaign_BAO_Survey',
          'localizable' => 0,
          'FKClassName' => 'CRM_Contact_DAO_Contact',
          'FKColumnName' => 'id',
          'html' => [
            'label' => ts("Modified By"),
          ],
          'add' => '3.3',
        ],
        'last_modified_date' => [
          'name' => 'last_modified_date',
          'type' => CRM_Utils_Type::T_DATE + CRM_Utils_Type::T_TIME,
          'title' => ts('Survey Modified On'),
          'description' => ts('Date and time that Survey was edited last time.'),
          'usage' => [
            'import' => FALSE,
            'export' => FALSE,
            'duplicate_matching' => FALSE,
            'token' => FALSE,
          ],
          'where' => 'civicrm_survey.last_modified_date',
          'table_name' => 'civicrm_survey',
          'entity' => 'Survey',
          'bao' => 'CRM_Campaign_BAO_Survey',
          'localizable' => 0,
          'add' => '3.3',
        ],
        'result_id' => [
          'name' => 'result_id',
          'type' => CRM_Utils_Type::T_INT,
          'title' => ts('Survey Result'),
          'description' => ts('Used to store option group id.'),
          'usage' => [
            'import' => FALSE,
            'export' => FALSE,
            'duplicate_matching' => FALSE,
            'token' => FALSE,
          ],
          'where' => 'civicrm_survey.result_id',
          'default' => NULL,
          'table_name' => 'civicrm_survey',
          'entity' => 'Survey',
          'bao' => 'CRM_Campaign_BAO_Survey',
          'localizable' => 0,
          'pseudoconstant' => [
            'table' => 'civicrm_option_group',
            'keyColumn' => 'id',
            'labelColumn' => 'title',
            'nameColumn' => 'name',
            'condition' => 'name LIKE "civicrm_survey_%"',
          ],
          'add' => '3.3',
        ],
        'bypass_confirm' => [
          'name' => 'bypass_confirm',
          'type' => CRM_Utils_Type::T_BOOLEAN,
          'title' => ts('No Email Verification'),
          'description' => ts('Bypass the email verification.'),
          'required' => TRUE,
          'usage' => [
            'import' => FALSE,
            'export' => FALSE,
            'duplicate_matching' => FALSE,
            'token' => FALSE,
          ],
          'where' => 'civicrm_survey.bypass_confirm',
          'default' => '0',
          'table_name' => 'civicrm_survey',
          'entity' => 'Survey',
          'bao' => 'CRM_Campaign_BAO_Survey',
          'localizable' => 0,
          'add' => '4.2',
        ],
        'thankyou_title' => [
          'name' => 'thankyou_title',
          'type' => CRM_Utils_Type::T_STRING,
          'title' => ts('Thank-you Title'),
          'description' => ts('Title for Thank-you page (header title tag, and display at the top of the page).'),
          'maxlength' => 255,
          'size' => CRM_Utils_Type::HUGE,
          'usage' => [
            'import' => FALSE,
            'export' => FALSE,
            'duplicate_matching' => FALSE,
            'token' => FALSE,
          ],
          'where' => 'civicrm_survey.thankyou_title',
          'table_name' => 'civicrm_survey',
          'entity' => 'Survey',
          'bao' => 'CRM_Campaign_BAO_Survey',
          'localizable' => 1,
          'add' => '4.2',
        ],
        'thankyou_text' => [
          'name' => 'thankyou_text',
          'type' => CRM_Utils_Type::T_TEXT,
          'title' => ts('Thank-you Text'),
          'description' => ts('text and html allowed. displayed above result on success page'),
          'rows' => 8,
          'cols' => 60,
          'usage' => [
            'import' => FALSE,
            'export' => FALSE,
            'duplicate_matching' => FALSE,
            'token' => FALSE,
          ],
          'where' => 'civicrm_survey.thankyou_text',
          'table_name' => 'civicrm_survey',
          'entity' => 'Survey',
          'bao' => 'CRM_Campaign_BAO_Survey',
          'localizable' => 1,
          'html' => [
            'type' => 'TextArea',
          ],
          'add' => '4.2',
        ],
        'is_share' => [
          'name' => 'is_share',
          'type' => CRM_Utils_Type::T_BOOLEAN,
          'title' => ts('Is shared through social media'),
          'description' => ts('Can people share the petition through social media?'),
          'required' => TRUE,
          'usage' => [
            'import' => FALSE,
            'export' => FALSE,
            'duplicate_matching' => FALSE,
            'token' => FALSE,
          ],
          'where' => 'civicrm_survey.is_share',
          'default' => '1',
          'table_name' => 'civicrm_survey',
          'entity' => 'Survey',
          'bao' => 'CRM_Campaign_BAO_Survey',
          'localizable' => 0,
          'add' => '4.4',
        ],
      ];
      CRM_Core_DAO_AllCoreTables::invoke(__CLASS__, 'fields_callback', Civi::$statics[__CLASS__]['fields']);
    }
    return Civi::$statics[__CLASS__]['fields'];
  }

  /**
   * Returns the list of fields that can be imported
   *
   * @param bool $prefix
   *
   * @return array
   */
  public static function &import($prefix = FALSE) {
    $r = CRM_Core_DAO_AllCoreTables::getImports(__CLASS__, 'survey', $prefix, []);
    return $r;
  }

  /**
   * Returns the list of fields that can be exported
   *
   * @param bool $prefix
   *
   * @return array
   */
  public static function &export($prefix = FALSE) {
    $r = CRM_Core_DAO_AllCoreTables::getExports(__CLASS__, 'survey', $prefix, []);
    return $r;
  }

  /**
   * Returns the list of indices
   *
   * @param bool $localize
   *
   * @return array
   */
  public static function indices($localize = TRUE) {
    $indices = [
      'UI_activity_type_id' => [
        'name' => 'UI_activity_type_id',
        'field' => [
          0 => 'activity_type_id',
        ],
        'localizable' => FALSE,
        'sig' => 'civicrm_survey::0::activity_type_id',
      ],
    ];
    return ($localize && !empty($indices)) ? CRM_Core_DAO_AllCoreTables::multilingualize(__CLASS__, $indices) : $indices;
  }

}
