<?php

/**
 * @package CRM
 * @copyright CiviCRM LLC https://civicrm.org/licensing
 *
 * Generated from xml/schema/CRM/Case/Case.xml
 * DO NOT EDIT.  Generated by CRM_Core_CodeGen
 * (GenCodeChecksum:d8669ec8aecbc1ba74f28e993a0013e5)
 */

/**
 * Database access object for the Case entity.
 */
class CRM_Case_DAO_Case extends CRM_Core_DAO {
  const EXT = 'civicrm';
  const TABLE_ADDED = '1.8';
  const COMPONENT = 'CiviCase';

  /**
   * Static instance to hold the table name.
   *
   * @var string
   */
  public static $_tableName = 'civicrm_case';

  /**
   * Icon associated with this entity.
   *
   * @var string
   */
  public static $_icon = 'fa-folder-open';

  /**
   * Field to show when displaying a record.
   *
   * @var string
   */
  public static $_labelField = 'subject';

  /**
   * Should CiviCRM log any modifications to this table in the civicrm_log table.
   *
   * @var bool
   */
  public static $_log = TRUE;

  /**
   * Paths for accessing this entity in the UI.
   *
   * @var string[]
   */
  protected static $_paths = [
    'view' => 'civicrm/contact/view/case?action=view&reset=1&id=[id]',
  ];

  /**
   * Unique Case ID
   *
   * @var int|string|null
   *   (SQL type: int unsigned)
   *   Note that values will be retrieved from the database as a string.
   */
  public $id;

  /**
   * FK to civicrm_case_type.id
   *
   * @var int|string
   *   (SQL type: int unsigned)
   *   Note that values will be retrieved from the database as a string.
   */
  public $case_type_id;

  /**
   * Short name of the case.
   *
   * @var string|null
   *   (SQL type: varchar(128))
   *   Note that values will be retrieved from the database as a string.
   */
  public $subject;

  /**
   * Date on which given case starts.
   *
   * @var string|null
   *   (SQL type: date)
   *   Note that values will be retrieved from the database as a string.
   */
  public $start_date;

  /**
   * Date on which given case ends.
   *
   * @var string|null
   *   (SQL type: date)
   *   Note that values will be retrieved from the database as a string.
   */
  public $end_date;

  /**
   * Details populated from Open Case. Only used in the CiviCase extension.
   *
   * @var string|null
   *   (SQL type: text)
   *   Note that values will be retrieved from the database as a string.
   */
  public $details;

  /**
   * ID of case status.
   *
   * @var int|string
   *   (SQL type: int unsigned)
   *   Note that values will be retrieved from the database as a string.
   */
  public $status_id;

  /**
   * @var bool|string
   *   (SQL type: tinyint)
   *   Note that values will be retrieved from the database as a string.
   */
  public $is_deleted;

  /**
   * When was the case was created.
   *
   * @var string
   *   (SQL type: timestamp)
   *   Note that values will be retrieved from the database as a string.
   */
  public $created_date;

  /**
   * When was the case (or closely related entity) was created or modified or deleted.
   *
   * @var string
   *   (SQL type: timestamp)
   *   Note that values will be retrieved from the database as a string.
   */
  public $modified_date;

  /**
   * Class constructor.
   */
  public function __construct() {
    $this->__table = 'civicrm_case';
    parent::__construct();
  }

  /**
   * Returns localized title of this entity.
   *
   * @param bool $plural
   *   Whether to return the plural version of the title.
   */
  public static function getEntityTitle($plural = FALSE) {
    return $plural ? ts('Cases') : ts('Case');
  }

  /**
   * Returns user-friendly description of this entity.
   *
   * @return string
   */
  public static function getEntityDescription() {
    return ts('Collections of activities and relationships for a given purpose.');
  }

  /**
   * Returns all the column names of this table
   *
   * @return array
   */
  public static function &fields() {
    if (!isset(Civi::$statics[__CLASS__]['fields'])) {
      Civi::$statics[__CLASS__]['fields'] = [
        'case_id' => [
          'name' => 'id',
          'type' => CRM_Utils_Type::T_INT,
          'title' => ts('Case ID'),
          'description' => ts('Unique Case ID'),
          'required' => TRUE,
          'usage' => [
            'import' => TRUE,
            'export' => TRUE,
            'duplicate_matching' => TRUE,
            'token' => FALSE,
          ],
          'import' => TRUE,
          'where' => 'civicrm_case.id',
          'export' => TRUE,
          'table_name' => 'civicrm_case',
          'entity' => 'Case',
          'bao' => 'CRM_Case_BAO_Case',
          'localizable' => 0,
          'html' => [
            'type' => 'Number',
          ],
          'readonly' => TRUE,
          'add' => '1.8',
        ],
        'case_type_id' => [
          'name' => 'case_type_id',
          'type' => CRM_Utils_Type::T_INT,
          'title' => ts('Case Type ID'),
          'description' => ts('FK to civicrm_case_type.id'),
          'required' => TRUE,
          'usage' => [
            'import' => TRUE,
            'export' => FALSE,
            'duplicate_matching' => TRUE,
            'token' => FALSE,
          ],
          'import' => TRUE,
          'where' => 'civicrm_case.case_type_id',
          'export' => FALSE,
          'table_name' => 'civicrm_case',
          'entity' => 'Case',
          'bao' => 'CRM_Case_BAO_Case',
          'localizable' => 0,
          'FKClassName' => 'CRM_Case_DAO_CaseType',
          'FKColumnName' => 'id',
          'html' => [
            'type' => 'Select',
            'label' => ts("Case Type"),
          ],
          'pseudoconstant' => [
            'table' => 'civicrm_case_type',
            'keyColumn' => 'id',
            'labelColumn' => 'title',
          ],
          'add' => '2.0',
        ],
        'case_subject' => [
          'name' => 'subject',
          'type' => CRM_Utils_Type::T_STRING,
          'title' => ts('Case Subject'),
          'description' => ts('Short name of the case.'),
          'maxlength' => 128,
          'size' => CRM_Utils_Type::HUGE,
          'usage' => [
            'import' => TRUE,
            'export' => TRUE,
            'duplicate_matching' => TRUE,
            'token' => FALSE,
          ],
          'import' => TRUE,
          'where' => 'civicrm_case.subject',
          'export' => TRUE,
          'table_name' => 'civicrm_case',
          'entity' => 'Case',
          'bao' => 'CRM_Case_BAO_Case',
          'localizable' => 0,
          'html' => [
            'type' => 'Text',
          ],
          'add' => '1.8',
        ],
        'case_start_date' => [
          'name' => 'start_date',
          'type' => CRM_Utils_Type::T_DATE,
          'title' => ts('Case Start Date'),
          'description' => ts('Date on which given case starts.'),
          'usage' => [
            'import' => TRUE,
            'export' => TRUE,
            'duplicate_matching' => TRUE,
            'token' => FALSE,
          ],
          'import' => TRUE,
          'where' => 'civicrm_case.start_date',
          'export' => TRUE,
          'table_name' => 'civicrm_case',
          'entity' => 'Case',
          'bao' => 'CRM_Case_BAO_Case',
          'localizable' => 0,
          'html' => [
            'type' => 'Select Date',
            'formatType' => 'activityDate',
          ],
          'add' => '1.8',
        ],
        'case_end_date' => [
          'name' => 'end_date',
          'type' => CRM_Utils_Type::T_DATE,
          'title' => ts('Case End Date'),
          'description' => ts('Date on which given case ends.'),
          'usage' => [
            'import' => TRUE,
            'export' => TRUE,
            'duplicate_matching' => TRUE,
            'token' => FALSE,
          ],
          'import' => TRUE,
          'where' => 'civicrm_case.end_date',
          'export' => TRUE,
          'table_name' => 'civicrm_case',
          'entity' => 'Case',
          'bao' => 'CRM_Case_BAO_Case',
          'localizable' => 0,
          'html' => [
            'type' => 'Select Date',
            'formatType' => 'activityDate',
          ],
          'add' => '1.8',
        ],
        'details' => [
          'name' => 'details',
          'type' => CRM_Utils_Type::T_TEXT,
          'title' => ts('Details'),
          'description' => ts('Details populated from Open Case. Only used in the CiviCase extension.'),
          'rows' => 8,
          'cols' => 60,
          'usage' => [
            'import' => FALSE,
            'export' => FALSE,
            'duplicate_matching' => FALSE,
            'token' => FALSE,
          ],
          'where' => 'civicrm_case.details',
          'table_name' => 'civicrm_case',
          'entity' => 'Case',
          'bao' => 'CRM_Case_BAO_Case',
          'localizable' => 0,
          'html' => [
            'type' => 'TextArea',
            'label' => ts("Details"),
          ],
          'add' => '1.8',
        ],
        'case_status_id' => [
          'name' => 'status_id',
          'type' => CRM_Utils_Type::T_INT,
          'title' => ts('Case Status'),
          'description' => ts('ID of case status.'),
          'required' => TRUE,
          'usage' => [
            'import' => TRUE,
            'export' => FALSE,
            'duplicate_matching' => TRUE,
            'token' => FALSE,
          ],
          'import' => TRUE,
          'where' => 'civicrm_case.status_id',
          'export' => FALSE,
          'table_name' => 'civicrm_case',
          'entity' => 'Case',
          'bao' => 'CRM_Case_BAO_Case',
          'localizable' => 0,
          'html' => [
            'type' => 'Select',
            'controlField' => 'case_type_id',
          ],
          'pseudoconstant' => [
            'optionGroupName' => 'case_status',
            'optionEditPath' => 'civicrm/admin/options/case_status',
          ],
          'add' => '1.8',
        ],
        'case_deleted' => [
          'name' => 'is_deleted',
          'type' => CRM_Utils_Type::T_BOOLEAN,
          'title' => ts('Case is in the Trash'),
          'required' => TRUE,
          'usage' => [
            'import' => TRUE,
            'export' => TRUE,
            'duplicate_matching' => TRUE,
            'token' => FALSE,
          ],
          'import' => TRUE,
          'where' => 'civicrm_case.is_deleted',
          'export' => TRUE,
          'default' => '0',
          'table_name' => 'civicrm_case',
          'entity' => 'Case',
          'bao' => 'CRM_Case_BAO_Case',
          'localizable' => 0,
          'html' => [
            'type' => 'CheckBox',
          ],
          'add' => '2.2',
        ],
        'case_created_date' => [
          'name' => 'created_date',
          'type' => CRM_Utils_Type::T_TIMESTAMP,
          'title' => ts('Created Date'),
          'description' => ts('When was the case was created.'),
          'required' => FALSE,
          'usage' => [
            'import' => FALSE,
            'export' => TRUE,
            'duplicate_matching' => FALSE,
            'token' => FALSE,
          ],
          'where' => 'civicrm_case.created_date',
          'export' => TRUE,
          'default' => NULL,
          'table_name' => 'civicrm_case',
          'entity' => 'Case',
          'bao' => 'CRM_Case_BAO_Case',
          'localizable' => 0,
          'html' => [
            'label' => ts("Created Date"),
          ],
          'readonly' => TRUE,
          'add' => '4.7',
        ],
        'case_modified_date' => [
          'name' => 'modified_date',
          'type' => CRM_Utils_Type::T_TIMESTAMP,
          'title' => ts('Modified Date'),
          'description' => ts('When was the case (or closely related entity) was created or modified or deleted.'),
          'required' => FALSE,
          'usage' => [
            'import' => FALSE,
            'export' => TRUE,
            'duplicate_matching' => FALSE,
            'token' => FALSE,
          ],
          'where' => 'civicrm_case.modified_date',
          'export' => TRUE,
          'default' => 'CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP',
          'table_name' => 'civicrm_case',
          'entity' => 'Case',
          'bao' => 'CRM_Case_BAO_Case',
          'localizable' => 0,
          'html' => [
            'label' => ts("Modified Date"),
          ],
          'readonly' => TRUE,
          'add' => '4.7',
        ],
      ];
      CRM_Core_DAO_AllCoreTables::invoke(__CLASS__, 'fields_callback', Civi::$statics[__CLASS__]['fields']);
    }
    return Civi::$statics[__CLASS__]['fields'];
  }

  /**
   * Returns the list of fields that can be imported
   *
   * @param bool $prefix
   *
   * @return array
   */
  public static function &import($prefix = FALSE) {
    $r = CRM_Core_DAO_AllCoreTables::getImports(__CLASS__, 'case', $prefix, []);
    return $r;
  }

  /**
   * Returns the list of fields that can be exported
   *
   * @param bool $prefix
   *
   * @return array
   */
  public static function &export($prefix = FALSE) {
    $r = CRM_Core_DAO_AllCoreTables::getExports(__CLASS__, 'case', $prefix, []);
    return $r;
  }

  /**
   * Returns the list of indices
   *
   * @param bool $localize
   *
   * @return array
   */
  public static function indices($localize = TRUE) {
    $indices = [
      'index_case_type_id' => [
        'name' => 'index_case_type_id',
        'field' => [
          0 => 'case_type_id',
        ],
        'localizable' => FALSE,
        'sig' => 'civicrm_case::0::case_type_id',
      ],
      'index_is_deleted' => [
        'name' => 'index_is_deleted',
        'field' => [
          0 => 'is_deleted',
        ],
        'localizable' => FALSE,
        'sig' => 'civicrm_case::0::is_deleted',
      ],
    ];
    return ($localize && !empty($indices)) ? CRM_Core_DAO_AllCoreTables::multilingualize(__CLASS__, $indices) : $indices;
  }

}
