<?php

/**
 * @package CRM
 * @copyright CiviCRM LLC https://civicrm.org/licensing
 *
 * Generated from xml/schema/CRM/Contribute/Product.xml
 * DO NOT EDIT.  Generated by CRM_Core_CodeGen
 * (GenCodeChecksum:25d230f83535ed383bf72377471e6d98)
 */

/**
 * Database access object for the Product entity.
 */
class CRM_Contribute_DAO_Product extends CRM_Core_DAO {
  const EXT = 'civicrm';
  const TABLE_ADDED = '1.4';
  const COMPONENT = 'CiviContribute';

  /**
   * Static instance to hold the table name.
   *
   * @var string
   */
  public static $_tableName = 'civicrm_product';

  /**
   * Field to show when displaying a record.
   *
   * @var string
   */
  public static $_labelField = 'name';

  /**
   * Should CiviCRM log any modifications to this table in the civicrm_log table.
   *
   * @var bool
   */
  public static $_log = TRUE;

  /**
   * Paths for accessing this entity in the UI.
   *
   * @var string[]
   */
  protected static $_paths = [
    'add' => 'civicrm/admin/contribute/managePremiums/edit?action=add&reset=1',
    'update' => 'civicrm/admin/contribute/managePremiums/edit?action=update&id=[id]&reset=1',
    'delete' => 'civicrm/admin/contribute/managePremiums/edit?action=delete&id=[id]&reset=1',
    'preview' => 'civicrm/admin/contribute/managePremiums/edit?action=preview&reset=1&id=[id]',
    'browse' => 'civicrm/admin/contribute/managePremiums/',
  ];

  /**
   * @var int|string|null
   *   (SQL type: int unsigned)
   *   Note that values will be retrieved from the database as a string.
   */
  public $id;

  /**
   * Required product/premium name
   *
   * @var string
   *   (SQL type: varchar(255))
   *   Note that values will be retrieved from the database as a string.
   */
  public $name;

  /**
   * Optional description of the product/premium.
   *
   * @var string|null
   *   (SQL type: text)
   *   Note that values will be retrieved from the database as a string.
   */
  public $description;

  /**
   * Optional product sku or code.
   *
   * @var string|null
   *   (SQL type: varchar(50))
   *   Note that values will be retrieved from the database as a string.
   */
  public $sku;

  /**
   * Store comma-delimited list of color, size, etc. options for the product.
   *
   * @var string|null
   *   (SQL type: text)
   *   Note that values will be retrieved from the database as a string.
   */
  public $options;

  /**
   * Full or relative URL to uploaded image - fullsize.
   *
   * @var string|null
   *   (SQL type: varchar(255))
   *   Note that values will be retrieved from the database as a string.
   */
  public $image;

  /**
   * Full or relative URL to image thumbnail.
   *
   * @var string|null
   *   (SQL type: varchar(255))
   *   Note that values will be retrieved from the database as a string.
   */
  public $thumbnail;

  /**
   * Sell price or market value for premiums. For tax-deductible contributions, this will be stored as non_deductible_amount in the contribution record.
   *
   * @var float|string|null
   *   (SQL type: decimal(20,2))
   *   Note that values will be retrieved from the database as a string.
   */
  public $price;

  /**
   * 3 character string, value from config setting or input via user.
   *
   * @var string|null
   *   (SQL type: varchar(3))
   *   Note that values will be retrieved from the database as a string.
   */
  public $currency;

  /**
   * FK to Financial Type.
   *
   * @var int|string|null
   *   (SQL type: int unsigned)
   *   Note that values will be retrieved from the database as a string.
   */
  public $financial_type_id;

  /**
   * Minimum contribution required to be eligible to select this premium.
   *
   * @var float|string|null
   *   (SQL type: decimal(20,2))
   *   Note that values will be retrieved from the database as a string.
   */
  public $min_contribution;

  /**
   * Actual cost of this product. Useful to determine net return from sale or using this as an incentive.
   *
   * @var float|string|null
   *   (SQL type: decimal(20,2))
   *   Note that values will be retrieved from the database as a string.
   */
  public $cost;

  /**
   * Disabling premium removes it from the premiums_premium join table below.
   *
   * @var bool|string
   *   (SQL type: tinyint)
   *   Note that values will be retrieved from the database as a string.
   */
  public $is_active;

  /**
   * Rolling means we set start/end based on current day, fixed means we set start/end for current year or month (e.g. 1 year + fixed -> we would set start/end for 1/1/06 thru 12/31/06 for any premium chosen in 2006)
   *
   * @var string|null
   *   (SQL type: varchar(8))
   *   Note that values will be retrieved from the database as a string.
   */
  public $period_type;

  /**
   * Month and day (MMDD) that fixed period type subscription or membership starts.
   *
   * @var int|string|null
   *   (SQL type: int)
   *   Note that values will be retrieved from the database as a string.
   */
  public $fixed_period_start_day;

  /**
   * @var string|null
   *   (SQL type: varchar(8))
   *   Note that values will be retrieved from the database as a string.
   */
  public $duration_unit;

  /**
   * Number of units for total duration of subscription, service, membership (e.g. 12 Months).
   *
   * @var int|string|null
   *   (SQL type: int)
   *   Note that values will be retrieved from the database as a string.
   */
  public $duration_interval;

  /**
   * Frequency unit and interval allow option to store actual delivery frequency for a subscription or service.
   *
   * @var string|null
   *   (SQL type: varchar(8))
   *   Note that values will be retrieved from the database as a string.
   */
  public $frequency_unit;

  /**
   * Number of units for delivery frequency of subscription, service, membership (e.g. every 3 Months).
   *
   * @var int|string|null
   *   (SQL type: int)
   *   Note that values will be retrieved from the database as a string.
   */
  public $frequency_interval;

  /**
   * Class constructor.
   */
  public function __construct() {
    $this->__table = 'civicrm_product';
    parent::__construct();
  }

  /**
   * Returns localized title of this entity.
   *
   * @param bool $plural
   *   Whether to return the plural version of the title.
   */
  public static function getEntityTitle($plural = FALSE) {
    return $plural ? ts('Products') : ts('Product');
  }

  /**
   * Returns all the column names of this table
   *
   * @return array
   */
  public static function &fields() {
    if (!isset(Civi::$statics[__CLASS__]['fields'])) {
      Civi::$statics[__CLASS__]['fields'] = [
        'id' => [
          'name' => 'id',
          'type' => CRM_Utils_Type::T_INT,
          'title' => ts('Product ID'),
          'required' => TRUE,
          'usage' => [
            'import' => FALSE,
            'export' => FALSE,
            'duplicate_matching' => FALSE,
            'token' => FALSE,
          ],
          'where' => 'civicrm_product.id',
          'table_name' => 'civicrm_product',
          'entity' => 'Product',
          'bao' => 'CRM_Contribute_BAO_Product',
          'localizable' => 0,
          'html' => [
            'type' => 'Number',
          ],
          'readonly' => TRUE,
          'add' => '1.4',
        ],
        'product_name' => [
          'name' => 'name',
          'type' => CRM_Utils_Type::T_STRING,
          'title' => ts('Product Name'),
          'description' => ts('Required product/premium name'),
          'required' => TRUE,
          'maxlength' => 255,
          'size' => CRM_Utils_Type::HUGE,
          'usage' => [
            'import' => FALSE,
            'export' => TRUE,
            'duplicate_matching' => FALSE,
            'token' => FALSE,
          ],
          'where' => 'civicrm_product.name',
          'export' => TRUE,
          'table_name' => 'civicrm_product',
          'entity' => 'Product',
          'bao' => 'CRM_Contribute_BAO_Product',
          'localizable' => 1,
          'add' => '1.4',
        ],
        'description' => [
          'name' => 'description',
          'type' => CRM_Utils_Type::T_TEXT,
          'title' => ts('Description'),
          'description' => ts('Optional description of the product/premium.'),
          'usage' => [
            'import' => FALSE,
            'export' => FALSE,
            'duplicate_matching' => FALSE,
            'token' => FALSE,
          ],
          'where' => 'civicrm_product.description',
          'table_name' => 'civicrm_product',
          'entity' => 'Product',
          'bao' => 'CRM_Contribute_BAO_Product',
          'localizable' => 1,
          'add' => '1.4',
        ],
        'sku' => [
          'name' => 'sku',
          'type' => CRM_Utils_Type::T_STRING,
          'title' => ts('SKU'),
          'description' => ts('Optional product sku or code.'),
          'maxlength' => 50,
          'size' => CRM_Utils_Type::BIG,
          'usage' => [
            'import' => FALSE,
            'export' => TRUE,
            'duplicate_matching' => FALSE,
            'token' => FALSE,
          ],
          'where' => 'civicrm_product.sku',
          'export' => TRUE,
          'table_name' => 'civicrm_product',
          'entity' => 'Product',
          'bao' => 'CRM_Contribute_BAO_Product',
          'localizable' => 0,
          'add' => '1.4',
        ],
        'options' => [
          'name' => 'options',
          'type' => CRM_Utils_Type::T_TEXT,
          'title' => ts('Options'),
          'description' => ts('Store comma-delimited list of color, size, etc. options for the product.'),
          'usage' => [
            'import' => FALSE,
            'export' => FALSE,
            'duplicate_matching' => FALSE,
            'token' => FALSE,
          ],
          'where' => 'civicrm_product.options',
          'table_name' => 'civicrm_product',
          'entity' => 'Product',
          'bao' => 'CRM_Contribute_BAO_Product',
          'localizable' => 1,
          'serialize' => self::SERIALIZE_COMMA,
          'add' => '1.4',
        ],
        'image' => [
          'name' => 'image',
          'type' => CRM_Utils_Type::T_STRING,
          'title' => ts('Image'),
          'description' => ts('Full or relative URL to uploaded image - fullsize.'),
          'maxlength' => 255,
          'size' => CRM_Utils_Type::HUGE,
          'usage' => [
            'import' => FALSE,
            'export' => FALSE,
            'duplicate_matching' => FALSE,
            'token' => FALSE,
          ],
          'where' => 'civicrm_product.image',
          'table_name' => 'civicrm_product',
          'entity' => 'Product',
          'bao' => 'CRM_Contribute_BAO_Product',
          'localizable' => 0,
          'add' => '1.4',
        ],
        'thumbnail' => [
          'name' => 'thumbnail',
          'type' => CRM_Utils_Type::T_STRING,
          'title' => ts('Thumbnail'),
          'description' => ts('Full or relative URL to image thumbnail.'),
          'maxlength' => 255,
          'size' => CRM_Utils_Type::HUGE,
          'usage' => [
            'import' => FALSE,
            'export' => FALSE,
            'duplicate_matching' => FALSE,
            'token' => FALSE,
          ],
          'where' => 'civicrm_product.thumbnail',
          'table_name' => 'civicrm_product',
          'entity' => 'Product',
          'bao' => 'CRM_Contribute_BAO_Product',
          'localizable' => 0,
          'add' => '1.4',
        ],
        'price' => [
          'name' => 'price',
          'type' => CRM_Utils_Type::T_MONEY,
          'title' => ts('Price'),
          'description' => ts('Sell price or market value for premiums. For tax-deductible contributions, this will be stored as non_deductible_amount in the contribution record.'),
          'precision' => [
            20,
            2,
          ],
          'usage' => [
            'import' => FALSE,
            'export' => FALSE,
            'duplicate_matching' => FALSE,
            'token' => FALSE,
          ],
          'where' => 'civicrm_product.price',
          'table_name' => 'civicrm_product',
          'entity' => 'Product',
          'bao' => 'CRM_Contribute_BAO_Product',
          'localizable' => 0,
          'add' => '1.4',
        ],
        'currency' => [
          'name' => 'currency',
          'type' => CRM_Utils_Type::T_STRING,
          'title' => ts('Currency'),
          'description' => ts('3 character string, value from config setting or input via user.'),
          'maxlength' => 3,
          'size' => CRM_Utils_Type::FOUR,
          'usage' => [
            'import' => FALSE,
            'export' => FALSE,
            'duplicate_matching' => FALSE,
            'token' => FALSE,
          ],
          'where' => 'civicrm_product.currency',
          'default' => NULL,
          'table_name' => 'civicrm_product',
          'entity' => 'Product',
          'bao' => 'CRM_Contribute_BAO_Product',
          'localizable' => 0,
          'html' => [
            'type' => 'Select',
            'label' => ts("Currency"),
          ],
          'pseudoconstant' => [
            'table' => 'civicrm_currency',
            'keyColumn' => 'name',
            'labelColumn' => 'full_name',
            'nameColumn' => 'name',
            'abbrColumn' => 'symbol',
          ],
          'add' => '3.2',
        ],
        'financial_type_id' => [
          'name' => 'financial_type_id',
          'type' => CRM_Utils_Type::T_INT,
          'title' => ts('Financial Type ID'),
          'description' => ts('FK to Financial Type.'),
          'usage' => [
            'import' => FALSE,
            'export' => FALSE,
            'duplicate_matching' => FALSE,
            'token' => FALSE,
          ],
          'where' => 'civicrm_product.financial_type_id',
          'default' => NULL,
          'table_name' => 'civicrm_product',
          'entity' => 'Product',
          'bao' => 'CRM_Contribute_BAO_Product',
          'localizable' => 0,
          'FKClassName' => 'CRM_Financial_DAO_FinancialType',
          'FKColumnName' => 'id',
          'html' => [
            'label' => ts("Financial Type"),
          ],
          'pseudoconstant' => [
            'table' => 'civicrm_financial_type',
            'keyColumn' => 'id',
            'labelColumn' => 'name',
          ],
          'add' => '4.3',
        ],
        'min_contribution' => [
          'name' => 'min_contribution',
          'type' => CRM_Utils_Type::T_MONEY,
          'title' => ts('Minimum Contribution'),
          'description' => ts('Minimum contribution required to be eligible to select this premium.'),
          'precision' => [
            20,
            2,
          ],
          'usage' => [
            'import' => FALSE,
            'export' => FALSE,
            'duplicate_matching' => FALSE,
            'token' => FALSE,
          ],
          'where' => 'civicrm_product.min_contribution',
          'table_name' => 'civicrm_product',
          'entity' => 'Product',
          'bao' => 'CRM_Contribute_BAO_Product',
          'localizable' => 0,
          'add' => '1.4',
        ],
        'cost' => [
          'name' => 'cost',
          'type' => CRM_Utils_Type::T_MONEY,
          'title' => ts('Cost'),
          'description' => ts('Actual cost of this product. Useful to determine net return from sale or using this as an incentive.'),
          'precision' => [
            20,
            2,
          ],
          'usage' => [
            'import' => FALSE,
            'export' => FALSE,
            'duplicate_matching' => FALSE,
            'token' => FALSE,
          ],
          'where' => 'civicrm_product.cost',
          'table_name' => 'civicrm_product',
          'entity' => 'Product',
          'bao' => 'CRM_Contribute_BAO_Product',
          'localizable' => 0,
          'add' => '1.4',
        ],
        'is_active' => [
          'name' => 'is_active',
          'type' => CRM_Utils_Type::T_BOOLEAN,
          'title' => ts('Is Active'),
          'description' => ts('Disabling premium removes it from the premiums_premium join table below.'),
          'required' => TRUE,
          'usage' => [
            'import' => FALSE,
            'export' => FALSE,
            'duplicate_matching' => FALSE,
            'token' => FALSE,
          ],
          'where' => 'civicrm_product.is_active',
          'default' => '1',
          'table_name' => 'civicrm_product',
          'entity' => 'Product',
          'bao' => 'CRM_Contribute_BAO_Product',
          'localizable' => 0,
          'html' => [
            'type' => 'CheckBox',
            'label' => ts("Enabled"),
          ],
          'add' => '1.4',
        ],
        'period_type' => [
          'name' => 'period_type',
          'type' => CRM_Utils_Type::T_STRING,
          'title' => ts('Period Type'),
          'description' => ts('Rolling means we set start/end based on current day, fixed means we set start/end for current year or month (e.g. 1 year + fixed -> we would set start/end for 1/1/06 thru 12/31/06 for any premium chosen in 2006)'),
          'maxlength' => 8,
          'size' => CRM_Utils_Type::EIGHT,
          'usage' => [
            'import' => FALSE,
            'export' => FALSE,
            'duplicate_matching' => FALSE,
            'token' => FALSE,
          ],
          'where' => 'civicrm_product.period_type',
          'default' => 'rolling',
          'table_name' => 'civicrm_product',
          'entity' => 'Product',
          'bao' => 'CRM_Contribute_BAO_Product',
          'localizable' => 0,
          'html' => [
            'type' => 'Select',
          ],
          'pseudoconstant' => [
            'callback' => 'CRM_Core_SelectValues::periodType',
          ],
          'add' => '1.4',
        ],
        'fixed_period_start_day' => [
          'name' => 'fixed_period_start_day',
          'type' => CRM_Utils_Type::T_INT,
          'title' => ts('Fixed Period Start Day'),
          'description' => ts('Month and day (MMDD) that fixed period type subscription or membership starts.'),
          'usage' => [
            'import' => FALSE,
            'export' => FALSE,
            'duplicate_matching' => FALSE,
            'token' => FALSE,
          ],
          'where' => 'civicrm_product.fixed_period_start_day',
          'default' => '0101',
          'table_name' => 'civicrm_product',
          'entity' => 'Product',
          'bao' => 'CRM_Contribute_BAO_Product',
          'localizable' => 0,
          'add' => '1.4',
        ],
        'duration_unit' => [
          'name' => 'duration_unit',
          'type' => CRM_Utils_Type::T_STRING,
          'title' => ts('Duration Unit'),
          'maxlength' => 8,
          'size' => CRM_Utils_Type::EIGHT,
          'usage' => [
            'import' => FALSE,
            'export' => FALSE,
            'duplicate_matching' => FALSE,
            'token' => FALSE,
          ],
          'where' => 'civicrm_product.duration_unit',
          'default' => 'year',
          'table_name' => 'civicrm_product',
          'entity' => 'Product',
          'bao' => 'CRM_Contribute_BAO_Product',
          'localizable' => 0,
          'html' => [
            'type' => 'Select',
          ],
          'pseudoconstant' => [
            'callback' => 'CRM_Core_SelectValues::getPremiumUnits',
          ],
          'add' => '1.4',
        ],
        'duration_interval' => [
          'name' => 'duration_interval',
          'type' => CRM_Utils_Type::T_INT,
          'title' => ts('Duration Interval'),
          'description' => ts('Number of units for total duration of subscription, service, membership (e.g. 12 Months).'),
          'usage' => [
            'import' => FALSE,
            'export' => FALSE,
            'duplicate_matching' => FALSE,
            'token' => FALSE,
          ],
          'where' => 'civicrm_product.duration_interval',
          'table_name' => 'civicrm_product',
          'entity' => 'Product',
          'bao' => 'CRM_Contribute_BAO_Product',
          'localizable' => 0,
          'add' => '1.4',
        ],
        'frequency_unit' => [
          'name' => 'frequency_unit',
          'type' => CRM_Utils_Type::T_STRING,
          'title' => ts('Frequency Unit'),
          'description' => ts('Frequency unit and interval allow option to store actual delivery frequency for a subscription or service.'),
          'maxlength' => 8,
          'size' => CRM_Utils_Type::EIGHT,
          'usage' => [
            'import' => FALSE,
            'export' => FALSE,
            'duplicate_matching' => FALSE,
            'token' => FALSE,
          ],
          'where' => 'civicrm_product.frequency_unit',
          'default' => 'month',
          'table_name' => 'civicrm_product',
          'entity' => 'Product',
          'bao' => 'CRM_Contribute_BAO_Product',
          'localizable' => 0,
          'html' => [
            'type' => 'Select',
          ],
          'pseudoconstant' => [
            'callback' => 'CRM_Core_SelectValues::getPremiumUnits',
          ],
          'add' => '1.4',
        ],
        'frequency_interval' => [
          'name' => 'frequency_interval',
          'type' => CRM_Utils_Type::T_INT,
          'title' => ts('Frequency Interval'),
          'description' => ts('Number of units for delivery frequency of subscription, service, membership (e.g. every 3 Months).'),
          'usage' => [
            'import' => FALSE,
            'export' => FALSE,
            'duplicate_matching' => FALSE,
            'token' => FALSE,
          ],
          'where' => 'civicrm_product.frequency_interval',
          'table_name' => 'civicrm_product',
          'entity' => 'Product',
          'bao' => 'CRM_Contribute_BAO_Product',
          'localizable' => 0,
          'add' => '1.4',
        ],
      ];
      CRM_Core_DAO_AllCoreTables::invoke(__CLASS__, 'fields_callback', Civi::$statics[__CLASS__]['fields']);
    }
    return Civi::$statics[__CLASS__]['fields'];
  }

  /**
   * Returns the list of fields that can be imported
   *
   * @param bool $prefix
   *
   * @return array
   */
  public static function &import($prefix = FALSE) {
    $r = CRM_Core_DAO_AllCoreTables::getImports(__CLASS__, 'product', $prefix, []);
    return $r;
  }

  /**
   * Returns the list of fields that can be exported
   *
   * @param bool $prefix
   *
   * @return array
   */
  public static function &export($prefix = FALSE) {
    $r = CRM_Core_DAO_AllCoreTables::getExports(__CLASS__, 'product', $prefix, []);
    return $r;
  }

  /**
   * Returns the list of indices
   *
   * @param bool $localize
   *
   * @return array
   */
  public static function indices($localize = TRUE) {
    $indices = [];
    return ($localize && !empty($indices)) ? CRM_Core_DAO_AllCoreTables::multilingualize(__CLASS__, $indices) : $indices;
  }

}
