<?php

/**
 * @package CRM
 * @copyright CiviCRM LLC https://civicrm.org/licensing
 *
 * Generated from xml/schema/CRM/Core/ActionLog.xml
 * DO NOT EDIT.  Generated by CRM_Core_CodeGen
 * (GenCodeChecksum:fb407a1919e8bb230001ccab90250e6c)
 */

/**
 * Database access object for the ActionLog entity.
 */
class CRM_Core_DAO_ActionLog extends CRM_Core_DAO {
  const EXT = 'civicrm';
  const TABLE_ADDED = '3.4';

  /**
   * Static instance to hold the table name.
   *
   * @var string
   */
  public static $_tableName = 'civicrm_action_log';

  /**
   * Should CiviCRM log any modifications to this table in the civicrm_log table.
   *
   * @var bool
   */
  public static $_log = FALSE;

  /**
   * @var int|string|null
   *   (SQL type: int unsigned)
   *   Note that values will be retrieved from the database as a string.
   */
  public $id;

  /**
   * FK to Contact ID
   *
   * @var int|string|null
   *   (SQL type: int unsigned)
   *   Note that values will be retrieved from the database as a string.
   */
  public $contact_id;

  /**
   * FK to id of the entity that the action was performed on. Pseudo - FK.
   *
   * @var int|string
   *   (SQL type: int unsigned)
   *   Note that values will be retrieved from the database as a string.
   */
  public $entity_id;

  /**
   * name of the entity table for the above id, e.g. civicrm_activity, civicrm_participant
   *
   * @var string|null
   *   (SQL type: varchar(255))
   *   Note that values will be retrieved from the database as a string.
   */
  public $entity_table;

  /**
   * FK to the action schedule that this action originated from.
   *
   * @var int|string
   *   (SQL type: int unsigned)
   *   Note that values will be retrieved from the database as a string.
   */
  public $action_schedule_id;

  /**
   * date time that the action was performed on.
   *
   * @var string|null
   *   (SQL type: datetime)
   *   Note that values will be retrieved from the database as a string.
   */
  public $action_date_time;

  /**
   * Was there any error sending the reminder?
   *
   * @var bool|string
   *   (SQL type: tinyint)
   *   Note that values will be retrieved from the database as a string.
   */
  public $is_error;

  /**
   * Description / text in case there was an error encountered.
   *
   * @var string|null
   *   (SQL type: text)
   *   Note that values will be retrieved from the database as a string.
   */
  public $message;

  /**
   * Keeps track of the sequence number of this repetition.
   *
   * @var int|string|null
   *   (SQL type: int unsigned)
   *   Note that values will be retrieved from the database as a string.
   */
  public $repetition_number;

  /**
   * Stores the date from the entity which triggered this reminder action (e.g. membership.end_date for most membership renewal reminders)
   *
   * @var string|null
   *   (SQL type: datetime)
   *   Note that values will be retrieved from the database as a string.
   */
  public $reference_date;

  /**
   * Class constructor.
   */
  public function __construct() {
    $this->__table = 'civicrm_action_log';
    parent::__construct();
  }

  /**
   * Returns localized title of this entity.
   *
   * @param bool $plural
   *   Whether to return the plural version of the title.
   */
  public static function getEntityTitle($plural = FALSE) {
    return $plural ? ts('Action Logs') : ts('Action Log');
  }

  /**
   * Returns all the column names of this table
   *
   * @return array
   */
  public static function &fields() {
    if (!isset(Civi::$statics[__CLASS__]['fields'])) {
      Civi::$statics[__CLASS__]['fields'] = [
        'id' => [
          'name' => 'id',
          'type' => CRM_Utils_Type::T_INT,
          'title' => ts('Action Schedule ID'),
          'required' => TRUE,
          'usage' => [
            'import' => FALSE,
            'export' => FALSE,
            'duplicate_matching' => FALSE,
            'token' => FALSE,
          ],
          'where' => 'civicrm_action_log.id',
          'table_name' => 'civicrm_action_log',
          'entity' => 'ActionLog',
          'bao' => 'CRM_Core_BAO_ActionLog',
          'localizable' => 0,
          'html' => [
            'type' => 'Number',
          ],
          'readonly' => TRUE,
          'add' => '3.4',
        ],
        'contact_id' => [
          'name' => 'contact_id',
          'type' => CRM_Utils_Type::T_INT,
          'title' => ts('Contact ID'),
          'description' => ts('FK to Contact ID'),
          'usage' => [
            'import' => FALSE,
            'export' => FALSE,
            'duplicate_matching' => FALSE,
            'token' => FALSE,
          ],
          'where' => 'civicrm_action_log.contact_id',
          'table_name' => 'civicrm_action_log',
          'entity' => 'ActionLog',
          'bao' => 'CRM_Core_BAO_ActionLog',
          'localizable' => 0,
          'FKClassName' => 'CRM_Contact_DAO_Contact',
          'FKColumnName' => 'id',
          'html' => [
            'label' => ts("Contact"),
          ],
          'add' => '3.4',
        ],
        'entity_id' => [
          'name' => 'entity_id',
          'type' => CRM_Utils_Type::T_INT,
          'title' => ts('Entity ID'),
          'description' => ts('FK to id of the entity that the action was performed on. Pseudo - FK.'),
          'required' => TRUE,
          'usage' => [
            'import' => FALSE,
            'export' => FALSE,
            'duplicate_matching' => FALSE,
            'token' => FALSE,
          ],
          'where' => 'civicrm_action_log.entity_id',
          'table_name' => 'civicrm_action_log',
          'entity' => 'ActionLog',
          'bao' => 'CRM_Core_BAO_ActionLog',
          'localizable' => 0,
          'DFKEntityColumn' => 'entity_table',
          'FKColumnName' => 'id',
          'add' => '3.4',
        ],
        'entity_table' => [
          'name' => 'entity_table',
          'type' => CRM_Utils_Type::T_STRING,
          'title' => ts('Entity Table'),
          'description' => ts('name of the entity table for the above id, e.g. civicrm_activity, civicrm_participant'),
          'maxlength' => 255,
          'size' => CRM_Utils_Type::HUGE,
          'usage' => [
            'import' => FALSE,
            'export' => FALSE,
            'duplicate_matching' => FALSE,
            'token' => FALSE,
          ],
          'where' => 'civicrm_action_log.entity_table',
          'table_name' => 'civicrm_action_log',
          'entity' => 'ActionLog',
          'bao' => 'CRM_Core_BAO_ActionLog',
          'localizable' => 0,
          'add' => '3.4',
        ],
        'action_schedule_id' => [
          'name' => 'action_schedule_id',
          'type' => CRM_Utils_Type::T_INT,
          'title' => ts('Schedule ID'),
          'description' => ts('FK to the action schedule that this action originated from.'),
          'required' => TRUE,
          'usage' => [
            'import' => FALSE,
            'export' => FALSE,
            'duplicate_matching' => FALSE,
            'token' => FALSE,
          ],
          'where' => 'civicrm_action_log.action_schedule_id',
          'table_name' => 'civicrm_action_log',
          'entity' => 'ActionLog',
          'bao' => 'CRM_Core_BAO_ActionLog',
          'localizable' => 0,
          'FKClassName' => 'CRM_Core_DAO_ActionSchedule',
          'FKColumnName' => 'id',
          'html' => [
            'label' => ts("Schedule"),
          ],
          'add' => '3.4',
        ],
        'action_date_time' => [
          'name' => 'action_date_time',
          'type' => CRM_Utils_Type::T_DATE + CRM_Utils_Type::T_TIME,
          'title' => ts('Action Date And Time'),
          'description' => ts('date time that the action was performed on.'),
          'usage' => [
            'import' => FALSE,
            'export' => FALSE,
            'duplicate_matching' => FALSE,
            'token' => FALSE,
          ],
          'where' => 'civicrm_action_log.action_date_time',
          'table_name' => 'civicrm_action_log',
          'entity' => 'ActionLog',
          'bao' => 'CRM_Core_BAO_ActionLog',
          'localizable' => 0,
          'add' => '3.4',
        ],
        'is_error' => [
          'name' => 'is_error',
          'type' => CRM_Utils_Type::T_BOOLEAN,
          'title' => ts('Error?'),
          'description' => ts('Was there any error sending the reminder?'),
          'required' => TRUE,
          'usage' => [
            'import' => FALSE,
            'export' => FALSE,
            'duplicate_matching' => FALSE,
            'token' => FALSE,
          ],
          'where' => 'civicrm_action_log.is_error',
          'default' => '0',
          'table_name' => 'civicrm_action_log',
          'entity' => 'ActionLog',
          'bao' => 'CRM_Core_BAO_ActionLog',
          'localizable' => 0,
          'add' => '3.4',
        ],
        'message' => [
          'name' => 'message',
          'type' => CRM_Utils_Type::T_TEXT,
          'title' => ts('Message'),
          'description' => ts('Description / text in case there was an error encountered.'),
          'usage' => [
            'import' => FALSE,
            'export' => FALSE,
            'duplicate_matching' => FALSE,
            'token' => FALSE,
          ],
          'where' => 'civicrm_action_log.message',
          'table_name' => 'civicrm_action_log',
          'entity' => 'ActionLog',
          'bao' => 'CRM_Core_BAO_ActionLog',
          'localizable' => 0,
          'add' => '3.4',
        ],
        'repetition_number' => [
          'name' => 'repetition_number',
          'type' => CRM_Utils_Type::T_INT,
          'title' => ts('Repetition Number'),
          'description' => ts('Keeps track of the sequence number of this repetition.'),
          'usage' => [
            'import' => FALSE,
            'export' => FALSE,
            'duplicate_matching' => FALSE,
            'token' => FALSE,
          ],
          'where' => 'civicrm_action_log.repetition_number',
          'table_name' => 'civicrm_action_log',
          'entity' => 'ActionLog',
          'bao' => 'CRM_Core_BAO_ActionLog',
          'localizable' => 0,
          'add' => '3.4',
        ],
        'reference_date' => [
          'name' => 'reference_date',
          'type' => CRM_Utils_Type::T_DATE + CRM_Utils_Type::T_TIME,
          'title' => ts('Reference Date'),
          'description' => ts('Stores the date from the entity which triggered this reminder action (e.g. membership.end_date for most membership renewal reminders)'),
          'usage' => [
            'import' => FALSE,
            'export' => FALSE,
            'duplicate_matching' => FALSE,
            'token' => FALSE,
          ],
          'where' => 'civicrm_action_log.reference_date',
          'default' => NULL,
          'table_name' => 'civicrm_action_log',
          'entity' => 'ActionLog',
          'bao' => 'CRM_Core_BAO_ActionLog',
          'localizable' => 0,
          'add' => '4.6',
        ],
      ];
      CRM_Core_DAO_AllCoreTables::invoke(__CLASS__, 'fields_callback', Civi::$statics[__CLASS__]['fields']);
    }
    return Civi::$statics[__CLASS__]['fields'];
  }

  /**
   * Returns the list of fields that can be imported
   *
   * @param bool $prefix
   *
   * @return array
   */
  public static function &import($prefix = FALSE) {
    $r = CRM_Core_DAO_AllCoreTables::getImports(__CLASS__, 'action_log', $prefix, []);
    return $r;
  }

  /**
   * Returns the list of fields that can be exported
   *
   * @param bool $prefix
   *
   * @return array
   */
  public static function &export($prefix = FALSE) {
    $r = CRM_Core_DAO_AllCoreTables::getExports(__CLASS__, 'action_log', $prefix, []);
    return $r;
  }

  /**
   * Returns the list of indices
   *
   * @param bool $localize
   *
   * @return array
   */
  public static function indices($localize = TRUE) {
    $indices = [];
    return ($localize && !empty($indices)) ? CRM_Core_DAO_AllCoreTables::multilingualize(__CLASS__, $indices) : $indices;
  }

}
