<?php

/**
 * @package CRM
 * @copyright CiviCRM LLC https://civicrm.org/licensing
 *
 * Generated from xml/schema/CRM/Core/File.xml
 * DO NOT EDIT.  Generated by CRM_Core_CodeGen
 * (GenCodeChecksum:0f54a53356092fa11da07162c141e43f)
 */

/**
 * Database access object for the File entity.
 */
class CRM_Core_DAO_File extends CRM_Core_DAO {
  const EXT = 'civicrm';
  const TABLE_ADDED = '1.5';

  /**
   * Static instance to hold the table name.
   *
   * @var string
   */
  public static $_tableName = 'civicrm_file';

  /**
   * Should CiviCRM log any modifications to this table in the civicrm_log table.
   *
   * @var bool
   */
  public static $_log = TRUE;

  /**
   * Unique ID
   *
   * @var int|string|null
   *   (SQL type: int unsigned)
   *   Note that values will be retrieved from the database as a string.
   */
  public $id;

  /**
   * Type of file (e.g. Transcript, Income Tax Return, etc). FK to civicrm_option_value.
   *
   * @var int|string|null
   *   (SQL type: int unsigned)
   *   Note that values will be retrieved from the database as a string.
   */
  public $file_type_id;

  /**
   * mime type of the document
   *
   * @var string|null
   *   (SQL type: varchar(255))
   *   Note that values will be retrieved from the database as a string.
   */
  public $mime_type;

  /**
   * uri of the file on disk
   *
   * @var string|null
   *   (SQL type: varchar(255))
   *   Note that values will be retrieved from the database as a string.
   */
  public $uri;

  /**
   * contents of the document
   *
   * @var string|null
   *   (SQL type: mediumblob)
   *   Note that values will be retrieved from the database as a string.
   */
  public $document;

  /**
   * Additional descriptive text regarding this attachment (optional).
   *
   * @var string|null
   *   (SQL type: varchar(255))
   *   Note that values will be retrieved from the database as a string.
   */
  public $description;

  /**
   * Date and time that this attachment was uploaded or written to server.
   *
   * @var string|null
   *   (SQL type: datetime)
   *   Note that values will be retrieved from the database as a string.
   */
  public $upload_date;

  /**
   * FK to civicrm_contact, who uploaded this file
   *
   * @var int|string|null
   *   (SQL type: int unsigned)
   *   Note that values will be retrieved from the database as a string.
   */
  public $created_id;

  /**
   * Class constructor.
   */
  public function __construct() {
    $this->__table = 'civicrm_file';
    parent::__construct();
  }

  /**
   * Returns localized title of this entity.
   *
   * @param bool $plural
   *   Whether to return the plural version of the title.
   */
  public static function getEntityTitle($plural = FALSE) {
    return $plural ? ts('Files') : ts('File');
  }

  /**
   * Returns all the column names of this table
   *
   * @return array
   */
  public static function &fields() {
    if (!isset(Civi::$statics[__CLASS__]['fields'])) {
      Civi::$statics[__CLASS__]['fields'] = [
        'id' => [
          'name' => 'id',
          'type' => CRM_Utils_Type::T_INT,
          'title' => ts('File ID'),
          'description' => ts('Unique ID'),
          'required' => TRUE,
          'usage' => [
            'import' => FALSE,
            'export' => FALSE,
            'duplicate_matching' => FALSE,
            'token' => FALSE,
          ],
          'where' => 'civicrm_file.id',
          'table_name' => 'civicrm_file',
          'entity' => 'File',
          'bao' => 'CRM_Core_BAO_File',
          'localizable' => 0,
          'html' => [
            'type' => 'Number',
          ],
          'readonly' => TRUE,
          'add' => '1.5',
        ],
        'file_type_id' => [
          'name' => 'file_type_id',
          'type' => CRM_Utils_Type::T_INT,
          'title' => ts('File Type'),
          'description' => ts('Type of file (e.g. Transcript, Income Tax Return, etc). FK to civicrm_option_value.'),
          'usage' => [
            'import' => FALSE,
            'export' => FALSE,
            'duplicate_matching' => FALSE,
            'token' => FALSE,
          ],
          'where' => 'civicrm_file.file_type_id',
          'table_name' => 'civicrm_file',
          'entity' => 'File',
          'bao' => 'CRM_Core_BAO_File',
          'localizable' => 0,
          'html' => [
            'type' => 'Select',
          ],
          'pseudoconstant' => [
            'optionGroupName' => 'file_type',
            'optionEditPath' => 'civicrm/admin/options/file_type',
          ],
          'add' => '1.5',
        ],
        'mime_type' => [
          'name' => 'mime_type',
          'type' => CRM_Utils_Type::T_STRING,
          'title' => ts('Mime Type'),
          'description' => ts('mime type of the document'),
          'maxlength' => 255,
          'size' => CRM_Utils_Type::HUGE,
          'usage' => [
            'import' => FALSE,
            'export' => FALSE,
            'duplicate_matching' => FALSE,
            'token' => FALSE,
          ],
          'where' => 'civicrm_file.mime_type',
          'table_name' => 'civicrm_file',
          'entity' => 'File',
          'bao' => 'CRM_Core_BAO_File',
          'localizable' => 0,
          'add' => '1.5',
        ],
        'uri' => [
          'name' => 'uri',
          'type' => CRM_Utils_Type::T_STRING,
          'title' => ts('Path'),
          'description' => ts('uri of the file on disk'),
          'maxlength' => 255,
          'size' => CRM_Utils_Type::HUGE,
          'usage' => [
            'import' => FALSE,
            'export' => FALSE,
            'duplicate_matching' => FALSE,
            'token' => FALSE,
          ],
          'where' => 'civicrm_file.uri',
          'table_name' => 'civicrm_file',
          'entity' => 'File',
          'bao' => 'CRM_Core_BAO_File',
          'localizable' => 0,
          'add' => '1.5',
        ],
        'document' => [
          'name' => 'document',
          'type' => CRM_Utils_Type::T_MEDIUMBLOB,
          'title' => ts('File Contents'),
          'description' => ts('contents of the document'),
          'usage' => [
            'import' => FALSE,
            'export' => FALSE,
            'duplicate_matching' => FALSE,
            'token' => FALSE,
          ],
          'where' => 'civicrm_file.document',
          'table_name' => 'civicrm_file',
          'entity' => 'File',
          'bao' => 'CRM_Core_BAO_File',
          'localizable' => 0,
          'add' => '1.5',
        ],
        'description' => [
          'name' => 'description',
          'type' => CRM_Utils_Type::T_STRING,
          'title' => ts('File Description'),
          'description' => ts('Additional descriptive text regarding this attachment (optional).'),
          'maxlength' => 255,
          'size' => CRM_Utils_Type::HUGE,
          'usage' => [
            'import' => FALSE,
            'export' => FALSE,
            'duplicate_matching' => FALSE,
            'token' => FALSE,
          ],
          'where' => 'civicrm_file.description',
          'table_name' => 'civicrm_file',
          'entity' => 'File',
          'bao' => 'CRM_Core_BAO_File',
          'localizable' => 0,
          'add' => '1.5',
        ],
        'upload_date' => [
          'name' => 'upload_date',
          'type' => CRM_Utils_Type::T_DATE + CRM_Utils_Type::T_TIME,
          'title' => ts('File Upload Date'),
          'description' => ts('Date and time that this attachment was uploaded or written to server.'),
          'usage' => [
            'import' => FALSE,
            'export' => FALSE,
            'duplicate_matching' => FALSE,
            'token' => FALSE,
          ],
          'where' => 'civicrm_file.upload_date',
          'table_name' => 'civicrm_file',
          'entity' => 'File',
          'bao' => 'CRM_Core_BAO_File',
          'localizable' => 0,
          'add' => '1.5',
        ],
        'created_id' => [
          'name' => 'created_id',
          'type' => CRM_Utils_Type::T_INT,
          'title' => ts('Created By Contact ID'),
          'description' => ts('FK to civicrm_contact, who uploaded this file'),
          'usage' => [
            'import' => FALSE,
            'export' => FALSE,
            'duplicate_matching' => FALSE,
            'token' => FALSE,
          ],
          'where' => 'civicrm_file.created_id',
          'table_name' => 'civicrm_file',
          'entity' => 'File',
          'bao' => 'CRM_Core_BAO_File',
          'localizable' => 0,
          'FKClassName' => 'CRM_Contact_DAO_Contact',
          'FKColumnName' => 'id',
          'html' => [
            'label' => ts("Created By"),
          ],
          'add' => '5.3',
        ],
      ];
      CRM_Core_DAO_AllCoreTables::invoke(__CLASS__, 'fields_callback', Civi::$statics[__CLASS__]['fields']);
    }
    return Civi::$statics[__CLASS__]['fields'];
  }

  /**
   * Returns the list of fields that can be imported
   *
   * @param bool $prefix
   *
   * @return array
   */
  public static function &import($prefix = FALSE) {
    $r = CRM_Core_DAO_AllCoreTables::getImports(__CLASS__, 'file', $prefix, []);
    return $r;
  }

  /**
   * Returns the list of fields that can be exported
   *
   * @param bool $prefix
   *
   * @return array
   */
  public static function &export($prefix = FALSE) {
    $r = CRM_Core_DAO_AllCoreTables::getExports(__CLASS__, 'file', $prefix, []);
    return $r;
  }

  /**
   * Returns the list of indices
   *
   * @param bool $localize
   *
   * @return array
   */
  public static function indices($localize = TRUE) {
    $indices = [];
    return ($localize && !empty($indices)) ? CRM_Core_DAO_AllCoreTables::multilingualize(__CLASS__, $indices) : $indices;
  }

}
