<?php

/**
 * @package CRM
 * @copyright CiviCRM LLC https://civicrm.org/licensing
 *
 * Generated from xml/schema/CRM/Mailing/Event/MailingEventBounce.xml
 * DO NOT EDIT.  Generated by CRM_Core_CodeGen
 * (GenCodeChecksum:1b94272a41cbe10d181eea827015f7b2)
 */

/**
 * Database access object for the MailingEventBounce entity.
 */
class CRM_Mailing_Event_DAO_MailingEventBounce extends CRM_Core_DAO {
  const EXT = 'civicrm';
  const TABLE_ADDED = '';
  const COMPONENT = 'CiviMail';

  /**
   * Static instance to hold the table name.
   *
   * @var string
   */
  public static $_tableName = 'civicrm_mailing_event_bounce';

  /**
   * Should CiviCRM log any modifications to this table in the civicrm_log table.
   *
   * @var bool
   */
  public static $_log = FALSE;

  /**
   * @var int|string|null
   *   (SQL type: int unsigned)
   *   Note that values will be retrieved from the database as a string.
   */
  public $id;

  /**
   * FK to EventQueue
   *
   * @var int|string
   *   (SQL type: int unsigned)
   *   Note that values will be retrieved from the database as a string.
   */
  public $event_queue_id;

  /**
   * What type of bounce was it?
   *
   * @var int|string|null
   *   (SQL type: int unsigned)
   *   Note that values will be retrieved from the database as a string.
   */
  public $bounce_type_id;

  /**
   * The reason the email bounced.
   *
   * @var string|null
   *   (SQL type: varchar(255))
   *   Note that values will be retrieved from the database as a string.
   */
  public $bounce_reason;

  /**
   * When this bounce event occurred.
   *
   * @var string
   *   (SQL type: timestamp)
   *   Note that values will be retrieved from the database as a string.
   */
  public $time_stamp;

  /**
   * Class constructor.
   */
  public function __construct() {
    $this->__table = 'civicrm_mailing_event_bounce';
    parent::__construct();
  }

  /**
   * Returns localized title of this entity.
   *
   * @param bool $plural
   *   Whether to return the plural version of the title.
   */
  public static function getEntityTitle($plural = FALSE) {
    return $plural ? ts('Mailing Bounces') : ts('Mailing Bounce');
  }

  /**
   * Returns user-friendly description of this entity.
   *
   * @return string
   */
  public static function getEntityDescription() {
    return ts('Mailings that failed to reach the inbox of the recipient.');
  }

  /**
   * Returns all the column names of this table
   *
   * @return array
   */
  public static function &fields() {
    if (!isset(Civi::$statics[__CLASS__]['fields'])) {
      Civi::$statics[__CLASS__]['fields'] = [
        'id' => [
          'name' => 'id',
          'type' => CRM_Utils_Type::T_INT,
          'title' => ts('Bounce ID'),
          'required' => TRUE,
          'usage' => [
            'import' => FALSE,
            'export' => FALSE,
            'duplicate_matching' => FALSE,
            'token' => FALSE,
          ],
          'where' => 'civicrm_mailing_event_bounce.id',
          'table_name' => 'civicrm_mailing_event_bounce',
          'entity' => 'MailingEventBounce',
          'bao' => 'CRM_Mailing_Event_BAO_MailingEventBounce',
          'localizable' => 0,
          'html' => [
            'type' => 'Number',
            'label' => ts("ID"),
          ],
          'readonly' => TRUE,
          'add' => NULL,
        ],
        'event_queue_id' => [
          'name' => 'event_queue_id',
          'type' => CRM_Utils_Type::T_INT,
          'title' => ts('Event Queue ID'),
          'description' => ts('FK to EventQueue'),
          'required' => TRUE,
          'usage' => [
            'import' => FALSE,
            'export' => FALSE,
            'duplicate_matching' => FALSE,
            'token' => FALSE,
          ],
          'where' => 'civicrm_mailing_event_bounce.event_queue_id',
          'table_name' => 'civicrm_mailing_event_bounce',
          'entity' => 'MailingEventBounce',
          'bao' => 'CRM_Mailing_Event_BAO_MailingEventBounce',
          'localizable' => 0,
          'FKClassName' => 'CRM_Mailing_Event_DAO_MailingEventQueue',
          'FKColumnName' => 'id',
          'html' => [
            'label' => ts("Recipient"),
          ],
          'add' => NULL,
        ],
        'bounce_type_id' => [
          'name' => 'bounce_type_id',
          'type' => CRM_Utils_Type::T_INT,
          'title' => ts('Bounce Type ID'),
          'description' => ts('What type of bounce was it?'),
          'usage' => [
            'import' => FALSE,
            'export' => FALSE,
            'duplicate_matching' => FALSE,
            'token' => FALSE,
          ],
          'where' => 'civicrm_mailing_event_bounce.bounce_type_id',
          'table_name' => 'civicrm_mailing_event_bounce',
          'entity' => 'MailingEventBounce',
          'bao' => 'CRM_Mailing_Event_BAO_MailingEventBounce',
          'localizable' => 0,
          'html' => [
            'type' => 'Select',
            'label' => ts("Bounce Type"),
          ],
          'pseudoconstant' => [
            'table' => 'civicrm_mailing_bounce_type',
            'keyColumn' => 'id',
            'labelColumn' => 'name',
          ],
          'add' => NULL,
        ],
        'bounce_reason' => [
          'name' => 'bounce_reason',
          'type' => CRM_Utils_Type::T_STRING,
          'title' => ts('Bounce Reason'),
          'description' => ts('The reason the email bounced.'),
          'maxlength' => 255,
          'size' => CRM_Utils_Type::HUGE,
          'usage' => [
            'import' => FALSE,
            'export' => FALSE,
            'duplicate_matching' => FALSE,
            'token' => FALSE,
          ],
          'where' => 'civicrm_mailing_event_bounce.bounce_reason',
          'table_name' => 'civicrm_mailing_event_bounce',
          'entity' => 'MailingEventBounce',
          'bao' => 'CRM_Mailing_Event_BAO_MailingEventBounce',
          'localizable' => 0,
          'add' => NULL,
        ],
        'time_stamp' => [
          'name' => 'time_stamp',
          'type' => CRM_Utils_Type::T_TIMESTAMP,
          'title' => ts('Timestamp'),
          'description' => ts('When this bounce event occurred.'),
          'required' => TRUE,
          'usage' => [
            'import' => FALSE,
            'export' => FALSE,
            'duplicate_matching' => FALSE,
            'token' => FALSE,
          ],
          'where' => 'civicrm_mailing_event_bounce.time_stamp',
          'default' => 'CURRENT_TIMESTAMP',
          'table_name' => 'civicrm_mailing_event_bounce',
          'entity' => 'MailingEventBounce',
          'bao' => 'CRM_Mailing_Event_BAO_MailingEventBounce',
          'localizable' => 0,
          'add' => NULL,
        ],
      ];
      CRM_Core_DAO_AllCoreTables::invoke(__CLASS__, 'fields_callback', Civi::$statics[__CLASS__]['fields']);
    }
    return Civi::$statics[__CLASS__]['fields'];
  }

  /**
   * Returns the list of fields that can be imported
   *
   * @param bool $prefix
   *
   * @return array
   */
  public static function &import($prefix = FALSE) {
    $r = CRM_Core_DAO_AllCoreTables::getImports(__CLASS__, 'mailing_event_bounce', $prefix, []);
    return $r;
  }

  /**
   * Returns the list of fields that can be exported
   *
   * @param bool $prefix
   *
   * @return array
   */
  public static function &export($prefix = FALSE) {
    $r = CRM_Core_DAO_AllCoreTables::getExports(__CLASS__, 'mailing_event_bounce', $prefix, []);
    return $r;
  }

  /**
   * Returns the list of indices
   *
   * @param bool $localize
   *
   * @return array
   */
  public static function indices($localize = TRUE) {
    $indices = [];
    return ($localize && !empty($indices)) ? CRM_Core_DAO_AllCoreTables::multilingualize(__CLASS__, $indices) : $indices;
  }

}
