<?php

/**
 * @package CRM
 * @copyright CiviCRM LLC https://civicrm.org/licensing
 *
 * Generated from xml/schema/CRM/Price/LineItem.xml
 * DO NOT EDIT.  Generated by CRM_Core_CodeGen
 * (GenCodeChecksum:3680ce678d999b96b3d6533393a8aa5a)
 */

/**
 * Database access object for the LineItem entity.
 */
class CRM_Price_DAO_LineItem extends CRM_Core_DAO {
  const EXT = 'civicrm';
  const TABLE_ADDED = '1.7';
  const COMPONENT = 'CiviContribute';

  /**
   * Static instance to hold the table name.
   *
   * @var string
   */
  public static $_tableName = 'civicrm_line_item';

  /**
   * Field to show when displaying a record.
   *
   * @var string
   */
  public static $_labelField = 'label';

  /**
   * Should CiviCRM log any modifications to this table in the civicrm_log table.
   *
   * @var bool
   */
  public static $_log = TRUE;

  /**
   * Line Item
   *
   * @var int|string|null
   *   (SQL type: int unsigned)
   *   Note that values will be retrieved from the database as a string.
   */
  public $id;

  /**
   * May contain civicrm_contribution, civicrm_participant or civicrm_membership
   *
   * @var string
   *   (SQL type: varchar(64))
   *   Note that values will be retrieved from the database as a string.
   */
  public $entity_table;

  /**
   * entry in table
   *
   * @var int|string
   *   (SQL type: int unsigned)
   *   Note that values will be retrieved from the database as a string.
   */
  public $entity_id;

  /**
   * FK to civicrm_contribution
   *
   * @var int|string|null
   *   (SQL type: int unsigned)
   *   Note that values will be retrieved from the database as a string.
   */
  public $contribution_id;

  /**
   * FK to civicrm_price_field
   *
   * @var int|string|null
   *   (SQL type: int unsigned)
   *   Note that values will be retrieved from the database as a string.
   */
  public $price_field_id;

  /**
   * descriptive label for item - from price_field_value.label
   *
   * @var string|null
   *   (SQL type: varchar(255))
   *   Note that values will be retrieved from the database as a string.
   */
  public $label;

  /**
   * How many items ordered
   *
   * @var float|string
   *   (SQL type: decimal(20,2))
   *   Note that values will be retrieved from the database as a string.
   */
  public $qty;

  /**
   * price of each item
   *
   * @var float|string
   *   (SQL type: decimal(20,2))
   *   Note that values will be retrieved from the database as a string.
   */
  public $unit_price;

  /**
   * qty * unit_price
   *
   * @var float|string
   *   (SQL type: decimal(20,2))
   *   Note that values will be retrieved from the database as a string.
   */
  public $line_total;

  /**
   * Participant count for field
   *
   * @var int|string|null
   *   (SQL type: int unsigned)
   *   Note that values will be retrieved from the database as a string.
   */
  public $participant_count;

  /**
   * FK to civicrm_price_field_value
   *
   * @var int|string|null
   *   (SQL type: int unsigned)
   *   Note that values will be retrieved from the database as a string.
   */
  public $price_field_value_id;

  /**
   * FK to Financial Type.
   *
   * @var int|string|null
   *   (SQL type: int unsigned)
   *   Note that values will be retrieved from the database as a string.
   */
  public $financial_type_id;

  /**
   * Portion of total amount which is NOT tax deductible.
   *
   * @var float|string
   *   (SQL type: decimal(20,2))
   *   Note that values will be retrieved from the database as a string.
   */
  public $non_deductible_amount;

  /**
   * tax of each item
   *
   * @var float|string
   *   (SQL type: decimal(20,2))
   *   Note that values will be retrieved from the database as a string.
   */
  public $tax_amount;

  /**
   * Number of terms for this membership (only supported in Order->Payment flow). If the field is NULL it means unknown and it will be assumed to be 1 during payment.create if entity_table is civicrm_membership
   *
   * @var int|string|null
   *   (SQL type: int unsigned)
   *   Note that values will be retrieved from the database as a string.
   */
  public $membership_num_terms;

  /**
   * Class constructor.
   */
  public function __construct() {
    $this->__table = 'civicrm_line_item';
    parent::__construct();
  }

  /**
   * Returns localized title of this entity.
   *
   * @param bool $plural
   *   Whether to return the plural version of the title.
   */
  public static function getEntityTitle($plural = FALSE) {
    return $plural ? ts('Line Items') : ts('Line Item');
  }

  /**
   * Returns all the column names of this table
   *
   * @return array
   */
  public static function &fields() {
    if (!isset(Civi::$statics[__CLASS__]['fields'])) {
      Civi::$statics[__CLASS__]['fields'] = [
        'id' => [
          'name' => 'id',
          'type' => CRM_Utils_Type::T_INT,
          'title' => ts('Line Item ID'),
          'description' => ts('Line Item'),
          'required' => TRUE,
          'usage' => [
            'import' => FALSE,
            'export' => FALSE,
            'duplicate_matching' => FALSE,
            'token' => FALSE,
          ],
          'where' => 'civicrm_line_item.id',
          'table_name' => 'civicrm_line_item',
          'entity' => 'LineItem',
          'bao' => 'CRM_Price_BAO_LineItem',
          'localizable' => 0,
          'html' => [
            'type' => 'Number',
          ],
          'readonly' => TRUE,
          'add' => '1.7',
        ],
        'entity_table' => [
          'name' => 'entity_table',
          'type' => CRM_Utils_Type::T_STRING,
          'title' => ts('Line Item Entity Type'),
          'description' => ts('May contain civicrm_contribution, civicrm_participant or civicrm_membership'),
          'required' => TRUE,
          'maxlength' => 64,
          'size' => CRM_Utils_Type::BIG,
          'usage' => [
            'import' => FALSE,
            'export' => FALSE,
            'duplicate_matching' => FALSE,
            'token' => FALSE,
          ],
          'where' => 'civicrm_line_item.entity_table',
          'table_name' => 'civicrm_line_item',
          'entity' => 'LineItem',
          'bao' => 'CRM_Price_BAO_LineItem',
          'localizable' => 0,
          'pseudoconstant' => [
            'callback' => 'CRM_Price_BAO_LineItem::entityTables',
          ],
          'add' => '1.7',
        ],
        'entity_id' => [
          'name' => 'entity_id',
          'type' => CRM_Utils_Type::T_INT,
          'title' => ts('Line Item Entity'),
          'description' => ts('entry in table'),
          'required' => TRUE,
          'usage' => [
            'import' => FALSE,
            'export' => FALSE,
            'duplicate_matching' => FALSE,
            'token' => FALSE,
          ],
          'where' => 'civicrm_line_item.entity_id',
          'table_name' => 'civicrm_line_item',
          'entity' => 'LineItem',
          'bao' => 'CRM_Price_BAO_LineItem',
          'localizable' => 0,
          'DFKEntityColumn' => 'entity_table',
          'FKColumnName' => 'id',
          'add' => '1.7',
        ],
        'contribution_id' => [
          'name' => 'contribution_id',
          'type' => CRM_Utils_Type::T_INT,
          'title' => ts('Contribution ID'),
          'description' => ts('FK to civicrm_contribution'),
          'usage' => [
            'import' => FALSE,
            'export' => FALSE,
            'duplicate_matching' => FALSE,
            'token' => FALSE,
          ],
          'where' => 'civicrm_line_item.contribution_id',
          'table_name' => 'civicrm_line_item',
          'entity' => 'LineItem',
          'bao' => 'CRM_Price_BAO_LineItem',
          'localizable' => 0,
          'FKClassName' => 'CRM_Contribute_DAO_Contribution',
          'FKColumnName' => 'id',
          'html' => [
            'type' => 'EntityRef',
            'label' => ts("Contribution"),
          ],
          'add' => '4.5',
        ],
        'price_field_id' => [
          'name' => 'price_field_id',
          'type' => CRM_Utils_Type::T_INT,
          'title' => ts('Price Field ID'),
          'description' => ts('FK to civicrm_price_field'),
          'usage' => [
            'import' => FALSE,
            'export' => FALSE,
            'duplicate_matching' => FALSE,
            'token' => FALSE,
          ],
          'where' => 'civicrm_line_item.price_field_id',
          'table_name' => 'civicrm_line_item',
          'entity' => 'LineItem',
          'bao' => 'CRM_Price_BAO_LineItem',
          'localizable' => 0,
          'FKClassName' => 'CRM_Price_DAO_PriceField',
          'FKColumnName' => 'id',
          'html' => [
            'type' => 'Select',
            'label' => ts("Price Field"),
          ],
          'pseudoconstant' => [
            'table' => 'civicrm_price_field',
            'keyColumn' => 'id',
            'labelColumn' => 'label',
            'nameColumn' => 'name',
          ],
          'add' => '1.7',
        ],
        'label' => [
          'name' => 'label',
          'type' => CRM_Utils_Type::T_STRING,
          'title' => ts('Line Item Label'),
          'description' => ts('descriptive label for item - from price_field_value.label'),
          'maxlength' => 255,
          'size' => CRM_Utils_Type::HUGE,
          'usage' => [
            'import' => FALSE,
            'export' => FALSE,
            'duplicate_matching' => FALSE,
            'token' => FALSE,
          ],
          'where' => 'civicrm_line_item.label',
          'default' => NULL,
          'table_name' => 'civicrm_line_item',
          'entity' => 'LineItem',
          'bao' => 'CRM_Price_BAO_LineItem',
          'localizable' => 0,
          'html' => [
            'type' => 'Text',
          ],
          'add' => '1.7',
        ],
        'qty' => [
          'name' => 'qty',
          'type' => CRM_Utils_Type::T_FLOAT,
          'title' => ts('Line Item Quantity'),
          'description' => ts('How many items ordered'),
          'required' => TRUE,
          'precision' => [
            20,
            2,
          ],
          'usage' => [
            'import' => FALSE,
            'export' => FALSE,
            'duplicate_matching' => FALSE,
            'token' => FALSE,
          ],
          'where' => 'civicrm_line_item.qty',
          'table_name' => 'civicrm_line_item',
          'entity' => 'LineItem',
          'bao' => 'CRM_Price_BAO_LineItem',
          'localizable' => 0,
          'html' => [
            'type' => 'Text',
          ],
          'add' => '1.7',
        ],
        'unit_price' => [
          'name' => 'unit_price',
          'type' => CRM_Utils_Type::T_MONEY,
          'title' => ts('Unit Price'),
          'description' => ts('price of each item'),
          'required' => TRUE,
          'precision' => [
            20,
            2,
          ],
          'usage' => [
            'import' => FALSE,
            'export' => FALSE,
            'duplicate_matching' => FALSE,
            'token' => FALSE,
          ],
          'where' => 'civicrm_line_item.unit_price',
          'table_name' => 'civicrm_line_item',
          'entity' => 'LineItem',
          'bao' => 'CRM_Price_BAO_LineItem',
          'localizable' => 0,
          'html' => [
            'type' => 'Text',
            'label' => ts("Unit Price"),
          ],
          'add' => '1.7',
        ],
        'line_total' => [
          'name' => 'line_total',
          'type' => CRM_Utils_Type::T_MONEY,
          'title' => ts('Line Item Total'),
          'description' => ts('qty * unit_price'),
          'required' => TRUE,
          'precision' => [
            20,
            2,
          ],
          'usage' => [
            'import' => FALSE,
            'export' => FALSE,
            'duplicate_matching' => FALSE,
            'token' => FALSE,
          ],
          'where' => 'civicrm_line_item.line_total',
          'table_name' => 'civicrm_line_item',
          'entity' => 'LineItem',
          'bao' => 'CRM_Price_BAO_LineItem',
          'localizable' => 0,
          'add' => '1.7',
        ],
        'participant_count' => [
          'name' => 'participant_count',
          'type' => CRM_Utils_Type::T_INT,
          'title' => ts('Line Item Participant Count'),
          'description' => ts('Participant count for field'),
          'usage' => [
            'import' => FALSE,
            'export' => FALSE,
            'duplicate_matching' => FALSE,
            'token' => FALSE,
          ],
          'where' => 'civicrm_line_item.participant_count',
          'default' => NULL,
          'table_name' => 'civicrm_line_item',
          'entity' => 'LineItem',
          'bao' => 'CRM_Price_BAO_LineItem',
          'localizable' => 0,
          'html' => [
            'type' => 'Text',
          ],
          'add' => '3.2',
        ],
        'price_field_value_id' => [
          'name' => 'price_field_value_id',
          'type' => CRM_Utils_Type::T_INT,
          'title' => ts('Option ID'),
          'description' => ts('FK to civicrm_price_field_value'),
          'usage' => [
            'import' => FALSE,
            'export' => FALSE,
            'duplicate_matching' => FALSE,
            'token' => FALSE,
          ],
          'where' => 'civicrm_line_item.price_field_value_id',
          'default' => NULL,
          'table_name' => 'civicrm_line_item',
          'entity' => 'LineItem',
          'bao' => 'CRM_Price_BAO_LineItem',
          'localizable' => 0,
          'FKClassName' => 'CRM_Price_DAO_PriceFieldValue',
          'FKColumnName' => 'id',
          'html' => [
            'label' => ts("Option"),
          ],
          'pseudoconstant' => [
            'table' => 'civicrm_price_field_value',
            'keyColumn' => 'id',
            'labelColumn' => 'label',
            'nameColumn' => 'name',
          ],
          'add' => '3.3',
        ],
        'financial_type_id' => [
          'name' => 'financial_type_id',
          'type' => CRM_Utils_Type::T_INT,
          'title' => ts('Financial Type ID'),
          'description' => ts('FK to Financial Type.'),
          'usage' => [
            'import' => FALSE,
            'export' => FALSE,
            'duplicate_matching' => FALSE,
            'token' => FALSE,
          ],
          'where' => 'civicrm_line_item.financial_type_id',
          'default' => NULL,
          'table_name' => 'civicrm_line_item',
          'entity' => 'LineItem',
          'bao' => 'CRM_Price_BAO_LineItem',
          'localizable' => 0,
          'FKClassName' => 'CRM_Financial_DAO_FinancialType',
          'FKColumnName' => 'id',
          'html' => [
            'type' => 'Select',
            'label' => ts("Financial Type"),
          ],
          'pseudoconstant' => [
            'table' => 'civicrm_financial_type',
            'keyColumn' => 'id',
            'labelColumn' => 'name',
          ],
          'add' => '4.3',
        ],
        'non_deductible_amount' => [
          'name' => 'non_deductible_amount',
          'type' => CRM_Utils_Type::T_MONEY,
          'title' => ts('Non-deductible Amount'),
          'description' => ts('Portion of total amount which is NOT tax deductible.'),
          'required' => TRUE,
          'precision' => [
            20,
            2,
          ],
          'usage' => [
            'import' => FALSE,
            'export' => FALSE,
            'duplicate_matching' => FALSE,
            'token' => FALSE,
          ],
          'where' => 'civicrm_line_item.non_deductible_amount',
          'headerPattern' => '/non?.?deduct/i',
          'dataPattern' => '/^\d+(\.\d{2})?$/',
          'default' => '0.0',
          'table_name' => 'civicrm_line_item',
          'entity' => 'LineItem',
          'bao' => 'CRM_Price_BAO_LineItem',
          'localizable' => 0,
          'html' => [
            'type' => 'Text',
          ],
          'add' => '4.7',
        ],
        'tax_amount' => [
          'name' => 'tax_amount',
          'type' => CRM_Utils_Type::T_MONEY,
          'title' => ts('Tax Amount'),
          'description' => ts('tax of each item'),
          'required' => TRUE,
          'precision' => [
            20,
            2,
          ],
          'usage' => [
            'import' => TRUE,
            'export' => TRUE,
            'duplicate_matching' => TRUE,
            'token' => FALSE,
          ],
          'import' => TRUE,
          'where' => 'civicrm_line_item.tax_amount',
          'headerPattern' => '/tax(.?am(ou)?nt)?/i',
          'dataPattern' => '/^\d+(\.\d{2})?$/',
          'export' => TRUE,
          'default' => '0',
          'table_name' => 'civicrm_line_item',
          'entity' => 'LineItem',
          'bao' => 'CRM_Price_BAO_LineItem',
          'localizable' => 0,
          'html' => [
            'type' => 'Text',
          ],
          'add' => '4.6',
        ],
        'membership_num_terms' => [
          'name' => 'membership_num_terms',
          'type' => CRM_Utils_Type::T_INT,
          'title' => ts('Number of membership terms purchased'),
          'description' => ts('Number of terms for this membership (only supported in Order->Payment flow). If the field is NULL it means unknown and it will be assumed to be 1 during payment.create if entity_table is civicrm_membership'),
          'usage' => [
            'import' => FALSE,
            'export' => FALSE,
            'duplicate_matching' => FALSE,
            'token' => FALSE,
          ],
          'where' => 'civicrm_line_item.membership_num_terms',
          'default' => NULL,
          'table_name' => 'civicrm_line_item',
          'entity' => 'LineItem',
          'bao' => 'CRM_Price_BAO_LineItem',
          'localizable' => 0,
          'add' => '5.40',
        ],
      ];
      CRM_Core_DAO_AllCoreTables::invoke(__CLASS__, 'fields_callback', Civi::$statics[__CLASS__]['fields']);
    }
    return Civi::$statics[__CLASS__]['fields'];
  }

  /**
   * Returns the list of fields that can be imported
   *
   * @param bool $prefix
   *
   * @return array
   */
  public static function &import($prefix = FALSE) {
    $r = CRM_Core_DAO_AllCoreTables::getImports(__CLASS__, 'line_item', $prefix, []);
    return $r;
  }

  /**
   * Returns the list of fields that can be exported
   *
   * @param bool $prefix
   *
   * @return array
   */
  public static function &export($prefix = FALSE) {
    $r = CRM_Core_DAO_AllCoreTables::getExports(__CLASS__, 'line_item', $prefix, []);
    return $r;
  }

  /**
   * Returns the list of indices
   *
   * @param bool $localize
   *
   * @return array
   */
  public static function indices($localize = TRUE) {
    $indices = [
      'UI_line_item_value' => [
        'name' => 'UI_line_item_value',
        'field' => [
          0 => 'entity_id',
          1 => 'entity_table',
          2 => 'contribution_id',
          3 => 'price_field_value_id',
          4 => 'price_field_id',
        ],
        'localizable' => FALSE,
        'unique' => TRUE,
        'sig' => 'civicrm_line_item::1::entity_id::entity_table::contribution_id::price_field_value_id::price_field_id',
      ],
    ];
    return ($localize && !empty($indices)) ? CRM_Core_DAO_AllCoreTables::multilingualize(__CLASS__, $indices) : $indices;
  }

}
