<?php

/**
 * @package CRM
 * @copyright CiviCRM LLC https://civicrm.org/licensing
 *
 * Generated from xml/schema/CRM/Price/PriceField.xml
 * DO NOT EDIT.  Generated by CRM_Core_CodeGen
 * (GenCodeChecksum:a025293005d5f886c5371e539ceaa75d)
 */

/**
 * Database access object for the PriceField entity.
 */
class CRM_Price_DAO_PriceField extends CRM_Core_DAO {
  const EXT = 'civicrm';
  const TABLE_ADDED = '1.8';
  const COMPONENT = 'CiviContribute';

  /**
   * Static instance to hold the table name.
   *
   * @var string
   */
  public static $_tableName = 'civicrm_price_field';

  /**
   * Field to show when displaying a record.
   *
   * @var string
   */
  public static $_labelField = 'label';

  /**
   * Should CiviCRM log any modifications to this table in the civicrm_log table.
   *
   * @var bool
   */
  public static $_log = TRUE;

  /**
   * Paths for accessing this entity in the UI.
   *
   * @var string[]
   */
  protected static $_paths = [
    'add' => 'civicrm/admin/price/field/edit?reset=1&action=add&sid=[price_set_id]',
    'update' => 'civicrm/admin/price/field/edit?reset=1&action=update&sid=[price_set_id]&fid=[id]',
    'delete' => 'civicrm/admin/price/field/edit?reset=1&action=delete&sid=[price_set_id]&fid=[id]',
    'preview' => 'civicrm/admin/price/field/edit?reset=1&action=preview&sid=[price_set_id]&fid=[id]',
    'browse' => 'civicrm/admin/price/field',
  ];

  /**
   * Price Field
   *
   * @var int|string|null
   *   (SQL type: int unsigned)
   *   Note that values will be retrieved from the database as a string.
   */
  public $id;

  /**
   * FK to civicrm_price_set
   *
   * @var int|string
   *   (SQL type: int unsigned)
   *   Note that values will be retrieved from the database as a string.
   */
  public $price_set_id;

  /**
   * Variable name/programmatic handle for this field.
   *
   * @var string
   *   (SQL type: varchar(255))
   *   Note that values will be retrieved from the database as a string.
   */
  public $name;

  /**
   * Text for form field label (also friendly name for administering this field).
   *
   * @var string
   *   (SQL type: varchar(255))
   *   Note that values will be retrieved from the database as a string.
   */
  public $label;

  /**
   * @var string
   *   (SQL type: varchar(12))
   *   Note that values will be retrieved from the database as a string.
   */
  public $html_type;

  /**
   * Enter a quantity for this field?
   *
   * @var bool|string
   *   (SQL type: tinyint)
   *   Note that values will be retrieved from the database as a string.
   */
  public $is_enter_qty;

  /**
   * Description and/or help text to display before this field.
   *
   * @var string|null
   *   (SQL type: text)
   *   Note that values will be retrieved from the database as a string.
   */
  public $help_pre;

  /**
   * Description and/or help text to display after this field.
   *
   * @var string|null
   *   (SQL type: text)
   *   Note that values will be retrieved from the database as a string.
   */
  public $help_post;

  /**
   * Order in which the fields should appear
   *
   * @var int|string|null
   *   (SQL type: int)
   *   Note that values will be retrieved from the database as a string.
   */
  public $weight;

  /**
   * Should the price be displayed next to the label for each option?
   *
   * @var bool|string
   *   (SQL type: tinyint)
   *   Note that values will be retrieved from the database as a string.
   */
  public $is_display_amounts;

  /**
   * number of options per line for checkbox and radio
   *
   * @var int|string|null
   *   (SQL type: int unsigned)
   *   Note that values will be retrieved from the database as a string.
   */
  public $options_per_line;

  /**
   * Is this price field active
   *
   * @var bool|string
   *   (SQL type: tinyint)
   *   Note that values will be retrieved from the database as a string.
   */
  public $is_active;

  /**
   * Is this price field required (value must be > 1)
   *
   * @var bool|string
   *   (SQL type: tinyint)
   *   Note that values will be retrieved from the database as a string.
   */
  public $is_required;

  /**
   * If non-zero, do not show this field before the date specified
   *
   * @var string|null
   *   (SQL type: datetime)
   *   Note that values will be retrieved from the database as a string.
   */
  public $active_on;

  /**
   * If non-zero, do not show this field after the date specified
   *
   * @var string|null
   *   (SQL type: datetime)
   *   Note that values will be retrieved from the database as a string.
   */
  public $expire_on;

  /**
   * Optional scripting attributes for field
   *
   * @var string|null
   *   (SQL type: varchar(255))
   *   Note that values will be retrieved from the database as a string.
   */
  public $javascript;

  /**
   * Implicit FK to civicrm_option_group with name = 'visibility'
   *
   * @var int|string|null
   *   (SQL type: int unsigned)
   *   Note that values will be retrieved from the database as a string.
   */
  public $visibility_id;

  /**
   * Class constructor.
   */
  public function __construct() {
    $this->__table = 'civicrm_price_field';
    parent::__construct();
  }

  /**
   * Returns localized title of this entity.
   *
   * @param bool $plural
   *   Whether to return the plural version of the title.
   */
  public static function getEntityTitle($plural = FALSE) {
    return $plural ? ts('Price Fields') : ts('Price Field');
  }

  /**
   * Returns all the column names of this table
   *
   * @return array
   */
  public static function &fields() {
    if (!isset(Civi::$statics[__CLASS__]['fields'])) {
      Civi::$statics[__CLASS__]['fields'] = [
        'id' => [
          'name' => 'id',
          'type' => CRM_Utils_Type::T_INT,
          'title' => ts('Price Field ID'),
          'description' => ts('Price Field'),
          'required' => TRUE,
          'usage' => [
            'import' => FALSE,
            'export' => FALSE,
            'duplicate_matching' => FALSE,
            'token' => FALSE,
          ],
          'where' => 'civicrm_price_field.id',
          'table_name' => 'civicrm_price_field',
          'entity' => 'PriceField',
          'bao' => 'CRM_Price_BAO_PriceField',
          'localizable' => 0,
          'html' => [
            'type' => 'Number',
          ],
          'readonly' => TRUE,
          'add' => '1.8',
        ],
        'price_set_id' => [
          'name' => 'price_set_id',
          'type' => CRM_Utils_Type::T_INT,
          'title' => ts('Price Set ID'),
          'description' => ts('FK to civicrm_price_set'),
          'required' => TRUE,
          'usage' => [
            'import' => FALSE,
            'export' => FALSE,
            'duplicate_matching' => FALSE,
            'token' => FALSE,
          ],
          'where' => 'civicrm_price_field.price_set_id',
          'table_name' => 'civicrm_price_field',
          'entity' => 'PriceField',
          'bao' => 'CRM_Price_BAO_PriceField',
          'localizable' => 0,
          'FKClassName' => 'CRM_Price_DAO_PriceSet',
          'FKColumnName' => 'id',
          'html' => [
            'type' => 'EntityRef',
            'label' => ts("Price Set"),
          ],
          'pseudoconstant' => [
            'table' => 'civicrm_price_set',
            'keyColumn' => 'id',
            'labelColumn' => 'title',
            'nameColumn' => 'name',
          ],
          'add' => '1.8',
        ],
        'name' => [
          'name' => 'name',
          'type' => CRM_Utils_Type::T_STRING,
          'title' => ts('Name'),
          'description' => ts('Variable name/programmatic handle for this field.'),
          'required' => TRUE,
          'maxlength' => 255,
          'size' => CRM_Utils_Type::HUGE,
          'usage' => [
            'import' => FALSE,
            'export' => FALSE,
            'duplicate_matching' => FALSE,
            'token' => FALSE,
          ],
          'where' => 'civicrm_price_field.name',
          'table_name' => 'civicrm_price_field',
          'entity' => 'PriceField',
          'bao' => 'CRM_Price_BAO_PriceField',
          'localizable' => 0,
          'html' => [
            'type' => 'Text',
          ],
          'add' => '1.8',
        ],
        'label' => [
          'name' => 'label',
          'type' => CRM_Utils_Type::T_STRING,
          'title' => ts('Label'),
          'description' => ts('Text for form field label (also friendly name for administering this field).'),
          'required' => TRUE,
          'maxlength' => 255,
          'size' => CRM_Utils_Type::HUGE,
          'usage' => [
            'import' => FALSE,
            'export' => FALSE,
            'duplicate_matching' => FALSE,
            'token' => FALSE,
          ],
          'where' => 'civicrm_price_field.label',
          'table_name' => 'civicrm_price_field',
          'entity' => 'PriceField',
          'bao' => 'CRM_Price_BAO_PriceField',
          'localizable' => 1,
          'html' => [
            'type' => 'Text',
          ],
          'add' => '1.8',
        ],
        'html_type' => [
          'name' => 'html_type',
          'type' => CRM_Utils_Type::T_STRING,
          'title' => ts('Html Type'),
          'required' => TRUE,
          'maxlength' => 12,
          'size' => CRM_Utils_Type::TWELVE,
          'usage' => [
            'import' => FALSE,
            'export' => FALSE,
            'duplicate_matching' => FALSE,
            'token' => FALSE,
          ],
          'where' => 'civicrm_price_field.html_type',
          'table_name' => 'civicrm_price_field',
          'entity' => 'PriceField',
          'bao' => 'CRM_Price_BAO_PriceField',
          'localizable' => 0,
          'html' => [
            'type' => 'Select',
            'label' => ts("Html Type"),
          ],
          'pseudoconstant' => [
            'callback' => 'CRM_Price_BAO_PriceField::htmlTypes',
          ],
          'add' => '1.8',
        ],
        'is_enter_qty' => [
          'name' => 'is_enter_qty',
          'type' => CRM_Utils_Type::T_BOOLEAN,
          'title' => ts('Price Field Quantity Required?'),
          'description' => ts('Enter a quantity for this field?'),
          'required' => TRUE,
          'usage' => [
            'import' => FALSE,
            'export' => FALSE,
            'duplicate_matching' => FALSE,
            'token' => FALSE,
          ],
          'where' => 'civicrm_price_field.is_enter_qty',
          'default' => '0',
          'table_name' => 'civicrm_price_field',
          'entity' => 'PriceField',
          'bao' => 'CRM_Price_BAO_PriceField',
          'localizable' => 0,
          'html' => [
            'type' => 'CheckBox',
          ],
          'add' => '1.8',
        ],
        'help_pre' => [
          'name' => 'help_pre',
          'type' => CRM_Utils_Type::T_TEXT,
          'title' => ts('Price Field Pre Text'),
          'description' => ts('Description and/or help text to display before this field.'),
          'rows' => 4,
          'cols' => 80,
          'usage' => [
            'import' => FALSE,
            'export' => FALSE,
            'duplicate_matching' => FALSE,
            'token' => FALSE,
          ],
          'where' => 'civicrm_price_field.help_pre',
          'table_name' => 'civicrm_price_field',
          'entity' => 'PriceField',
          'bao' => 'CRM_Price_BAO_PriceField',
          'localizable' => 1,
          'html' => [
            'type' => 'TextArea',
          ],
          'add' => '1.8',
        ],
        'help_post' => [
          'name' => 'help_post',
          'type' => CRM_Utils_Type::T_TEXT,
          'title' => ts('Price Field Post Text'),
          'description' => ts('Description and/or help text to display after this field.'),
          'rows' => 4,
          'cols' => 80,
          'usage' => [
            'import' => FALSE,
            'export' => FALSE,
            'duplicate_matching' => FALSE,
            'token' => FALSE,
          ],
          'where' => 'civicrm_price_field.help_post',
          'table_name' => 'civicrm_price_field',
          'entity' => 'PriceField',
          'bao' => 'CRM_Price_BAO_PriceField',
          'localizable' => 1,
          'html' => [
            'type' => 'TextArea',
          ],
          'add' => '1.8',
        ],
        'weight' => [
          'name' => 'weight',
          'type' => CRM_Utils_Type::T_INT,
          'title' => ts('Order'),
          'description' => ts('Order in which the fields should appear'),
          'usage' => [
            'import' => FALSE,
            'export' => FALSE,
            'duplicate_matching' => FALSE,
            'token' => FALSE,
          ],
          'where' => 'civicrm_price_field.weight',
          'default' => '1',
          'table_name' => 'civicrm_price_field',
          'entity' => 'PriceField',
          'bao' => 'CRM_Price_BAO_PriceField',
          'localizable' => 0,
          'html' => [
            'type' => 'Select',
          ],
          'add' => '1.8',
        ],
        'is_display_amounts' => [
          'name' => 'is_display_amounts',
          'type' => CRM_Utils_Type::T_BOOLEAN,
          'title' => ts('Price Field Show Amounts?'),
          'description' => ts('Should the price be displayed next to the label for each option?'),
          'required' => TRUE,
          'usage' => [
            'import' => FALSE,
            'export' => FALSE,
            'duplicate_matching' => FALSE,
            'token' => FALSE,
          ],
          'where' => 'civicrm_price_field.is_display_amounts',
          'default' => '1',
          'table_name' => 'civicrm_price_field',
          'entity' => 'PriceField',
          'bao' => 'CRM_Price_BAO_PriceField',
          'localizable' => 0,
          'html' => [
            'type' => 'CheckBox',
          ],
          'add' => NULL,
        ],
        'options_per_line' => [
          'name' => 'options_per_line',
          'type' => CRM_Utils_Type::T_INT,
          'title' => ts('Price Field Options per Row'),
          'description' => ts('number of options per line for checkbox and radio'),
          'usage' => [
            'import' => FALSE,
            'export' => FALSE,
            'duplicate_matching' => FALSE,
            'token' => FALSE,
          ],
          'where' => 'civicrm_price_field.options_per_line',
          'default' => '1',
          'table_name' => 'civicrm_price_field',
          'entity' => 'PriceField',
          'bao' => 'CRM_Price_BAO_PriceField',
          'localizable' => 0,
          'html' => [
            'type' => 'Text',
          ],
          'add' => '1.8',
        ],
        'is_active' => [
          'name' => 'is_active',
          'type' => CRM_Utils_Type::T_BOOLEAN,
          'title' => ts('Price Field Is Active?'),
          'description' => ts('Is this price field active'),
          'required' => TRUE,
          'usage' => [
            'import' => FALSE,
            'export' => FALSE,
            'duplicate_matching' => FALSE,
            'token' => FALSE,
          ],
          'where' => 'civicrm_price_field.is_active',
          'default' => '1',
          'table_name' => 'civicrm_price_field',
          'entity' => 'PriceField',
          'bao' => 'CRM_Price_BAO_PriceField',
          'localizable' => 0,
          'html' => [
            'type' => 'CheckBox',
            'label' => ts("Enabled"),
          ],
          'add' => '1.8',
        ],
        'is_required' => [
          'name' => 'is_required',
          'type' => CRM_Utils_Type::T_BOOLEAN,
          'title' => ts('Price Field is Required?'),
          'description' => ts('Is this price field required (value must be > 1)'),
          'required' => TRUE,
          'usage' => [
            'import' => FALSE,
            'export' => FALSE,
            'duplicate_matching' => FALSE,
            'token' => FALSE,
          ],
          'where' => 'civicrm_price_field.is_required',
          'default' => '1',
          'table_name' => 'civicrm_price_field',
          'entity' => 'PriceField',
          'bao' => 'CRM_Price_BAO_PriceField',
          'localizable' => 0,
          'html' => [
            'type' => 'CheckBox',
          ],
          'add' => '1.8',
        ],
        'active_on' => [
          'name' => 'active_on',
          'type' => CRM_Utils_Type::T_DATE + CRM_Utils_Type::T_TIME,
          'title' => ts('Price Field Start Date'),
          'description' => ts('If non-zero, do not show this field before the date specified'),
          'usage' => [
            'import' => FALSE,
            'export' => FALSE,
            'duplicate_matching' => FALSE,
            'token' => FALSE,
          ],
          'where' => 'civicrm_price_field.active_on',
          'default' => NULL,
          'table_name' => 'civicrm_price_field',
          'entity' => 'PriceField',
          'bao' => 'CRM_Price_BAO_PriceField',
          'localizable' => 0,
          'html' => [
            'type' => 'Select Date',
            'formatType' => 'activityDateTime',
          ],
          'add' => '1.8',
        ],
        'expire_on' => [
          'name' => 'expire_on',
          'type' => CRM_Utils_Type::T_DATE + CRM_Utils_Type::T_TIME,
          'title' => ts('Price Field End Date'),
          'description' => ts('If non-zero, do not show this field after the date specified'),
          'usage' => [
            'import' => FALSE,
            'export' => FALSE,
            'duplicate_matching' => FALSE,
            'token' => FALSE,
          ],
          'where' => 'civicrm_price_field.expire_on',
          'default' => NULL,
          'table_name' => 'civicrm_price_field',
          'entity' => 'PriceField',
          'bao' => 'CRM_Price_BAO_PriceField',
          'localizable' => 0,
          'html' => [
            'type' => 'Select Date',
            'formatType' => 'activityDateTime',
          ],
          'add' => '1.8',
        ],
        'javascript' => [
          'name' => 'javascript',
          'type' => CRM_Utils_Type::T_STRING,
          'title' => ts('Price Field Javascript'),
          'description' => ts('Optional scripting attributes for field'),
          'maxlength' => 255,
          'size' => CRM_Utils_Type::HUGE,
          'usage' => [
            'import' => FALSE,
            'export' => FALSE,
            'duplicate_matching' => FALSE,
            'token' => FALSE,
          ],
          'where' => 'civicrm_price_field.javascript',
          'table_name' => 'civicrm_price_field',
          'entity' => 'PriceField',
          'bao' => 'CRM_Price_BAO_PriceField',
          'localizable' => 0,
          'html' => [
            'type' => 'Text',
          ],
          'add' => '1.8',
        ],
        'visibility_id' => [
          'name' => 'visibility_id',
          'type' => CRM_Utils_Type::T_INT,
          'title' => ts('Price Field Visibility'),
          'description' => ts('Implicit FK to civicrm_option_group with name = \'visibility\''),
          'usage' => [
            'import' => FALSE,
            'export' => FALSE,
            'duplicate_matching' => FALSE,
            'token' => FALSE,
          ],
          'where' => 'civicrm_price_field.visibility_id',
          'default' => '1',
          'table_name' => 'civicrm_price_field',
          'entity' => 'PriceField',
          'bao' => 'CRM_Price_BAO_PriceField',
          'localizable' => 0,
          'html' => [
            'type' => 'Select',
          ],
          'pseudoconstant' => [
            'optionGroupName' => 'visibility',
            'optionEditPath' => 'civicrm/admin/options/visibility',
          ],
          'add' => '3.2',
        ],
      ];
      CRM_Core_DAO_AllCoreTables::invoke(__CLASS__, 'fields_callback', Civi::$statics[__CLASS__]['fields']);
    }
    return Civi::$statics[__CLASS__]['fields'];
  }

  /**
   * Returns the list of fields that can be imported
   *
   * @param bool $prefix
   *
   * @return array
   */
  public static function &import($prefix = FALSE) {
    $r = CRM_Core_DAO_AllCoreTables::getImports(__CLASS__, 'price_field', $prefix, []);
    return $r;
  }

  /**
   * Returns the list of fields that can be exported
   *
   * @param bool $prefix
   *
   * @return array
   */
  public static function &export($prefix = FALSE) {
    $r = CRM_Core_DAO_AllCoreTables::getExports(__CLASS__, 'price_field', $prefix, []);
    return $r;
  }

  /**
   * Returns the list of indices
   *
   * @param bool $localize
   *
   * @return array
   */
  public static function indices($localize = TRUE) {
    $indices = [
      'index_name' => [
        'name' => 'index_name',
        'field' => [
          0 => 'name',
        ],
        'localizable' => FALSE,
        'sig' => 'civicrm_price_field::0::name',
      ],
    ];
    return ($localize && !empty($indices)) ? CRM_Core_DAO_AllCoreTables::multilingualize(__CLASS__, $indices) : $indices;
  }

}
