<?php

/**
 * @package CRM
 * @copyright CiviCRM LLC https://civicrm.org/licensing
 *
 * Generated from org.civicrm.afform/xml/schema/CRM/Afform/AfformSubmission.xml
 * DO NOT EDIT.  Generated by CRM_Core_CodeGen
 * (GenCodeChecksum:7f2d888fb07086aae91b0c864f9dedde)
 */
use CRM_Afform_ExtensionUtil as E;

/**
 * Database access object for the AfformSubmission entity.
 */
class CRM_Afform_DAO_AfformSubmission extends CRM_Core_DAO {
  const EXT = E::LONG_NAME;
  const TABLE_ADDED = '';

  /**
   * Static instance to hold the table name.
   *
   * @var string
   */
  public static $_tableName = 'civicrm_afform_submission';

  /**
   * Should CiviCRM log any modifications to this table in the civicrm_log table.
   *
   * @var bool
   */
  public static $_log = TRUE;

  /**
   * Paths for accessing this entity in the UI.
   *
   * @var string[]
   */
  protected static $_paths = [
    'view' => '[afform_name:url]#?sid=[id]',
  ];

  /**
   * Unique Submission ID
   *
   * @var int|string|null
   *   (SQL type: int unsigned)
   *   Note that values will be retrieved from the database as a string.
   */
  public $id;

  /**
   * @var int|string|null
   *   (SQL type: int unsigned)
   *   Note that values will be retrieved from the database as a string.
   */
  public $contact_id;

  /**
   * Name of submitted afform
   *
   * @var string|null
   *   (SQL type: varchar(255))
   *   Note that values will be retrieved from the database as a string.
   */
  public $afform_name;

  /**
   * IDs of saved entities
   *
   * @var string|null
   *   (SQL type: text)
   *   Note that values will be retrieved from the database as a string.
   */
  public $data;

  /**
   * @var string|null
   *   (SQL type: timestamp)
   *   Note that values will be retrieved from the database as a string.
   */
  public $submission_date;

  /**
   * fk to Afform Submission Status options in civicrm_option_values
   *
   * @var int|string
   *   (SQL type: int unsigned)
   *   Note that values will be retrieved from the database as a string.
   */
  public $status_id;

  /**
   * Class constructor.
   */
  public function __construct() {
    $this->__table = 'civicrm_afform_submission';
    parent::__construct();
  }

  /**
   * Returns localized title of this entity.
   *
   * @param bool $plural
   *   Whether to return the plural version of the title.
   */
  public static function getEntityTitle($plural = FALSE) {
    return $plural ? E::ts('FormBuilder Submissions') : E::ts('FormBuilder Submission');
  }

  /**
   * Returns all the column names of this table
   *
   * @return array
   */
  public static function &fields() {
    if (!isset(Civi::$statics[__CLASS__]['fields'])) {
      Civi::$statics[__CLASS__]['fields'] = [
        'id' => [
          'name' => 'id',
          'type' => CRM_Utils_Type::T_INT,
          'title' => E::ts('Form Submission ID'),
          'description' => E::ts('Unique Submission ID'),
          'required' => TRUE,
          'usage' => [
            'import' => FALSE,
            'export' => FALSE,
            'duplicate_matching' => FALSE,
            'token' => FALSE,
          ],
          'where' => 'civicrm_afform_submission.id',
          'table_name' => 'civicrm_afform_submission',
          'entity' => 'AfformSubmission',
          'bao' => 'CRM_Afform_DAO_AfformSubmission',
          'localizable' => 0,
          'html' => [
            'type' => 'Number',
          ],
          'readonly' => TRUE,
          'add' => '5.41',
        ],
        'contact_id' => [
          'name' => 'contact_id',
          'type' => CRM_Utils_Type::T_INT,
          'title' => E::ts('User Contact ID'),
          'usage' => [
            'import' => FALSE,
            'export' => FALSE,
            'duplicate_matching' => FALSE,
            'token' => FALSE,
          ],
          'where' => 'civicrm_afform_submission.contact_id',
          'table_name' => 'civicrm_afform_submission',
          'entity' => 'AfformSubmission',
          'bao' => 'CRM_Afform_DAO_AfformSubmission',
          'localizable' => 0,
          'FKClassName' => 'CRM_Contact_DAO_Contact',
          'FKColumnName' => 'id',
          'html' => [
            'type' => 'EntityRef',
          ],
          'add' => '5.41',
        ],
        'afform_name' => [
          'name' => 'afform_name',
          'type' => CRM_Utils_Type::T_STRING,
          'title' => E::ts('Afform Name'),
          'description' => E::ts('Name of submitted afform'),
          'maxlength' => 255,
          'size' => CRM_Utils_Type::HUGE,
          'usage' => [
            'import' => FALSE,
            'export' => FALSE,
            'duplicate_matching' => FALSE,
            'token' => FALSE,
          ],
          'where' => 'civicrm_afform_submission.afform_name',
          'table_name' => 'civicrm_afform_submission',
          'entity' => 'AfformSubmission',
          'bao' => 'CRM_Afform_DAO_AfformSubmission',
          'localizable' => 0,
          'html' => [
            'type' => 'Select',
          ],
          'pseudoconstant' => [
            'callback' => 'CRM_Afform_BAO_AfformSubmission::getAllAfformsByName',
            'suffixes' => [
              'name',
              'label',
              'description',
              'abbr',
              'icon',
              'url',
            ],
          ],
          'add' => '5.41',
        ],
        'data' => [
          'name' => 'data',
          'type' => CRM_Utils_Type::T_TEXT,
          'title' => E::ts('Submission Data'),
          'description' => E::ts('IDs of saved entities'),
          'usage' => [
            'import' => FALSE,
            'export' => FALSE,
            'duplicate_matching' => FALSE,
            'token' => FALSE,
          ],
          'where' => 'civicrm_afform_submission.data',
          'table_name' => 'civicrm_afform_submission',
          'entity' => 'AfformSubmission',
          'bao' => 'CRM_Afform_DAO_AfformSubmission',
          'localizable' => 0,
          'serialize' => self::SERIALIZE_JSON,
          'add' => '5.41',
        ],
        'submission_date' => [
          'name' => 'submission_date',
          'type' => CRM_Utils_Type::T_TIMESTAMP,
          'title' => E::ts('Submission Date/Time'),
          'usage' => [
            'import' => FALSE,
            'export' => FALSE,
            'duplicate_matching' => FALSE,
            'token' => FALSE,
          ],
          'where' => 'civicrm_afform_submission.submission_date',
          'default' => 'CURRENT_TIMESTAMP',
          'table_name' => 'civicrm_afform_submission',
          'entity' => 'AfformSubmission',
          'bao' => 'CRM_Afform_DAO_AfformSubmission',
          'localizable' => 0,
          'html' => [
            'type' => 'Select Date',
          ],
          'readonly' => TRUE,
          'add' => '5.41',
        ],
        'status_id' => [
          'name' => 'status_id',
          'type' => CRM_Utils_Type::T_INT,
          'title' => E::ts('Submission Status'),
          'description' => E::ts('fk to Afform Submission Status options in civicrm_option_values'),
          'required' => TRUE,
          'usage' => [
            'import' => FALSE,
            'export' => FALSE,
            'duplicate_matching' => FALSE,
            'token' => FALSE,
          ],
          'where' => 'civicrm_afform_submission.status_id',
          'default' => '1',
          'table_name' => 'civicrm_afform_submission',
          'entity' => 'AfformSubmission',
          'bao' => 'CRM_Afform_DAO_AfformSubmission',
          'localizable' => 0,
          'html' => [
            'type' => 'Select',
          ],
          'pseudoconstant' => [
            'optionGroupName' => 'afform_submission_status',
            'optionEditPath' => 'civicrm/admin/options/afform_submission_status',
          ],
          'add' => '5.66',
        ],
      ];
      CRM_Core_DAO_AllCoreTables::invoke(__CLASS__, 'fields_callback', Civi::$statics[__CLASS__]['fields']);
    }
    return Civi::$statics[__CLASS__]['fields'];
  }

  /**
   * Returns the list of fields that can be imported
   *
   * @param bool $prefix
   *
   * @return array
   */
  public static function &import($prefix = FALSE) {
    $r = CRM_Core_DAO_AllCoreTables::getImports(__CLASS__, 'afform_submission', $prefix, []);
    return $r;
  }

  /**
   * Returns the list of fields that can be exported
   *
   * @param bool $prefix
   *
   * @return array
   */
  public static function &export($prefix = FALSE) {
    $r = CRM_Core_DAO_AllCoreTables::getExports(__CLASS__, 'afform_submission', $prefix, []);
    return $r;
  }

  /**
   * Returns the list of indices
   *
   * @param bool $localize
   *
   * @return array
   */
  public static function indices($localize = TRUE) {
    $indices = [];
    return ($localize && !empty($indices)) ? CRM_Core_DAO_AllCoreTables::multilingualize(__CLASS__, $indices) : $indices;
  }

}
