<?php

/**
 * @package CRM
 * @copyright CiviCRM LLC https://civicrm.org/licensing
 *
 * Generated from standaloneusers/xml/schema/CRM/Standaloneusers/User.xml
 * DO NOT EDIT.  Generated by CRM_Core_CodeGen
 * (GenCodeChecksum:b7e5920d71c6d2ea6ee10a4f6e9b101b)
 */
use CRM_Standaloneusers_ExtensionUtil as E;

/**
 * Database access object for the User entity.
 */
class CRM_Standaloneusers_DAO_User extends CRM_Core_DAO {
  const EXT = E::LONG_NAME;
  const TABLE_ADDED = '';

  /**
   * Static instance to hold the table name.
   *
   * @var string
   */
  public static $_tableName = 'civicrm_uf_match';

  /**
   * Field to show when displaying a record.
   *
   * @var string
   */
  public static $_labelField = 'username';

  /**
   * Should CiviCRM log any modifications to this table in the civicrm_log table.
   *
   * @var bool
   */
  public static $_log = TRUE;

  /**
   * Paths for accessing this entity in the UI.
   *
   * @var string[]
   */
  protected static $_paths = [
    'add' => 'civicrm/admin/user',
    'update' => 'civicrm/admin/user/#?User1=[id]',
  ];

  /**
   * Unique User ID
   *
   * @var int|string|null
   *   (SQL type: int unsigned)
   *   Note that values will be retrieved from the database as a string.
   */
  public $id;

  /**
   * Which Domain is this match entry for
   *
   * @var int|string
   *   (SQL type: int unsigned)
   *   Note that values will be retrieved from the database as a string.
   */
  public $domain_id;

  /**
   * UF ID. Redundant in Standalone. Needs to be identical to id.
   *
   * @var int|string
   *   (SQL type: int unsigned)
   *   Note that values will be retrieved from the database as a string.
   */
  public $uf_id;

  /**
   * Email (e.g. for password resets)
   *
   * @var string|null
   *   (SQL type: varchar(255))
   *   Note that values will be retrieved from the database as a string.
   */
  public $uf_name;

  /**
   * FK to Contact ID
   *
   * @var int|string|null
   *   (SQL type: int unsigned)
   *   Note that values will be retrieved from the database as a string.
   */
  public $contact_id;

  /**
   * @var string
   *   (SQL type: varchar(60))
   *   Note that values will be retrieved from the database as a string.
   */
  public $username;

  /**
   * Hashed, not plaintext password
   *
   * @var string
   *   (SQL type: varchar(128))
   *   Note that values will be retrieved from the database as a string.
   */
  public $hashed_password;

  /**
   * @var string|null
   *   (SQL type: timestamp)
   *   Note that values will be retrieved from the database as a string.
   */
  public $when_created;

  /**
   * @var string
   *   (SQL type: timestamp)
   *   Note that values will be retrieved from the database as a string.
   */
  public $when_last_accessed;

  /**
   * @var string
   *   (SQL type: timestamp)
   *   Note that values will be retrieved from the database as a string.
   */
  public $when_updated;

  /**
   * @var bool|string
   *   (SQL type: tinyint)
   *   Note that values will be retrieved from the database as a string.
   */
  public $is_active;

  /**
   * User's timezone
   *
   * @var string
   *   (SQL type: varchar(32))
   *   Note that values will be retrieved from the database as a string.
   */
  public $timezone;

  /**
   * UI language preferred by the given user/contact
   *
   * @var string|null
   *   (SQL type: varchar(5))
   *   Note that values will be retrieved from the database as a string.
   */
  public $language;

  /**
   * The unspent token
   *
   * @var string|null
   *   (SQL type: varchar(255))
   *   Note that values will be retrieved from the database as a string.
   */
  public $password_reset_token;

  /**
   * Class constructor.
   */
  public function __construct() {
    $this->__table = 'civicrm_uf_match';
    parent::__construct();
  }

  /**
   * Returns localized title of this entity.
   *
   * @param bool $plural
   *   Whether to return the plural version of the title.
   */
  public static function getEntityTitle($plural = FALSE) {
    return $plural ? E::ts('Users') : E::ts('User');
  }

  /**
   * Returns all the column names of this table
   *
   * @return array
   */
  public static function &fields() {
    if (!isset(Civi::$statics[__CLASS__]['fields'])) {
      Civi::$statics[__CLASS__]['fields'] = [
        'id' => [
          'name' => 'id',
          'type' => CRM_Utils_Type::T_INT,
          'title' => E::ts('UF Match ID'),
          'description' => E::ts('Unique User ID'),
          'required' => TRUE,
          'usage' => [
            'import' => FALSE,
            'export' => FALSE,
            'duplicate_matching' => FALSE,
            'token' => FALSE,
          ],
          'where' => 'civicrm_uf_match.id',
          'table_name' => 'civicrm_uf_match',
          'entity' => 'User',
          'bao' => 'CRM_Standaloneusers_DAO_User',
          'localizable' => 0,
          'html' => [
            'type' => 'Number',
          ],
          'readonly' => TRUE,
          'add' => '5.67',
        ],
        'domain_id' => [
          'name' => 'domain_id',
          'type' => CRM_Utils_Type::T_INT,
          'title' => E::ts('Domain ID'),
          'description' => E::ts('Which Domain is this match entry for'),
          'required' => TRUE,
          'usage' => [
            'import' => FALSE,
            'export' => FALSE,
            'duplicate_matching' => FALSE,
            'token' => FALSE,
          ],
          'where' => 'civicrm_uf_match.domain_id',
          'table_name' => 'civicrm_uf_match',
          'entity' => 'User',
          'bao' => 'CRM_Standaloneusers_DAO_User',
          'localizable' => 0,
          'FKClassName' => 'CRM_Core_DAO_Domain',
          'FKColumnName' => 'id',
          'html' => [
            'label' => E::ts("Domain"),
          ],
          'pseudoconstant' => [
            'table' => 'civicrm_domain',
            'keyColumn' => 'id',
            'labelColumn' => 'name',
          ],
          'add' => '3.0',
        ],
        'uf_id' => [
          'name' => 'uf_id',
          'type' => CRM_Utils_Type::T_INT,
          'title' => E::ts('CMS ID'),
          'description' => E::ts('UF ID. Redundant in Standalone. Needs to be identical to id.'),
          'required' => TRUE,
          'usage' => [
            'import' => FALSE,
            'export' => FALSE,
            'duplicate_matching' => FALSE,
            'token' => FALSE,
          ],
          'where' => 'civicrm_uf_match.uf_id',
          'default' => '0',
          'table_name' => 'civicrm_uf_match',
          'entity' => 'User',
          'bao' => 'CRM_Standaloneusers_DAO_User',
          'localizable' => 0,
          'add' => '1.1',
        ],
        'uf_name' => [
          'name' => 'uf_name',
          'type' => CRM_Utils_Type::T_STRING,
          'title' => E::ts('User Email'),
          'description' => E::ts('Email (e.g. for password resets)'),
          'maxlength' => 255,
          'size' => CRM_Utils_Type::HUGE,
          'usage' => [
            'import' => FALSE,
            'export' => FALSE,
            'duplicate_matching' => FALSE,
            'token' => FALSE,
          ],
          'where' => 'civicrm_uf_match.uf_name',
          'table_name' => 'civicrm_uf_match',
          'entity' => 'User',
          'bao' => 'CRM_Standaloneusers_DAO_User',
          'localizable' => 0,
          'html' => [
            'type' => 'Email',
          ],
          'add' => NULL,
        ],
        'contact_id' => [
          'name' => 'contact_id',
          'type' => CRM_Utils_Type::T_INT,
          'title' => E::ts('Contact ID'),
          'description' => E::ts('FK to Contact ID'),
          'usage' => [
            'import' => FALSE,
            'export' => FALSE,
            'duplicate_matching' => FALSE,
            'token' => FALSE,
          ],
          'where' => 'civicrm_uf_match.contact_id',
          'table_name' => 'civicrm_uf_match',
          'entity' => 'User',
          'bao' => 'CRM_Standaloneusers_DAO_User',
          'localizable' => 0,
          'FKClassName' => 'CRM_Contact_DAO_Contact',
          'html' => [
            'type' => 'EntityRef',
            'label' => E::ts("Contact"),
            'filter' => [
              'contact_type=Individual',
            ],
          ],
          'add' => '1.1',
        ],
        'username' => [
          'name' => 'username',
          'type' => CRM_Utils_Type::T_STRING,
          'title' => E::ts('Username'),
          'required' => TRUE,
          'maxlength' => 60,
          'size' => CRM_Utils_Type::BIG,
          'usage' => [
            'import' => FALSE,
            'export' => FALSE,
            'duplicate_matching' => FALSE,
            'token' => FALSE,
          ],
          'where' => 'civicrm_uf_match.username',
          'table_name' => 'civicrm_uf_match',
          'entity' => 'User',
          'bao' => 'CRM_Standaloneusers_DAO_User',
          'localizable' => 0,
          'html' => [
            'type' => 'Text',
          ],
          'add' => NULL,
        ],
        'hashed_password' => [
          'name' => 'hashed_password',
          'type' => CRM_Utils_Type::T_STRING,
          'title' => E::ts('Hashed Password'),
          'description' => E::ts('Hashed, not plaintext password'),
          'required' => TRUE,
          'maxlength' => 128,
          'size' => CRM_Utils_Type::HUGE,
          'usage' => [
            'import' => FALSE,
            'export' => FALSE,
            'duplicate_matching' => FALSE,
            'token' => FALSE,
          ],
          'where' => 'civicrm_uf_match.hashed_password',
          'permission' => [
            [
              'administer CiviCRM',
              'cms:administer users',
            ],
          ],
          'default' => '',
          'table_name' => 'civicrm_uf_match',
          'entity' => 'User',
          'bao' => 'CRM_Standaloneusers_DAO_User',
          'localizable' => 0,
          'readonly' => TRUE,
          'add' => NULL,
        ],
        'when_created' => [
          'name' => 'when_created',
          'type' => CRM_Utils_Type::T_TIMESTAMP,
          'title' => E::ts('When Created'),
          'usage' => [
            'import' => FALSE,
            'export' => FALSE,
            'duplicate_matching' => FALSE,
            'token' => FALSE,
          ],
          'where' => 'civicrm_uf_match.when_created',
          'default' => 'CURRENT_TIMESTAMP',
          'table_name' => 'civicrm_uf_match',
          'entity' => 'User',
          'bao' => 'CRM_Standaloneusers_DAO_User',
          'localizable' => 0,
          'add' => NULL,
        ],
        'when_last_accessed' => [
          'name' => 'when_last_accessed',
          'type' => CRM_Utils_Type::T_TIMESTAMP,
          'title' => E::ts('When Last Accessed'),
          'required' => FALSE,
          'usage' => [
            'import' => FALSE,
            'export' => FALSE,
            'duplicate_matching' => FALSE,
            'token' => FALSE,
          ],
          'where' => 'civicrm_uf_match.when_last_accessed',
          'table_name' => 'civicrm_uf_match',
          'entity' => 'User',
          'bao' => 'CRM_Standaloneusers_DAO_User',
          'localizable' => 0,
          'add' => NULL,
        ],
        'when_updated' => [
          'name' => 'when_updated',
          'type' => CRM_Utils_Type::T_TIMESTAMP,
          'title' => E::ts('When Updated'),
          'required' => FALSE,
          'usage' => [
            'import' => FALSE,
            'export' => FALSE,
            'duplicate_matching' => FALSE,
            'token' => FALSE,
          ],
          'where' => 'civicrm_uf_match.when_updated',
          'table_name' => 'civicrm_uf_match',
          'entity' => 'User',
          'bao' => 'CRM_Standaloneusers_DAO_User',
          'localizable' => 0,
          'add' => NULL,
        ],
        'is_active' => [
          'name' => 'is_active',
          'type' => CRM_Utils_Type::T_BOOLEAN,
          'title' => E::ts('Enabled'),
          'required' => TRUE,
          'usage' => [
            'import' => FALSE,
            'export' => FALSE,
            'duplicate_matching' => FALSE,
            'token' => FALSE,
          ],
          'where' => 'civicrm_uf_match.is_active',
          'default' => '1',
          'table_name' => 'civicrm_uf_match',
          'entity' => 'User',
          'bao' => 'CRM_Standaloneusers_DAO_User',
          'localizable' => 0,
          'html' => [
            'type' => 'CheckBox',
            'label' => E::ts("Enabled"),
          ],
          'add' => NULL,
        ],
        'timezone' => [
          'name' => 'timezone',
          'type' => CRM_Utils_Type::T_STRING,
          'title' => E::ts('Timezone'),
          'description' => E::ts('User\'s timezone'),
          'required' => FALSE,
          'maxlength' => 32,
          'size' => CRM_Utils_Type::MEDIUM,
          'usage' => [
            'import' => FALSE,
            'export' => FALSE,
            'duplicate_matching' => FALSE,
            'token' => FALSE,
          ],
          'where' => 'civicrm_uf_match.timezone',
          'table_name' => 'civicrm_uf_match',
          'entity' => 'User',
          'bao' => 'CRM_Standaloneusers_DAO_User',
          'localizable' => 0,
          'html' => [
            'type' => 'Select',
          ],
          'pseudoconstant' => [
            'callback' => 'CRM_Standaloneusers_BAO_User::getTimeZones',
          ],
          'add' => NULL,
        ],
        'language' => [
          'name' => 'language',
          'type' => CRM_Utils_Type::T_STRING,
          'title' => E::ts('Preferred Language'),
          'description' => E::ts('UI language preferred by the given user/contact'),
          'maxlength' => 5,
          'size' => CRM_Utils_Type::SIX,
          'usage' => [
            'import' => FALSE,
            'export' => FALSE,
            'duplicate_matching' => FALSE,
            'token' => FALSE,
          ],
          'where' => 'civicrm_uf_match.language',
          'table_name' => 'civicrm_uf_match',
          'entity' => 'User',
          'bao' => 'CRM_Standaloneusers_DAO_User',
          'localizable' => 0,
          'html' => [
            'type' => 'Select',
          ],
          'pseudoconstant' => [
            'callback' => 'CRM_Standaloneusers_BAO_User::getPreferredLanguages',
          ],
          'add' => '2.1',
        ],
        'password_reset_token' => [
          'name' => 'password_reset_token',
          'type' => CRM_Utils_Type::T_STRING,
          'title' => E::ts('Password Reset Token'),
          'description' => E::ts('The unspent token'),
          'maxlength' => 255,
          'size' => CRM_Utils_Type::HUGE,
          'usage' => [
            'import' => FALSE,
            'export' => FALSE,
            'duplicate_matching' => FALSE,
            'token' => FALSE,
          ],
          'where' => 'civicrm_uf_match.password_reset_token',
          'permission' => [
            [
              'administer CiviCRM',
              'cms:administer users',
            ],
          ],
          'table_name' => 'civicrm_uf_match',
          'entity' => 'User',
          'bao' => 'CRM_Standaloneusers_DAO_User',
          'localizable' => 0,
          'readonly' => TRUE,
          'add' => NULL,
        ],
      ];
      CRM_Core_DAO_AllCoreTables::invoke(__CLASS__, 'fields_callback', Civi::$statics[__CLASS__]['fields']);
    }
    return Civi::$statics[__CLASS__]['fields'];
  }

  /**
   * Returns the list of fields that can be imported
   *
   * @param bool $prefix
   *
   * @return array
   */
  public static function &import($prefix = FALSE) {
    $r = CRM_Core_DAO_AllCoreTables::getImports(__CLASS__, 'uf_match', $prefix, []);
    return $r;
  }

  /**
   * Returns the list of fields that can be exported
   *
   * @param bool $prefix
   *
   * @return array
   */
  public static function &export($prefix = FALSE) {
    $r = CRM_Core_DAO_AllCoreTables::getExports(__CLASS__, 'uf_match', $prefix, []);
    return $r;
  }

  /**
   * Returns the list of indices
   *
   * @param bool $localize
   *
   * @return array
   */
  public static function indices($localize = TRUE) {
    $indices = [
      'I_civicrm_uf_match_uf_id' => [
        'name' => 'I_civicrm_uf_match_uf_id',
        'field' => [
          0 => 'uf_id',
        ],
        'localizable' => FALSE,
        'sig' => 'civicrm_uf_match::0::uf_id',
      ],
      'UI_username' => [
        'name' => 'UI_username',
        'field' => [
          0 => 'username',
        ],
        'localizable' => FALSE,
        'unique' => TRUE,
        'sig' => 'civicrm_uf_match::1::username',
      ],
      'UI_uf_name_domain_id' => [
        'name' => 'UI_uf_name_domain_id',
        'field' => [
          0 => 'uf_name',
          1 => 'domain_id',
        ],
        'localizable' => FALSE,
        'unique' => TRUE,
        'sig' => 'civicrm_uf_match::1::uf_name::domain_id',
      ],
      'UI_contact_domain_id' => [
        'name' => 'UI_contact_domain_id',
        'field' => [
          0 => 'contact_id',
          1 => 'domain_id',
        ],
        'localizable' => FALSE,
        'unique' => TRUE,
        'sig' => 'civicrm_uf_match::1::contact_id::domain_id',
      ],
    ];
    return ($localize && !empty($indices)) ? CRM_Core_DAO_AllCoreTables::multilingualize(__CLASS__, $indices) : $indices;
  }

}
