<?php

// line 11 "src/Parser/TemplateParser.y"


namespace Smarty\Parser;

use \Smarty\Lexer\TemplateLexer as Lexer;
use \Smarty\ParseTree\Template as TemplateParseTree;
use \Smarty\Compiler\Template as TemplateCompiler;
use \Smarty\ParseTree\Code;
use \Smarty\ParseTree\Dq;
use \Smarty\ParseTree\DqContent;
use \Smarty\ParseTree\Tag;


/**
* Smarty Template Parser Class
*
* This is the template parser.
* It is generated from the TemplateParser.y file
* 
* @author Uwe Tews <uwe.tews@googlemail.com>
*/
class TemplateParser
{
// line 35 "src/Parser/TemplateParser.y"

    const ERR1 = 'Security error: Call to private object member not allowed';
    const ERR2 = 'Security error: Call to dynamic object member not allowed';

    /**
     * result status
     *
     * @var bool
     */
    public $successful = true;

    /**
     * return value
     *
     * @var mixed
     */
    public $retvalue = 0;

    /**
     * @var
     */
    public $yymajor;

    /**
     * last index of array variable
     *
     * @var mixed
     */
    public $last_index;

    /**
     * last variable name
     *
     * @var string
     */
    public $last_variable;

    /**
     * root parse tree buffer
     *
     * @var TemplateParseTree
     */
    public $root_buffer;

    /**
     * current parse tree object
     *
     * @var \Smarty\ParseTree\Base
     */
    public $current_buffer;

    /**
     * lexer object
     *
     * @var Lexer
     */
    public $lex;

    /**
     * internal error flag
     *
     * @var bool
     */
    private $internalError = false;

    /**
     * {strip} status
     *
     * @var bool
     */
    public $strip = false;
    /**
     * compiler object
     *
     * @var TemplateCompiler
     */
    public $compiler = null;

    /**
     * smarty object
     *
     * @var \Smarty\Smarty
     */
    public $smarty = null;

    /**
     * template object
     *
     * @var \Smarty\Template
     */
    public $template = null;

    /**
     * block nesting level
     *
     * @var int
     */
    public $block_nesting_level = 0;

    /**
     * security object
     *
     * @var \Smarty\Security
     */
    public $security = null;

    /**
     * template prefix array
     *
     * @var \Smarty\ParseTree\Base[]
     */
    public $template_prefix = array();

    /**
     * template prefix array
     *
     * @var \Smarty\ParseTree\Base[]
     */
    public $template_postfix = array();

    /**
     * constructor
     *
     * @param Lexer        $lex
     * @param TemplateCompiler $compiler
     */
    public function __construct(Lexer $lex, TemplateCompiler $compiler)
    {
        $this->lex = $lex;
        $this->compiler = $compiler;
        $this->template = $this->compiler->getTemplate();
        $this->smarty = $this->template->getSmarty();
        $this->security = $this->smarty->security_policy ?? false;
        $this->current_buffer = $this->root_buffer = new TemplateParseTree();
    }

     /**
     * insert PHP code in current buffer
     *
     * @param string $code
     */
    public function insertPhpCode($code)
    {
        $this->current_buffer->append_subtree($this, new Tag($this, $code));
    }

    /**
     * error rundown
     *
     */
    public function errorRunDown()
    {
        while ($this->yystack !== array()) {
            $this->yy_pop_parser_stack();
        }
        if (is_resource($this->yyTraceFILE)) {
            fclose($this->yyTraceFILE);
        }
    }

    /**
     *  merge PHP code with prefix code and return parse tree tag object
     *
     * @param string $code
     *
     * @return Tag
     */
    private function mergePrefixCode($code)
    {
        $tmp = '';
        foreach ($this->compiler->prefix_code as $preCode) {
            $tmp .= $preCode;
        }
        $this->compiler->prefix_code = array();
        $tmp .= $code;
        return new Tag($this, $this->compiler->processNocacheCode($tmp));
    }


    const TP_VERT                           =  1;
    const TP_COLON                          =  2;
    const TP_TEXT                           =  3;
    const TP_STRIPON                        =  4;
    const TP_STRIPOFF                       =  5;
    const TP_LITERALSTART                   =  6;
    const TP_LITERALEND                     =  7;
    const TP_LITERAL                        =  8;
    const TP_SIMPELOUTPUT                   =  9;
    const TP_SIMPLETAG                      = 10;
    const TP_SMARTYBLOCKCHILDPARENT         = 11;
    const TP_LDEL                           = 12;
    const TP_RDEL                           = 13;
    const TP_DOLLARID                       = 14;
    const TP_EQUAL                          = 15;
    const TP_ID                             = 16;
    const TP_PTR                            = 17;
    const TP_LDELIF                         = 18;
    const TP_LDELFOR                        = 19;
    const TP_SEMICOLON                      = 20;
    const TP_INCDEC                         = 21;
    const TP_TO                             = 22;
    const TP_STEP                           = 23;
    const TP_LDELFOREACH                    = 24;
    const TP_SPACE                          = 25;
    const TP_AS                             = 26;
    const TP_APTR                           = 27;
    const TP_LDELSETFILTER                  = 28;
    const TP_CLOSETAG                       = 29;
    const TP_LDELSLASH                      = 30;
    const TP_ATTR                           = 31;
    const TP_INTEGER                        = 32;
    const TP_COMMA                          = 33;
    const TP_OPENP                          = 34;
    const TP_CLOSEP                         = 35;
    const TP_MATH                           = 36;
    const TP_UNIMATH                        = 37;
    const TP_ISIN                           = 38;
    const TP_QMARK                          = 39;
    const TP_NOT                            = 40;
    const TP_TYPECAST                       = 41;
    const TP_HEX                            = 42;
    const TP_DOT                            = 43;
    const TP_INSTANCEOF                     = 44;
    const TP_SINGLEQUOTESTRING              = 45;
    const TP_DOUBLECOLON                    = 46;
    const TP_NAMESPACE                      = 47;
    const TP_AT                             = 48;
    const TP_HATCH                          = 49;
    const TP_OPENB                          = 50;
    const TP_CLOSEB                         = 51;
    const TP_DOLLAR                         = 52;
    const TP_LOGOP                          = 53;
    const TP_SLOGOP                         = 54;
    const TP_TLOGOP                         = 55;
    const TP_SINGLECOND                     = 56;
    const TP_ARRAYOPEN                      = 57;
    const TP_QUOTE                          = 58;
    const TP_BACKTICK                       = 59;
    const YY_NO_ACTION = 527;
    const YY_ACCEPT_ACTION = 526;
    const YY_ERROR_ACTION = 525;

    const YY_SZ_ACTTAB = 2372;
public static $yy_action = array(
     33,  197,  264,  299,  176,  298,  259,  242,  243,  244,
      1,  259,  135,  232,  199,  354,    6,   84,  495,  217,
    331,  354,  109,  104,  393,  248,  212,  256,  213,   51,
    219,  393,   21,  393,   51,   43,  393,   32,   44,   45,
    273,  221,  393,  277,  393,  200,  393,   83,    4,  136,
    295,  226,  149,   99,  220,    5,   52,  242,  243,  244,
      1,  307,  132,  211,  190,    9,    6,   84,  241,  217,
    211,  126,  109,  150,  261,  252,  212,  256,  213,  137,
    205,   98,   21,  313,   83,   43,   13,  295,   44,   45,
    273,  221,  260,  230,  197,  200,  293,   83,    4,  321,
    295,   35,  149,   86,  309,    5,   52,  242,  243,  244,
      1,  146,   97,  387,   82,  231,    6,   84,   14,  217,
    138,  251,  109,  148,   15,  387,  212,  256,  213,  452,
    219,  387,   21,  251,  439,   43,  452,  252,   44,   45,
    273,  221,    3,  277,   99,  200,  439,   83,    4,  252,
    295,  259,  526,   96,  252,    5,   52,  242,  243,  244,
      1,  136,  134,  262,  199,  103,    6,   84,  155,  217,
    252,  279,  109,  112,   51,  439,  212,  256,  213,  127,
    219,  316,   21,   99,  228,   43,  314,  439,   44,   45,
    273,  221,  318,  277,  263,  200,   83,   83,    4,  295,
    295,   46,   22,  280,   40,    5,   52,  242,  243,  244,
      1,   20,  134,  189,  191,  266,    6,   84,  254,  217,
    250,   19,  109,  152,  141,  253,  212,  256,  213,  197,
    219,  267,   21,  251,  251,   43,  175,  298,   44,   45,
    273,  221,  151,  277,  108,  200,   91,   83,    4,   87,
    295,  295,  251,  354,  180,    5,   52,  242,  243,  244,
      1,  259,  133,  140,  199,  354,    6,   84,  307,  217,
    211,  354,  109,  181,  197,   39,  212,  256,  213,  286,
    219,   14,   11,   94,   51,   43,   88,   15,   44,   45,
    273,  221,  153,  277,  143,  200,   92,   83,    4,  139,
    295,  295,  251,  154,  104,    5,   52,  242,  243,  244,
      1,  303,  134,  251,  186,  173,    6,   84,   36,  217,
     99,  126,  109,  181,  227,  285,  212,  256,  213,  137,
    208,   98,   21,  127,  180,   43,   13,  295,   44,   45,
    273,  221,  181,  277,  232,  200,  293,   83,    4,  112,
    295,  234,  196,  297,  104,    5,   52,  242,  243,  244,
      1,   29,  134,  224,  184,  156,    6,   84,  468,  217,
    197,  468,  109,  197,   23,  468,  212,  256,  213,  264,
    219,   18,   21,  175,  298,   43,  215,   15,   44,   45,
    273,  221,  232,  277,  170,  200,  168,   83,    4,  233,
    295,  295,  104,  144,   99,    5,   52,  242,  243,  244,
      1,  259,  134,  251,  199,  157,    6,   84,   26,  217,
    161,  181,  109,  181,  255,  439,  212,  256,  213,  178,
    185,  240,   21,  112,   51,   43,  164,  439,   44,   45,
    273,  221,  174,  277,  222,  200,  251,   83,    4,  305,
    295,   41,   42,  281,   12,    5,   52,  242,  243,  244,
      1,  197,  136,  163,  199,  167,    6,   84,  288,  289,
    290,  291,  109,   17,  304,  251,  212,  256,  213,  330,
    219,   16,   21,  258,  171,   47,  180,   25,   44,   45,
    273,  221,   39,  277,   93,  200,  255,   83,    4,  328,
    295,   41,   42,  281,   12,    5,   52,  242,  243,  244,
      1,  181,  136,  439,  199,  214,    6,   84,  288,  289,
    290,  291,  109,  177,  298,  439,  212,  256,  213,   28,
    219,    8,   21,  209,  194,   43,   89,  295,   44,   45,
    273,  221,  452,  277,   24,  200,  296,   83,    4,  452,
    295,    7,  440,  239,  240,    5,   52,  283,  210,  211,
    247,   95,   90,  106,  440,  188,  100,   81,   10,    9,
    254,  310,   98,   19,  294,  268,  269,  253,  195,  158,
    113,  169,  276,  201,  278,  172,  284,  293,  283,  210,
    211,  247,  197,   90,  106,  238,  187,  100,   58,   24,
     34,  322,  220,   98,  358,  159,  268,  269,  225,  223,
    317,  245,  179,  276,  201,  278,   14,  284,  293,  246,
    110,  283,   15,  211,  249,  439,  111,  106,  220,  188,
    100,   81,   24,  257,  323,  254,   98,  439,   19,  268,
    269,  118,  253,  265,  270,  272,  276,  201,  278,    7,
    284,  293,  283,  220,  211,  274,  292,  111,   85,  229,
    198,  116,   70,  275,  319,  160,  329,   98,  162,  320,
    268,  269,   36,  145,  216,   37,  332,  276,  201,  278,
    303,  284,  293,   41,   42,  281,   12,  303,  303,  283,
    303,  211,  204,  312,  111,  303,  303,  198,  116,   70,
    288,  289,  290,  291,   98,  303,  303,  268,  269,  303,
    303,  303,  303,  303,  276,  201,  278,  303,  284,  293,
    303,  303,  303,  283,  303,  211,  303,  303,  105,  203,
    312,  198,  119,   49,  303,  117,  303,  303,   98,  303,
    254,  268,  269,   19,  303,  303,  303,  253,  276,  201,
    278,  303,  284,  293,  303,  283,   14,  211,  147,  303,
    111,  303,   15,  198,  119,   65,  197,  303,  303,  303,
     98,  303,  468,  268,  269,  468,  197,  303,  355,  468,
    276,  201,  278,  303,  284,  293,  303,  303,  389,  283,
    355,  211,  207,  303,  111,  303,  355,  198,  119,   65,
    389,  303,  303,  303,   98,  303,  389,  268,  269,  303,
    197,  468,  303,  303,  276,  201,  278,  303,  284,  293,
    303,  303,  386,  283,  303,  211,  202,  303,  111,  303,
    303,  198,  116,   70,  386,  303,  303,  303,   98,  303,
    386,  268,  269,  303,  303,  303,  303,  303,  276,  201,
    278,  303,  284,  293,  303,  303,  303,  283,  303,  211,
    303,  303,  111,  303,  311,  198,  119,   65,  303,  303,
    303,  303,   98,  303,  303,  268,  269,  303,  303,  303,
    303,  303,  276,  201,  278,  303,  284,  293,  303,  303,
    303,  283,  303,  211,  206,  303,  105,  303,  303,  198,
    119,   56,  303,  233,  303,  303,   98,  303,  303,  268,
    269,  303,  303,  303,  303,  303,  276,  201,  278,  303,
    284,  293,  303,  283,  303,  211,  303,  303,  111,  303,
    303,  198,  115,   62,  303,  303,  303,  303,   98,  303,
    303,  268,  269,  303,  303,  303,  303,  303,  276,  201,
    278,  303,  284,  293,  303,  303,  303,  283,  303,  211,
    303,  303,  111,  303,  303,  193,  114,   57,  303,  303,
    303,  303,   98,  303,  303,  268,  269,  303,  303,  303,
    303,  303,  276,  201,  278,  303,  284,  293,  303,  283,
    303,  211,  303,  303,  111,  303,  303,  198,  101,   80,
    303,  303,  303,  303,   98,  303,  303,  268,  269,  303,
    303,  303,  303,  303,  276,  201,  278,  303,  284,  293,
    303,  303,  303,  283,  303,  211,  303,  303,  111,  303,
    303,  198,  102,   79,  303,  303,  303,  303,   98,  303,
    303,  268,  269,  303,  303,  303,  303,  303,  276,  201,
    278,  303,  284,  293,  303,  283,  303,  211,  303,  303,
    111,  303,  303,  198,  119,   53,  303,  303,  303,  303,
     98,  303,  303,  268,  269,  303,  303,  303,  303,  303,
    276,  201,  278,  303,  284,  293,  303,  303,  303,  283,
    303,  211,  303,  303,  111,  303,  303,  198,  119,   64,
    303,  303,  303,  303,   98,  303,  303,  268,  269,  303,
    303,  303,  303,  303,  276,  201,  278,  303,  284,  293,
    303,  283,  303,  211,  303,  303,  111,  303,  303,  198,
    101,   54,  303,  303,  303,  303,   98,  303,  303,  268,
    269,  303,  303,  303,  303,  303,  276,  201,  278,  303,
    284,  293,  303,  303,  303,  283,  303,  211,  303,  303,
    111,  303,  303,  198,  119,   63,  303,  303,  303,  303,
     98,  303,  303,  268,  269,  303,  303,  303,  303,  303,
    276,  201,  278,  303,  284,  293,  303,  283,  303,  211,
    303,  303,  111,  303,  303,  198,  119,   55,  303,  303,
    303,  303,   98,  303,  303,  268,  269,  303,  303,  303,
    303,  303,  276,  201,  278,  303,  284,  293,  303,  303,
    303,  283,  303,  211,  303,  303,  111,  303,  303,  198,
    119,   56,  303,  303,  303,  303,   98,  303,  303,  268,
    269,  303,  303,  303,  303,  303,  276,  201,  278,  303,
    284,  293,  303,  283,  303,  211,  303,  303,  111,  303,
    303,  198,  119,   66,  303,  303,  303,  303,   98,  303,
    303,  268,  269,  303,  303,  303,  303,  303,  276,  201,
    278,  303,  284,  293,  303,  303,  303,  283,  303,  211,
    303,  303,  111,  303,  303,  198,  119,   67,  303,  303,
    303,  303,   98,  303,  303,  268,  269,  303,  303,  303,
    303,  303,  276,  201,  278,  303,  284,  293,  303,  283,
    303,  211,  303,  303,  111,  303,  303,  198,  119,   68,
    303,  303,  303,  303,   98,  303,  303,  268,  269,  303,
    303,  303,  303,  303,  276,  201,  278,  303,  284,  293,
    303,  303,  303,  283,  303,  211,  303,  303,  111,  303,
    303,  198,  119,   69,  303,  303,  303,  303,   98,  303,
    303,  268,  269,  303,  303,  303,  303,  303,  276,  201,
    278,  303,  284,  293,  303,  283,  303,  211,  303,  303,
    111,  303,  303,  198,  119,   71,  303,  303,  303,  303,
     98,  303,  303,  268,  269,  303,  303,  303,  303,  303,
    276,  201,  278,  303,  284,  293,  303,  303,  303,  283,
    303,  211,  303,  303,  111,  303,  303,  192,  119,   59,
    303,  303,  303,  303,   98,  303,  303,  268,  269,  303,
    303,  303,  303,  303,  276,  201,  278,  303,  284,  293,
    303,  283,  303,  211,  303,  303,  111,  303,  303,  198,
    119,   60,  303,  303,  303,  303,   98,  303,  303,  268,
    269,  303,  303,  303,  303,  303,  276,  201,  278,  303,
    284,  293,  303,  303,  303,  283,  303,  211,  303,  303,
    111,  303,  303,  198,  119,   61,  303,  303,  303,  303,
     98,  303,  303,  268,  269,  303,  303,  303,  303,  303,
    276,  201,  278,  303,  284,  293,  303,  283,  303,  211,
    303,  303,  111,  303,  303,  198,  119,   72,  303,  303,
    303,  303,   98,  303,  303,  268,  269,  303,  303,  303,
    303,  303,  276,  201,  278,  303,  284,  293,  303,  303,
    303,  283,  303,  211,  303,  303,  111,  303,  303,  198,
    119,   73,  303,  303,  303,  303,   98,  303,  303,  268,
    269,  303,  303,  303,  303,  303,  276,  201,  278,  303,
    284,  293,  303,  283,  303,  211,  303,  303,  111,  303,
    303,  198,  119,   74,  303,  303,  303,  303,   98,  303,
    303,  268,  269,  303,  303,  303,  303,  303,  276,  201,
    278,  303,  284,  293,  303,  303,  303,  283,  303,  211,
    303,  303,  111,  303,  303,  198,  119,   75,  303,  303,
    303,  303,   98,  303,  303,  268,  269,  303,  303,  303,
    303,  303,  276,  201,  278,  303,  284,  293,  303,  283,
    303,  211,  303,  303,  111,  303,  303,  198,  119,   76,
    303,  303,  303,  303,   98,  303,  303,  268,  269,  303,
    303,  303,  303,  303,  276,  201,  278,  303,  284,  293,
    303,  303,  303,  283,  303,  211,  303,  303,  111,  303,
    303,  198,  119,   77,  303,  303,  303,  303,   98,  303,
    303,  268,  269,  303,  303,  303,  303,  303,  276,  201,
    278,  303,  284,  293,  303,  283,  303,  211,  303,  303,
    111,  303,  303,  198,  119,   78,  303,  303,  303,  303,
     98,  303,  303,  268,  269,  303,  303,  303,  303,  303,
    276,  201,  278,  303,  284,  293,  303,  303,  303,  283,
    303,  211,  303,  303,  111,  303,  303,  198,  119,   48,
    303,  303,  303,  303,   98,  303,  303,  268,  269,  303,
    303,  303,  303,  303,  276,  201,  278,  303,  284,  293,
    303,  283,  303,  211,  303,  303,  111,  303,  303,  198,
    119,   50,  303,  303,  303,  303,   98,  303,  303,  268,
    269,  303,  303,  303,  303,  303,  276,  201,  278,  303,
    284,  293,  308,  303,  303,  303,  303,  303,  242,  243,
    244,    2,  303,  306,  303,  303,  303,    6,   84,  254,
    303,  303,   19,  109,  303,  303,  253,  212,  256,  213,
    303,  303,   38,  303,   14,   14,  303,  303,  303,  165,
     15,   15,  303,  303,  303,   41,   42,  281,   12,  251,
    303,  303,   46,   22,  280,   40,  303,  301,   27,  303,
    303,  308,  288,  289,  290,  291,  303,  242,  243,  244,
      2,  303,  306,  303,  303,  303,    6,   84,  303,  303,
    303,  303,  109,  303,   14,  303,  212,  256,  213,  303,
     15,  142,  303,  303,  303,   41,   42,  281,   12,  303,
    303,  251,  303,  303,   46,   22,  280,   40,  303,  303,
    303,  303,  288,  289,  290,  291,  302,   27,  303,  303,
    235,  236,  237,  130,  303,  303,  242,  243,  244,    1,
    468,  303,  303,  468,  303,    6,   84,  468,  452,  303,
    303,  109,  303,  303,  303,  212,  256,  213,  283,  303,
    211,  303,  303,  111,  303,  303,  198,  131,  303,  303,
    303,  303,  303,   98,  452,  303,  303,  452,  303,  468,
    303,  452,  326,  276,  201,  278,  303,  284,  293,  303,
    218,  303,  303,  283,  303,  211,  303,  468,  111,  303,
    468,  198,  125,    3,  468,  452,  303,  303,   98,  271,
    303,  303,  303,  303,  303,  303,  303,  282,  276,  201,
    278,  303,  284,  293,  283,  303,  211,  303,  303,  111,
    166,  452,  198,  129,  452,  303,  468,  303,  452,   98,
    251,  303,  303,   46,   22,  280,   40,  303,  303,  276,
    201,  278,  303,  284,  293,  303,  218,  303,  303,  283,
    303,  211,  303,  468,  111,  303,  468,  198,  120,   35,
    468,  452,  303,  303,   98,  271,  303,  303,  303,  303,
    303,  303,  303,  303,  276,  201,  278,  303,  284,  293,
    283,  303,  211,  303,  303,  111,  303,  452,  198,  121,
    452,  303,  468,  303,  452,   98,  303,  303,  303,  303,
    303,  303,  303,  303,  303,  276,  201,  278,  303,  284,
    293,  303,  218,  303,  303,  283,  303,  211,  303,  468,
    111,  303,  468,  198,  122,  303,  468,  452,  303,  303,
     98,  271,  303,  303,  303,  303,  303,  303,  303,  303,
    276,  201,  278,  303,  284,  293,  283,  303,  211,  303,
    303,  111,  303,  452,  198,  123,  452,  303,  468,  303,
    452,   98,  303,  303,  303,  303,  303,  303,  303,  303,
    303,  276,  201,  278,  303,  284,  293,  303,   30,  303,
    303,  283,  303,  211,  218,  468,  111,  303,  468,  198,
    124,  468,  468,  452,  468,  303,   98,  271,  468,  452,
    303,  303,  303,  271,  303,  303,  276,  201,  278,  303,
    284,  293,  283,  402,  211,  303,  303,  111,  303,  452,
    198,  128,  452,  303,  468,  452,  452,   98,  452,  303,
    468,  303,  452,  287,  303,  107,  325,  276,  201,  278,
    303,  284,  293,  303,  303,  439,  303,  402,  402,  402,
    402,   41,   42,  281,   12,  303,  303,  439,  303,   41,
     42,  281,   12,  303,  402,  402,  402,  402,  288,  289,
    290,  291,   41,   42,  281,   12,  288,  289,  290,  291,
    300,  324,   41,   42,  281,   12,  182,  315,  303,  288,
    289,  290,  291,  183,  303,  303,  303,  303,  303,  288,
    289,  290,  291,   41,   42,  281,   12,   31,  303,   41,
     42,  281,   12,  303,  327,  303,   41,   42,  281,   12,
    288,  289,  290,  291,  303,  303,  288,  289,  290,  291,
    303,  303,  303,  288,  289,  290,  291,   41,   42,  281,
     12,   41,   42,  281,   12,  303,  303,  303,  303,  303,
    303,  303,  303,  303,  288,  289,  290,  291,  288,  289,
    290,  291,
    );
    public static $yy_lookahead = array(
      2,    1,   97,   13,   99,  100,   21,    9,   10,   11,
     12,   21,   14,   70,   16,   25,   18,   19,    1,   21,
     77,   31,   24,   80,   13,   69,   28,   29,   30,   44,
     32,   20,   34,   22,   44,   37,   25,   39,   40,   41,
     42,   43,   31,   45,   33,   47,   35,   49,   50,   14,
     52,   16,   96,   17,   43,   57,   58,    9,   10,   11,
     12,   65,   14,   67,   16,   33,   18,   19,   65,   21,
     67,   70,   24,   96,   73,   98,   28,   29,   30,   43,
     32,   80,   34,   51,   49,   37,   50,   52,   40,   41,
     42,   43,   91,   45,    1,   47,   95,   49,   50,   51,
     52,   15,   96,  107,  108,   57,   58,    9,   10,   11,
     12,   72,   14,   13,   16,   15,   18,   19,   25,   21,
     80,   82,   24,   72,   31,   25,   28,   29,   30,   43,
     32,   31,   34,   82,   34,   37,   50,   98,   40,   41,
     42,   43,   15,   45,   17,   47,   46,   49,   50,   98,
     52,   21,   61,   62,   98,   57,   58,    9,   10,   11,
     12,   14,   14,   16,   16,   80,   18,   19,   96,   21,
     98,   93,   24,   46,   44,   34,   28,   29,   30,  101,
     32,   51,   34,   17,   43,   37,  101,   46,   40,   41,
     42,   43,   51,   45,   47,   47,   49,   49,   50,   52,
     52,   85,   86,   87,   88,   57,   58,    9,   10,   11,
     12,   12,   14,   14,   16,   16,   18,   19,    9,   21,
     82,   12,   24,   72,   72,   16,   28,   29,   30,    1,
     32,   32,   34,   82,   82,   37,   99,  100,   40,   41,
     42,   43,   72,   45,   79,   47,   76,   49,   50,   80,
     52,   52,   82,   13,  103,   57,   58,    9,   10,   11,
     12,   21,   14,   14,   16,   25,   18,   19,   65,   21,
     67,   31,   24,  103,    1,    2,   28,   29,   30,   51,
     32,   25,   34,   34,   44,   37,   80,   31,   40,   41,
     42,   43,   72,   45,   70,   47,   76,   49,   50,   14,
     52,   52,   82,   72,   80,   57,   58,    9,   10,   11,
     12,  108,   14,   82,   16,   76,   18,   19,   15,   21,
     17,   70,   24,  103,   73,   93,   28,   29,   30,   43,
     32,   80,   34,  101,  103,   37,   50,   52,   40,   41,
     42,   43,  103,   45,   70,   47,   95,   49,   50,   46,
     52,   77,   78,   69,   80,   57,   58,    9,   10,   11,
     12,   12,   14,   14,   16,   16,   18,   19,    9,   21,
      1,   12,   24,    1,    2,   16,   28,   29,   30,   97,
     32,   25,   34,   99,  100,   37,   17,   31,   40,   41,
     42,   43,   70,   45,   76,   47,   76,   49,   50,   77,
     52,   52,   80,   72,   17,   57,   58,    9,   10,   11,
     12,   21,   14,   82,   16,   96,   18,   19,   27,   21,
     96,  103,   24,  103,  104,   34,   28,   29,   30,    6,
     32,    8,   34,   46,   44,   37,   72,   46,   40,   41,
     42,   43,   14,   45,   16,   47,   82,   49,   50,   59,
     52,   36,   37,   38,   39,   57,   58,    9,   10,   11,
     12,    1,   14,   96,   16,   72,   18,   19,   53,   54,
     55,   56,   24,   15,   59,   82,   28,   29,   30,   21,
     32,   20,   34,   16,   76,   37,  103,   27,   40,   41,
     42,   43,    2,   45,   33,   47,  104,   49,   50,   14,
     52,   36,   37,   38,   39,   57,   58,    9,   10,   11,
     12,  103,   14,   34,   16,   48,   18,   19,   53,   54,
     55,   56,   24,   99,  100,   46,   28,   29,   30,   12,
     32,   34,   34,   63,   64,   37,   96,   52,   40,   41,
     42,   43,   43,   45,   33,   47,   35,   49,   50,   50,
     52,   34,   34,    7,    8,   57,   58,   65,   66,   67,
     68,   81,   70,   71,   46,   73,   74,   75,   34,   33,
      9,   35,   80,   12,  100,   83,   84,   16,   64,   96,
     46,   81,   90,   91,   92,   81,   94,   95,   65,   66,
     67,   68,    1,   70,   71,    7,   73,   74,   75,   33,
     15,   35,   43,   80,   13,   96,   83,   84,   17,   48,
     51,   13,   16,   90,   91,   92,   25,   94,   95,   13,
     16,   65,   31,   67,   68,   34,   70,   71,   43,   73,
     74,   75,   33,   16,   35,    9,   80,   46,   12,   83,
     84,   16,   16,   16,   14,   16,   90,   91,   92,   34,
     94,   95,   65,   43,   67,   32,   16,   70,   16,   16,
     73,   74,   75,   32,   51,   49,   16,   80,   49,   51,
     83,   84,   15,   26,   48,   22,   35,   90,   91,   92,
    109,   94,   95,   36,   37,   38,   39,  109,  109,   65,
    109,   67,  105,  106,   70,  109,  109,   73,   74,   75,
     53,   54,   55,   56,   80,  109,  109,   83,   84,  109,
    109,  109,  109,  109,   90,   91,   92,  109,   94,   95,
    109,  109,  109,   65,  109,   67,  109,  109,   70,  105,
    106,   73,   74,   75,  109,   77,  109,  109,   80,  109,
      9,   83,   84,   12,  109,  109,  109,   16,   90,   91,
     92,  109,   94,   95,  109,   65,   25,   67,   27,  109,
     70,  109,   31,   73,   74,   75,    1,  109,  109,  109,
     80,  109,    9,   83,   84,   12,    1,  109,   13,   16,
     90,   91,   92,  109,   94,   95,  109,  109,   13,   65,
     25,   67,  102,  109,   70,  109,   31,   73,   74,   75,
     25,  109,  109,  109,   80,  109,   31,   83,   84,  109,
      1,   48,  109,  109,   90,   91,   92,  109,   94,   95,
    109,  109,   13,   65,  109,   67,  102,  109,   70,  109,
    109,   73,   74,   75,   25,  109,  109,  109,   80,  109,
     31,   83,   84,  109,  109,  109,  109,  109,   90,   91,
     92,  109,   94,   95,  109,  109,  109,   65,  109,   67,
    109,  109,   70,  109,  106,   73,   74,   75,  109,  109,
    109,  109,   80,  109,  109,   83,   84,  109,  109,  109,
    109,  109,   90,   91,   92,  109,   94,   95,  109,  109,
    109,   65,  109,   67,  102,  109,   70,  109,  109,   73,
     74,   75,  109,   77,  109,  109,   80,  109,  109,   83,
     84,  109,  109,  109,  109,  109,   90,   91,   92,  109,
     94,   95,  109,   65,  109,   67,  109,  109,   70,  109,
    109,   73,   74,   75,  109,  109,  109,  109,   80,  109,
    109,   83,   84,  109,  109,  109,  109,  109,   90,   91,
     92,  109,   94,   95,  109,  109,  109,   65,  109,   67,
    109,  109,   70,  109,  109,   73,   74,   75,  109,  109,
    109,  109,   80,  109,  109,   83,   84,  109,  109,  109,
    109,  109,   90,   91,   92,  109,   94,   95,  109,   65,
    109,   67,  109,  109,   70,  109,  109,   73,   74,   75,
    109,  109,  109,  109,   80,  109,  109,   83,   84,  109,
    109,  109,  109,  109,   90,   91,   92,  109,   94,   95,
    109,  109,  109,   65,  109,   67,  109,  109,   70,  109,
    109,   73,   74,   75,  109,  109,  109,  109,   80,  109,
    109,   83,   84,  109,  109,  109,  109,  109,   90,   91,
     92,  109,   94,   95,  109,   65,  109,   67,  109,  109,
     70,  109,  109,   73,   74,   75,  109,  109,  109,  109,
     80,  109,  109,   83,   84,  109,  109,  109,  109,  109,
     90,   91,   92,  109,   94,   95,  109,  109,  109,   65,
    109,   67,  109,  109,   70,  109,  109,   73,   74,   75,
    109,  109,  109,  109,   80,  109,  109,   83,   84,  109,
    109,  109,  109,  109,   90,   91,   92,  109,   94,   95,
    109,   65,  109,   67,  109,  109,   70,  109,  109,   73,
     74,   75,  109,  109,  109,  109,   80,  109,  109,   83,
     84,  109,  109,  109,  109,  109,   90,   91,   92,  109,
     94,   95,  109,  109,  109,   65,  109,   67,  109,  109,
     70,  109,  109,   73,   74,   75,  109,  109,  109,  109,
     80,  109,  109,   83,   84,  109,  109,  109,  109,  109,
     90,   91,   92,  109,   94,   95,  109,   65,  109,   67,
    109,  109,   70,  109,  109,   73,   74,   75,  109,  109,
    109,  109,   80,  109,  109,   83,   84,  109,  109,  109,
    109,  109,   90,   91,   92,  109,   94,   95,  109,  109,
    109,   65,  109,   67,  109,  109,   70,  109,  109,   73,
     74,   75,  109,  109,  109,  109,   80,  109,  109,   83,
     84,  109,  109,  109,  109,  109,   90,   91,   92,  109,
     94,   95,  109,   65,  109,   67,  109,  109,   70,  109,
    109,   73,   74,   75,  109,  109,  109,  109,   80,  109,
    109,   83,   84,  109,  109,  109,  109,  109,   90,   91,
     92,  109,   94,   95,  109,  109,  109,   65,  109,   67,
    109,  109,   70,  109,  109,   73,   74,   75,  109,  109,
    109,  109,   80,  109,  109,   83,   84,  109,  109,  109,
    109,  109,   90,   91,   92,  109,   94,   95,  109,   65,
    109,   67,  109,  109,   70,  109,  109,   73,   74,   75,
    109,  109,  109,  109,   80,  109,  109,   83,   84,  109,
    109,  109,  109,  109,   90,   91,   92,  109,   94,   95,
    109,  109,  109,   65,  109,   67,  109,  109,   70,  109,
    109,   73,   74,   75,  109,  109,  109,  109,   80,  109,
    109,   83,   84,  109,  109,  109,  109,  109,   90,   91,
     92,  109,   94,   95,  109,   65,  109,   67,  109,  109,
     70,  109,  109,   73,   74,   75,  109,  109,  109,  109,
     80,  109,  109,   83,   84,  109,  109,  109,  109,  109,
     90,   91,   92,  109,   94,   95,  109,  109,  109,   65,
    109,   67,  109,  109,   70,  109,  109,   73,   74,   75,
    109,  109,  109,  109,   80,  109,  109,   83,   84,  109,
    109,  109,  109,  109,   90,   91,   92,  109,   94,   95,
    109,   65,  109,   67,  109,  109,   70,  109,  109,   73,
     74,   75,  109,  109,  109,  109,   80,  109,  109,   83,
     84,  109,  109,  109,  109,  109,   90,   91,   92,  109,
     94,   95,  109,  109,  109,   65,  109,   67,  109,  109,
     70,  109,  109,   73,   74,   75,  109,  109,  109,  109,
     80,  109,  109,   83,   84,  109,  109,  109,  109,  109,
     90,   91,   92,  109,   94,   95,  109,   65,  109,   67,
    109,  109,   70,  109,  109,   73,   74,   75,  109,  109,
    109,  109,   80,  109,  109,   83,   84,  109,  109,  109,
    109,  109,   90,   91,   92,  109,   94,   95,  109,  109,
    109,   65,  109,   67,  109,  109,   70,  109,  109,   73,
     74,   75,  109,  109,  109,  109,   80,  109,  109,   83,
     84,  109,  109,  109,  109,  109,   90,   91,   92,  109,
     94,   95,  109,   65,  109,   67,  109,  109,   70,  109,
    109,   73,   74,   75,  109,  109,  109,  109,   80,  109,
    109,   83,   84,  109,  109,  109,  109,  109,   90,   91,
     92,  109,   94,   95,  109,  109,  109,   65,  109,   67,
    109,  109,   70,  109,  109,   73,   74,   75,  109,  109,
    109,  109,   80,  109,  109,   83,   84,  109,  109,  109,
    109,  109,   90,   91,   92,  109,   94,   95,  109,   65,
    109,   67,  109,  109,   70,  109,  109,   73,   74,   75,
    109,  109,  109,  109,   80,  109,  109,   83,   84,  109,
    109,  109,  109,  109,   90,   91,   92,  109,   94,   95,
    109,  109,  109,   65,  109,   67,  109,  109,   70,  109,
    109,   73,   74,   75,  109,  109,  109,  109,   80,  109,
    109,   83,   84,  109,  109,  109,  109,  109,   90,   91,
     92,  109,   94,   95,  109,   65,  109,   67,  109,  109,
     70,  109,  109,   73,   74,   75,  109,  109,  109,  109,
     80,  109,  109,   83,   84,  109,  109,  109,  109,  109,
     90,   91,   92,  109,   94,   95,  109,  109,  109,   65,
    109,   67,  109,  109,   70,  109,  109,   73,   74,   75,
    109,  109,  109,  109,   80,  109,  109,   83,   84,  109,
    109,  109,  109,  109,   90,   91,   92,  109,   94,   95,
    109,   65,  109,   67,  109,  109,   70,  109,  109,   73,
     74,   75,  109,  109,  109,  109,   80,  109,  109,   83,
     84,  109,  109,  109,  109,  109,   90,   91,   92,  109,
     94,   95,    3,  109,  109,  109,  109,  109,    9,   10,
     11,   12,  109,   14,  109,  109,  109,   18,   19,    9,
    109,  109,   12,   24,  109,  109,   16,   28,   29,   30,
    109,  109,   23,  109,   25,   25,  109,  109,  109,   72,
     31,   31,  109,  109,  109,   36,   37,   38,   39,   82,
    109,  109,   85,   86,   87,   88,  109,   58,   59,  109,
    109,    3,   53,   54,   55,   56,  109,    9,   10,   11,
     12,  109,   14,  109,  109,  109,   18,   19,  109,  109,
    109,  109,   24,  109,   25,  109,   28,   29,   30,  109,
     31,   72,  109,  109,  109,   36,   37,   38,   39,  109,
    109,   82,  109,  109,   85,   86,   87,   88,  109,  109,
    109,  109,   53,   54,   55,   56,   58,   59,  109,  109,
      3,    4,    5,    6,  109,  109,    9,   10,   11,   12,
      9,  109,  109,   12,  109,   18,   19,   16,   17,  109,
    109,   24,  109,  109,  109,   28,   29,   30,   65,  109,
     67,  109,  109,   70,  109,  109,   73,   74,  109,  109,
    109,  109,  109,   80,   43,  109,  109,   46,  109,   48,
    109,   50,   89,   90,   91,   92,  109,   94,   95,  109,
      2,  109,  109,   65,  109,   67,  109,    9,   70,  109,
     12,   73,   74,   15,   16,   17,  109,  109,   80,   21,
    109,  109,  109,  109,  109,  109,  109,   89,   90,   91,
     92,  109,   94,   95,   65,  109,   67,  109,  109,   70,
     72,   43,   73,   74,   46,  109,   48,  109,   50,   80,
     82,  109,  109,   85,   86,   87,   88,  109,  109,   90,
     91,   92,  109,   94,   95,  109,    2,  109,  109,   65,
    109,   67,  109,    9,   70,  109,   12,   73,   74,   15,
     16,   17,  109,  109,   80,   21,  109,  109,  109,  109,
    109,  109,  109,  109,   90,   91,   92,  109,   94,   95,
     65,  109,   67,  109,  109,   70,  109,   43,   73,   74,
     46,  109,   48,  109,   50,   80,  109,  109,  109,  109,
    109,  109,  109,  109,  109,   90,   91,   92,  109,   94,
     95,  109,    2,  109,  109,   65,  109,   67,  109,    9,
     70,  109,   12,   73,   74,  109,   16,   17,  109,  109,
     80,   21,  109,  109,  109,  109,  109,  109,  109,  109,
     90,   91,   92,  109,   94,   95,   65,  109,   67,  109,
    109,   70,  109,   43,   73,   74,   46,  109,   48,  109,
     50,   80,  109,  109,  109,  109,  109,  109,  109,  109,
    109,   90,   91,   92,  109,   94,   95,  109,    2,  109,
    109,   65,  109,   67,    2,    9,   70,  109,   12,   73,
     74,    9,   16,   17,   12,  109,   80,   21,   16,   17,
    109,  109,  109,   21,  109,  109,   90,   91,   92,  109,
     94,   95,   65,    2,   67,  109,  109,   70,  109,   43,
     73,   74,   46,  109,   48,   43,   50,   80,   46,  109,
     48,  109,   50,   51,  109,   20,   13,   90,   91,   92,
    109,   94,   95,  109,  109,   34,  109,   36,   37,   38,
     39,   36,   37,   38,   39,  109,  109,   46,  109,   36,
     37,   38,   39,  109,   53,   54,   55,   56,   53,   54,
     55,   56,   36,   37,   38,   39,   53,   54,   55,   56,
     13,   35,   36,   37,   38,   39,   13,   51,  109,   53,
     54,   55,   56,   13,  109,  109,  109,  109,  109,   53,
     54,   55,   56,   36,   37,   38,   39,    2,  109,   36,
     37,   38,   39,  109,   13,  109,   36,   37,   38,   39,
     53,   54,   55,   56,  109,  109,   53,   54,   55,   56,
    109,  109,  109,   53,   54,   55,   56,   36,   37,   38,
     39,   36,   37,   38,   39,  109,  109,  109,  109,  109,
    109,  109,  109,  109,   53,   54,   55,   56,   53,   54,
     55,   56,
);
    const YY_SHIFT_USE_DFLT = -16;
    const YY_SHIFT_MAX = 234;
    public static $yy_shift_ofst = array(
    -16,   98,   98,  148,  198,  198,  248,  148,  148,  198,
    148,  248,   -2,   48,  298,  148,  148,  148,  298,  148,
    148,  148,  148,  148,  148,  148,  148,  148,  148,  148,
    348,  148,  148,  148,  148,  398,  148,  148,  148,  448,
    498,  498,  498,  498,  498,  498,  498,  498, 1819, 1869,
   1869,  147, 1809, 2225,  647, 2233, 2256, 2246, 2277,  415,
   2283, 2290, 2315, 2311,  465,  465,  465,  465,  465,  465,
    465,  465,  465,  465,  465,  465,  465,  465,  465,  465,
    465,  465,  591,   35,  249,   93, 1868,  731, 1820,   36,
    127,   93,   93,  249,  249,  273, 1927, 1988,  561,  349,
    765,  775,  809,  209,  209,  303,  256,  285,  256,  356,
    369,  387,  428,  428,  228,  372,  460,  256,    0,    0,
      0,    0,    0,    0,    0,    0,  166,  166,   17,    0,
    -16,  -16, 2192, 2054, 2120, 2186, 1931,  199,  626,  359,
     86,  256,  256,  458,  256,  485,  256,  485,  256,  286,
    286,  256,  256,  256,  256,  286,  517,  286,  286,  286,
    499,  286,  499,  286,  256,  256,  256,  256,    0,  490,
      0,    0,  490,    0,  497,  166,  166,  166,  -16,  -16,
    -16,  -16,  -16,  -16, 2221,   11,  100,  -10,  240,  763,
    141,  391,  390,  130,  423,  546,  461,  467,  -15,  479,
    518,  534,  511,  536,   32,  559,  566,  599,  585,  588,
    598,  606,  596,  604,  617,  625,  627,  630,  629,  610,
    623,  631,  615,  640,  497,  642,  616,  619,  643,  613,
    618,  650,  657,  641,  653,
);
    const YY_REDUCE_USE_DFLT = -96;
    const YY_REDUCE_MAX = 183;
    public static $yy_reduce_ofst = array(
     91,  492,  523,  556,  587,  624,  658,  690,  724,  758,
    792,  826,  858,  892,  924,  958,  990, 1024, 1056, 1090,
   1122, 1156, 1188, 1222, 1254, 1288, 1320, 1354, 1386, 1420,
   1452, 1486, 1518, 1552, 1584, 1618, 1650, 1684, 1716, 1893,
   1928, 1959, 1994, 2025, 2060, 2091, 2126, 2157, 1777, 1829,
   1958,    1,   -4,  116,  116,  116,  116,  116,  116,  116,
    116,  116,  116,  116,  116,  116,  116,  116,  116,  116,
    116,  116,  116,  116,  116,  116,  116,  116,  116,  116,
    116,  116,  170,  251,  274,  220,  203,   39,   51,  -95,
    284,  151,  231,  -57,  322,  320,    3,  -44,  -23,   85,
    239,  239,  239,   72,  -23,  137,  152,  224,  331,  364,
    318,  137,   78,  232,  239,  239,  239,  393,  408,  239,
    239,  239,  239,  239,  239,  239,  137,  424,  239,  239,
    470,  239,    6,    6,    6,    6,    6,   40,   56,    6,
      6,  138,  138,  165,  138,  169,  138,  206,  138,  282,
    282,  138,  138,  138,  138,  282,  319,  282,  282,  282,
    324,  282,  367,  282,  138,  138,  138,  138,  383,  392,
    383,  383,  392,  383,  440,  474,  474,  474,  514,  480,
    500,  504,  483,  509,
);
    public static $yyExpectedTokens = array(
         array(),
         array(9, 10, 11, 12, 14, 16, 18, 19, 21, 24, 28, 29, 30, 32, 34, 37, 40, 41, 42, 43, 45, 47, 49, 50, 52, 57, 58, ),
         array(9, 10, 11, 12, 14, 16, 18, 19, 21, 24, 28, 29, 30, 32, 34, 37, 40, 41, 42, 43, 45, 47, 49, 50, 52, 57, 58, ),
         array(9, 10, 11, 12, 14, 16, 18, 19, 21, 24, 28, 29, 30, 32, 34, 37, 40, 41, 42, 43, 45, 47, 49, 50, 52, 57, 58, ),
         array(9, 10, 11, 12, 14, 16, 18, 19, 21, 24, 28, 29, 30, 32, 34, 37, 40, 41, 42, 43, 45, 47, 49, 50, 52, 57, 58, ),
         array(9, 10, 11, 12, 14, 16, 18, 19, 21, 24, 28, 29, 30, 32, 34, 37, 40, 41, 42, 43, 45, 47, 49, 50, 52, 57, 58, ),
         array(9, 10, 11, 12, 14, 16, 18, 19, 21, 24, 28, 29, 30, 32, 34, 37, 40, 41, 42, 43, 45, 47, 49, 50, 52, 57, 58, ),
         array(9, 10, 11, 12, 14, 16, 18, 19, 21, 24, 28, 29, 30, 32, 34, 37, 40, 41, 42, 43, 45, 47, 49, 50, 52, 57, 58, ),
         array(9, 10, 11, 12, 14, 16, 18, 19, 21, 24, 28, 29, 30, 32, 34, 37, 40, 41, 42, 43, 45, 47, 49, 50, 52, 57, 58, ),
         array(9, 10, 11, 12, 14, 16, 18, 19, 21, 24, 28, 29, 30, 32, 34, 37, 40, 41, 42, 43, 45, 47, 49, 50, 52, 57, 58, ),
         array(9, 10, 11, 12, 14, 16, 18, 19, 21, 24, 28, 29, 30, 32, 34, 37, 40, 41, 42, 43, 45, 47, 49, 50, 52, 57, 58, ),
         array(9, 10, 11, 12, 14, 16, 18, 19, 21, 24, 28, 29, 30, 32, 34, 37, 40, 41, 42, 43, 45, 47, 49, 50, 52, 57, 58, ),
         array(2, 9, 10, 11, 12, 14, 16, 18, 19, 21, 24, 28, 29, 30, 32, 34, 37, 39, 40, 41, 42, 43, 45, 47, 49, 50, 52, 57, 58, ),
         array(9, 10, 11, 12, 14, 16, 18, 19, 21, 24, 28, 29, 30, 32, 34, 37, 40, 41, 42, 43, 45, 47, 49, 50, 51, 52, 57, 58, ),
         array(9, 10, 11, 12, 14, 16, 18, 19, 21, 24, 28, 29, 30, 32, 34, 37, 40, 41, 42, 43, 45, 47, 49, 50, 52, 57, 58, ),
         array(9, 10, 11, 12, 14, 16, 18, 19, 21, 24, 28, 29, 30, 32, 34, 37, 40, 41, 42, 43, 45, 47, 49, 50, 52, 57, 58, ),
         array(9, 10, 11, 12, 14, 16, 18, 19, 21, 24, 28, 29, 30, 32, 34, 37, 40, 41, 42, 43, 45, 47, 49, 50, 52, 57, 58, ),
         array(9, 10, 11, 12, 14, 16, 18, 19, 21, 24, 28, 29, 30, 32, 34, 37, 40, 41, 42, 43, 45, 47, 49, 50, 52, 57, 58, ),
         array(9, 10, 11, 12, 14, 16, 18, 19, 21, 24, 28, 29, 30, 32, 34, 37, 40, 41, 42, 43, 45, 47, 49, 50, 52, 57, 58, ),
         array(9, 10, 11, 12, 14, 16, 18, 19, 21, 24, 28, 29, 30, 32, 34, 37, 40, 41, 42, 43, 45, 47, 49, 50, 52, 57, 58, ),
         array(9, 10, 11, 12, 14, 16, 18, 19, 21, 24, 28, 29, 30, 32, 34, 37, 40, 41, 42, 43, 45, 47, 49, 50, 52, 57, 58, ),
         array(9, 10, 11, 12, 14, 16, 18, 19, 21, 24, 28, 29, 30, 32, 34, 37, 40, 41, 42, 43, 45, 47, 49, 50, 52, 57, 58, ),
         array(9, 10, 11, 12, 14, 16, 18, 19, 21, 24, 28, 29, 30, 32, 34, 37, 40, 41, 42, 43, 45, 47, 49, 50, 52, 57, 58, ),
         array(9, 10, 11, 12, 14, 16, 18, 19, 21, 24, 28, 29, 30, 32, 34, 37, 40, 41, 42, 43, 45, 47, 49, 50, 52, 57, 58, ),
         array(9, 10, 11, 12, 14, 16, 18, 19, 21, 24, 28, 29, 30, 32, 34, 37, 40, 41, 42, 43, 45, 47, 49, 50, 52, 57, 58, ),
         array(9, 10, 11, 12, 14, 16, 18, 19, 21, 24, 28, 29, 30, 32, 34, 37, 40, 41, 42, 43, 45, 47, 49, 50, 52, 57, 58, ),
         array(9, 10, 11, 12, 14, 16, 18, 19, 21, 24, 28, 29, 30, 32, 34, 37, 40, 41, 42, 43, 45, 47, 49, 50, 52, 57, 58, ),
         array(9, 10, 11, 12, 14, 16, 18, 19, 21, 24, 28, 29, 30, 32, 34, 37, 40, 41, 42, 43, 45, 47, 49, 50, 52, 57, 58, ),
         array(9, 10, 11, 12, 14, 16, 18, 19, 21, 24, 28, 29, 30, 32, 34, 37, 40, 41, 42, 43, 45, 47, 49, 50, 52, 57, 58, ),
         array(9, 10, 11, 12, 14, 16, 18, 19, 21, 24, 28, 29, 30, 32, 34, 37, 40, 41, 42, 43, 45, 47, 49, 50, 52, 57, 58, ),
         array(9, 10, 11, 12, 14, 16, 18, 19, 21, 24, 28, 29, 30, 32, 34, 37, 40, 41, 42, 43, 45, 47, 49, 50, 52, 57, 58, ),
         array(9, 10, 11, 12, 14, 16, 18, 19, 21, 24, 28, 29, 30, 32, 34, 37, 40, 41, 42, 43, 45, 47, 49, 50, 52, 57, 58, ),
         array(9, 10, 11, 12, 14, 16, 18, 19, 21, 24, 28, 29, 30, 32, 34, 37, 40, 41, 42, 43, 45, 47, 49, 50, 52, 57, 58, ),
         array(9, 10, 11, 12, 14, 16, 18, 19, 21, 24, 28, 29, 30, 32, 34, 37, 40, 41, 42, 43, 45, 47, 49, 50, 52, 57, 58, ),
         array(9, 10, 11, 12, 14, 16, 18, 19, 21, 24, 28, 29, 30, 32, 34, 37, 40, 41, 42, 43, 45, 47, 49, 50, 52, 57, 58, ),
         array(9, 10, 11, 12, 14, 16, 18, 19, 21, 24, 28, 29, 30, 32, 34, 37, 40, 41, 42, 43, 45, 47, 49, 50, 52, 57, 58, ),
         array(9, 10, 11, 12, 14, 16, 18, 19, 21, 24, 28, 29, 30, 32, 34, 37, 40, 41, 42, 43, 45, 47, 49, 50, 52, 57, 58, ),
         array(9, 10, 11, 12, 14, 16, 18, 19, 21, 24, 28, 29, 30, 32, 34, 37, 40, 41, 42, 43, 45, 47, 49, 50, 52, 57, 58, ),
         array(9, 10, 11, 12, 14, 16, 18, 19, 21, 24, 28, 29, 30, 32, 34, 37, 40, 41, 42, 43, 45, 47, 49, 50, 52, 57, 58, ),
         array(9, 10, 11, 12, 14, 16, 18, 19, 24, 28, 29, 30, 32, 34, 37, 40, 41, 42, 43, 45, 47, 49, 50, 52, 57, 58, ),
         array(9, 10, 11, 12, 14, 16, 18, 19, 24, 28, 29, 30, 32, 34, 37, 40, 41, 42, 43, 45, 47, 49, 50, 52, 57, 58, ),
         array(9, 10, 11, 12, 14, 16, 18, 19, 24, 28, 29, 30, 32, 34, 37, 40, 41, 42, 43, 45, 47, 49, 50, 52, 57, 58, ),
         array(9, 10, 11, 12, 14, 16, 18, 19, 24, 28, 29, 30, 32, 34, 37, 40, 41, 42, 43, 45, 47, 49, 50, 52, 57, 58, ),
         array(9, 10, 11, 12, 14, 16, 18, 19, 24, 28, 29, 30, 32, 34, 37, 40, 41, 42, 43, 45, 47, 49, 50, 52, 57, 58, ),
         array(9, 10, 11, 12, 14, 16, 18, 19, 24, 28, 29, 30, 32, 34, 37, 40, 41, 42, 43, 45, 47, 49, 50, 52, 57, 58, ),
         array(9, 10, 11, 12, 14, 16, 18, 19, 24, 28, 29, 30, 32, 34, 37, 40, 41, 42, 43, 45, 47, 49, 50, 52, 57, 58, ),
         array(9, 10, 11, 12, 14, 16, 18, 19, 24, 28, 29, 30, 32, 34, 37, 40, 41, 42, 43, 45, 47, 49, 50, 52, 57, 58, ),
         array(9, 10, 11, 12, 14, 16, 18, 19, 24, 28, 29, 30, 32, 34, 37, 40, 41, 42, 43, 45, 47, 49, 50, 52, 57, 58, ),
         array(23, 25, 31, 36, 37, 38, 39, 53, 54, 55, 56, ),
         array(25, 31, 36, 37, 38, 39, 53, 54, 55, 56, ),
         array(25, 31, 36, 37, 38, 39, 53, 54, 55, 56, ),
         array(14, 16, 47, 49, 52, ),
         array(3, 9, 10, 11, 12, 14, 18, 19, 24, 28, 29, 30, 58, 59, ),
         array(20, 36, 37, 38, 39, 53, 54, 55, 56, ),
         array(26, 36, 37, 38, 39, 53, 54, 55, 56, ),
         array(13, 36, 37, 38, 39, 53, 54, 55, 56, ),
         array(35, 36, 37, 38, 39, 53, 54, 55, 56, ),
         array(36, 37, 38, 39, 51, 53, 54, 55, 56, ),
         array(13, 36, 37, 38, 39, 53, 54, 55, 56, ),
         array(36, 37, 38, 39, 53, 54, 55, 56, 59, ),
         array(13, 36, 37, 38, 39, 53, 54, 55, 56, ),
         array(13, 36, 37, 38, 39, 53, 54, 55, 56, ),
         array(2, 36, 37, 38, 39, 53, 54, 55, 56, ),
         array(13, 36, 37, 38, 39, 53, 54, 55, 56, ),
         array(36, 37, 38, 39, 53, 54, 55, 56, ),
         array(36, 37, 38, 39, 53, 54, 55, 56, ),
         array(36, 37, 38, 39, 53, 54, 55, 56, ),
         array(36, 37, 38, 39, 53, 54, 55, 56, ),
         array(36, 37, 38, 39, 53, 54, 55, 56, ),
         array(36, 37, 38, 39, 53, 54, 55, 56, ),
         array(36, 37, 38, 39, 53, 54, 55, 56, ),
         array(36, 37, 38, 39, 53, 54, 55, 56, ),
         array(36, 37, 38, 39, 53, 54, 55, 56, ),
         array(36, 37, 38, 39, 53, 54, 55, 56, ),
         array(36, 37, 38, 39, 53, 54, 55, 56, ),
         array(36, 37, 38, 39, 53, 54, 55, 56, ),
         array(36, 37, 38, 39, 53, 54, 55, 56, ),
         array(36, 37, 38, 39, 53, 54, 55, 56, ),
         array(36, 37, 38, 39, 53, 54, 55, 56, ),
         array(36, 37, 38, 39, 53, 54, 55, 56, ),
         array(36, 37, 38, 39, 53, 54, 55, 56, ),
         array(36, 37, 38, 39, 53, 54, 55, 56, ),
         array(1, 13, 17, 25, 31, 34, 46, ),
         array(14, 16, 49, 52, ),
         array(14, 34, 52, ),
         array(1, 25, 31, ),
         array(3, 9, 10, 11, 12, 14, 18, 19, 24, 28, 29, 30, 58, 59, ),
         array(9, 12, 16, 25, 27, 31, ),
         array(9, 12, 16, 25, 31, ),
         array(17, 43, 50, ),
         array(15, 17, 46, ),
         array(1, 25, 31, ),
         array(1, 25, 31, ),
         array(14, 34, 52, ),
         array(14, 34, 52, ),
         array(1, 2, ),
         array(3, 4, 5, 6, 9, 10, 11, 12, 18, 19, 24, 28, 29, 30, ),
         array(2, 9, 12, 15, 16, 17, 21, 43, 46, 48, 50, ),
         array(9, 12, 16, 48, ),
         array(12, 14, 16, 52, ),
         array(1, 13, 25, 31, ),
         array(1, 13, 25, 31, ),
         array(1, 13, 25, 31, ),
         array(9, 12, 16, ),
         array(9, 12, 16, ),
         array(15, 17, 46, ),
         array(25, 31, ),
         array(14, 52, ),
         array(25, 31, ),
         array(25, 31, ),
         array(1, 17, ),
         array(17, 46, ),
         array(14, 16, ),
         array(14, 16, ),
         array(1, 51, ),
         array(1, 2, ),
         array(1, 27, ),
         array(25, 31, ),
         array(1, ),
         array(1, ),
         array(1, ),
         array(1, ),
         array(1, ),
         array(1, ),
         array(1, ),
         array(1, ),
         array(17, ),
         array(17, ),
         array(1, ),
         array(1, ),
         array(),
         array(),
         array(2, 9, 12, 16, 17, 21, 43, 46, 48, 50, 51, ),
         array(2, 9, 12, 15, 16, 17, 21, 43, 46, 48, 50, ),
         array(2, 9, 12, 16, 17, 21, 43, 46, 48, 50, ),
         array(2, 9, 12, 16, 17, 21, 43, 46, 48, 50, ),
         array(9, 12, 16, 17, 43, 46, 48, 50, ),
         array(12, 14, 16, 32, 52, ),
         array(9, 12, 16, 48, ),
         array(9, 12, 16, ),
         array(15, 43, 50, ),
         array(25, 31, ),
         array(25, 31, ),
         array(15, 21, ),
         array(25, 31, ),
         array(14, 52, ),
         array(25, 31, ),
         array(14, 52, ),
         array(25, 31, ),
         array(43, 50, ),
         array(43, 50, ),
         array(25, 31, ),
         array(25, 31, ),
         array(25, 31, ),
         array(25, 31, ),
         array(43, 50, ),
         array(12, 34, ),
         array(43, 50, ),
         array(43, 50, ),
         array(43, 50, ),
         array(43, 50, ),
         array(43, 50, ),
         array(43, 50, ),
         array(43, 50, ),
         array(25, 31, ),
         array(25, 31, ),
         array(25, 31, ),
         array(25, 31, ),
         array(1, ),
         array(2, ),
         array(1, ),
         array(1, ),
         array(2, ),
         array(1, ),
         array(34, ),
         array(17, ),
         array(17, ),
         array(17, ),
         array(),
         array(),
         array(),
         array(),
         array(),
         array(),
         array(2, 34, 36, 37, 38, 39, 46, 53, 54, 55, 56, ),
         array(13, 20, 22, 25, 31, 33, 35, 43, ),
         array(13, 15, 25, 31, 34, 46, ),
         array(13, 21, 25, 31, 44, ),
         array(13, 21, 25, 31, 44, ),
         array(9, 12, 16, 48, ),
         array(34, 43, 46, 51, ),
         array(27, 34, 46, ),
         array(21, 44, 59, ),
         array(21, 44, 51, ),
         array(6, 8, ),
         array(7, 8, ),
         array(20, 33, ),
         array(16, 48, ),
         array(21, 44, ),
         array(34, 46, ),
         array(34, 46, ),
         array(34, 46, ),
         array(33, 35, ),
         array(33, 35, ),
         array(33, 51, ),
         array(43, 51, ),
         array(33, 35, ),
         array(33, 35, ),
         array(15, 43, ),
         array(7, ),
         array(13, ),
         array(13, ),
         array(16, ),
         array(16, ),
         array(16, ),
         array(16, ),
         array(16, ),
         array(14, ),
         array(16, ),
         array(43, ),
         array(32, ),
         array(32, ),
         array(34, ),
         array(16, ),
         array(34, ),
         array(16, ),
         array(49, ),
         array(49, ),
         array(16, ),
         array(51, ),
         array(51, ),
         array(16, ),
         array(15, ),
         array(35, ),
         array(22, ),
         array(),
         array(),
         array(),
         array(),
         array(),
         array(),
         array(),
         array(),
         array(),
         array(),
         array(),
         array(),
         array(),
         array(),
         array(),
         array(),
         array(),
         array(),
         array(),
         array(),
         array(),
         array(),
         array(),
         array(),
         array(),
         array(),
         array(),
         array(),
         array(),
         array(),
         array(),
         array(),
         array(),
         array(),
         array(),
         array(),
         array(),
         array(),
         array(),
         array(),
         array(),
         array(),
         array(),
         array(),
         array(),
         array(),
         array(),
         array(),
         array(),
         array(),
         array(),
         array(),
         array(),
         array(),
         array(),
         array(),
         array(),
         array(),
         array(),
         array(),
         array(),
         array(),
         array(),
         array(),
         array(),
         array(),
         array(),
         array(),
         array(),
         array(),
         array(),
         array(),
         array(),
         array(),
         array(),
         array(),
         array(),
         array(),
         array(),
         array(),
         array(),
         array(),
         array(),
         array(),
         array(),
         array(),
         array(),
         array(),
         array(),
         array(),
         array(),
         array(),
         array(),
         array(),
         array(),
         array(),
         array(),
         array(),
);
    public static $yy_default = array(
    343,  525,  525,  525,  510,  510,  525,  487,  487,  525,
    487,  525,  525,  525,  525,  525,  525,  525,  525,  525,
    525,  525,  525,  525,  525,  525,  525,  525,  525,  525,
    525,  525,  525,  525,  525,  525,  525,  525,  525,  525,
    525,  525,  525,  525,  525,  525,  525,  525,  383,  362,
    383,  525,  525,  525,  388,  525,  525,  525,  356,  525,
    525,  525,  525,  525,  367,  486,  406,  413,  485,  511,
    513,  512,  412,  414,  411,  415,  390,  394,  395,  385,
    388,  356,  426,  525,  525,  383,  525,  383,  383,  500,
    442,  383,  383,  525,  525,  374,  333,  441,  452,  525,
    397,  397,  397,  452,  452,  442,  383,  525,  383,  383,
    377,  442,  525,  525,  397,  397,  397,  364,  379,  397,
    404,  417,  418,  419,  405,  410,  442,  497,  417,  403,
    341,  494,  441,  441,  441,  441,  441,  525,  454,  452,
    468,  353,  363,  525,  366,  525,  371,  525,  372,  449,
    450,  357,  359,  360,  361,  478,  452,  477,  480,  479,
    445,  446,  447,  448,  373,  369,  370,  365,  375,  488,
    378,  380,  489,  435,  452,  474,  501,  498,  341,  493,
    493,  493,  452,  452,  426,  422,  426,  416,  416,  453,
    426,  426,  416,  416,  339,  525,  525,  525,  416,  426,
    436,  525,  525,  525,  525,  422,  525,  525,  422,  525,
    525,  525,  525,  525,  525,  525,  525,  525,  525,  422,
    424,  525,  499,  525,  468,  525,  525,  525,  525,  525,
    431,  525,  525,  525,  391,  334,  335,  336,  337,  338,
    340,  342,  344,  345,  346,  347,  348,  349,  350,  352,
    381,  382,  470,  471,  472,  492,  376,  490,  491,  420,
    429,  430,  439,  440,  451,  455,  456,  457,  398,  399,
    400,  401,  402,  421,  423,  425,  427,  431,  432,  433,
    407,  408,  409,  434,  437,  438,  465,  463,  502,  503,
    504,  505,  443,  444,  476,  469,  484,  351,  475,  521,
    522,  514,  515,  516,  519,  518,  520,  523,  524,  517,
    507,  509,  508,  506,  481,  466,  464,  462,  459,  460,
    461,  467,  482,  483,  428,  458,  496,  473,  468,  384,
    368,  392,  396,
);
    const YYNOCODE = 110;
    const YYSTACKDEPTH = 500;
    const YYNSTATE = 333;
    const YYNRULE = 192;
    const YYERRORSYMBOL = 60;
    const YYERRSYMDT = 'yy0';
    const YYFALLBACK = 0;
    public static $yyFallback = array(
    );
    public function Trace($TraceFILE, $zTracePrompt)
    {
        if (!$TraceFILE) {
            $zTracePrompt = 0;
        } elseif (!$zTracePrompt) {
            $TraceFILE = 0;
        }
        $this->yyTraceFILE = $TraceFILE;
        $this->yyTracePrompt = $zTracePrompt;
    }

    public function PrintTrace()
    {
        $this->yyTraceFILE = fopen('php://output', 'w');
        $this->yyTracePrompt = '<br>';
    }

    public $yyTraceFILE;
    public $yyTracePrompt;
    public $yyidx;                    /* Index of top element in stack */
    public $yyerrcnt;                 /* Shifts left before out of the error */
    public $yystack = array();  /* The parser's stack */

    public $yyTokenName = array(
  '$',             'VERT',          'COLON',         'TEXT',        
  'STRIPON',       'STRIPOFF',      'LITERALSTART',  'LITERALEND',  
  'LITERAL',       'SIMPELOUTPUT',  'SIMPLETAG',     'SMARTYBLOCKCHILDPARENT',
  'LDEL',          'RDEL',          'DOLLARID',      'EQUAL',       
  'ID',            'PTR',           'LDELIF',        'LDELFOR',     
  'SEMICOLON',     'INCDEC',        'TO',            'STEP',        
  'LDELFOREACH',   'SPACE',         'AS',            'APTR',        
  'LDELSETFILTER',  'CLOSETAG',      'LDELSLASH',     'ATTR',        
  'INTEGER',       'COMMA',         'OPENP',         'CLOSEP',      
  'MATH',          'UNIMATH',       'ISIN',          'QMARK',       
  'NOT',           'TYPECAST',      'HEX',           'DOT',         
  'INSTANCEOF',    'SINGLEQUOTESTRING',  'DOUBLECOLON',   'NAMESPACE',   
  'AT',            'HATCH',         'OPENB',         'CLOSEB',      
  'DOLLAR',        'LOGOP',         'SLOGOP',        'TLOGOP',      
  'SINGLECOND',    'ARRAYOPEN',     'QUOTE',         'BACKTICK',    
  'error',         'start',         'template',      'literal_e2',  
  'literal_e1',    'smartytag',     'tagbody',       'tag',         
  'outattr',       'eqoutattr',     'varindexed',    'output',      
  'attributes',    'variable',      'value',         'expr',        
  'modifierlist',  'statement',     'statements',    'foraction',   
  'varvar',        'modparameters',  'attribute',     'nullcoalescing',
  'ternary',       'tlop',          'lop',           'scond',       
  'isin',          'array',         'function',      'ns1',         
  'doublequoted_with_quotes',  'static_class_access',  'arraydef',      'object',      
  'arrayindex',    'indexdef',      'varvarele',     'objectchain', 
  'objectelement',  'method',        'params',        'modifier',    
  'modparameter',  'arrayelements',  'arrayelement',  'doublequoted',
  'doublequotedcontent',
    );

    public static $yyRuleName = array(
  'start ::= template',
  'template ::= template TEXT',
  'template ::= template STRIPON',
  'template ::= template STRIPOFF',
  'template ::= template LITERALSTART literal_e2 LITERALEND',
  'literal_e2 ::= literal_e1 LITERALSTART literal_e1 LITERALEND',
  'literal_e2 ::= literal_e1',
  'literal_e1 ::= literal_e1 LITERAL',
  'literal_e1 ::=',
  'template ::= template smartytag',
  'template ::=',
  'smartytag ::= SIMPELOUTPUT',
  'smartytag ::= SIMPLETAG',
  'smartytag ::= SMARTYBLOCKCHILDPARENT',
  'smartytag ::= LDEL tagbody RDEL',
  'smartytag ::= tag RDEL',
  'tagbody ::= outattr',
  'tagbody ::= DOLLARID eqoutattr',
  'tagbody ::= varindexed eqoutattr',
  'eqoutattr ::= EQUAL outattr',
  'outattr ::= output attributes',
  'output ::= variable',
  'output ::= value',
  'output ::= expr',
  'tag ::= LDEL ID attributes',
  'tag ::= LDEL ID',
  'tag ::= LDEL ID modifierlist attributes',
  'tag ::= LDEL ID PTR ID attributes',
  'tag ::= LDEL ID PTR ID modifierlist attributes',
  'tag ::= LDELIF expr',
  'tag ::= LDELIF expr attributes',
  'tag ::= LDELIF statement',
  'tag ::= LDELIF statement attributes',
  'tag ::= LDELFOR statements SEMICOLON expr SEMICOLON varindexed foraction attributes',
  'foraction ::= EQUAL expr',
  'foraction ::= INCDEC',
  'tag ::= LDELFOR statement TO expr attributes',
  'tag ::= LDELFOR statement TO expr STEP expr attributes',
  'tag ::= LDELFOREACH SPACE expr AS varvar attributes',
  'tag ::= LDELFOREACH SPACE expr AS varvar APTR varvar attributes',
  'tag ::= LDELFOREACH attributes',
  'tag ::= LDELSETFILTER ID modparameters',
  'tag ::= LDELSETFILTER ID modparameters modifierlist',
  'smartytag ::= CLOSETAG',
  'tag ::= LDELSLASH ID',
  'tag ::= LDELSLASH ID modifierlist',
  'tag ::= LDELSLASH ID PTR ID',
  'tag ::= LDELSLASH ID PTR ID modifierlist',
  'attributes ::= attributes attribute',
  'attributes ::= attribute',
  'attributes ::=',
  'attribute ::= SPACE ID EQUAL ID',
  'attribute ::= ATTR expr',
  'attribute ::= ATTR value',
  'attribute ::= SPACE ID',
  'attribute ::= SPACE expr',
  'attribute ::= SPACE value',
  'attribute ::= SPACE INTEGER EQUAL expr',
  'statements ::= statement',
  'statements ::= statements COMMA statement',
  'statement ::= DOLLARID EQUAL INTEGER',
  'statement ::= DOLLARID EQUAL expr',
  'statement ::= varindexed EQUAL expr',
  'statement ::= OPENP statement CLOSEP',
  'expr ::= value',
  'expr ::= nullcoalescing',
  'expr ::= ternary',
  'expr ::= INCDEC DOLLARID',
  'expr ::= DOLLARID INCDEC',
  'expr ::= DOLLARID COLON ID',
  'expr ::= expr MATH value',
  'expr ::= expr UNIMATH value',
  'expr ::= expr tlop value',
  'expr ::= expr lop expr',
  'expr ::= expr scond',
  'isin ::= ISIN',
  'expr ::= expr isin array',
  'expr ::= expr isin value',
  'nullcoalescing ::= expr QMARK QMARK expr',
  'ternary ::= expr QMARK DOLLARID COLON expr',
  'ternary ::= expr QMARK value COLON expr',
  'ternary ::= expr QMARK expr COLON expr',
  'ternary ::= expr QMARK COLON expr',
  'value ::= variable',
  'value ::= UNIMATH value',
  'value ::= NOT value',
  'value ::= TYPECAST value',
  'value ::= variable INCDEC',
  'value ::= HEX',
  'value ::= INTEGER',
  'value ::= INTEGER DOT INTEGER',
  'value ::= INTEGER DOT',
  'value ::= DOT INTEGER',
  'value ::= ID',
  'value ::= function',
  'value ::= OPENP expr CLOSEP',
  'value ::= variable INSTANCEOF ns1',
  'value ::= variable INSTANCEOF variable',
  'value ::= SINGLEQUOTESTRING',
  'value ::= doublequoted_with_quotes',
  'value ::= varindexed DOUBLECOLON static_class_access',
  'value ::= smartytag',
  'value ::= value modifierlist',
  'value ::= NAMESPACE',
  'value ::= arraydef',
  'value ::= ns1 DOUBLECOLON static_class_access',
  'ns1 ::= ID',
  'ns1 ::= NAMESPACE',
  'variable ::= DOLLARID',
  'variable ::= varindexed',
  'variable ::= varvar AT ID',
  'variable ::= object',
  'variable ::= HATCH ID HATCH',
  'variable ::= HATCH ID HATCH arrayindex',
  'variable ::= HATCH variable HATCH',
  'variable ::= HATCH variable HATCH arrayindex',
  'varindexed ::= DOLLARID arrayindex',
  'varindexed ::= varvar arrayindex',
  'arrayindex ::= arrayindex indexdef',
  'arrayindex ::=',
  'indexdef ::= DOT DOLLARID',
  'indexdef ::= DOT varvar',
  'indexdef ::= DOT varvar AT ID',
  'indexdef ::= DOT ID',
  'indexdef ::= DOT INTEGER',
  'indexdef ::= DOT LDEL expr RDEL',
  'indexdef ::= OPENB ID CLOSEB',
  'indexdef ::= OPENB ID DOT ID CLOSEB',
  'indexdef ::= OPENB SINGLEQUOTESTRING CLOSEB',
  'indexdef ::= OPENB INTEGER CLOSEB',
  'indexdef ::= OPENB DOLLARID CLOSEB',
  'indexdef ::= OPENB variable CLOSEB',
  'indexdef ::= OPENB value CLOSEB',
  'indexdef ::= OPENB expr CLOSEB',
  'indexdef ::= OPENB CLOSEB',
  'varvar ::= DOLLARID',
  'varvar ::= DOLLAR',
  'varvar ::= varvar varvarele',
  'varvarele ::= ID',
  'varvarele ::= SIMPELOUTPUT',
  'varvarele ::= LDEL expr RDEL',
  'object ::= varindexed objectchain',
  'objectchain ::= objectelement',
  'objectchain ::= objectchain objectelement',
  'objectelement ::= PTR ID arrayindex',
  'objectelement ::= PTR varvar arrayindex',
  'objectelement ::= PTR LDEL expr RDEL arrayindex',
  'objectelement ::= PTR ID LDEL expr RDEL arrayindex',
  'objectelement ::= PTR method',
  'function ::= ns1 OPENP params CLOSEP',
  'method ::= ID OPENP params CLOSEP',
  'method ::= DOLLARID OPENP params CLOSEP',
  'params ::= params COMMA expr',
  'params ::= expr',
  'params ::=',
  'modifierlist ::= modifierlist modifier modparameters',
  'modifierlist ::= modifier modparameters',
  'modifier ::= VERT AT ID',
  'modifier ::= VERT ID',
  'modparameters ::= modparameters modparameter',
  'modparameters ::=',
  'modparameter ::= COLON value',
  'modparameter ::= COLON UNIMATH value',
  'modparameter ::= COLON array',
  'static_class_access ::= method',
  'static_class_access ::= method objectchain',
  'static_class_access ::= ID',
  'static_class_access ::= DOLLARID arrayindex',
  'static_class_access ::= DOLLARID arrayindex objectchain',
  'lop ::= LOGOP',
  'lop ::= SLOGOP',
  'tlop ::= TLOGOP',
  'scond ::= SINGLECOND',
  'arraydef ::= OPENB arrayelements CLOSEB',
  'arraydef ::= ARRAYOPEN arrayelements CLOSEP',
  'arrayelements ::= arrayelement',
  'arrayelements ::= arrayelements COMMA arrayelement',
  'arrayelements ::=',
  'arrayelement ::= value APTR expr',
  'arrayelement ::= ID APTR expr',
  'arrayelement ::= expr',
  'doublequoted_with_quotes ::= QUOTE QUOTE',
  'doublequoted_with_quotes ::= QUOTE doublequoted QUOTE',
  'doublequoted ::= doublequoted doublequotedcontent',
  'doublequoted ::= doublequotedcontent',
  'doublequotedcontent ::= BACKTICK variable BACKTICK',
  'doublequotedcontent ::= BACKTICK expr BACKTICK',
  'doublequotedcontent ::= DOLLARID',
  'doublequotedcontent ::= LDEL variable RDEL',
  'doublequotedcontent ::= LDEL expr RDEL',
  'doublequotedcontent ::= smartytag',
  'doublequotedcontent ::= TEXT',
    );

    public function tokenName($tokenType)
    {
        if ($tokenType === 0) {
            return 'End of Input';
        }
        if ($tokenType > 0 && $tokenType < count($this->yyTokenName)) {
            return $this->yyTokenName[$tokenType];
        } else {
            return 'Unknown';
        }
    }

    public static function yy_destructor($yymajor, $yypminor)
    {
        switch ($yymajor) {
            default:  break;   /* If no destructor action specified: do nothing */
        }
    }

    public function yy_pop_parser_stack()
    {
        if (empty($this->yystack)) {
            return;
        }
        $yytos = array_pop($this->yystack);
        if ($this->yyTraceFILE && $this->yyidx >= 0) {
            fwrite($this->yyTraceFILE,
                $this->yyTracePrompt . 'Popping ' . $this->yyTokenName[$yytos->major] .
                    "\n");
        }
        $yymajor = $yytos->major;
        self::yy_destructor($yymajor, $yytos->minor);
        $this->yyidx--;

        return $yymajor;
    }

    public function __destruct()
    {
        while ($this->yystack !== Array()) {
            $this->yy_pop_parser_stack();
        }
        if (is_resource($this->yyTraceFILE)) {
            fclose($this->yyTraceFILE);
        }
    }

    public function yy_get_expected_tokens($token)
    {
        static $res3 = array();
        static $res4 = array();
        $state = $this->yystack[$this->yyidx]->stateno;
        $expected = self::$yyExpectedTokens[$state];
        if (isset($res3[$state][$token])) {
            if ($res3[$state][$token]) {
                return $expected;
            }
        } else {
            if ($res3[$state][$token] = in_array($token, self::$yyExpectedTokens[$state], true)) {
                return $expected;
            }
        }
        $stack = $this->yystack;
        $yyidx = $this->yyidx;
        do {
            $yyact = $this->yy_find_shift_action($token);
            if ($yyact >= self::YYNSTATE && $yyact < self::YYNSTATE + self::YYNRULE) {
                // reduce action
                $done = 0;
                do {
                    if ($done++ === 100) {
                        $this->yyidx = $yyidx;
                        $this->yystack = $stack;
                        // too much recursion prevents proper detection
                        // so give up
                        return array_unique($expected);
                    }
                    $yyruleno = $yyact - self::YYNSTATE;
                    $this->yyidx -= self::$yyRuleInfo[$yyruleno][1];
                    $nextstate = $this->yy_find_reduce_action(
                        $this->yystack[$this->yyidx]->stateno,
                        self::$yyRuleInfo[$yyruleno][0]);
                    if (isset(self::$yyExpectedTokens[$nextstate])) {
                        $expected = array_merge($expected, self::$yyExpectedTokens[$nextstate]);
                        if (isset($res4[$nextstate][$token])) {
                            if ($res4[$nextstate][$token]) {
                                $this->yyidx = $yyidx;
                                $this->yystack = $stack;
                                return array_unique($expected);
                            }
                        } else {
                            if ($res4[$nextstate][$token] = in_array($token, self::$yyExpectedTokens[$nextstate], true)) {
                                $this->yyidx = $yyidx;
                                $this->yystack = $stack;
                                return array_unique($expected);
                            }
                        }
                    }
                    if ($nextstate < self::YYNSTATE) {
                        // we need to shift a non-terminal
                        $this->yyidx++;
                        $x = (object) ['stateno' => null, 'major' => null, 'minor' => null];
                        $x->stateno = $nextstate;
                        $x->major = self::$yyRuleInfo[$yyruleno][0];
                        $this->yystack[$this->yyidx] = $x;
                        continue 2;
                    } elseif ($nextstate === self::YYNSTATE + self::YYNRULE + 1) {
                        $this->yyidx = $yyidx;
                        $this->yystack = $stack;
                        // the last token was just ignored, we can't accept
                        // by ignoring input, this is in essence ignoring a
                        // syntax error!
                        return array_unique($expected);
                    } elseif ($nextstate === self::YY_NO_ACTION) {
                        $this->yyidx = $yyidx;
                        $this->yystack = $stack;
                        // input accepted, but not shifted (I guess)
                        return $expected;
                    } else {
                        $yyact = $nextstate;
                    }
                } while (true);
            }
            break;
        } while (true);
        $this->yyidx = $yyidx;
        $this->yystack = $stack;

        return array_unique($expected);
    }

    public function yy_is_expected_token($token)
    {
        static $res = array();
        static $res2 = array();
        if ($token === 0) {
            return true; // 0 is not part of this
        }
        $state = $this->yystack[$this->yyidx]->stateno;
        if (isset($res[$state][$token])) {
            if ($res[$state][$token]) {
                return true;
            }
        } else {
            if ($res[$state][$token] = in_array($token, self::$yyExpectedTokens[$state], true)) {
                return true;
            }
       }
        $stack = $this->yystack;
        $yyidx = $this->yyidx;
        do {
            $yyact = $this->yy_find_shift_action($token);
            if ($yyact >= self::YYNSTATE && $yyact < self::YYNSTATE + self::YYNRULE) {
                // reduce action
                $done = 0;
                do {
                    if ($done++ === 100) {
                        $this->yyidx = $yyidx;
                        $this->yystack = $stack;
                        // too much recursion prevents proper detection
                        // so give up
                        return true;
                    }
                    $yyruleno = $yyact - self::YYNSTATE;
                    $this->yyidx -= self::$yyRuleInfo[$yyruleno][1];
                    $nextstate = $this->yy_find_reduce_action(
                        $this->yystack[$this->yyidx]->stateno,
                        self::$yyRuleInfo[$yyruleno][0]);
                    if (isset($res2[$nextstate][$token])) {
                        if ($res2[$nextstate][$token]) {
                            $this->yyidx = $yyidx;
                            $this->yystack = $stack;
                            return true;
                        }
                    } else {
                        if ($res2[$nextstate][$token] = (isset(self::$yyExpectedTokens[$nextstate]) && in_array($token, self::$yyExpectedTokens[$nextstate], true))) {
                            $this->yyidx = $yyidx;
                            $this->yystack = $stack;
                            return true;
                        }
                    }
                    if ($nextstate < self::YYNSTATE) {
                        // we need to shift a non-terminal
                        $this->yyidx++;
                        $x = (object) ['stateno' => null, 'major' => null, 'minor' => null];
                        $x->stateno = $nextstate;
                        $x->major = self::$yyRuleInfo[$yyruleno][0];
                        $this->yystack[$this->yyidx] = $x;
                        continue 2;
                    } elseif ($nextstate === self::YYNSTATE + self::YYNRULE + 1) {
                        $this->yyidx = $yyidx;
                        $this->yystack = $stack;
                        if (!$token) {
                            // end of input: this is valid
                            return true;
                        }
                        // the last token was just ignored, we can't accept
                        // by ignoring input, this is in essence ignoring a
                        // syntax error!
                        return false;
                    } elseif ($nextstate === self::YY_NO_ACTION) {
                        $this->yyidx = $yyidx;
                        $this->yystack = $stack;
                        // input accepted, but not shifted (I guess)
                        return true;
                    } else {
                        $yyact = $nextstate;
                    }
                } while (true);
            }
            break;
        } while (true);
        $this->yyidx = $yyidx;
        $this->yystack = $stack;

        return true;
    }

   public function yy_find_shift_action($iLookAhead)
    {
        $stateno = $this->yystack[$this->yyidx]->stateno;

        /* if ($this->yyidx < 0) return self::YY_NO_ACTION;  */
        if (!isset(self::$yy_shift_ofst[$stateno])) {
            // no shift actions
            return self::$yy_default[$stateno];
        }
        $i = self::$yy_shift_ofst[$stateno];
        if ($i === self::YY_SHIFT_USE_DFLT) {
            return self::$yy_default[$stateno];
        }
        if ($iLookAhead === self::YYNOCODE) {
            return self::YY_NO_ACTION;
        }
        $i += $iLookAhead;
        if ($i < 0 || $i >= self::YY_SZ_ACTTAB ||
              self::$yy_lookahead[$i] != $iLookAhead) {
            if (count(self::$yyFallback) && $iLookAhead < count(self::$yyFallback)
                   && ($iFallback = self::$yyFallback[$iLookAhead]) != 0) {
                if ($this->yyTraceFILE) {
                    fwrite($this->yyTraceFILE, $this->yyTracePrompt . 'FALLBACK ' .
                        $this->yyTokenName[$iLookAhead] . ' => ' .
                        $this->yyTokenName[$iFallback] . "\n");
                }

                return $this->yy_find_shift_action($iFallback);
            }

            return self::$yy_default[$stateno];
        } else {
            return self::$yy_action[$i];
        }
    }

    public function yy_find_reduce_action($stateno, $iLookAhead)
    {
        /* $stateno = $this->yystack[$this->yyidx]->stateno; */

        if (!isset(self::$yy_reduce_ofst[$stateno])) {
            return self::$yy_default[$stateno];
        }
        $i = self::$yy_reduce_ofst[$stateno];
        if ($i === self::YY_REDUCE_USE_DFLT) {
            return self::$yy_default[$stateno];
        }
        if ($iLookAhead === self::YYNOCODE) {
            return self::YY_NO_ACTION;
        }
        $i += $iLookAhead;
        if ($i < 0 || $i >= self::YY_SZ_ACTTAB ||
              self::$yy_lookahead[$i] != $iLookAhead) {
            return self::$yy_default[$stateno];
        } else {
            return self::$yy_action[$i];
        }
    }

    public function yy_shift($yyNewState, $yyMajor, $yypMinor)
    {
        $this->yyidx++;
        if ($this->yyidx >= self::YYSTACKDEPTH) {
            $this->yyidx--;
            if ($this->yyTraceFILE) {
                fprintf($this->yyTraceFILE, "%sStack Overflow!\n", $this->yyTracePrompt);
            }
            while ($this->yyidx >= 0) {
                $this->yy_pop_parser_stack();
            }
// line 232 "src/Parser/TemplateParser.y"

    $this->internalError = true;
    $this->compiler->trigger_template_error('Stack overflow in template parser');

            return;
        }
        $yytos = (object) ['stateno' => null, 'major' => null, 'minor' => null];
        $yytos->stateno = $yyNewState;
        $yytos->major = $yyMajor;
        $yytos->minor = $yypMinor;
        $this->yystack[] = $yytos;
        if ($this->yyTraceFILE && $this->yyidx > 0) {
            fprintf($this->yyTraceFILE, "%sShift %d\n", $this->yyTracePrompt,
                $yyNewState);
            fprintf($this->yyTraceFILE, "%sStack:", $this->yyTracePrompt);
            for ($i = 1; $i <= $this->yyidx; $i++) {
                fprintf($this->yyTraceFILE, " %s",
                    $this->yyTokenName[$this->yystack[$i]->major]);
            }
            fwrite($this->yyTraceFILE,"\n");
        }
    }

    public static $yyRuleInfo = array(
  array( 0 => 61, 1 => 1 ),
  array( 0 => 62, 1 => 2 ),
  array( 0 => 62, 1 => 2 ),
  array( 0 => 62, 1 => 2 ),
  array( 0 => 62, 1 => 4 ),
  array( 0 => 63, 1 => 4 ),
  array( 0 => 63, 1 => 1 ),
  array( 0 => 64, 1 => 2 ),
  array( 0 => 64, 1 => 0 ),
  array( 0 => 62, 1 => 2 ),
  array( 0 => 62, 1 => 0 ),
  array( 0 => 65, 1 => 1 ),
  array( 0 => 65, 1 => 1 ),
  array( 0 => 65, 1 => 1 ),
  array( 0 => 65, 1 => 3 ),
  array( 0 => 65, 1 => 2 ),
  array( 0 => 66, 1 => 1 ),
  array( 0 => 66, 1 => 2 ),
  array( 0 => 66, 1 => 2 ),
  array( 0 => 69, 1 => 2 ),
  array( 0 => 68, 1 => 2 ),
  array( 0 => 71, 1 => 1 ),
  array( 0 => 71, 1 => 1 ),
  array( 0 => 71, 1 => 1 ),
  array( 0 => 67, 1 => 3 ),
  array( 0 => 67, 1 => 2 ),
  array( 0 => 67, 1 => 4 ),
  array( 0 => 67, 1 => 5 ),
  array( 0 => 67, 1 => 6 ),
  array( 0 => 67, 1 => 2 ),
  array( 0 => 67, 1 => 3 ),
  array( 0 => 67, 1 => 2 ),
  array( 0 => 67, 1 => 3 ),
  array( 0 => 67, 1 => 8 ),
  array( 0 => 79, 1 => 2 ),
  array( 0 => 79, 1 => 1 ),
  array( 0 => 67, 1 => 5 ),
  array( 0 => 67, 1 => 7 ),
  array( 0 => 67, 1 => 6 ),
  array( 0 => 67, 1 => 8 ),
  array( 0 => 67, 1 => 2 ),
  array( 0 => 67, 1 => 3 ),
  array( 0 => 67, 1 => 4 ),
  array( 0 => 65, 1 => 1 ),
  array( 0 => 67, 1 => 2 ),
  array( 0 => 67, 1 => 3 ),
  array( 0 => 67, 1 => 4 ),
  array( 0 => 67, 1 => 5 ),
  array( 0 => 72, 1 => 2 ),
  array( 0 => 72, 1 => 1 ),
  array( 0 => 72, 1 => 0 ),
  array( 0 => 82, 1 => 4 ),
  array( 0 => 82, 1 => 2 ),
  array( 0 => 82, 1 => 2 ),
  array( 0 => 82, 1 => 2 ),
  array( 0 => 82, 1 => 2 ),
  array( 0 => 82, 1 => 2 ),
  array( 0 => 82, 1 => 4 ),
  array( 0 => 78, 1 => 1 ),
  array( 0 => 78, 1 => 3 ),
  array( 0 => 77, 1 => 3 ),
  array( 0 => 77, 1 => 3 ),
  array( 0 => 77, 1 => 3 ),
  array( 0 => 77, 1 => 3 ),
  array( 0 => 75, 1 => 1 ),
  array( 0 => 75, 1 => 1 ),
  array( 0 => 75, 1 => 1 ),
  array( 0 => 75, 1 => 2 ),
  array( 0 => 75, 1 => 2 ),
  array( 0 => 75, 1 => 3 ),
  array( 0 => 75, 1 => 3 ),
  array( 0 => 75, 1 => 3 ),
  array( 0 => 75, 1 => 3 ),
  array( 0 => 75, 1 => 3 ),
  array( 0 => 75, 1 => 2 ),
  array( 0 => 88, 1 => 1 ),
  array( 0 => 75, 1 => 3 ),
  array( 0 => 75, 1 => 3 ),
  array( 0 => 83, 1 => 4 ),
  array( 0 => 84, 1 => 5 ),
  array( 0 => 84, 1 => 5 ),
  array( 0 => 84, 1 => 5 ),
  array( 0 => 84, 1 => 4 ),
  array( 0 => 74, 1 => 1 ),
  array( 0 => 74, 1 => 2 ),
  array( 0 => 74, 1 => 2 ),
  array( 0 => 74, 1 => 2 ),
  array( 0 => 74, 1 => 2 ),
  array( 0 => 74, 1 => 1 ),
  array( 0 => 74, 1 => 1 ),
  array( 0 => 74, 1 => 3 ),
  array( 0 => 74, 1 => 2 ),
  array( 0 => 74, 1 => 2 ),
  array( 0 => 74, 1 => 1 ),
  array( 0 => 74, 1 => 1 ),
  array( 0 => 74, 1 => 3 ),
  array( 0 => 74, 1 => 3 ),
  array( 0 => 74, 1 => 3 ),
  array( 0 => 74, 1 => 1 ),
  array( 0 => 74, 1 => 1 ),
  array( 0 => 74, 1 => 3 ),
  array( 0 => 74, 1 => 1 ),
  array( 0 => 74, 1 => 2 ),
  array( 0 => 74, 1 => 1 ),
  array( 0 => 74, 1 => 1 ),
  array( 0 => 74, 1 => 3 ),
  array( 0 => 91, 1 => 1 ),
  array( 0 => 91, 1 => 1 ),
  array( 0 => 73, 1 => 1 ),
  array( 0 => 73, 1 => 1 ),
  array( 0 => 73, 1 => 3 ),
  array( 0 => 73, 1 => 1 ),
  array( 0 => 73, 1 => 3 ),
  array( 0 => 73, 1 => 4 ),
  array( 0 => 73, 1 => 3 ),
  array( 0 => 73, 1 => 4 ),
  array( 0 => 70, 1 => 2 ),
  array( 0 => 70, 1 => 2 ),
  array( 0 => 96, 1 => 2 ),
  array( 0 => 96, 1 => 0 ),
  array( 0 => 97, 1 => 2 ),
  array( 0 => 97, 1 => 2 ),
  array( 0 => 97, 1 => 4 ),
  array( 0 => 97, 1 => 2 ),
  array( 0 => 97, 1 => 2 ),
  array( 0 => 97, 1 => 4 ),
  array( 0 => 97, 1 => 3 ),
  array( 0 => 97, 1 => 5 ),
  array( 0 => 97, 1 => 3 ),
  array( 0 => 97, 1 => 3 ),
  array( 0 => 97, 1 => 3 ),
  array( 0 => 97, 1 => 3 ),
  array( 0 => 97, 1 => 3 ),
  array( 0 => 97, 1 => 3 ),
  array( 0 => 97, 1 => 2 ),
  array( 0 => 80, 1 => 1 ),
  array( 0 => 80, 1 => 1 ),
  array( 0 => 80, 1 => 2 ),
  array( 0 => 98, 1 => 1 ),
  array( 0 => 98, 1 => 1 ),
  array( 0 => 98, 1 => 3 ),
  array( 0 => 95, 1 => 2 ),
  array( 0 => 99, 1 => 1 ),
  array( 0 => 99, 1 => 2 ),
  array( 0 => 100, 1 => 3 ),
  array( 0 => 100, 1 => 3 ),
  array( 0 => 100, 1 => 5 ),
  array( 0 => 100, 1 => 6 ),
  array( 0 => 100, 1 => 2 ),
  array( 0 => 90, 1 => 4 ),
  array( 0 => 101, 1 => 4 ),
  array( 0 => 101, 1 => 4 ),
  array( 0 => 102, 1 => 3 ),
  array( 0 => 102, 1 => 1 ),
  array( 0 => 102, 1 => 0 ),
  array( 0 => 76, 1 => 3 ),
  array( 0 => 76, 1 => 2 ),
  array( 0 => 103, 1 => 3 ),
  array( 0 => 103, 1 => 2 ),
  array( 0 => 81, 1 => 2 ),
  array( 0 => 81, 1 => 0 ),
  array( 0 => 104, 1 => 2 ),
  array( 0 => 104, 1 => 3 ),
  array( 0 => 104, 1 => 2 ),
  array( 0 => 93, 1 => 1 ),
  array( 0 => 93, 1 => 2 ),
  array( 0 => 93, 1 => 1 ),
  array( 0 => 93, 1 => 2 ),
  array( 0 => 93, 1 => 3 ),
  array( 0 => 86, 1 => 1 ),
  array( 0 => 86, 1 => 1 ),
  array( 0 => 85, 1 => 1 ),
  array( 0 => 87, 1 => 1 ),
  array( 0 => 94, 1 => 3 ),
  array( 0 => 94, 1 => 3 ),
  array( 0 => 105, 1 => 1 ),
  array( 0 => 105, 1 => 3 ),
  array( 0 => 105, 1 => 0 ),
  array( 0 => 106, 1 => 3 ),
  array( 0 => 106, 1 => 3 ),
  array( 0 => 106, 1 => 1 ),
  array( 0 => 92, 1 => 2 ),
  array( 0 => 92, 1 => 3 ),
  array( 0 => 107, 1 => 2 ),
  array( 0 => 107, 1 => 1 ),
  array( 0 => 108, 1 => 3 ),
  array( 0 => 108, 1 => 3 ),
  array( 0 => 108, 1 => 1 ),
  array( 0 => 108, 1 => 3 ),
  array( 0 => 108, 1 => 3 ),
  array( 0 => 108, 1 => 1 ),
  array( 0 => 108, 1 => 1 ),
    );

    public static $yyReduceMap = array(
        0 => 0,
        1 => 1,
        2 => 2,
        3 => 3,
        4 => 4,
        5 => 5,
        6 => 6,
        21 => 6,
        22 => 6,
        23 => 6,
        35 => 6,
        55 => 6,
        56 => 6,
        64 => 6,
        65 => 6,
        66 => 6,
        83 => 6,
        88 => 6,
        89 => 6,
        94 => 6,
        98 => 6,
        99 => 6,
        103 => 6,
        104 => 6,
        106 => 6,
        111 => 6,
        175 => 6,
        180 => 6,
        7 => 7,
        8 => 8,
        9 => 9,
        11 => 11,
        12 => 12,
        13 => 13,
        14 => 14,
        15 => 15,
        16 => 16,
        17 => 17,
        18 => 18,
        19 => 19,
        20 => 20,
        24 => 24,
        25 => 25,
        26 => 26,
        27 => 27,
        28 => 28,
        29 => 29,
        30 => 30,
        32 => 30,
        31 => 31,
        33 => 33,
        34 => 34,
        36 => 36,
        37 => 37,
        38 => 38,
        39 => 39,
        40 => 40,
        41 => 41,
        42 => 42,
        43 => 43,
        44 => 44,
        45 => 45,
        46 => 46,
        47 => 47,
        48 => 48,
        49 => 49,
        58 => 49,
        153 => 49,
        157 => 49,
        161 => 49,
        163 => 49,
        50 => 50,
        154 => 50,
        160 => 50,
        51 => 51,
        52 => 52,
        53 => 52,
        54 => 54,
        138 => 54,
        57 => 57,
        59 => 59,
        60 => 60,
        61 => 60,
        62 => 62,
        63 => 63,
        67 => 67,
        68 => 68,
        69 => 69,
        70 => 70,
        71 => 70,
        72 => 72,
        73 => 73,
        74 => 74,
        75 => 75,
        76 => 76,
        77 => 77,
        78 => 78,
        79 => 79,
        80 => 80,
        81 => 80,
        82 => 82,
        84 => 84,
        86 => 84,
        87 => 84,
        118 => 84,
        85 => 85,
        90 => 90,
        91 => 91,
        92 => 92,
        93 => 93,
        95 => 95,
        96 => 96,
        97 => 96,
        100 => 100,
        101 => 101,
        102 => 102,
        105 => 105,
        107 => 107,
        108 => 108,
        109 => 109,
        110 => 110,
        112 => 112,
        113 => 113,
        114 => 114,
        115 => 115,
        116 => 116,
        117 => 117,
        119 => 119,
        177 => 119,
        120 => 120,
        121 => 121,
        122 => 122,
        123 => 123,
        124 => 124,
        125 => 125,
        133 => 125,
        126 => 126,
        127 => 127,
        128 => 128,
        129 => 128,
        131 => 128,
        132 => 128,
        130 => 130,
        134 => 134,
        135 => 135,
        136 => 136,
        181 => 136,
        137 => 137,
        139 => 139,
        140 => 140,
        141 => 141,
        142 => 142,
        143 => 143,
        144 => 144,
        145 => 145,
        146 => 146,
        147 => 147,
        148 => 148,
        149 => 149,
        150 => 150,
        151 => 151,
        152 => 152,
        155 => 155,
        156 => 156,
        158 => 158,
        159 => 159,
        162 => 162,
        164 => 164,
        165 => 165,
        166 => 166,
        167 => 167,
        168 => 168,
        169 => 169,
        170 => 170,
        171 => 171,
        172 => 172,
        173 => 173,
        174 => 173,
        176 => 176,
        178 => 178,
        179 => 179,
        182 => 182,
        183 => 183,
        184 => 184,
        185 => 185,
        188 => 185,
        186 => 186,
        189 => 186,
        187 => 187,
        190 => 190,
        191 => 191,
    );
// line 245 "src/Parser/TemplateParser.y"
    public function yy_r0(){
    $this->root_buffer->prepend_array($this, $this->template_prefix);
    $this->root_buffer->append_array($this, $this->template_postfix);
    $this->_retvalue = $this->root_buffer->to_smarty_php($this);
    }
// line 252 "src/Parser/TemplateParser.y"
    public function yy_r1(){
         $text = $this->yystack[ $this->yyidx + 0 ]->minor;

         if ((string)$text == '') {
            $this->current_buffer->append_subtree($this, null);
         }

         $this->current_buffer->append_subtree($this, new \Smarty\ParseTree\Text($text, $this->strip));
    }
// line 262 "src/Parser/TemplateParser.y"
    public function yy_r2(){
    $this->strip = true;
    }
// line 266 "src/Parser/TemplateParser.y"
    public function yy_r3(){
    $this->strip = false;
    }
// line 271 "src/Parser/TemplateParser.y"
    public function yy_r4(){
       $this->current_buffer->append_subtree($this, new \Smarty\ParseTree\Text($this->yystack[$this->yyidx + -1]->minor));
    }
// line 276 "src/Parser/TemplateParser.y"
    public function yy_r5(){
    $this->_retvalue = $this->yystack[$this->yyidx + -3]->minor.$this->yystack[$this->yyidx + -1]->minor;
    }
// line 279 "src/Parser/TemplateParser.y"
    public function yy_r6(){
    $this->_retvalue = $this->yystack[$this->yyidx + 0]->minor;
    }
// line 283 "src/Parser/TemplateParser.y"
    public function yy_r7(){
        $this->_retvalue = $this->yystack[$this->yyidx + -1]->minor.$this->yystack[$this->yyidx + 0]->minor;

    }
// line 288 "src/Parser/TemplateParser.y"
    public function yy_r8(){
    $this->_retvalue = '';
    }
// line 292 "src/Parser/TemplateParser.y"
    public function yy_r9(){
     $this->current_buffer->append_subtree($this, $this->mergePrefixCode($this->yystack[$this->yyidx + 0]->minor));
     $this->compiler->has_variable_string = false;
     $this->block_nesting_level = $this->compiler->getTagStackCount();
    }
// line 302 "src/Parser/TemplateParser.y"
    public function yy_r11(){
    $var = trim(substr($this->yystack[$this->yyidx + 0]->minor, $this->compiler->getLdelLength(), -$this->compiler->getRdelLength()), ' $');
    $attributes = [];
    if (preg_match('/^(.*)(\s+nocache)$/', $var, $match)) {
        $attributes[] = 'nocache';
        $var = $match[1];
    }
    $this->_retvalue = $this->compiler->compilePrintExpression($this->compiler->compileVariable('\''.$var.'\''), $attributes);
    }
// line 313 "src/Parser/TemplateParser.y"
    public function yy_r12(){
    $tag = trim(substr($this->yystack[$this->yyidx + 0]->minor, $this->compiler->getLdelLength(), -$this->compiler->getRdelLength()));
    if ($tag == 'strip') {
        $this->strip = true;
        $this->_retvalue = null;
    } else {
        if (defined($tag)) {
            if ($this->security) {
               $this->security->isTrustedConstant($tag, $this->compiler);
            }
            $this->_retvalue = $this->compiler->compilePrintExpression($tag);
        } else {
            if (preg_match('/^(.*)(\s+nocache)$/', $tag, $match)) {
                $this->_retvalue = $this->compiler->compileTag($match[1],array('\'nocache\''));
            } else {
                $this->_retvalue = $this->compiler->compileTag($tag,array());
            }
        }
    }
    }
// line 334 "src/Parser/TemplateParser.y"
    public function yy_r13(){
    $j = strrpos($this->yystack[$this->yyidx + 0]->minor,'.');
    if ($this->yystack[$this->yyidx + 0]->minor[$j+1] == 'c') {
        // {$smarty.block.child}
        $this->_retvalue = $this->compiler->compileChildBlock();
    } else {
        // {$smarty.block.parent}
       $this->_retvalue = $this->compiler->compileParentBlock();
     }
    }
// line 345 "src/Parser/TemplateParser.y"
    public function yy_r14(){
    $this->_retvalue  = $this->yystack[$this->yyidx + -1]->minor;
    }
// line 349 "src/Parser/TemplateParser.y"
    public function yy_r15(){
     $this->_retvalue  = $this->yystack[$this->yyidx + -1]->minor;
     }
// line 353 "src/Parser/TemplateParser.y"
    public function yy_r16(){
    $this->_retvalue = $this->compiler->compilePrintExpression($this->yystack[$this->yyidx + 0]->minor[0], $this->yystack[$this->yyidx + 0]->minor[1]);
    }
// line 362 "src/Parser/TemplateParser.y"
    public function yy_r17(){
    $this->_retvalue = $this->compiler->compileTag('assign',array_merge(array(array('value'=>$this->yystack[$this->yyidx + 0]->minor[0]),array('var'=>'\''.substr($this->yystack[$this->yyidx + -1]->minor,1).'\'')),$this->yystack[$this->yyidx + 0]->minor[1]));
    }
// line 366 "src/Parser/TemplateParser.y"
    public function yy_r18(){
    $this->_retvalue = $this->compiler->compileTag('assign',array_merge(array(array('value'=>$this->yystack[$this->yyidx + 0]->minor[0]),array('var'=>$this->yystack[$this->yyidx + -1]->minor['var'])),$this->yystack[$this->yyidx + 0]->minor[1]),array('smarty_internal_index'=>$this->yystack[$this->yyidx + -1]->minor['smarty_internal_index']));
    }
// line 370 "src/Parser/TemplateParser.y"
    public function yy_r19(){
       $this->_retvalue = $this->yystack[$this->yyidx + 0]->minor;
    }
// line 374 "src/Parser/TemplateParser.y"
    public function yy_r20(){
    $this->_retvalue = array($this->yystack[$this->yyidx + -1]->minor,$this->yystack[$this->yyidx + 0]->minor);
    }
// line 389 "src/Parser/TemplateParser.y"
    public function yy_r24(){
        if (defined($this->yystack[$this->yyidx + -1]->minor)) {
            if ($this->security) {
                $this->security->isTrustedConstant($this->yystack[$this->yyidx + -1]->minor, $this->compiler);
            }
            $this->_retvalue = $this->compiler->compilePrintExpression($this->yystack[$this->yyidx + -1]->minor, $this->yystack[$this->yyidx + 0]->minor);
        } else {
            $this->_retvalue = $this->compiler->compileTag($this->yystack[$this->yyidx + -1]->minor,$this->yystack[$this->yyidx + 0]->minor);
        }
    }
// line 399 "src/Parser/TemplateParser.y"
    public function yy_r25(){
        if (defined($this->yystack[$this->yyidx + 0]->minor)) {
            if ($this->security) {
                $this->security->isTrustedConstant($this->yystack[$this->yyidx + 0]->minor, $this->compiler);
            }
            $this->_retvalue = $this->compiler->compilePrintExpression($this->yystack[$this->yyidx + 0]->minor);
        } else {
            $this->_retvalue = $this->compiler->compileTag($this->yystack[$this->yyidx + 0]->minor,array());
        }
    }
// line 412 "src/Parser/TemplateParser.y"
    public function yy_r26(){
        if (defined($this->yystack[$this->yyidx + -2]->minor)) {
            if ($this->security) {
                $this->security->isTrustedConstant($this->yystack[$this->yyidx + -2]->minor, $this->compiler);
            }
            $this->_retvalue = $this->compiler->compilePrintExpression($this->yystack[$this->yyidx + -2]->minor, $this->yystack[$this->yyidx + 0]->minor, $this->yystack[$this->yyidx + -1]->minor);
        } else {
            $this->_retvalue = $this->compiler->compileTag($this->yystack[$this->yyidx + -2]->minor,$this->yystack[$this->yyidx + 0]->minor, array('modifierlist'=>$this->yystack[$this->yyidx + -1]->minor));
        }
    }
// line 424 "src/Parser/TemplateParser.y"
    public function yy_r27(){
    $this->_retvalue = $this->compiler->compileTag($this->yystack[$this->yyidx + -3]->minor,$this->yystack[$this->yyidx + 0]->minor,array('object_method'=>$this->yystack[$this->yyidx + -1]->minor));
    }
// line 429 "src/Parser/TemplateParser.y"
    public function yy_r28(){
    $this->_retvalue = $this->compiler->compileTag($this->yystack[$this->yyidx + -4]->minor,$this->yystack[$this->yyidx + 0]->minor,array('modifierlist'=>$this->yystack[$this->yyidx + -1]->minor, 'object_method'=>$this->yystack[$this->yyidx + -2]->minor));
    }
// line 434 "src/Parser/TemplateParser.y"
    public function yy_r29(){
    $tag = trim(substr($this->yystack[$this->yyidx + -1]->minor,$this->compiler->getLdelLength())); 
    $this->_retvalue = $this->compiler->compileTag(($tag === 'else if')? 'elseif' : $tag,array(),array('if condition'=>$this->yystack[$this->yyidx + 0]->minor));
    }
// line 439 "src/Parser/TemplateParser.y"
    public function yy_r30(){
    $tag = trim(substr($this->yystack[$this->yyidx + -2]->minor,$this->compiler->getLdelLength()));
    $this->_retvalue = $this->compiler->compileTag(($tag === 'else if')? 'elseif' : $tag,$this->yystack[$this->yyidx + 0]->minor,array('if condition'=>$this->yystack[$this->yyidx + -1]->minor));
    }
// line 444 "src/Parser/TemplateParser.y"
    public function yy_r31(){
    $tag = trim(substr($this->yystack[$this->yyidx + -1]->minor,$this->compiler->getLdelLength()));
    $this->_retvalue = $this->compiler->compileTag(($tag === 'else if')? 'elseif' : $tag,array(),array('if condition'=>$this->yystack[$this->yyidx + 0]->minor));
    }
// line 455 "src/Parser/TemplateParser.y"
    public function yy_r33(){
    $this->_retvalue = $this->compiler->compileTag('for',array_merge($this->yystack[$this->yyidx + 0]->minor,array(array('start'=>$this->yystack[$this->yyidx + -6]->minor),array('ifexp'=>$this->yystack[$this->yyidx + -4]->minor),array('var'=>$this->yystack[$this->yyidx + -2]->minor),array('step'=>$this->yystack[$this->yyidx + -1]->minor))),1);
    }
// line 459 "src/Parser/TemplateParser.y"
    public function yy_r34(){
    $this->_retvalue = '='.$this->yystack[$this->yyidx + 0]->minor;
    }
// line 467 "src/Parser/TemplateParser.y"
    public function yy_r36(){
    $this->_retvalue = $this->compiler->compileTag('for',array_merge($this->yystack[$this->yyidx + 0]->minor,array(array('start'=>$this->yystack[$this->yyidx + -3]->minor),array('to'=>$this->yystack[$this->yyidx + -1]->minor))),0);
    }
// line 471 "src/Parser/TemplateParser.y"
    public function yy_r37(){
    $this->_retvalue = $this->compiler->compileTag('for',array_merge($this->yystack[$this->yyidx + 0]->minor,array(array('start'=>$this->yystack[$this->yyidx + -5]->minor),array('to'=>$this->yystack[$this->yyidx + -3]->minor),array('step'=>$this->yystack[$this->yyidx + -1]->minor))),0);
    }
// line 476 "src/Parser/TemplateParser.y"
    public function yy_r38(){
    $this->_retvalue = $this->compiler->compileTag('foreach',array_merge($this->yystack[$this->yyidx + 0]->minor,array(array('from'=>$this->yystack[$this->yyidx + -3]->minor),array('item'=>$this->yystack[$this->yyidx + -1]->minor))));
    }
// line 480 "src/Parser/TemplateParser.y"
    public function yy_r39(){
    $this->_retvalue = $this->compiler->compileTag('foreach',array_merge($this->yystack[$this->yyidx + 0]->minor,array(array('from'=>$this->yystack[$this->yyidx + -5]->minor),array('item'=>$this->yystack[$this->yyidx + -1]->minor),array('key'=>$this->yystack[$this->yyidx + -3]->minor))));
    }
// line 483 "src/Parser/TemplateParser.y"
    public function yy_r40(){
    $this->_retvalue = $this->compiler->compileTag('foreach',$this->yystack[$this->yyidx + 0]->minor);
    }
// line 488 "src/Parser/TemplateParser.y"
    public function yy_r41(){
    $this->_retvalue = $this->compiler->compileTag('setfilter',array(),array('modifier_list'=>array(array_merge(array($this->yystack[$this->yyidx + -1]->minor),$this->yystack[$this->yyidx + 0]->minor))));
    }
// line 492 "src/Parser/TemplateParser.y"
    public function yy_r42(){
    $this->_retvalue = $this->compiler->compileTag('setfilter',array(),array('modifier_list'=>array_merge(array(array_merge(array($this->yystack[$this->yyidx + -2]->minor),$this->yystack[$this->yyidx + -1]->minor)),$this->yystack[$this->yyidx + 0]->minor)));
    }
// line 498 "src/Parser/TemplateParser.y"
    public function yy_r43(){
    $tag = trim(substr($this->yystack[$this->yyidx + 0]->minor, $this->compiler->getLdelLength(), -$this->compiler->getRdelLength()), ' /');
    if ($tag === 'strip') {
        $this->strip = false;
        $this->_retvalue = null;
    } else {
       $this->_retvalue = $this->compiler->compileTag($tag.'close',array());
    }
     }
// line 507 "src/Parser/TemplateParser.y"
    public function yy_r44(){
    $this->_retvalue = $this->compiler->compileTag($this->yystack[$this->yyidx + 0]->minor.'close',array());
    }
// line 511 "src/Parser/TemplateParser.y"
    public function yy_r45(){
    $this->_retvalue = $this->compiler->compileTag($this->yystack[$this->yyidx + -1]->minor.'close',array(),array('modifier_list'=>$this->yystack[$this->yyidx + 0]->minor));
    }
// line 516 "src/Parser/TemplateParser.y"
    public function yy_r46(){
    $this->_retvalue = $this->compiler->compileTag($this->yystack[$this->yyidx + -2]->minor.'close',array(),array('object_method'=>$this->yystack[$this->yyidx + 0]->minor));
    }
// line 520 "src/Parser/TemplateParser.y"
    public function yy_r47(){
    $this->_retvalue = $this->compiler->compileTag($this->yystack[$this->yyidx + -3]->minor.'close',array(),array('object_method'=>$this->yystack[$this->yyidx + -1]->minor, 'modifier_list'=>$this->yystack[$this->yyidx + 0]->minor));
    }
// line 528 "src/Parser/TemplateParser.y"
    public function yy_r48(){
    $this->_retvalue = $this->yystack[$this->yyidx + -1]->minor;
    $this->_retvalue[] = $this->yystack[$this->yyidx + 0]->minor;
    }
// line 534 "src/Parser/TemplateParser.y"
    public function yy_r49(){
    $this->_retvalue = array($this->yystack[$this->yyidx + 0]->minor);
    }
// line 539 "src/Parser/TemplateParser.y"
    public function yy_r50(){
    $this->_retvalue = array();
    }
// line 544 "src/Parser/TemplateParser.y"
    public function yy_r51(){
    if (defined($this->yystack[$this->yyidx + 0]->minor)) {
        if ($this->security) {
            $this->security->isTrustedConstant($this->yystack[$this->yyidx + 0]->minor, $this->compiler);
        }
        $this->_retvalue = array($this->yystack[$this->yyidx + -2]->minor=>$this->yystack[$this->yyidx + 0]->minor);
    } else {
        $this->_retvalue = array($this->yystack[$this->yyidx + -2]->minor=>'\''.$this->yystack[$this->yyidx + 0]->minor.'\'');
    }
    }
// line 555 "src/Parser/TemplateParser.y"
    public function yy_r52(){
    $this->_retvalue = array(trim($this->yystack[$this->yyidx + -1]->minor," =\n\r\t")=>$this->yystack[$this->yyidx + 0]->minor);
    }
// line 563 "src/Parser/TemplateParser.y"
    public function yy_r54(){
    $this->_retvalue = '\''.$this->yystack[$this->yyidx + 0]->minor.'\'';
    }
// line 575 "src/Parser/TemplateParser.y"
    public function yy_r57(){
    $this->_retvalue = array($this->yystack[$this->yyidx + -2]->minor=>$this->yystack[$this->yyidx + 0]->minor);
    }
// line 588 "src/Parser/TemplateParser.y"
    public function yy_r59(){
    $this->yystack[$this->yyidx + -2]->minor[]=$this->yystack[$this->yyidx + 0]->minor;
    $this->_retvalue = $this->yystack[$this->yyidx + -2]->minor;
    }
// line 593 "src/Parser/TemplateParser.y"
    public function yy_r60(){
    $this->_retvalue = array('var' => '\''.substr($this->yystack[$this->yyidx + -2]->minor,1).'\'', 'value'=>$this->yystack[$this->yyidx + 0]->minor);
    }
// line 600 "src/Parser/TemplateParser.y"
    public function yy_r62(){
    $this->_retvalue = array('var' => $this->yystack[$this->yyidx + -2]->minor, 'value'=>$this->yystack[$this->yyidx + 0]->minor);
    }
// line 604 "src/Parser/TemplateParser.y"
    public function yy_r63(){
    $this->_retvalue = $this->yystack[$this->yyidx + -1]->minor;
    }
// line 629 "src/Parser/TemplateParser.y"
    public function yy_r67(){
	$this->_retvalue = '$_smarty_tpl->getVariable(\''. substr($this->yystack[$this->yyidx + 0]->minor,1) .'\')->preIncDec(\'' . $this->yystack[$this->yyidx + -1]->minor . '\')';
    }
// line 634 "src/Parser/TemplateParser.y"
    public function yy_r68(){
	$this->_retvalue = '$_smarty_tpl->getVariable(\''. substr($this->yystack[$this->yyidx + -1]->minor,1) .'\')->postIncDec(\'' . $this->yystack[$this->yyidx + 0]->minor . '\')';
    }
// line 639 "src/Parser/TemplateParser.y"
    public function yy_r69(){
    $this->_retvalue = '$_smarty_tpl->getStreamVariable(\''.substr($this->yystack[$this->yyidx + -2]->minor,1).'://' . $this->yystack[$this->yyidx + 0]->minor . '\')';
    }
// line 644 "src/Parser/TemplateParser.y"
    public function yy_r70(){
    $this->_retvalue = $this->yystack[$this->yyidx + -2]->minor . trim($this->yystack[$this->yyidx + -1]->minor) . $this->yystack[$this->yyidx + 0]->minor;
    }
// line 654 "src/Parser/TemplateParser.y"
    public function yy_r72(){
    $this->_retvalue = $this->yystack[$this->yyidx + -1]->minor['pre']. $this->yystack[$this->yyidx + -2]->minor.$this->yystack[$this->yyidx + -1]->minor['op'].$this->yystack[$this->yyidx + 0]->minor .')';
    }
// line 658 "src/Parser/TemplateParser.y"
    public function yy_r73(){
    $this->_retvalue = $this->yystack[$this->yyidx + -2]->minor.$this->yystack[$this->yyidx + -1]->minor.$this->yystack[$this->yyidx + 0]->minor;
    }
// line 662 "src/Parser/TemplateParser.y"
    public function yy_r74(){
    $this->_retvalue = $this->yystack[$this->yyidx + 0]->minor . $this->yystack[$this->yyidx + -1]->minor . ')';
    }
// line 666 "src/Parser/TemplateParser.y"
    public function yy_r75(){
    static $isin = [
        'isin' => 'in_array(',
        'isnotin' => '!in_array(',
    ];
   $op = strtolower(str_replace(' ', '', $this->yystack[$this->yyidx + 0]->minor));
   $this->_retvalue = $isin[$op];
    }
// line 675 "src/Parser/TemplateParser.y"
    public function yy_r76(){
    $this->_retvalue = $this->yystack[$this->yyidx + -1]->minor . $this->yystack[$this->yyidx + -2]->minor.','.$this->yystack[$this->yyidx + 0]->minor.')';
    }
// line 679 "src/Parser/TemplateParser.y"
    public function yy_r77(){
    $this->_retvalue = $this->yystack[$this->yyidx + -1]->minor . $this->yystack[$this->yyidx + -2]->minor.',(array)'.$this->yystack[$this->yyidx + 0]->minor.')';
    }
// line 684 "src/Parser/TemplateParser.y"
    public function yy_r78(){
    $this->_retvalue = $this->yystack[$this->yyidx + -3]->minor.' ?? '.$this->yystack[$this->yyidx + 0]->minor;
    }
// line 691 "src/Parser/TemplateParser.y"
    public function yy_r79(){
    $this->_retvalue = $this->yystack[$this->yyidx + -4]->minor.' ? '. $this->compiler->compileVariable('\''.substr($this->yystack[$this->yyidx + -2]->minor,1).'\'') . ' : '.$this->yystack[$this->yyidx + 0]->minor;
    }
// line 695 "src/Parser/TemplateParser.y"
    public function yy_r80(){
    $this->_retvalue = $this->yystack[$this->yyidx + -4]->minor.' ? '.$this->yystack[$this->yyidx + -2]->minor.' : '.$this->yystack[$this->yyidx + 0]->minor;
    }
// line 704 "src/Parser/TemplateParser.y"
    public function yy_r82(){
    $this->_retvalue = $this->yystack[$this->yyidx + -3]->minor.' ?: '.$this->yystack[$this->yyidx + 0]->minor;
    }
// line 714 "src/Parser/TemplateParser.y"
    public function yy_r84(){
    $this->_retvalue = $this->yystack[$this->yyidx + -1]->minor.$this->yystack[$this->yyidx + 0]->minor;
    }
// line 719 "src/Parser/TemplateParser.y"
    public function yy_r85(){
    $this->_retvalue = '!'.$this->yystack[$this->yyidx + 0]->minor;
    }
// line 740 "src/Parser/TemplateParser.y"
    public function yy_r90(){
    $this->_retvalue = $this->yystack[$this->yyidx + -2]->minor.'.'.$this->yystack[$this->yyidx + 0]->minor;
    }
// line 744 "src/Parser/TemplateParser.y"
    public function yy_r91(){
    $this->_retvalue = $this->yystack[$this->yyidx + -1]->minor.'.';
    }
// line 748 "src/Parser/TemplateParser.y"
    public function yy_r92(){
    $this->_retvalue = '.'.$this->yystack[$this->yyidx + 0]->minor;
    }
// line 753 "src/Parser/TemplateParser.y"
    public function yy_r93(){
    if (defined($this->yystack[$this->yyidx + 0]->minor)) {
        if ($this->security) {
             $this->security->isTrustedConstant($this->yystack[$this->yyidx + 0]->minor, $this->compiler);
        }
        $this->_retvalue = $this->yystack[$this->yyidx + 0]->minor;
    } else {
        $this->_retvalue = '\''.$this->yystack[$this->yyidx + 0]->minor.'\'';
    }
    }
// line 770 "src/Parser/TemplateParser.y"
    public function yy_r95(){
    $this->_retvalue = '('. $this->yystack[$this->yyidx + -1]->minor .')';
    }
// line 774 "src/Parser/TemplateParser.y"
    public function yy_r96(){
      $this->_retvalue = $this->yystack[$this->yyidx + -2]->minor.$this->yystack[$this->yyidx + -1]->minor.$this->yystack[$this->yyidx + 0]->minor;
    }
// line 792 "src/Parser/TemplateParser.y"
    public function yy_r100(){
    if ($this->security && $this->security->static_classes !== array()) {
        $this->compiler->trigger_template_error('dynamic static class not allowed by security setting');
    }
    $prefixVar = $this->compiler->getNewPrefixVariable();
    if ($this->yystack[$this->yyidx + -2]->minor['var'] === '\'smarty\'') {
        $this->compiler->appendPrefixCode("<?php {$prefixVar} = ". (new \Smarty\Compile\SpecialVariableCompiler())->compile(array(),$this->compiler,$this->yystack[$this->yyidx + -2]->minor['smarty_internal_index']).';?>');
     } else {
        $this->compiler->appendPrefixCode("<?php  {$prefixVar} = ". $this->compiler->compileVariable($this->yystack[$this->yyidx + -2]->minor['var']).$this->yystack[$this->yyidx + -2]->minor['smarty_internal_index'].';?>');
    }
    $this->_retvalue = $prefixVar .'::'.$this->yystack[$this->yyidx + 0]->minor[0].$this->yystack[$this->yyidx + 0]->minor[1];
    }
// line 806 "src/Parser/TemplateParser.y"
    public function yy_r101(){
    $prefixVar = $this->compiler->getNewPrefixVariable();
    $tmp = $this->compiler->appendCode('<?php ob_start();?>', $this->yystack[$this->yyidx + 0]->minor);
    $this->compiler->appendPrefixCode($this->compiler->appendCode($tmp, "<?php {$prefixVar} = ob_get_clean();?>"));
    $this->_retvalue = $prefixVar;
    }
// line 813 "src/Parser/TemplateParser.y"
    public function yy_r102(){
    $this->_retvalue = $this->compiler->compileModifier($this->yystack[$this->yyidx + 0]->minor, $this->yystack[$this->yyidx + -1]->minor);
    }
// line 826 "src/Parser/TemplateParser.y"
    public function yy_r105(){
    if (!in_array(strtolower($this->yystack[$this->yyidx + -2]->minor), array('self', 'parent')) && (!$this->security || $this->security->isTrustedStaticClassAccess($this->yystack[$this->yyidx + -2]->minor, $this->yystack[$this->yyidx + 0]->minor, $this->compiler))) {
        if (isset($this->smarty->registered_classes[$this->yystack[$this->yyidx + -2]->minor])) {
            $this->_retvalue = $this->smarty->registered_classes[$this->yystack[$this->yyidx + -2]->minor].'::'.$this->yystack[$this->yyidx + 0]->minor[0].$this->yystack[$this->yyidx + 0]->minor[1];
        } else {
            $this->_retvalue = $this->yystack[$this->yyidx + -2]->minor.'::'.$this->yystack[$this->yyidx + 0]->minor[0].$this->yystack[$this->yyidx + 0]->minor[1];
        } 
    } else {
        $this->compiler->trigger_template_error ('static class \''.$this->yystack[$this->yyidx + -2]->minor.'\' is undefined or not allowed by security setting');
    }
    }
// line 845 "src/Parser/TemplateParser.y"
    public function yy_r107(){
    $this->_retvalue = $this->yystack[$this->yyidx + 0]->minor;
        }
// line 856 "src/Parser/TemplateParser.y"
    public function yy_r108(){
   $this->_retvalue = $this->compiler->compileVariable('\''.substr($this->yystack[$this->yyidx + 0]->minor,1).'\'');
    }
// line 859 "src/Parser/TemplateParser.y"
    public function yy_r109(){
    if ($this->yystack[$this->yyidx + 0]->minor['var'] === '\'smarty\'') {
        $smarty_var = (new \Smarty\Compile\SpecialVariableCompiler())->compile(array(),$this->compiler,$this->yystack[$this->yyidx + 0]->minor['smarty_internal_index']);
        $this->_retvalue = $smarty_var;
    } else {
        // used for array reset,next,prev,end,current 
        $this->last_variable = $this->yystack[$this->yyidx + 0]->minor['var'];
        $this->last_index = $this->yystack[$this->yyidx + 0]->minor['smarty_internal_index'];
        $this->_retvalue = $this->compiler->compileVariable($this->yystack[$this->yyidx + 0]->minor['var']).$this->yystack[$this->yyidx + 0]->minor['smarty_internal_index'];
    }
    }
// line 872 "src/Parser/TemplateParser.y"
    public function yy_r110(){
    $this->_retvalue = '$_smarty_tpl->getVariable('. $this->yystack[$this->yyidx + -2]->minor .')->'.$this->yystack[$this->yyidx + 0]->minor;
    }
// line 882 "src/Parser/TemplateParser.y"
    public function yy_r112(){
    $this->_retvalue = $this->compiler->compileConfigVariable('\'' . $this->yystack[$this->yyidx + -1]->minor . '\'');
    }
// line 886 "src/Parser/TemplateParser.y"
    public function yy_r113(){
    $this->_retvalue = '(is_array($tmp = ' . $this->compiler->compileConfigVariable('\'' . $this->yystack[$this->yyidx + -2]->minor . '\'') . ') ? $tmp'.$this->yystack[$this->yyidx + 0]->minor.' :null)';
    }
// line 890 "src/Parser/TemplateParser.y"
    public function yy_r114(){
    $this->_retvalue = $this->compiler->compileConfigVariable($this->yystack[$this->yyidx + -1]->minor);
    }
// line 894 "src/Parser/TemplateParser.y"
    public function yy_r115(){
    $this->_retvalue = '(is_array($tmp = ' . $this->compiler->compileConfigVariable($this->yystack[$this->yyidx + -2]->minor) . ') ? $tmp'.$this->yystack[$this->yyidx + 0]->minor.' : null)';
    }
// line 898 "src/Parser/TemplateParser.y"
    public function yy_r116(){
    $this->_retvalue = array('var'=>'\''.substr($this->yystack[$this->yyidx + -1]->minor,1).'\'', 'smarty_internal_index'=>$this->yystack[$this->yyidx + 0]->minor);
    }
// line 901 "src/Parser/TemplateParser.y"
    public function yy_r117(){
    $this->_retvalue = array('var'=>$this->yystack[$this->yyidx + -1]->minor, 'smarty_internal_index'=>$this->yystack[$this->yyidx + 0]->minor);
    }
// line 914 "src/Parser/TemplateParser.y"
    public function yy_r119(){
    return;
    }
// line 920 "src/Parser/TemplateParser.y"
    public function yy_r120(){
    $this->_retvalue = '['.$this->compiler->compileVariable('\''.substr($this->yystack[$this->yyidx + 0]->minor,1).'\'').']';
    }
// line 923 "src/Parser/TemplateParser.y"
    public function yy_r121(){
    $this->_retvalue = '['.$this->compiler->compileVariable($this->yystack[$this->yyidx + 0]->minor).']';
    }
// line 927 "src/Parser/TemplateParser.y"
    public function yy_r122(){
    $this->_retvalue = '['.$this->compiler->compileVariable($this->yystack[$this->yyidx + -2]->minor).'->'.$this->yystack[$this->yyidx + 0]->minor.']';
    }
// line 931 "src/Parser/TemplateParser.y"
    public function yy_r123(){
    $this->_retvalue = '[\''. $this->yystack[$this->yyidx + 0]->minor .'\']';
    }
// line 935 "src/Parser/TemplateParser.y"
    public function yy_r124(){
    $this->_retvalue = '['. $this->yystack[$this->yyidx + 0]->minor .']';
    }
// line 940 "src/Parser/TemplateParser.y"
    public function yy_r125(){
    $this->_retvalue = '['. $this->yystack[$this->yyidx + -1]->minor .']';
    }
// line 945 "src/Parser/TemplateParser.y"
    public function yy_r126(){
    $this->_retvalue = '['.(new \Smarty\Compile\SpecialVariableCompiler())->compile(array(),$this->compiler,'[\'section\'][\''.$this->yystack[$this->yyidx + -1]->minor.'\'][\'index\']').']';
    }
// line 949 "src/Parser/TemplateParser.y"
    public function yy_r127(){
    $this->_retvalue = '['.(new \Smarty\Compile\SpecialVariableCompiler())->compile(array(),$this->compiler,'[\'section\'][\''.$this->yystack[$this->yyidx + -3]->minor.'\'][\''.$this->yystack[$this->yyidx + -1]->minor.'\']').']';
    }
// line 952 "src/Parser/TemplateParser.y"
    public function yy_r128(){
    $this->_retvalue = '['.$this->yystack[$this->yyidx + -1]->minor.']';
    }
// line 958 "src/Parser/TemplateParser.y"
    public function yy_r130(){
    $this->_retvalue = '['.$this->compiler->compileVariable('\''.substr($this->yystack[$this->yyidx + -1]->minor,1).'\'').']';
    }
// line 974 "src/Parser/TemplateParser.y"
    public function yy_r134(){
    $this->_retvalue = '[]';
    }
// line 984 "src/Parser/TemplateParser.y"
    public function yy_r135(){
    $this->_retvalue = '\''.substr($this->yystack[$this->yyidx + 0]->minor,1).'\'';
    }
// line 988 "src/Parser/TemplateParser.y"
    public function yy_r136(){
    $this->_retvalue = '\'\'';
    }
// line 993 "src/Parser/TemplateParser.y"
    public function yy_r137(){
    $this->_retvalue = $this->yystack[$this->yyidx + -1]->minor.'.'.$this->yystack[$this->yyidx + 0]->minor;
    }
// line 1001 "src/Parser/TemplateParser.y"
    public function yy_r139(){
    $var = trim(substr($this->yystack[$this->yyidx + 0]->minor, $this->compiler->getLdelLength(), -$this->compiler->getRdelLength()), ' $');
    $this->_retvalue = $this->compiler->compileVariable('\''.$var.'\'');
    }
// line 1007 "src/Parser/TemplateParser.y"
    public function yy_r140(){
    $this->_retvalue = '('.$this->yystack[$this->yyidx + -1]->minor.')';
    }
// line 1014 "src/Parser/TemplateParser.y"
    public function yy_r141(){
    if ($this->yystack[$this->yyidx + -1]->minor['var'] === '\'smarty\'') {
        $this->_retvalue = (new \Smarty\Compile\SpecialVariableCompiler())->compile(array(),$this->compiler,$this->yystack[$this->yyidx + -1]->minor['smarty_internal_index']).$this->yystack[$this->yyidx + 0]->minor;
    } else {
        $this->_retvalue = $this->compiler->compileVariable($this->yystack[$this->yyidx + -1]->minor['var']).$this->yystack[$this->yyidx + -1]->minor['smarty_internal_index'].$this->yystack[$this->yyidx + 0]->minor;
    }
    }
// line 1023 "src/Parser/TemplateParser.y"
    public function yy_r142(){
    $this->_retvalue  = $this->yystack[$this->yyidx + 0]->minor;
    }
// line 1028 "src/Parser/TemplateParser.y"
    public function yy_r143(){
    $this->_retvalue  = $this->yystack[$this->yyidx + -1]->minor.$this->yystack[$this->yyidx + 0]->minor;
    }
// line 1033 "src/Parser/TemplateParser.y"
    public function yy_r144(){
    if ($this->security && substr($this->yystack[$this->yyidx + -1]->minor,0,1) === '_') {
        $this->compiler->trigger_template_error (self::ERR1);
    }
    $this->_retvalue = '->'.$this->yystack[$this->yyidx + -1]->minor.$this->yystack[$this->yyidx + 0]->minor;
    }
// line 1040 "src/Parser/TemplateParser.y"
    public function yy_r145(){
    if ($this->security) {
        $this->compiler->trigger_template_error (self::ERR2);
    }
    $this->_retvalue = '->{'.$this->compiler->compileVariable($this->yystack[$this->yyidx + -1]->minor).$this->yystack[$this->yyidx + 0]->minor.'}';
    }
// line 1047 "src/Parser/TemplateParser.y"
    public function yy_r146(){
    if ($this->security) {
        $this->compiler->trigger_template_error (self::ERR2);
    }
    $this->_retvalue = '->{'.$this->yystack[$this->yyidx + -2]->minor.$this->yystack[$this->yyidx + 0]->minor.'}';
    }
// line 1054 "src/Parser/TemplateParser.y"
    public function yy_r147(){
    if ($this->security) {
        $this->compiler->trigger_template_error (self::ERR2);
    }
    $this->_retvalue = '->{\''.$this->yystack[$this->yyidx + -4]->minor.'\'.'.$this->yystack[$this->yyidx + -2]->minor.$this->yystack[$this->yyidx + 0]->minor.'}';
    }
// line 1062 "src/Parser/TemplateParser.y"
    public function yy_r148(){
    $this->_retvalue = '->'.$this->yystack[$this->yyidx + 0]->minor;
    }
// line 1070 "src/Parser/TemplateParser.y"
    public function yy_r149(){
    $this->_retvalue = $this->compiler->compileModifierInExpression($this->yystack[$this->yyidx + -3]->minor, $this->yystack[$this->yyidx + -1]->minor);
    }
// line 1078 "src/Parser/TemplateParser.y"
    public function yy_r150(){
    if ($this->security && substr($this->yystack[$this->yyidx + -3]->minor,0,1) === '_') {
        $this->compiler->trigger_template_error (self::ERR1);
    }
    $this->_retvalue = $this->yystack[$this->yyidx + -3]->minor . '('. implode(',',$this->yystack[$this->yyidx + -1]->minor) .')';
    }
// line 1085 "src/Parser/TemplateParser.y"
    public function yy_r151(){
    if ($this->security) {
        $this->compiler->trigger_template_error (self::ERR2);
    }
    $prefixVar = $this->compiler->getNewPrefixVariable();
    $this->compiler->appendPrefixCode("<?php {$prefixVar} = ".$this->compiler->compileVariable('\''.substr($this->yystack[$this->yyidx + -3]->minor,1).'\'').';?>');
    $this->_retvalue = $prefixVar .'('. implode(',',$this->yystack[$this->yyidx + -1]->minor) .')';
    }
// line 1096 "src/Parser/TemplateParser.y"
    public function yy_r152(){
    $this->_retvalue = array_merge($this->yystack[$this->yyidx + -2]->minor,array($this->yystack[$this->yyidx + 0]->minor));
    }
// line 1113 "src/Parser/TemplateParser.y"
    public function yy_r155(){
    $this->_retvalue = array_merge($this->yystack[$this->yyidx + -2]->minor,array(array_merge($this->yystack[$this->yyidx + -1]->minor,$this->yystack[$this->yyidx + 0]->minor)));
    }
// line 1117 "src/Parser/TemplateParser.y"
    public function yy_r156(){
    $this->_retvalue = array(array_merge($this->yystack[$this->yyidx + -1]->minor,$this->yystack[$this->yyidx + 0]->minor));
    }
// line 1125 "src/Parser/TemplateParser.y"
    public function yy_r158(){
    $this->_retvalue =  array($this->yystack[$this->yyidx + 0]->minor);
    }
// line 1133 "src/Parser/TemplateParser.y"
    public function yy_r159(){
    $this->_retvalue = array_merge($this->yystack[$this->yyidx + -1]->minor,$this->yystack[$this->yyidx + 0]->minor);
    }
// line 1146 "src/Parser/TemplateParser.y"
    public function yy_r162(){
    $this->_retvalue = array(trim($this->yystack[$this->yyidx + -1]->minor).$this->yystack[$this->yyidx + 0]->minor);
    }
// line 1155 "src/Parser/TemplateParser.y"
    public function yy_r164(){
    $this->_retvalue = array($this->yystack[$this->yyidx + 0]->minor, '', 'method');
    }
// line 1160 "src/Parser/TemplateParser.y"
    public function yy_r165(){
    $this->_retvalue = array($this->yystack[$this->yyidx + -1]->minor, $this->yystack[$this->yyidx + 0]->minor, 'method');
    }
// line 1165 "src/Parser/TemplateParser.y"
    public function yy_r166(){
    $this->_retvalue = array($this->yystack[$this->yyidx + 0]->minor, '');
    }
// line 1170 "src/Parser/TemplateParser.y"
    public function yy_r167(){
    $this->_retvalue = array($this->yystack[$this->yyidx + -1]->minor, $this->yystack[$this->yyidx + 0]->minor, 'property');
    }
// line 1175 "src/Parser/TemplateParser.y"
    public function yy_r168(){
    $this->_retvalue = array($this->yystack[$this->yyidx + -2]->minor, $this->yystack[$this->yyidx + -1]->minor.$this->yystack[$this->yyidx + 0]->minor, 'property');
    }
// line 1181 "src/Parser/TemplateParser.y"
    public function yy_r169(){
    $this->_retvalue = ' '. trim($this->yystack[$this->yyidx + 0]->minor) . ' ';
    }
// line 1185 "src/Parser/TemplateParser.y"
    public function yy_r170(){
    static $lops = array(
        'eq' => ' == ',
        'ne' => ' != ',
        'neq' => ' != ',
        'gt' => ' > ',
        'ge' => ' >= ',
        'gte' => ' >= ',
        'lt' =>  ' < ',
        'le' =>  ' <= ',
        'lte' => ' <= ',
        'mod' =>  ' % ',
        'and' => ' && ',
        'or' => ' || ',
        'xor' => ' xor ',
         );
    $op = strtolower(preg_replace('/\s*/', '', $this->yystack[$this->yyidx + 0]->minor));
    $this->_retvalue = $lops[$op];
    }
// line 1204 "src/Parser/TemplateParser.y"
    public function yy_r171(){
     static $tlops = array(
         'isdivby' => array('op' => ' % ', 'pre' => '!('),
         'isnotdivby' => array('op' => ' % ', 'pre' => '('),
         'isevenby' => array('op' => ' / ', 'pre' => '!(1 & '),
         'isnotevenby' => array('op' => ' / ', 'pre' => '(1 & '),
         'isoddby' => array('op' => ' / ', 'pre' => '(1 & '),
         'isnotoddby' => array('op' => ' / ', 'pre' => '!(1 & '),
         );
     $op = strtolower(preg_replace('/\s*/', '', $this->yystack[$this->yyidx + 0]->minor));
     $this->_retvalue = $tlops[$op];
     }
// line 1217 "src/Parser/TemplateParser.y"
    public function yy_r172(){
        static $scond = array (
            'iseven' => '!(1 & ',
            'isnoteven' => '(1 & ',
            'isodd' => '(1 & ',
            'isnotodd' => '!(1 & ',
        );
   $op = strtolower(str_replace(' ', '', $this->yystack[$this->yyidx + 0]->minor));
   $this->_retvalue = $scond[$op];
    }
// line 1231 "src/Parser/TemplateParser.y"
    public function yy_r173(){
    $this->_retvalue = 'array('.$this->yystack[$this->yyidx + -1]->minor.')';
    }
// line 1242 "src/Parser/TemplateParser.y"
    public function yy_r176(){
    $this->_retvalue = $this->yystack[$this->yyidx + -2]->minor.','.$this->yystack[$this->yyidx + 0]->minor;
    }
// line 1250 "src/Parser/TemplateParser.y"
    public function yy_r178(){
    $this->_retvalue = $this->yystack[$this->yyidx + -2]->minor.'=>'.$this->yystack[$this->yyidx + 0]->minor;
    }
// line 1254 "src/Parser/TemplateParser.y"
    public function yy_r179(){ 
    $this->_retvalue = '\''.$this->yystack[$this->yyidx + -2]->minor.'\'=>'.$this->yystack[$this->yyidx + 0]->minor;
    }
// line 1270 "src/Parser/TemplateParser.y"
    public function yy_r182(){
    $this->compiler->leaveDoubleQuote();
    $this->_retvalue = $this->yystack[$this->yyidx + -1]->minor->to_smarty_php($this);
    }
// line 1276 "src/Parser/TemplateParser.y"
    public function yy_r183(){
    $this->yystack[$this->yyidx + -1]->minor->append_subtree($this, $this->yystack[$this->yyidx + 0]->minor);
    $this->_retvalue = $this->yystack[$this->yyidx + -1]->minor;
    }
// line 1281 "src/Parser/TemplateParser.y"
    public function yy_r184(){
    $this->_retvalue = new Dq($this, $this->yystack[$this->yyidx + 0]->minor);
    }
// line 1285 "src/Parser/TemplateParser.y"
    public function yy_r185(){
    $this->_retvalue = new Code('(string)'.$this->yystack[$this->yyidx + -1]->minor);
    }
// line 1289 "src/Parser/TemplateParser.y"
    public function yy_r186(){
    $this->_retvalue = new Code('(string)('.$this->yystack[$this->yyidx + -1]->minor.')');
    }
// line 1293 "src/Parser/TemplateParser.y"
    public function yy_r187(){
    $this->_retvalue = new Code('(string)$_smarty_tpl->getValue(\''. substr($this->yystack[$this->yyidx + 0]->minor,1) .'\')');
    }
// line 1305 "src/Parser/TemplateParser.y"
    public function yy_r190(){
    $this->_retvalue = new Tag($this, $this->yystack[$this->yyidx + 0]->minor);
    }
// line 1309 "src/Parser/TemplateParser.y"
    public function yy_r191(){
    $this->_retvalue = new DqContent($this->yystack[$this->yyidx + 0]->minor);
    }

    private $_retvalue;

    public function yy_reduce($yyruleno)
    {
        if ($this->yyTraceFILE && $yyruleno >= 0
              && $yyruleno < count(self::$yyRuleName)) {
            fprintf($this->yyTraceFILE, "%sReduce (%d) [%s].\n",
                $this->yyTracePrompt, $yyruleno,
                self::$yyRuleName[$yyruleno]);
        }

        $this->_retvalue = $yy_lefthand_side = null;
        if (isset(self::$yyReduceMap[$yyruleno])) {
            // call the action
            $this->_retvalue = null;
            $this->{'yy_r' . self::$yyReduceMap[$yyruleno]}();
            $yy_lefthand_side = $this->_retvalue;
        }
        $yygoto = self::$yyRuleInfo[$yyruleno][0];
        $yysize = self::$yyRuleInfo[$yyruleno][1];
        $this->yyidx -= $yysize;
        for ($i = $yysize; $i; $i--) {
            // pop all of the right-hand side parameters
            array_pop($this->yystack);
        }
        $yyact = $this->yy_find_reduce_action($this->yystack[$this->yyidx]->stateno, $yygoto);
        if ($yyact < self::YYNSTATE) {
            if (!$this->yyTraceFILE && $yysize) {
                $this->yyidx++;
                $x = (object) ['stateno' => null, 'major' => null, 'minor' => null];
                $x->stateno = $yyact;
                $x->major = $yygoto;
                $x->minor = $yy_lefthand_side;
                $this->yystack[$this->yyidx] = $x;
            } else {
                $this->yy_shift($yyact, $yygoto, $yy_lefthand_side);
            }
        } elseif ($yyact === self::YYNSTATE + self::YYNRULE + 1) {
            $this->yy_accept();
        }
    }

    public function yy_parse_failed()
    {
        if ($this->yyTraceFILE) {
            fprintf($this->yyTraceFILE, "%sFail!\n", $this->yyTracePrompt);
        } while ($this->yyidx >= 0) {
            $this->yy_pop_parser_stack();
        }
    }

    public function yy_syntax_error($yymajor, $TOKEN)
    {
// line 225 "src/Parser/TemplateParser.y"

    $this->internalError = true;
    $this->yymajor = $yymajor;
    $this->compiler->trigger_template_error();
    }

    public function yy_accept()
    {
        if ($this->yyTraceFILE) {
            fprintf($this->yyTraceFILE, "%sAccept!\n", $this->yyTracePrompt);
        } while ($this->yyidx >= 0) {
            $this->yy_pop_parser_stack();
        }
// line 218 "src/Parser/TemplateParser.y"

    $this->successful = !$this->internalError;
    $this->internalError = false;
    $this->retvalue = $this->_retvalue;
    }

    public function doParse($yymajor, $yytokenvalue)
    {
        $yyerrorhit = 0;   /* True if yymajor has invoked an error */

        if ($this->yyidx === null || $this->yyidx < 0) {
            $this->yyidx = 0;
            $this->yyerrcnt = -1;
            $x = (object) ['stateno' => null, 'major' => null, 'minor' => null];
            $x->stateno = 0;
            $x->major = 0;
            $this->yystack = array();
            $this->yystack[] = $x;
        }
        $yyendofinput = ($yymajor==0);

        if ($this->yyTraceFILE) {
            fprintf($this->yyTraceFILE, "%sInput %s\n",
                $this->yyTracePrompt, $this->yyTokenName[$yymajor]);
        }

        do {
            $yyact = $this->yy_find_shift_action($yymajor);
            if ($yymajor < self::YYERRORSYMBOL &&
                  !$this->yy_is_expected_token($yymajor)) {
                // force a syntax error
                $yyact = self::YY_ERROR_ACTION;
            }
            if ($yyact < self::YYNSTATE) {
                $this->yy_shift($yyact, $yymajor, $yytokenvalue);
                $this->yyerrcnt--;
                if ($yyendofinput && $this->yyidx >= 0) {
                    $yymajor = 0;
                } else {
                    $yymajor = self::YYNOCODE;
                }
            } elseif ($yyact < self::YYNSTATE + self::YYNRULE) {
                $this->yy_reduce($yyact - self::YYNSTATE);
            } elseif ($yyact === self::YY_ERROR_ACTION) {
                if ($this->yyTraceFILE) {
                    fprintf($this->yyTraceFILE, "%sSyntax Error!\n",
                        $this->yyTracePrompt);
                }
                if (self::YYERRORSYMBOL) {
                    if ($this->yyerrcnt < 0) {
                        $this->yy_syntax_error($yymajor, $yytokenvalue);
                    }
                    $yymx = $this->yystack[$this->yyidx]->major;
                    if ($yymx === self::YYERRORSYMBOL || $yyerrorhit) {
                        if ($this->yyTraceFILE) {
                            fprintf($this->yyTraceFILE, "%sDiscard input token %s\n",
                                $this->yyTracePrompt, $this->yyTokenName[$yymajor]);
                        }
                        $this->yy_destructor($yymajor, $yytokenvalue);
                        $yymajor = self::YYNOCODE;
                    } else {
                        while ($this->yyidx >= 0 &&
                                 $yymx !== self::YYERRORSYMBOL &&
        ($yyact = $this->yy_find_shift_action(self::YYERRORSYMBOL)) >= self::YYNSTATE
                              ){
                            $this->yy_pop_parser_stack();
                        }
                        if ($this->yyidx < 0 || $yymajor==0) {
                            $this->yy_destructor($yymajor, $yytokenvalue);
                            $this->yy_parse_failed();
                            $yymajor = self::YYNOCODE;
                        } elseif ($yymx !== self::YYERRORSYMBOL) {
                            $u2 = 0;
                            $this->yy_shift($yyact, self::YYERRORSYMBOL, $u2);
                        }
                    }
                    $this->yyerrcnt = 3;
                    $yyerrorhit = 1;
                } else {
                    if ($this->yyerrcnt <= 0) {
                        $this->yy_syntax_error($yymajor, $yytokenvalue);
                    }
                    $this->yyerrcnt = 3;
                    $this->yy_destructor($yymajor, $yytokenvalue);
                    if ($yyendofinput) {
                        $this->yy_parse_failed();
                    }
                    $yymajor = self::YYNOCODE;
                }
            } else {
                $this->yy_accept();
                $yymajor = self::YYNOCODE;
            }
        } while ($yymajor !== self::YYNOCODE && $this->yyidx >= 0);
    }
}

