/**
	Author: Riste Tutureski
	Email: tutureski.riste@gmail.com
	Version: 2.1
**/

var updateEditors = true;
var textAreaIds = [];
var _debugger = false;
var activeEditorId = null;

function debug(value, _debuggerLocal){
	if (_debugger && _debuggerLocal != false){
		console.log(value);
	}
}

// Function that is called during initialization of the TinyMCE object. 
// It's used for populating "textAreaIds" array with all IDs of the textareas that are added to the Form.
function init(instance){
    debug('init ->');
	
	var id = instance.id;
	debug('init -> id=' + id);
	
	textAreaIds.push(id);
	debug('init -> textAreaIds=' + textAreaIds);

}

// This method is used for refresh all textarea components
function refresh(){
	debug('refresh ->', false);
	
	addTinyMCEBehavior();
	debug('refresh -> updateEditors=' + updateEditors, false);
	debug('refresh -> textAreaIds=' + textAreaIds, false);
	if (updateEditors && textAreaIds && textAreaIds.length > 0){
		for (var i = 0; i < textAreaIds.length; i++) { 
		    var id = textAreaIds[i];
		    var textarea = document.getElementById(id);
		    if (textarea != null){
		    	updateEditorContent(id, textarea.innerHTML);
		    }else{
		    	if (id != null){
		    		removeTinyMCEBehavior(id);
		    	}
		    }
		}
	}
}

// This method is used for updating TinyMCE editors that corresponding with specific textarea.
// It's used when textarea is pre-filled with data from the server.
function updateEditorContent(id, value){  
	debug('updateEditorContent -> id=' + id + ', value=' + value, false);
	
	tinymce.get(id).setContent(value);
}

// This method is used for adding TinyMCE behavior or textarea that are added on dynamic way
function addTinyMCEBehavior(){
	debug('addTinyMCEBehavior ->', false);
	
	if (updateEditors){
		var textareas = document.querySelectorAll('div.rta_container span.f-message:not([style="display: none;"])');
		debug('addTinyMCEBehavior -> textareas='+textareas);
	    if (textareas && textareas.length > 0){
	        for (var i = 0; i < textareas.length; i++){
			    var id = textareas[i].id;
				debug('addTinyMCEBehavior -> id='+id);
				if (id == null || id == 'undefined' || id == ""){
					id = new Date().getTime();
					textareas[i].id = id;
				}
	            tinymce.execCommand("mceAddEditor", false, id);
	        }
	    }	
	}
}

// This method 
function removeTinyMCEBehavior(id){
	debug('removeTinyMCEBehavior -> id=' + id);
	
	var index = textAreaIds.indexOf(id);

	if(index!=-1){
		textAreaIds.splice(index, 1);
	}
	
	try {
		tinymce.execCommand("mceRemoveEditor", false, id);
	}
	catch(error) {
	    // Normal behavior. The textarea does not exist anymore in the tinymce object
	}
}

tinymce.init({
				selector:'div.rta_container span.f-message',	
				init_instance_callback : 'init',
				setup: function(editor) {
					editor.on('change', function(e) {	
						debug('editor change -> ');
					});
					
					editor.on('focus', function(e) {
						debug('editor focus -> ');
						updateEditors = false;
						activeEditorId = tinymce.activeEditor.id;
					});
					
					editor.on('blur', function(e) {
						updateEditors = true;
						debug('editor blur -> ');
						if (activeEditorId != null){
							var changeEvent = document.createEvent("Event")
							changeEvent.initEvent("change", true, true);

							var textareaWrapper = document.getElementById(activeEditorId).parentNode.parentNode.nextElementSibling || nextElementSibling(document.getElementById(activeEditorId).parentNode.parentNode);
							var textarea = textareaWrapper.querySelector('div[class*=rta_html_holder] textarea');

							if (textarea != null){
								textarea.value = tinymce.activeEditor.getContent();
								tinymce.triggerSave();

								textarea.dispatchEvent(changeEvent);							
							}
						}
						activeEditorId = null;
					});
}});

function nextElementSibling(element) {
	debug('nextElementSibling ->');
	
    do { 
		element = element.nextSibling 
	} while ( element && element.nodeType !== 1 );
	
    return element;
}

setInterval('refresh()', 500);