package com.armedia.acm.plugins.admin.model;

/*-
 * #%L
 * ACM Default Plugin: admin
 * %%
 * Copyright (C) 2014 - 2018 ArkCase LLC
 * %%
 * This file is part of the ArkCase software. 
 * 
 * If the software was purchased under a paid ArkCase license, the terms of 
 * the paid license agreement will prevail.  Otherwise, the software is 
 * provided under the following open source license terms:
 * 
 * ArkCase is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *  
 * ArkCase is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License
 * along with ArkCase. If not, see <http://www.gnu.org/licenses/>.
 * #L%
 */

import com.fasterxml.jackson.annotation.JsonIdentityInfo;
import com.voodoodyne.jackson.jsog.JSOGGenerator;

import java.util.Date;

/**
 * @author Lazo Lazarev a.k.a. Lazarius Borg @ zerogravity Jan 27, 2017
 *
 */

@JsonIdentityInfo(generator = JSOGGenerator.class)
public class TemplateRequestResponse
{

    private String templateId;

    private String templateVersion;

    private boolean templateVersionActive;

    private String label;

    private String documentType;

    private String templateFilename;

    private String objectType;

    private String dateFormatString;

    private String numberFormatString;

    private boolean activated;

    private String modifier;

    private Date modified;

    private String downloadFileName;

    private String templateModelProvider;
    
    private String templateType;
    
    private boolean enabled;

    private String parentType;

    private String emailSubject;

    /**
     * @return the templateId
     */
    public String getTemplateId()
    {
        return templateId;
    }

    /**
     * @param templateId
     *            the templateId to set
     */
    public void setTemplateId(String templateId)
    {
        this.templateId = templateId;
    }

    /**
     * @return the templateVersion
     */
    public String getTemplateVersion()
    {
        return templateVersion;
    }

    /**
     * @param templateVersion
     *            the templateVersion to set
     */
    public void setTemplateVersion(String templateVersion)
    {
        this.templateVersion = templateVersion;
    }

    /**
     * @return the templateVersionActive
     */
    public boolean isTemplateVersionActive()
    {
        return templateVersionActive;
    }

    /**
     * @param templateVersionActive
     *            the templateVersionActive to set
     */
    public void setTemplateVersionActive(boolean templateVersionActive)
    {
        this.templateVersionActive = templateVersionActive;
    }

    /**
     * @return the label
     */
    public String getLabel()
    {
        return label;
    }

    /**
     * @param label
     *            the label to set
     */
    public void setLabel(String label)
    {
        this.label = label;
    }

    /**
     * @return the documentType
     */
    public String getDocumentType()
    {
        return documentType;
    }

    /**
     * @param documentType
     *            the documentType to set
     */
    public void setDocumentType(String documentType)
    {
        this.documentType = documentType;
    }

    /**
     * @return the templateFilename
     */
    public String getTemplateFilename()
    {
        return templateFilename;
    }

    /**
     * @param templateFilename
     *            the templateFilename to set
     */
    public void setTemplateFilename(String templateFilename)
    {
        this.templateFilename = templateFilename;
    }

    /**
     * @return the objectType
     */
    public String getObjectType()
    {
        return objectType;
    }

    /**
     * @param objectType
     *            the objectType to set
     */
    public void setObjectType(String objectType)
    {
        this.objectType = objectType;
    }

    /**
     * @return the dateFormatString
     */
    public String getDateFormatString()
    {
        return dateFormatString;
    }

    /**
     * @param dateFormatString
     *            the dateFormatString to set
     */
    public void setDateFormatString(String dateFormatString)
    {
        this.dateFormatString = dateFormatString;
    }

    /**
     * @return the numberFormatString
     */
    public String getNumberFormatString()
    {
        return numberFormatString;
    }

    /**
     * @param numberFormatString
     *            the numberFormatString to set
     */
    public void setNumberFormatString(String numberFormatString)
    {
        this.numberFormatString = numberFormatString;
    }

    /**
     * @return the activated
     */
    public boolean isActivated()
    {
        return activated;
    }

    /**
     * @param activated
     *            the activated to set
     */
    public void setActivated(boolean activated)
    {
        this.activated = activated;
    }

    /**
     * @return the modifier
     */
    public String getModifier()
    {
        return modifier;
    }

    /**
     * @param modifier
     *            the modifier to set
     */
    public void setModifier(String modifier)
    {
        this.modifier = modifier;
    }

    /**
     * @return the modified
     */
    public Date getModified()
    {
        return modified;
    }

    /**
     * @param modified
     *            the modified to set
     */
    public void setModified(Date modified)
    {
        this.modified = modified;
    }

    /**
     * @return the downloadFileName
     */
    public String getDownloadFileName()
    {
        return downloadFileName;
    }

    /**
     * @param downloadFileName
     *            the downloadFileName to set
     */
    public void setDownloadFileName(String downloadFileName)
    {
        this.downloadFileName = downloadFileName;
    }

    /**
     * @return the templateModelProvider
     */
    public String getTemplateModelProvider()
    {
        return templateModelProvider;
    }

    /**
     * @param templateModelProvider
     *            the templateModelProvider to set
     */
    public void setTemplateModelProvider(String templateModelProvider)
    {
        this.templateModelProvider = templateModelProvider;
    }
    /**
     * @return the templateType
     */
    public String getTemplateType() 
    {
        return templateType;
    }
    /**
     * @param templateType
     *            the templateType to set
     */
    public void setTemplateType(String templateType) 
    {
        this.templateType = templateType;
    }

    /**
     * @return the enabled
     */
    public boolean isEnabled() 
    {
        return enabled;
    }

    /**
     * @param enabled
     *          the enabled to set
     */
    public void setEnabled(boolean enabled) 
    {
        this.enabled = enabled;
    }

    /**
     * @return the parentType
     */
    public String getParentType()
    {
        return parentType;
    }

    /**
     * @param parentType
     *            the parentType to set
     */
    public void setParentType(String parentType)
    {
        this.parentType = parentType;
    }

    public String getEmailSubject()
    {
        return emailSubject;
    }

    public void setEmailSubject(String emailSubject)
    {
        this.emailSubject = emailSubject;
    }
}
