package com.armedia.acm.services.email.model;

/*-
 * #%L
 * ACM Service: Email
 * %%
 * Copyright (C) 2014 - 2018 ArkCase LLC
 * %%
 * This file is part of the ArkCase software. 
 * 
 * If the software was purchased under a paid ArkCase license, the terms of 
 * the paid license agreement will prevail.  Otherwise, the software is 
 * provided under the following open source license terms:
 * 
 * ArkCase is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *  
 * ArkCase is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License
 * along with ArkCase. If not, see <http://www.gnu.org/licenses/>.
 * #L%
 */

import com.fasterxml.jackson.annotation.JsonIdentityInfo;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.voodoodyne.jackson.jsog.JSOGGenerator;

import java.util.ArrayList;
import java.util.List;

@JsonIdentityInfo(generator = JSOGGenerator.class)
public class EmailWithEmbeddedLinksDTO
{

    private String subject;

    private String title;

    private String header;

    private String footer;

    private List<String> emailAddresses;

    private List<String> ccEmailAddresses;

    private List<String> bccEmailAddresses;

    private List<Long> fileIds;

    @JsonIgnore
    private List<String> fileNames;

    @JsonIgnore
    private List<String> tokens = new ArrayList<>();

    private String baseUrl;

    private String body;

    private String fileVersion;

    private String objectType;

    private String objectId;

    private String objectNumber;

    private String template;

    private String modelReferenceName;

    public String getSubject()
    {
        return subject;
    }

    public void setSubject(String subject)
    {
        this.subject = subject;
    }

    public String getTitle()
    {
        return title;
    }

    public void setTitle(String title)
    {
        this.title = title;
    }

    public String getHeader()
    {
        return header;
    }

    public void setHeader(String header)
    {
        this.header = header;
    }

    public String getFooter()
    {
        return footer;
    }

    public void setFooter(String footer)
    {
        this.footer = footer;
    }

    public List<String> getEmailAddresses()
    {
        return emailAddresses;
    }

    public void setEmailAddresses(List<String> emailAddresses)
    {
        this.emailAddresses = emailAddresses;
    }

    public List<String> getCcEmailAddresses()
    {
        return ccEmailAddresses;
    }

    public void setCcEmailAddresses(List<String> ccEmailAddresses)
    {
        this.ccEmailAddresses = ccEmailAddresses;
    }

    public List<String> getBccEmailAddresses()
    {
        return bccEmailAddresses;
    }

    public void setBccEmailAddresses(List<String> bccEmailAddresses)
    {
        this.bccEmailAddresses = bccEmailAddresses;
    }

    public List<Long> getFileIds()
    {
        return fileIds;
    }

    public void setFileIds(List<Long> fileIds)
    {
        this.fileIds = fileIds;
    }

    /**
     * @return the fileNames
     */
    public List<String> getFileNames()
    {
        return fileNames;
    }

    /**
     * @param fileNames
     *            the fileNames to set
     */
    public void setFileNames(List<String> fileNames)
    {
        this.fileNames = fileNames;
    }

    public String getBaseUrl()
    {
        return baseUrl;
    }

    public void setBaseUrl(String baseUrl)
    {
        this.baseUrl = baseUrl;
    }

    public String getBody()
    {
        return body;
    }

    public void setBody(String body)
    {
        this.body = body;
    }

    public List<String> getTokens()
    {
        return tokens;
    }

    public void setTokens(List<String> tokens)
    {
        this.tokens = tokens;
    }

    public String getFileVersion()
    {
        return fileVersion;
    }

    public void setFileVersion(String fileVersion)
    {
        this.fileVersion = fileVersion;
    }

    public String getObjectType()
    {
        return objectType;
    }

    public void setObjectType(String objectType)
    {
        this.objectType = objectType;
    }

    public String getObjectId()
    {
        return objectId;
    }

    public void setObjectId(String objectId)
    {
        this.objectId = objectId;
    }

    public String getObjectNumber()
    {
        return objectNumber;
    }

    public void setObjectNumber(String objectNumber)
    {
        this.objectNumber = objectNumber;
    }

    public String getTemplate()
    {
        return template;
    }

    public void setTemplate(String template)
    {
        this.template = template;
    }

    public String getModelReferenceName()
    {
        return modelReferenceName;
    }

    public void setModelReferenceName(String modelReferenceName)
    {
        this.modelReferenceName = modelReferenceName;
    }
}
