/**
	Author: Riste Tutureski
	Email: tutureski.riste@gmail.com
	Version: 1.0
**/

var updateEditors = true;
var textAreaIds = [];

// Function that is called during initialization of the TinyMCE object. 
// It's used for populating "textAreaIds" array with all IDs of the textareas that are added to the Form.
function init(instance){
	var id = instance.id;
	
	// Add only textareas that the user has added to the Form with drag-and-drop
	if (id.indexOf('_') == -1){
		textAreaIds.push(id);
	}
}

// This method is used for refresh all textarea components
function refresh(){
	addTinyMCEBehavior();
	if (updateEditors && textAreaIds && textAreaIds.length > 0){
		for (var i = 0; i < textAreaIds.length; i++) { 
		    var id = textAreaIds[i];
		    var textarea = document.getElementById(id);
		    if (textarea != null){
		    	updateEditorContent(id, textarea.value);
		    }else{
		    	if (id != null){
		    		removeTinyMCEBehavior(id);
		    	}
		    }
		}
	}
}

// This method is used for updating TinyMCE editors that corresponding with specific textarea.
// It's used when textarea is pre-filled with data from the server.
function updateEditorContent(id, value){    
	tinymce.get(id).setContent(value);
}

// This method is used for adding TinyMCE behavior or textarea that are added on dynamic way
function addTinyMCEBehavior(){
	if (updateEditors){
		var textareas = document.querySelectorAll('textarea:not([style="display: none;"])');
	
	    if (textareas && textareas.length > 0){
	        for (var i = 0; i < textareas.length; i++){
	            tinymce.execCommand("mceAddEditor",false, textareas[i].id);
	        }
	    }	
	}
}

// This method 
function removeTinyMCEBehavior(id){
	var index = textAreaIds.indexOf(id);

	if(index!=-1){
		textAreaIds.splice(index, 1);
	}
	
	try {
		tinymce.execCommand("mceRemoveEditor", false, id);
	}
	catch(error) {
	    // Normal behavior. The textarea does not exist anymore in the tinymce object
	}
}

tinymce.init({
				selector:'textarea',	
				init_instance_callback : "init",
				setup: function(editor) {
					editor.on('change', function(e) {	
						var keyboardEvent = document.createEvent("KeyboardEvent");
						var initMethod = typeof keyboardEvent.initKeyboardEvent !== 'undefined' ? "initKeyboardEvent" : "initKeyEvent";

						keyboardEvent[initMethod](
										   "keyup",
											true,
											true,
											window,
											false,
											false,
											false,
											false,
											40,
											0
						);
						var id = tinymce.activeEditor.id;
						var textarea = document.getElementById(id);
						
						tinymce.triggerSave();
						if (textarea != null){
							textarea.dispatchEvent(keyboardEvent);							
						}
					});
					
					editor.on('focus', function(e) {
						updateEditors = false;
					});
					
					editor.on('blur', function(e) {
						updateEditors = true;
					});
}});

setInterval('refresh()', 1000);