<?php

/**
 * @package CRM
 * @copyright CiviCRM LLC https://civicrm.org/licensing
 *
 * Generated from xml/schema/CRM/Contact/Contact.xml
 * DO NOT EDIT.  Generated by CRM_Core_CodeGen
 * (GenCodeChecksum:c2c4d9156d6646a4751d96b14b0b2ab8)
 */

/**
 * Database access object for the Contact entity.
 */
class CRM_Contact_DAO_Contact extends CRM_Core_DAO {
  const EXT = 'civicrm';
  const TABLE_ADDED = '1.1';

  /**
   * Static instance to hold the table name.
   *
   * @var string
   */
  public static $_tableName = 'civicrm_contact';

  /**
   * Icon associated with this entity.
   *
   * @var string
   */
  public static $_icon = 'fa-address-book-o';

  /**
   * Field to show when displaying a record.
   *
   * @var string
   */
  public static $_labelField = 'display_name';

  /**
   * Should CiviCRM log any modifications to this table in the civicrm_log table.
   *
   * @var bool
   */
  public static $_log = TRUE;

  /**
   * Paths for accessing this entity in the UI.
   *
   * @var string[]
   */
  protected static $_paths = [
    'add' => 'civicrm/contact/add?reset=1&ct=[contact_type]',
    'view' => 'civicrm/contact/view?reset=1&cid=[id]',
    'update' => 'civicrm/contact/add?reset=1&action=update&cid=[id]',
    'delete' => 'civicrm/contact/view/delete?reset=1&delete=1&cid=[id]',
  ];

  /**
   * Unique Contact ID
   *
   * @var int|string|null
   *   (SQL type: int unsigned)
   *   Note that values will be retrieved from the database as a string.
   */
  public $id;

  /**
   * Type of Contact.
   *
   * @var string|null
   *   (SQL type: varchar(64))
   *   Note that values will be retrieved from the database as a string.
   */
  public $contact_type;

  /**
   * Unique trusted external ID (generally from a legacy app/datasource). Particularly useful for deduping operations.
   *
   * @var string|null
   *   (SQL type: varchar(64))
   *   Note that values will be retrieved from the database as a string.
   */
  public $external_identifier;

  /**
   * Formatted name representing preferred format for display/print/other output.
   *
   * @var string|null
   *   (SQL type: varchar(128))
   *   Note that values will be retrieved from the database as a string.
   */
  public $display_name;

  /**
   * Organization Name.
   *
   * @var string|null
   *   (SQL type: varchar(128))
   *   Note that values will be retrieved from the database as a string.
   */
  public $organization_name;

  /**
   * May be used to over-ride contact view and edit templates.
   *
   * @var string|null
   *   (SQL type: varchar(255))
   *   Note that values will be retrieved from the database as a string.
   */
  public $contact_sub_type;

  /**
   * First Name.
   *
   * @var string|null
   *   (SQL type: varchar(64))
   *   Note that values will be retrieved from the database as a string.
   */
  public $first_name;

  /**
   * Middle Name.
   *
   * @var string|null
   *   (SQL type: varchar(64))
   *   Note that values will be retrieved from the database as a string.
   */
  public $middle_name;

  /**
   * Last Name.
   *
   * @var string|null
   *   (SQL type: varchar(64))
   *   Note that values will be retrieved from the database as a string.
   */
  public $last_name;

  /**
   * @var bool|string
   *   (SQL type: tinyint)
   *   Note that values will be retrieved from the database as a string.
   */
  public $do_not_email;

  /**
   * @var bool|string
   *   (SQL type: tinyint)
   *   Note that values will be retrieved from the database as a string.
   */
  public $do_not_phone;

  /**
   * @var bool|string
   *   (SQL type: tinyint)
   *   Note that values will be retrieved from the database as a string.
   */
  public $do_not_mail;

  /**
   * @var bool|string
   *   (SQL type: tinyint)
   *   Note that values will be retrieved from the database as a string.
   */
  public $do_not_sms;

  /**
   * @var bool|string
   *   (SQL type: tinyint)
   *   Note that values will be retrieved from the database as a string.
   */
  public $do_not_trade;

  /**
   * Has the contact opted out from receiving all bulk email from the organization or site domain?
   *
   * @var bool|string
   *   (SQL type: tinyint)
   *   Note that values will be retrieved from the database as a string.
   */
  public $is_opt_out;

  /**
   * May be used for SSN, EIN/TIN, Household ID (census) or other applicable unique legal/government ID.
   *
   * @var string|null
   *   (SQL type: varchar(32))
   *   Note that values will be retrieved from the database as a string.
   */
  public $legal_identifier;

  /**
   * Name used for sorting different contact types
   *
   * @var string|null
   *   (SQL type: varchar(128))
   *   Note that values will be retrieved from the database as a string.
   */
  public $sort_name;

  /**
   * Nickname.
   *
   * @var string|null
   *   (SQL type: varchar(128))
   *   Note that values will be retrieved from the database as a string.
   */
  public $nick_name;

  /**
   * Legal Name.
   *
   * @var string|null
   *   (SQL type: varchar(128))
   *   Note that values will be retrieved from the database as a string.
   */
  public $legal_name;

  /**
   * optional URL for preferred image (photo, logo, etc.) to display for this contact.
   *
   * @var string|null
   *   (SQL type: text)
   *   Note that values will be retrieved from the database as a string.
   */
  public $image_URL;

  /**
   * What is the preferred mode of communication.
   *
   * @var string|null
   *   (SQL type: varchar(255))
   *   Note that values will be retrieved from the database as a string.
   */
  public $preferred_communication_method;

  /**
   * Which language is preferred for communication. FK to languages in civicrm_option_value.
   *
   * @var string|null
   *   (SQL type: varchar(5))
   *   Note that values will be retrieved from the database as a string.
   */
  public $preferred_language;

  /**
   * Key for validating requests related to this contact.
   *
   * @var string|null
   *   (SQL type: varchar(32))
   *   Note that values will be retrieved from the database as a string.
   */
  public $hash;

  /**
   * API Key for validating requests related to this contact.
   *
   * @var string|null
   *   (SQL type: varchar(32))
   *   Note that values will be retrieved from the database as a string.
   */
  public $api_key;

  /**
   * where contact come from, e.g. import, donate module insert...
   *
   * @var string|null
   *   (SQL type: varchar(255))
   *   Note that values will be retrieved from the database as a string.
   */
  public $source;

  /**
   * Prefix or Title for name (Ms, Mr...). FK to prefix ID
   *
   * @var int|string|null
   *   (SQL type: int unsigned)
   *   Note that values will be retrieved from the database as a string.
   */
  public $prefix_id;

  /**
   * Suffix for name (Jr, Sr...). FK to suffix ID
   *
   * @var int|string|null
   *   (SQL type: int unsigned)
   *   Note that values will be retrieved from the database as a string.
   */
  public $suffix_id;

  /**
   * Formal (academic or similar) title in front of name. (Prof., Dr. etc.)
   *
   * @var string|null
   *   (SQL type: varchar(64))
   *   Note that values will be retrieved from the database as a string.
   */
  public $formal_title;

  /**
   * Communication style (e.g. formal vs. familiar) to use with this contact. FK to communication styles in civicrm_option_value.
   *
   * @var int|string|null
   *   (SQL type: int unsigned)
   *   Note that values will be retrieved from the database as a string.
   */
  public $communication_style_id;

  /**
   * FK to civicrm_option_value.id, that has to be valid registered Email Greeting.
   *
   * @var int|string|null
   *   (SQL type: int unsigned)
   *   Note that values will be retrieved from the database as a string.
   */
  public $email_greeting_id;

  /**
   * Custom Email Greeting.
   *
   * @var string|null
   *   (SQL type: varchar(128))
   *   Note that values will be retrieved from the database as a string.
   */
  public $email_greeting_custom;

  /**
   * Cache Email Greeting.
   *
   * @var string|null
   *   (SQL type: varchar(255))
   *   Note that values will be retrieved from the database as a string.
   */
  public $email_greeting_display;

  /**
   * FK to civicrm_option_value.id, that has to be valid registered Postal Greeting.
   *
   * @var int|string|null
   *   (SQL type: int unsigned)
   *   Note that values will be retrieved from the database as a string.
   */
  public $postal_greeting_id;

  /**
   * Custom Postal greeting.
   *
   * @var string|null
   *   (SQL type: varchar(128))
   *   Note that values will be retrieved from the database as a string.
   */
  public $postal_greeting_custom;

  /**
   * Cache Postal greeting.
   *
   * @var string|null
   *   (SQL type: varchar(255))
   *   Note that values will be retrieved from the database as a string.
   */
  public $postal_greeting_display;

  /**
   * FK to civicrm_option_value.id, that has to be valid registered Addressee.
   *
   * @var int|string|null
   *   (SQL type: int unsigned)
   *   Note that values will be retrieved from the database as a string.
   */
  public $addressee_id;

  /**
   * Custom Addressee.
   *
   * @var string|null
   *   (SQL type: varchar(128))
   *   Note that values will be retrieved from the database as a string.
   */
  public $addressee_custom;

  /**
   * Cache Addressee.
   *
   * @var string|null
   *   (SQL type: varchar(255))
   *   Note that values will be retrieved from the database as a string.
   */
  public $addressee_display;

  /**
   * Job Title
   *
   * @var string|null
   *   (SQL type: varchar(255))
   *   Note that values will be retrieved from the database as a string.
   */
  public $job_title;

  /**
   * FK to gender ID
   *
   * @var int|string|null
   *   (SQL type: int unsigned)
   *   Note that values will be retrieved from the database as a string.
   */
  public $gender_id;

  /**
   * Date of birth
   *
   * @var string|null
   *   (SQL type: date)
   *   Note that values will be retrieved from the database as a string.
   */
  public $birth_date;

  /**
   * @var bool|string
   *   (SQL type: tinyint)
   *   Note that values will be retrieved from the database as a string.
   */
  public $is_deceased;

  /**
   * Date of deceased
   *
   * @var string|null
   *   (SQL type: date)
   *   Note that values will be retrieved from the database as a string.
   */
  public $deceased_date;

  /**
   * Household Name.
   *
   * @var string|null
   *   (SQL type: varchar(128))
   *   Note that values will be retrieved from the database as a string.
   */
  public $household_name;

  /**
   * Optional FK to Primary Contact for this household.
   *
   * @var int|string|null
   *   (SQL type: int unsigned)
   *   Note that values will be retrieved from the database as a string.
   */
  public $primary_contact_id;

  /**
   * Standard Industry Classification Code.
   *
   * @var string|null
   *   (SQL type: varchar(8))
   *   Note that values will be retrieved from the database as a string.
   */
  public $sic_code;

  /**
   * the OpenID (or OpenID-style http://username.domain/) unique identifier for this contact mainly used for logging in to CiviCRM
   *
   * @var string|null
   *   (SQL type: varchar(255))
   *   Note that values will be retrieved from the database as a string.
   * @deprecated
   */
  public $user_unique_id;

  /**
   * OPTIONAL FK to civicrm_contact record.
   *
   * @var int|string|null
   *   (SQL type: int unsigned)
   *   Note that values will be retrieved from the database as a string.
   */
  public $employer_id;

  /**
   * @var bool|string
   *   (SQL type: tinyint)
   *   Note that values will be retrieved from the database as a string.
   */
  public $is_deleted;

  /**
   * When was the contact was created.
   *
   * @var string
   *   (SQL type: timestamp)
   *   Note that values will be retrieved from the database as a string.
   */
  public $created_date;

  /**
   * When was the contact (or closely related entity) was created or modified or deleted.
   *
   * @var string
   *   (SQL type: timestamp)
   *   Note that values will be retrieved from the database as a string.
   */
  public $modified_date;

  /**
   * Deprecated setting for text vs html mailings
   *
   * @var string|null
   *   (SQL type: varchar(8))
   *   Note that values will be retrieved from the database as a string.
   * @deprecated
   */
  public $preferred_mail_format;

  /**
   * Class constructor.
   */
  public function __construct() {
    $this->__table = 'civicrm_contact';
    parent::__construct();
  }

  /**
   * Returns localized title of this entity.
   *
   * @param bool $plural
   *   Whether to return the plural version of the title.
   */
  public static function getEntityTitle($plural = FALSE) {
    return $plural ? ts('Contacts') : ts('Contact');
  }

  /**
   * Returns user-friendly description of this entity.
   *
   * @return string
   */
  public static function getEntityDescription() {
    return ts('Individuals, organizations, households, etc.');
  }

  /**
   * Returns all the column names of this table
   *
   * @return array
   */
  public static function &fields() {
    if (!isset(Civi::$statics[__CLASS__]['fields'])) {
      Civi::$statics[__CLASS__]['fields'] = [
        'id' => [
          'name' => 'id',
          'type' => CRM_Utils_Type::T_INT,
          'title' => ts('Contact ID'),
          'description' => ts('Unique Contact ID'),
          'required' => TRUE,
          'usage' => [
            'import' => TRUE,
            'export' => TRUE,
            'duplicate_matching' => TRUE,
            'token' => FALSE,
          ],
          'import' => TRUE,
          'where' => 'civicrm_contact.id',
          'headerPattern' => '/internal|contact?|id$/i',
          'export' => TRUE,
          'table_name' => 'civicrm_contact',
          'entity' => 'Contact',
          'bao' => 'CRM_Contact_BAO_Contact',
          'localizable' => 0,
          'html' => [
            'type' => 'Number',
          ],
          'readonly' => TRUE,
          'add' => '1.1',
        ],
        'contact_type' => [
          'name' => 'contact_type',
          'type' => CRM_Utils_Type::T_STRING,
          'title' => ts('Contact Type'),
          'description' => ts('Type of Contact.'),
          'maxlength' => 64,
          'size' => CRM_Utils_Type::BIG,
          'usage' => [
            'import' => FALSE,
            'export' => TRUE,
            'duplicate_matching' => FALSE,
            'token' => FALSE,
          ],
          'where' => 'civicrm_contact.contact_type',
          'export' => TRUE,
          'table_name' => 'civicrm_contact',
          'entity' => 'Contact',
          'bao' => 'CRM_Contact_BAO_Contact',
          'localizable' => 0,
          'html' => [
            'type' => 'Select',
          ],
          'pseudoconstant' => [
            'table' => 'civicrm_contact_type',
            'keyColumn' => 'name',
            'labelColumn' => 'label',
            'iconColumn' => 'icon',
            'condition' => 'parent_id IS NULL',
          ],
          'readonly' => TRUE,
          'add' => '1.1',
        ],
        'external_identifier' => [
          'name' => 'external_identifier',
          'type' => CRM_Utils_Type::T_STRING,
          'title' => ts('External Identifier'),
          'description' => ts('Unique trusted external ID (generally from a legacy app/datasource). Particularly useful for deduping operations.'),
          'maxlength' => 64,
          'size' => 8,
          'usage' => [
            'import' => TRUE,
            'export' => TRUE,
            'duplicate_matching' => TRUE,
            'token' => FALSE,
          ],
          'import' => TRUE,
          'where' => 'civicrm_contact.external_identifier',
          'headerPattern' => '/external\s?id/i',
          'dataPattern' => '/^\d{11,}$/',
          'export' => TRUE,
          'table_name' => 'civicrm_contact',
          'entity' => 'Contact',
          'bao' => 'CRM_Contact_BAO_Contact',
          'localizable' => 0,
          'html' => [
            'type' => 'Text',
            'label' => ts("External Identifier"),
          ],
          'add' => '1.1',
        ],
        'display_name' => [
          'name' => 'display_name',
          'type' => CRM_Utils_Type::T_STRING,
          'title' => ts('Display Name'),
          'description' => ts('Formatted name representing preferred format for display/print/other output.'),
          'maxlength' => 128,
          'size' => 30,
          'usage' => [
            'import' => FALSE,
            'export' => TRUE,
            'duplicate_matching' => FALSE,
            'token' => FALSE,
          ],
          'where' => 'civicrm_contact.display_name',
          'export' => TRUE,
          'table_name' => 'civicrm_contact',
          'entity' => 'Contact',
          'bao' => 'CRM_Contact_BAO_Contact',
          'localizable' => 0,
          'html' => [
            'type' => 'Text',
          ],
          'readonly' => TRUE,
          'add' => '1.1',
        ],
        'organization_name' => [
          'name' => 'organization_name',
          'type' => CRM_Utils_Type::T_STRING,
          'title' => ts('Organization Name'),
          'description' => ts('Organization Name.'),
          'maxlength' => 128,
          'size' => 30,
          'usage' => [
            'import' => TRUE,
            'export' => TRUE,
            'duplicate_matching' => TRUE,
            'token' => FALSE,
          ],
          'import' => TRUE,
          'where' => 'civicrm_contact.organization_name',
          'headerPattern' => '/^organization|(o(rganization\s)?name)$/i',
          'dataPattern' => '/^\w+$/',
          'export' => TRUE,
          'contactType' => 'Organization',
          'table_name' => 'civicrm_contact',
          'entity' => 'Contact',
          'bao' => 'CRM_Contact_BAO_Contact',
          'localizable' => 0,
          'html' => [
            'type' => 'Text',
            'label' => ts("Organization Name"),
          ],
          'add' => '1.1',
        ],
        'contact_sub_type' => [
          'name' => 'contact_sub_type',
          'type' => CRM_Utils_Type::T_STRING,
          'title' => ts('Contact Subtype'),
          'description' => ts('May be used to over-ride contact view and edit templates.'),
          'maxlength' => 255,
          'size' => CRM_Utils_Type::HUGE,
          'usage' => [
            'import' => TRUE,
            'export' => TRUE,
            'duplicate_matching' => TRUE,
            'token' => FALSE,
          ],
          'import' => TRUE,
          'where' => 'civicrm_contact.contact_sub_type',
          'headerPattern' => '/C(ontact )?(subtype|sub-type|sub type)/i',
          'export' => TRUE,
          'table_name' => 'civicrm_contact',
          'entity' => 'Contact',
          'bao' => 'CRM_Contact_BAO_Contact',
          'localizable' => 0,
          'serialize' => self::SERIALIZE_SEPARATOR_BOOKEND,
          'html' => [
            'type' => 'Select',
            'controlField' => 'contact_type',
          ],
          'pseudoconstant' => [
            'table' => 'civicrm_contact_type',
            'keyColumn' => 'name',
            'labelColumn' => 'label',
            'iconColumn' => 'icon',
            'condition' => 'parent_id IS NOT NULL',
          ],
          'add' => '1.5',
        ],
        'first_name' => [
          'name' => 'first_name',
          'type' => CRM_Utils_Type::T_STRING,
          'title' => ts('First Name'),
          'description' => ts('First Name.'),
          'maxlength' => 64,
          'size' => 30,
          'usage' => [
            'import' => TRUE,
            'export' => TRUE,
            'duplicate_matching' => TRUE,
            'token' => FALSE,
          ],
          'import' => TRUE,
          'where' => 'civicrm_contact.first_name',
          'headerPattern' => '/^first|(f(irst\s)?name)$/i',
          'dataPattern' => '/^\w+$/',
          'export' => TRUE,
          'contactType' => 'Individual',
          'table_name' => 'civicrm_contact',
          'entity' => 'Contact',
          'bao' => 'CRM_Contact_BAO_Contact',
          'localizable' => 0,
          'html' => [
            'type' => 'Text',
            'label' => ts("First Name"),
          ],
          'add' => '1.1',
        ],
        'middle_name' => [
          'name' => 'middle_name',
          'type' => CRM_Utils_Type::T_STRING,
          'title' => ts('Middle Name'),
          'description' => ts('Middle Name.'),
          'maxlength' => 64,
          'size' => 30,
          'usage' => [
            'import' => TRUE,
            'export' => TRUE,
            'duplicate_matching' => TRUE,
            'token' => FALSE,
          ],
          'import' => TRUE,
          'where' => 'civicrm_contact.middle_name',
          'headerPattern' => '/^middle|(m(iddle\s)?name)$/i',
          'dataPattern' => '/^\w+$/',
          'export' => TRUE,
          'contactType' => 'Individual',
          'table_name' => 'civicrm_contact',
          'entity' => 'Contact',
          'bao' => 'CRM_Contact_BAO_Contact',
          'localizable' => 0,
          'html' => [
            'type' => 'Text',
            'label' => ts("Middle Name"),
          ],
          'add' => '1.1',
        ],
        'last_name' => [
          'name' => 'last_name',
          'type' => CRM_Utils_Type::T_STRING,
          'title' => ts('Last Name'),
          'description' => ts('Last Name.'),
          'maxlength' => 64,
          'size' => 30,
          'usage' => [
            'import' => TRUE,
            'export' => TRUE,
            'duplicate_matching' => TRUE,
            'token' => FALSE,
          ],
          'import' => TRUE,
          'where' => 'civicrm_contact.last_name',
          'headerPattern' => '/^last|(l(ast\s)?name)$/i',
          'dataPattern' => '/^\w+(\s\w+)?+$/',
          'export' => TRUE,
          'contactType' => 'Individual',
          'table_name' => 'civicrm_contact',
          'entity' => 'Contact',
          'bao' => 'CRM_Contact_BAO_Contact',
          'localizable' => 0,
          'html' => [
            'type' => 'Text',
            'label' => ts("Last Name"),
          ],
          'add' => '1.1',
        ],
        'do_not_email' => [
          'name' => 'do_not_email',
          'type' => CRM_Utils_Type::T_BOOLEAN,
          'title' => ts('Do Not Email'),
          'required' => TRUE,
          'usage' => [
            'import' => TRUE,
            'export' => TRUE,
            'duplicate_matching' => TRUE,
            'token' => FALSE,
          ],
          'import' => TRUE,
          'where' => 'civicrm_contact.do_not_email',
          'headerPattern' => '/d(o )?(not )?(email)/i',
          'dataPattern' => '/^\d{1,}$/',
          'export' => TRUE,
          'default' => '0',
          'table_name' => 'civicrm_contact',
          'entity' => 'Contact',
          'bao' => 'CRM_Contact_BAO_Contact',
          'localizable' => 0,
          'html' => [
            'type' => 'CheckBox',
            'label' => ts("Do Not Email"),
          ],
          'add' => '1.1',
        ],
        'do_not_phone' => [
          'name' => 'do_not_phone',
          'type' => CRM_Utils_Type::T_BOOLEAN,
          'title' => ts('Do Not Phone'),
          'required' => TRUE,
          'usage' => [
            'import' => TRUE,
            'export' => TRUE,
            'duplicate_matching' => TRUE,
            'token' => FALSE,
          ],
          'import' => TRUE,
          'where' => 'civicrm_contact.do_not_phone',
          'headerPattern' => '/d(o )?(not )?(call|phone)/i',
          'dataPattern' => '/^\d{1,}$/',
          'export' => TRUE,
          'default' => '0',
          'table_name' => 'civicrm_contact',
          'entity' => 'Contact',
          'bao' => 'CRM_Contact_BAO_Contact',
          'localizable' => 0,
          'html' => [
            'type' => 'CheckBox',
            'label' => ts("Do Not Phone"),
          ],
          'add' => '1.1',
        ],
        'do_not_mail' => [
          'name' => 'do_not_mail',
          'type' => CRM_Utils_Type::T_BOOLEAN,
          'title' => ts('Do Not Mail'),
          'required' => TRUE,
          'usage' => [
            'import' => TRUE,
            'export' => TRUE,
            'duplicate_matching' => TRUE,
            'token' => FALSE,
          ],
          'import' => TRUE,
          'where' => 'civicrm_contact.do_not_mail',
          'headerPattern' => '/^(d(o\s)?n(ot\s)?mail)|(\w*)?bulk\s?(\w*)$/i',
          'dataPattern' => '/^\d{1,}$/',
          'export' => TRUE,
          'default' => '0',
          'table_name' => 'civicrm_contact',
          'entity' => 'Contact',
          'bao' => 'CRM_Contact_BAO_Contact',
          'localizable' => 0,
          'html' => [
            'type' => 'CheckBox',
            'label' => ts("Do Not Mail"),
          ],
          'add' => '1.1',
        ],
        'do_not_sms' => [
          'name' => 'do_not_sms',
          'type' => CRM_Utils_Type::T_BOOLEAN,
          'title' => ts('Do Not Sms'),
          'required' => TRUE,
          'usage' => [
            'import' => TRUE,
            'export' => TRUE,
            'duplicate_matching' => TRUE,
            'token' => FALSE,
          ],
          'import' => TRUE,
          'where' => 'civicrm_contact.do_not_sms',
          'headerPattern' => '/d(o )?(not )?(sms)/i',
          'dataPattern' => '/^\d{1,}$/',
          'export' => TRUE,
          'default' => '0',
          'table_name' => 'civicrm_contact',
          'entity' => 'Contact',
          'bao' => 'CRM_Contact_BAO_Contact',
          'localizable' => 0,
          'html' => [
            'type' => 'CheckBox',
            'label' => ts("Do Not Sms"),
          ],
          'add' => '3.0',
        ],
        'do_not_trade' => [
          'name' => 'do_not_trade',
          'type' => CRM_Utils_Type::T_BOOLEAN,
          'title' => ts('Do Not Trade'),
          'required' => TRUE,
          'usage' => [
            'import' => TRUE,
            'export' => TRUE,
            'duplicate_matching' => TRUE,
            'token' => FALSE,
          ],
          'import' => TRUE,
          'where' => 'civicrm_contact.do_not_trade',
          'headerPattern' => '/d(o )?(not )?(trade)/i',
          'dataPattern' => '/^\d{1,}$/',
          'export' => TRUE,
          'default' => '0',
          'table_name' => 'civicrm_contact',
          'entity' => 'Contact',
          'bao' => 'CRM_Contact_BAO_Contact',
          'localizable' => 0,
          'html' => [
            'type' => 'CheckBox',
            'label' => ts("Do Not Trade"),
          ],
          'add' => '1.1',
        ],
        'is_opt_out' => [
          'name' => 'is_opt_out',
          'type' => CRM_Utils_Type::T_BOOLEAN,
          'title' => ts('No Bulk Emails (User Opt Out)'),
          'description' => ts('Has the contact opted out from receiving all bulk email from the organization or site domain?'),
          'required' => TRUE,
          'usage' => [
            'import' => TRUE,
            'export' => TRUE,
            'duplicate_matching' => TRUE,
            'token' => FALSE,
          ],
          'import' => TRUE,
          'where' => 'civicrm_contact.is_opt_out',
          'export' => TRUE,
          'default' => '0',
          'table_name' => 'civicrm_contact',
          'entity' => 'Contact',
          'bao' => 'CRM_Contact_BAO_Contact',
          'localizable' => 0,
          'html' => [
            'type' => 'CheckBox',
            'label' => ts("Is Opt Out"),
          ],
          'add' => '1.1',
        ],
        'legal_identifier' => [
          'name' => 'legal_identifier',
          'type' => CRM_Utils_Type::T_STRING,
          'title' => ts('Legal Identifier'),
          'description' => ts('May be used for SSN, EIN/TIN, Household ID (census) or other applicable unique legal/government ID.'),
          'maxlength' => 32,
          'size' => CRM_Utils_Type::MEDIUM,
          'usage' => [
            'import' => TRUE,
            'export' => TRUE,
            'duplicate_matching' => TRUE,
            'token' => FALSE,
          ],
          'import' => TRUE,
          'where' => 'civicrm_contact.legal_identifier',
          'headerPattern' => '/legal\s?id/i',
          'dataPattern' => '/\w+?\d{5,}/',
          'export' => TRUE,
          'table_name' => 'civicrm_contact',
          'entity' => 'Contact',
          'bao' => 'CRM_Contact_BAO_Contact',
          'localizable' => 0,
          'html' => [
            'type' => 'Text',
            'label' => ts("Legal Identifier"),
          ],
          'add' => '1.1',
        ],
        'sort_name' => [
          'name' => 'sort_name',
          'type' => CRM_Utils_Type::T_STRING,
          'title' => ts('Sort Name'),
          'description' => ts('Name used for sorting different contact types'),
          'maxlength' => 128,
          'size' => 30,
          'usage' => [
            'import' => FALSE,
            'export' => TRUE,
            'duplicate_matching' => FALSE,
            'token' => FALSE,
          ],
          'where' => 'civicrm_contact.sort_name',
          'export' => TRUE,
          'table_name' => 'civicrm_contact',
          'entity' => 'Contact',
          'bao' => 'CRM_Contact_BAO_Contact',
          'localizable' => 0,
          'html' => [
            'type' => 'Text',
          ],
          'readonly' => TRUE,
          'add' => '1.1',
        ],
        'nick_name' => [
          'name' => 'nick_name',
          'type' => CRM_Utils_Type::T_STRING,
          'title' => ts('Nickname'),
          'description' => ts('Nickname.'),
          'maxlength' => 128,
          'size' => 30,
          'usage' => [
            'import' => TRUE,
            'export' => TRUE,
            'duplicate_matching' => TRUE,
            'token' => FALSE,
          ],
          'import' => TRUE,
          'where' => 'civicrm_contact.nick_name',
          'headerPattern' => '/n(ick\s)name|nick$/i',
          'dataPattern' => '/^\w+$/',
          'export' => TRUE,
          'table_name' => 'civicrm_contact',
          'entity' => 'Contact',
          'bao' => 'CRM_Contact_BAO_Contact',
          'localizable' => 0,
          'html' => [
            'type' => 'Text',
          ],
          'add' => '1.1',
        ],
        'legal_name' => [
          'name' => 'legal_name',
          'type' => CRM_Utils_Type::T_STRING,
          'title' => ts('Legal Name'),
          'description' => ts('Legal Name.'),
          'maxlength' => 128,
          'size' => 30,
          'usage' => [
            'import' => TRUE,
            'export' => TRUE,
            'duplicate_matching' => TRUE,
            'token' => FALSE,
          ],
          'import' => TRUE,
          'where' => 'civicrm_contact.legal_name',
          'headerPattern' => '/^legal|(l(egal\s)?name)$/i',
          'export' => TRUE,
          'contactType' => 'Organization',
          'table_name' => 'civicrm_contact',
          'entity' => 'Contact',
          'bao' => 'CRM_Contact_BAO_Contact',
          'localizable' => 0,
          'html' => [
            'type' => 'Text',
            'label' => ts("Legal Name"),
          ],
          'add' => '1.1',
        ],
        'image_URL' => [
          'name' => 'image_URL',
          'type' => CRM_Utils_Type::T_TEXT,
          'title' => ts('Image Url'),
          'description' => ts('optional URL for preferred image (photo, logo, etc.) to display for this contact.'),
          'usage' => [
            'import' => TRUE,
            'export' => TRUE,
            'duplicate_matching' => TRUE,
            'token' => FALSE,
          ],
          'import' => TRUE,
          'where' => 'civicrm_contact.image_URL',
          'export' => TRUE,
          'table_name' => 'civicrm_contact',
          'entity' => 'Contact',
          'bao' => 'CRM_Contact_BAO_Contact',
          'localizable' => 0,
          'html' => [
            'type' => 'File',
            'label' => ts("Image"),
          ],
          'add' => '1.1',
        ],
        'preferred_communication_method' => [
          'name' => 'preferred_communication_method',
          'type' => CRM_Utils_Type::T_STRING,
          'title' => ts('Preferred Communication Method'),
          'description' => ts('What is the preferred mode of communication.'),
          'maxlength' => 255,
          'size' => CRM_Utils_Type::HUGE,
          'usage' => [
            'import' => TRUE,
            'export' => TRUE,
            'duplicate_matching' => TRUE,
            'token' => FALSE,
          ],
          'import' => TRUE,
          'where' => 'civicrm_contact.preferred_communication_method',
          'headerPattern' => '/^p(ref\w*\s)?c(omm\w*)|( meth\w*)$/i',
          'dataPattern' => '/^\w+$/',
          'export' => TRUE,
          'table_name' => 'civicrm_contact',
          'entity' => 'Contact',
          'bao' => 'CRM_Contact_BAO_Contact',
          'localizable' => 0,
          'serialize' => self::SERIALIZE_SEPARATOR_BOOKEND,
          'html' => [
            'type' => 'Select',
          ],
          'pseudoconstant' => [
            'optionGroupName' => 'preferred_communication_method',
            'optionEditPath' => 'civicrm/admin/options/preferred_communication_method',
          ],
          'add' => '1.1',
        ],
        'preferred_language' => [
          'name' => 'preferred_language',
          'type' => CRM_Utils_Type::T_STRING,
          'title' => ts('Preferred Language'),
          'description' => ts('Which language is preferred for communication. FK to languages in civicrm_option_value.'),
          'maxlength' => 5,
          'size' => CRM_Utils_Type::SIX,
          'usage' => [
            'import' => TRUE,
            'export' => TRUE,
            'duplicate_matching' => TRUE,
            'token' => FALSE,
          ],
          'import' => TRUE,
          'where' => 'civicrm_contact.preferred_language',
          'headerPattern' => '/^lang/i',
          'export' => TRUE,
          'table_name' => 'civicrm_contact',
          'entity' => 'Contact',
          'bao' => 'CRM_Contact_BAO_Contact',
          'localizable' => 0,
          'html' => [
            'type' => 'Select',
          ],
          'pseudoconstant' => [
            'optionGroupName' => 'languages',
            'keyColumn' => 'name',
            'optionEditPath' => 'civicrm/admin/options/languages',
          ],
          'add' => '3.2',
        ],
        'hash' => [
          'name' => 'hash',
          'type' => CRM_Utils_Type::T_STRING,
          'title' => ts('Contact Hash'),
          'description' => ts('Key for validating requests related to this contact.'),
          'maxlength' => 32,
          'size' => CRM_Utils_Type::MEDIUM,
          'usage' => [
            'import' => FALSE,
            'export' => TRUE,
            'duplicate_matching' => FALSE,
            'token' => FALSE,
          ],
          'where' => 'civicrm_contact.hash',
          'export' => TRUE,
          'table_name' => 'civicrm_contact',
          'entity' => 'Contact',
          'bao' => 'CRM_Contact_BAO_Contact',
          'localizable' => 0,
          'readonly' => TRUE,
          'add' => '1.1',
        ],
        'api_key' => [
          'name' => 'api_key',
          'type' => CRM_Utils_Type::T_STRING,
          'title' => ts('Api Key'),
          'description' => ts('API Key for validating requests related to this contact.'),
          'maxlength' => 32,
          'size' => CRM_Utils_Type::MEDIUM,
          'usage' => [
            'import' => FALSE,
            'export' => FALSE,
            'duplicate_matching' => FALSE,
            'token' => FALSE,
          ],
          'where' => 'civicrm_contact.api_key',
          'permission' => [
            [
              'administer CiviCRM',
              'edit api keys',
            ],
          ],
          'table_name' => 'civicrm_contact',
          'entity' => 'Contact',
          'bao' => 'CRM_Contact_BAO_Contact',
          'localizable' => 0,
          'html' => [
            'label' => ts("API KEY"),
          ],
          'readonly' => TRUE,
          'add' => '2.2',
        ],
        'contact_source' => [
          'name' => 'source',
          'type' => CRM_Utils_Type::T_STRING,
          'title' => ts('Contact Source'),
          'description' => ts('where contact come from, e.g. import, donate module insert...'),
          'maxlength' => 255,
          'size' => 30,
          'usage' => [
            'import' => TRUE,
            'export' => TRUE,
            'duplicate_matching' => TRUE,
            'token' => FALSE,
          ],
          'import' => TRUE,
          'where' => 'civicrm_contact.source',
          'headerPattern' => '/(C(ontact\s)?Source)$/i',
          'export' => TRUE,
          'table_name' => 'civicrm_contact',
          'entity' => 'Contact',
          'bao' => 'CRM_Contact_BAO_Contact',
          'localizable' => 0,
          'html' => [
            'type' => 'Text',
          ],
          'add' => '1.1',
        ],
        'prefix_id' => [
          'name' => 'prefix_id',
          'type' => CRM_Utils_Type::T_INT,
          'title' => ts('Individual Prefix'),
          'description' => ts('Prefix or Title for name (Ms, Mr...). FK to prefix ID'),
          'usage' => [
            'import' => TRUE,
            'export' => TRUE,
            'duplicate_matching' => TRUE,
            'token' => FALSE,
          ],
          'import' => TRUE,
          'where' => 'civicrm_contact.prefix_id',
          'headerPattern' => '/^(prefix|title)/i',
          'dataPattern' => '/^(mr|ms|mrs|sir|dr)\.?$/i',
          'export' => TRUE,
          'contactType' => 'Individual',
          'table_name' => 'civicrm_contact',
          'entity' => 'Contact',
          'bao' => 'CRM_Contact_BAO_Contact',
          'localizable' => 0,
          'html' => [
            'type' => 'Select',
          ],
          'pseudoconstant' => [
            'optionGroupName' => 'individual_prefix',
            'optionEditPath' => 'civicrm/admin/options/individual_prefix',
          ],
          'add' => '1.2',
        ],
        'suffix_id' => [
          'name' => 'suffix_id',
          'type' => CRM_Utils_Type::T_INT,
          'title' => ts('Individual Suffix'),
          'description' => ts('Suffix for name (Jr, Sr...). FK to suffix ID'),
          'usage' => [
            'import' => TRUE,
            'export' => TRUE,
            'duplicate_matching' => TRUE,
            'token' => FALSE,
          ],
          'import' => TRUE,
          'where' => 'civicrm_contact.suffix_id',
          'headerPattern' => '/^suffix$/i',
          'dataPattern' => '/^(sr|jr)\.?|i{2,}$/',
          'export' => TRUE,
          'contactType' => 'Individual',
          'table_name' => 'civicrm_contact',
          'entity' => 'Contact',
          'bao' => 'CRM_Contact_BAO_Contact',
          'localizable' => 0,
          'html' => [
            'type' => 'Select',
          ],
          'pseudoconstant' => [
            'optionGroupName' => 'individual_suffix',
            'optionEditPath' => 'civicrm/admin/options/individual_suffix',
          ],
          'add' => '1.2',
        ],
        'formal_title' => [
          'name' => 'formal_title',
          'type' => CRM_Utils_Type::T_STRING,
          'title' => ts('Formal Title'),
          'description' => ts('Formal (academic or similar) title in front of name. (Prof., Dr. etc.)'),
          'maxlength' => 64,
          'size' => CRM_Utils_Type::BIG,
          'usage' => [
            'import' => TRUE,
            'export' => TRUE,
            'duplicate_matching' => TRUE,
            'token' => FALSE,
          ],
          'import' => TRUE,
          'where' => 'civicrm_contact.formal_title',
          'headerPattern' => '/^title/i',
          'export' => TRUE,
          'contactType' => 'Individual',
          'table_name' => 'civicrm_contact',
          'entity' => 'Contact',
          'bao' => 'CRM_Contact_BAO_Contact',
          'localizable' => 0,
          'html' => [
            'type' => 'Text',
            'label' => ts("Formal Title"),
          ],
          'add' => '4.5',
        ],
        'communication_style_id' => [
          'name' => 'communication_style_id',
          'type' => CRM_Utils_Type::T_INT,
          'title' => ts('Communication Style'),
          'description' => ts('Communication style (e.g. formal vs. familiar) to use with this contact. FK to communication styles in civicrm_option_value.'),
          'usage' => [
            'import' => TRUE,
            'export' => TRUE,
            'duplicate_matching' => TRUE,
            'token' => FALSE,
          ],
          'import' => TRUE,
          'where' => 'civicrm_contact.communication_style_id',
          'headerPattern' => '/style/i',
          'export' => TRUE,
          'table_name' => 'civicrm_contact',
          'entity' => 'Contact',
          'bao' => 'CRM_Contact_BAO_Contact',
          'localizable' => 0,
          'html' => [
            'type' => 'Select',
          ],
          'pseudoconstant' => [
            'optionGroupName' => 'communication_style',
            'optionEditPath' => 'civicrm/admin/options/communication_style',
          ],
          'add' => '4.4',
        ],
        'email_greeting_id' => [
          'name' => 'email_greeting_id',
          'type' => CRM_Utils_Type::T_INT,
          'title' => ts('Email Greeting ID'),
          'description' => ts('FK to civicrm_option_value.id, that has to be valid registered Email Greeting.'),
          'usage' => [
            'import' => FALSE,
            'export' => TRUE,
            'duplicate_matching' => FALSE,
            'token' => FALSE,
          ],
          'where' => 'civicrm_contact.email_greeting_id',
          'export' => TRUE,
          'table_name' => 'civicrm_contact',
          'entity' => 'Contact',
          'bao' => 'CRM_Contact_BAO_Contact',
          'localizable' => 0,
          'html' => [
            'type' => 'Select',
          ],
          'pseudoconstant' => [
            'optionGroupName' => 'email_greeting',
            'optionEditPath' => 'civicrm/admin/options/email_greeting',
          ],
          'add' => '3.0',
        ],
        'email_greeting_custom' => [
          'name' => 'email_greeting_custom',
          'type' => CRM_Utils_Type::T_STRING,
          'title' => ts('Email Greeting Custom'),
          'description' => ts('Custom Email Greeting.'),
          'maxlength' => 128,
          'size' => CRM_Utils_Type::HUGE,
          'usage' => [
            'import' => TRUE,
            'export' => FALSE,
            'duplicate_matching' => TRUE,
            'token' => FALSE,
          ],
          'import' => TRUE,
          'where' => 'civicrm_contact.email_greeting_custom',
          'export' => FALSE,
          'table_name' => 'civicrm_contact',
          'entity' => 'Contact',
          'bao' => 'CRM_Contact_BAO_Contact',
          'localizable' => 0,
          'html' => [
            'type' => 'Text',
            'label' => ts("Email Greeting Custom"),
          ],
          'add' => '3.0',
        ],
        'email_greeting_display' => [
          'name' => 'email_greeting_display',
          'type' => CRM_Utils_Type::T_STRING,
          'title' => ts('Email Greeting'),
          'description' => ts('Cache Email Greeting.'),
          'maxlength' => 255,
          'size' => CRM_Utils_Type::HUGE,
          'usage' => [
            'import' => FALSE,
            'export' => FALSE,
            'duplicate_matching' => FALSE,
            'token' => FALSE,
          ],
          'where' => 'civicrm_contact.email_greeting_display',
          'table_name' => 'civicrm_contact',
          'entity' => 'Contact',
          'bao' => 'CRM_Contact_BAO_Contact',
          'localizable' => 0,
          'readonly' => TRUE,
          'add' => '3.0',
        ],
        'postal_greeting_id' => [
          'name' => 'postal_greeting_id',
          'type' => CRM_Utils_Type::T_INT,
          'title' => ts('Postal Greeting ID'),
          'description' => ts('FK to civicrm_option_value.id, that has to be valid registered Postal Greeting.'),
          'usage' => [
            'import' => FALSE,
            'export' => TRUE,
            'duplicate_matching' => FALSE,
            'token' => FALSE,
          ],
          'where' => 'civicrm_contact.postal_greeting_id',
          'export' => TRUE,
          'table_name' => 'civicrm_contact',
          'entity' => 'Contact',
          'bao' => 'CRM_Contact_BAO_Contact',
          'localizable' => 0,
          'html' => [
            'type' => 'Select',
          ],
          'pseudoconstant' => [
            'optionGroupName' => 'postal_greeting',
            'optionEditPath' => 'civicrm/admin/options/postal_greeting',
          ],
          'add' => '3.0',
        ],
        'postal_greeting_custom' => [
          'name' => 'postal_greeting_custom',
          'type' => CRM_Utils_Type::T_STRING,
          'title' => ts('Postal Greeting Custom'),
          'description' => ts('Custom Postal greeting.'),
          'maxlength' => 128,
          'size' => CRM_Utils_Type::HUGE,
          'usage' => [
            'import' => TRUE,
            'export' => FALSE,
            'duplicate_matching' => TRUE,
            'token' => FALSE,
          ],
          'import' => TRUE,
          'where' => 'civicrm_contact.postal_greeting_custom',
          'export' => FALSE,
          'table_name' => 'civicrm_contact',
          'entity' => 'Contact',
          'bao' => 'CRM_Contact_BAO_Contact',
          'localizable' => 0,
          'html' => [
            'type' => 'Text',
            'label' => ts("Postal Greeting Custom"),
          ],
          'add' => '3.0',
        ],
        'postal_greeting_display' => [
          'name' => 'postal_greeting_display',
          'type' => CRM_Utils_Type::T_STRING,
          'title' => ts('Postal Greeting'),
          'description' => ts('Cache Postal greeting.'),
          'maxlength' => 255,
          'size' => CRM_Utils_Type::HUGE,
          'usage' => [
            'import' => FALSE,
            'export' => FALSE,
            'duplicate_matching' => FALSE,
            'token' => FALSE,
          ],
          'where' => 'civicrm_contact.postal_greeting_display',
          'table_name' => 'civicrm_contact',
          'entity' => 'Contact',
          'bao' => 'CRM_Contact_BAO_Contact',
          'localizable' => 0,
          'readonly' => TRUE,
          'add' => '3.0',
        ],
        'addressee_id' => [
          'name' => 'addressee_id',
          'type' => CRM_Utils_Type::T_INT,
          'title' => ts('Addressee ID'),
          'description' => ts('FK to civicrm_option_value.id, that has to be valid registered Addressee.'),
          'usage' => [
            'import' => FALSE,
            'export' => TRUE,
            'duplicate_matching' => FALSE,
            'token' => FALSE,
          ],
          'where' => 'civicrm_contact.addressee_id',
          'export' => TRUE,
          'table_name' => 'civicrm_contact',
          'entity' => 'Contact',
          'bao' => 'CRM_Contact_BAO_Contact',
          'localizable' => 0,
          'html' => [
            'type' => 'Select',
          ],
          'pseudoconstant' => [
            'optionGroupName' => 'addressee',
            'optionEditPath' => 'civicrm/admin/options/addressee',
          ],
          'add' => '3.0',
        ],
        'addressee_custom' => [
          'name' => 'addressee_custom',
          'type' => CRM_Utils_Type::T_STRING,
          'title' => ts('Addressee Custom'),
          'description' => ts('Custom Addressee.'),
          'maxlength' => 128,
          'size' => CRM_Utils_Type::HUGE,
          'usage' => [
            'import' => TRUE,
            'export' => FALSE,
            'duplicate_matching' => TRUE,
            'token' => FALSE,
          ],
          'import' => TRUE,
          'where' => 'civicrm_contact.addressee_custom',
          'export' => FALSE,
          'table_name' => 'civicrm_contact',
          'entity' => 'Contact',
          'bao' => 'CRM_Contact_BAO_Contact',
          'localizable' => 0,
          'html' => [
            'type' => 'Text',
            'label' => ts("Addressee Custom"),
          ],
          'add' => '3.0',
        ],
        'addressee_display' => [
          'name' => 'addressee_display',
          'type' => CRM_Utils_Type::T_STRING,
          'title' => ts('Addressee'),
          'description' => ts('Cache Addressee.'),
          'maxlength' => 255,
          'size' => CRM_Utils_Type::HUGE,
          'usage' => [
            'import' => FALSE,
            'export' => FALSE,
            'duplicate_matching' => FALSE,
            'token' => FALSE,
          ],
          'where' => 'civicrm_contact.addressee_display',
          'table_name' => 'civicrm_contact',
          'entity' => 'Contact',
          'bao' => 'CRM_Contact_BAO_Contact',
          'localizable' => 0,
          'readonly' => TRUE,
          'add' => '3.0',
        ],
        'job_title' => [
          'name' => 'job_title',
          'type' => CRM_Utils_Type::T_STRING,
          'title' => ts('Job Title'),
          'description' => ts('Job Title'),
          'maxlength' => 255,
          'size' => 30,
          'usage' => [
            'import' => TRUE,
            'export' => TRUE,
            'duplicate_matching' => TRUE,
            'token' => FALSE,
          ],
          'import' => TRUE,
          'where' => 'civicrm_contact.job_title',
          'headerPattern' => '/^job|(j(ob\s)?title)$/i',
          'dataPattern' => '//',
          'export' => TRUE,
          'contactType' => 'Individual',
          'table_name' => 'civicrm_contact',
          'entity' => 'Contact',
          'bao' => 'CRM_Contact_BAO_Contact',
          'localizable' => 0,
          'html' => [
            'type' => 'Text',
            'label' => ts("Job Title"),
          ],
          'add' => '1.1',
        ],
        'gender_id' => [
          'name' => 'gender_id',
          'type' => CRM_Utils_Type::T_INT,
          'title' => ts('Gender ID'),
          'description' => ts('FK to gender ID'),
          'usage' => [
            'import' => TRUE,
            'export' => TRUE,
            'duplicate_matching' => TRUE,
            'token' => FALSE,
          ],
          'import' => TRUE,
          'where' => 'civicrm_contact.gender_id',
          'headerPattern' => '/^gender$/i',
          'export' => TRUE,
          'contactType' => 'Individual',
          'table_name' => 'civicrm_contact',
          'entity' => 'Contact',
          'bao' => 'CRM_Contact_BAO_Contact',
          'localizable' => 0,
          'html' => [
            'type' => 'Select',
            'label' => ts("Gender"),
          ],
          'pseudoconstant' => [
            'optionGroupName' => 'gender',
            'optionEditPath' => 'civicrm/admin/options/gender',
          ],
          'add' => '1.2',
        ],
        'birth_date' => [
          'name' => 'birth_date',
          'type' => CRM_Utils_Type::T_DATE,
          'title' => ts('Birth Date'),
          'description' => ts('Date of birth'),
          'usage' => [
            'import' => TRUE,
            'export' => TRUE,
            'duplicate_matching' => TRUE,
            'token' => FALSE,
          ],
          'import' => TRUE,
          'where' => 'civicrm_contact.birth_date',
          'headerPattern' => '/^birth|(b(irth\s)?date)|D(\W*)O(\W*)B(\W*)$/i',
          'dataPattern' => '/\d{4}-?\d{2}-?\d{2}/',
          'export' => TRUE,
          'contactType' => 'Individual',
          'table_name' => 'civicrm_contact',
          'entity' => 'Contact',
          'bao' => 'CRM_Contact_BAO_Contact',
          'localizable' => 0,
          'html' => [
            'type' => 'Select Date',
            'formatType' => 'birth',
            'label' => ts("Birth Date"),
          ],
          'add' => '1.1',
        ],
        'is_deceased' => [
          'name' => 'is_deceased',
          'type' => CRM_Utils_Type::T_BOOLEAN,
          'title' => ts('Deceased'),
          'required' => TRUE,
          'usage' => [
            'import' => TRUE,
            'export' => TRUE,
            'duplicate_matching' => TRUE,
            'token' => FALSE,
          ],
          'import' => TRUE,
          'where' => 'civicrm_contact.is_deceased',
          'headerPattern' => '/i(s\s)?d(eceased)$/i',
          'export' => TRUE,
          'contactType' => 'Individual',
          'default' => '0',
          'table_name' => 'civicrm_contact',
          'entity' => 'Contact',
          'bao' => 'CRM_Contact_BAO_Contact',
          'localizable' => 0,
          'html' => [
            'type' => 'CheckBox',
            'label' => ts("Is Deceased"),
          ],
          'add' => '1.1',
        ],
        'deceased_date' => [
          'name' => 'deceased_date',
          'type' => CRM_Utils_Type::T_DATE,
          'title' => ts('Deceased Date'),
          'description' => ts('Date of deceased'),
          'usage' => [
            'import' => TRUE,
            'export' => TRUE,
            'duplicate_matching' => TRUE,
            'token' => FALSE,
          ],
          'import' => TRUE,
          'where' => 'civicrm_contact.deceased_date',
          'headerPattern' => '/^deceased|(d(eceased\s)?date)$/i',
          'export' => TRUE,
          'contactType' => 'Individual',
          'table_name' => 'civicrm_contact',
          'entity' => 'Contact',
          'bao' => 'CRM_Contact_BAO_Contact',
          'localizable' => 0,
          'html' => [
            'type' => 'Select Date',
            'formatType' => 'birth',
            'label' => ts("Deceased Date"),
          ],
          'add' => '1.5',
        ],
        'household_name' => [
          'name' => 'household_name',
          'type' => CRM_Utils_Type::T_STRING,
          'title' => ts('Household Name'),
          'description' => ts('Household Name.'),
          'maxlength' => 128,
          'size' => 30,
          'usage' => [
            'import' => TRUE,
            'export' => TRUE,
            'duplicate_matching' => TRUE,
            'token' => FALSE,
          ],
          'import' => TRUE,
          'where' => 'civicrm_contact.household_name',
          'headerPattern' => '/^household|(h(ousehold\s)?name)$/i',
          'dataPattern' => '/^\w+$/',
          'export' => TRUE,
          'contactType' => 'Household',
          'table_name' => 'civicrm_contact',
          'entity' => 'Contact',
          'bao' => 'CRM_Contact_BAO_Contact',
          'localizable' => 0,
          'html' => [
            'type' => 'Text',
            'label' => ts("Household Name"),
          ],
          'add' => '1.1',
        ],
        'primary_contact_id' => [
          'name' => 'primary_contact_id',
          'type' => CRM_Utils_Type::T_INT,
          'title' => ts('Household Primary Contact ID'),
          'description' => ts('Optional FK to Primary Contact for this household.'),
          'usage' => [
            'import' => FALSE,
            'export' => FALSE,
            'duplicate_matching' => FALSE,
            'token' => FALSE,
          ],
          'where' => 'civicrm_contact.primary_contact_id',
          'contactType' => 'Household',
          'table_name' => 'civicrm_contact',
          'entity' => 'Contact',
          'bao' => 'CRM_Contact_BAO_Contact',
          'localizable' => 0,
          'FKClassName' => 'CRM_Contact_DAO_Contact',
          'FKColumnName' => 'id',
          'html' => [
            'label' => ts("Household Primary Contact"),
          ],
          'readonly' => TRUE,
          'add' => '1.1',
        ],
        'sic_code' => [
          'name' => 'sic_code',
          'type' => CRM_Utils_Type::T_STRING,
          'title' => ts('Sic Code'),
          'description' => ts('Standard Industry Classification Code.'),
          'maxlength' => 8,
          'size' => CRM_Utils_Type::EIGHT,
          'usage' => [
            'import' => TRUE,
            'export' => TRUE,
            'duplicate_matching' => TRUE,
            'token' => FALSE,
          ],
          'import' => TRUE,
          'where' => 'civicrm_contact.sic_code',
          'headerPattern' => '/^sic|(s(ic\s)?code)$/i',
          'export' => TRUE,
          'contactType' => 'Organization',
          'table_name' => 'civicrm_contact',
          'entity' => 'Contact',
          'bao' => 'CRM_Contact_BAO_Contact',
          'localizable' => 0,
          'html' => [
            'type' => 'Text',
            'label' => ts("SIC Code"),
          ],
          'add' => '1.1',
        ],
        'user_unique_id' => [
          'name' => 'user_unique_id',
          'type' => CRM_Utils_Type::T_STRING,
          'title' => ts('Unique ID (OpenID)'),
          'description' => ts('the OpenID (or OpenID-style http://username.domain/) unique identifier for this contact mainly used for logging in to CiviCRM'),
          'maxlength' => 255,
          'size' => CRM_Utils_Type::HUGE,
          'usage' => [
            'import' => TRUE,
            'export' => TRUE,
            'duplicate_matching' => TRUE,
            'token' => FALSE,
          ],
          'import' => TRUE,
          'where' => 'civicrm_contact.user_unique_id',
          'headerPattern' => '/^Open\s?ID|u(niq\w*)?\s?ID/i',
          'dataPattern' => '/^[\w\/\:\.]+$/',
          'export' => TRUE,
          'rule' => 'url',
          'table_name' => 'civicrm_contact',
          'entity' => 'Contact',
          'bao' => 'CRM_Contact_BAO_Contact',
          'localizable' => 0,
          'deprecated' => TRUE,
          'html' => [
            'type' => 'Text',
          ],
          'add' => '2.0',
        ],
        'current_employer_id' => [
          'name' => 'employer_id',
          'type' => CRM_Utils_Type::T_INT,
          'title' => ts('Current Employer ID'),
          'description' => ts('OPTIONAL FK to civicrm_contact record.'),
          'usage' => [
            'import' => FALSE,
            'export' => TRUE,
            'duplicate_matching' => FALSE,
            'token' => FALSE,
          ],
          'where' => 'civicrm_contact.employer_id',
          'export' => TRUE,
          'contactType' => 'Individual',
          'table_name' => 'civicrm_contact',
          'entity' => 'Contact',
          'bao' => 'CRM_Contact_BAO_Contact',
          'localizable' => 0,
          'FKClassName' => 'CRM_Contact_DAO_Contact',
          'FKColumnName' => 'id',
          'html' => [
            'type' => 'EntityRef',
            'label' => ts("Current Employer"),
            'filter' => [
              'contact_type=Organization',
            ],
          ],
          'add' => '2.1',
        ],
        'contact_is_deleted' => [
          'name' => 'is_deleted',
          'type' => CRM_Utils_Type::T_BOOLEAN,
          'title' => ts('Contact is in Trash'),
          'required' => TRUE,
          'usage' => [
            'import' => FALSE,
            'export' => TRUE,
            'duplicate_matching' => FALSE,
            'token' => FALSE,
          ],
          'where' => 'civicrm_contact.is_deleted',
          'export' => TRUE,
          'default' => '0',
          'table_name' => 'civicrm_contact',
          'entity' => 'Contact',
          'bao' => 'CRM_Contact_BAO_Contact',
          'localizable' => 0,
          'html' => [
            'type' => 'CheckBox',
          ],
          'add' => '3.2',
        ],
        'created_date' => [
          'name' => 'created_date',
          'type' => CRM_Utils_Type::T_TIMESTAMP,
          'title' => ts('Created Date'),
          'description' => ts('When was the contact was created.'),
          'required' => FALSE,
          'usage' => [
            'import' => FALSE,
            'export' => TRUE,
            'duplicate_matching' => FALSE,
            'token' => FALSE,
          ],
          'where' => 'civicrm_contact.created_date',
          'export' => TRUE,
          'default' => NULL,
          'table_name' => 'civicrm_contact',
          'entity' => 'Contact',
          'bao' => 'CRM_Contact_BAO_Contact',
          'localizable' => 0,
          'html' => [
            'type' => 'Select Date',
            'formatType' => 'activityDateTime',
            'label' => ts("Created Date"),
          ],
          'readonly' => TRUE,
          'add' => '4.3',
        ],
        'modified_date' => [
          'name' => 'modified_date',
          'type' => CRM_Utils_Type::T_TIMESTAMP,
          'title' => ts('Modified Date'),
          'description' => ts('When was the contact (or closely related entity) was created or modified or deleted.'),
          'required' => FALSE,
          'usage' => [
            'import' => FALSE,
            'export' => TRUE,
            'duplicate_matching' => FALSE,
            'token' => FALSE,
          ],
          'where' => 'civicrm_contact.modified_date',
          'export' => TRUE,
          'default' => 'CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP',
          'table_name' => 'civicrm_contact',
          'entity' => 'Contact',
          'bao' => 'CRM_Contact_BAO_Contact',
          'localizable' => 0,
          'html' => [
            'type' => 'Select Date',
            'formatType' => 'activityDateTime',
            'label' => ts("Modified Date"),
          ],
          'readonly' => TRUE,
          'add' => '4.3',
        ],
        'preferred_mail_format' => [
          'name' => 'preferred_mail_format',
          'type' => CRM_Utils_Type::T_STRING,
          'title' => ts('Preferred Mail Format'),
          'description' => ts('Deprecated setting for text vs html mailings'),
          'maxlength' => 8,
          'size' => CRM_Utils_Type::EIGHT,
          'usage' => [
            'import' => FALSE,
            'export' => FALSE,
            'duplicate_matching' => FALSE,
            'token' => FALSE,
          ],
          'where' => 'civicrm_contact.preferred_mail_format',
          'headerPattern' => '/^p(ref\w*\s)?m(ail\s)?f(orm\w*)$/i',
          'default' => 'Both',
          'table_name' => 'civicrm_contact',
          'entity' => 'Contact',
          'bao' => 'CRM_Contact_BAO_Contact',
          'localizable' => 0,
          'deprecated' => TRUE,
          'html' => [
            'type' => 'Select',
            'label' => ts("Preferred Mail Format"),
          ],
          'pseudoconstant' => [
            'callback' => 'CRM_Core_SelectValues::pmf',
          ],
          'add' => '1.1',
        ],
      ];
      CRM_Core_DAO_AllCoreTables::invoke(__CLASS__, 'fields_callback', Civi::$statics[__CLASS__]['fields']);
    }
    return Civi::$statics[__CLASS__]['fields'];
  }

  /**
   * Returns the list of fields that can be imported
   *
   * @param bool $prefix
   *
   * @return array
   */
  public static function &import($prefix = FALSE) {
    $r = CRM_Core_DAO_AllCoreTables::getImports(__CLASS__, 'contact', $prefix, []);
    return $r;
  }

  /**
   * Returns the list of fields that can be exported
   *
   * @param bool $prefix
   *
   * @return array
   */
  public static function &export($prefix = FALSE) {
    $r = CRM_Core_DAO_AllCoreTables::getExports(__CLASS__, 'contact', $prefix, []);
    return $r;
  }

  /**
   * Returns the list of indices
   *
   * @param bool $localize
   *
   * @return array
   */
  public static function indices($localize = TRUE) {
    $indices = [
      'index_contact_type' => [
        'name' => 'index_contact_type',
        'field' => [
          0 => 'contact_type',
        ],
        'localizable' => FALSE,
        'sig' => 'civicrm_contact::0::contact_type',
      ],
      'UI_external_identifier' => [
        'name' => 'UI_external_identifier',
        'field' => [
          0 => 'external_identifier',
        ],
        'localizable' => FALSE,
        'unique' => TRUE,
        'sig' => 'civicrm_contact::1::external_identifier',
      ],
      'index_organization_name' => [
        'name' => 'index_organization_name',
        'field' => [
          0 => 'organization_name',
        ],
        'localizable' => FALSE,
        'sig' => 'civicrm_contact::0::organization_name',
      ],
      'index_contact_sub_type' => [
        'name' => 'index_contact_sub_type',
        'field' => [
          0 => 'contact_sub_type',
        ],
        'localizable' => FALSE,
        'sig' => 'civicrm_contact::0::contact_sub_type',
      ],
      'index_first_name' => [
        'name' => 'index_first_name',
        'field' => [
          0 => 'first_name',
        ],
        'localizable' => FALSE,
        'sig' => 'civicrm_contact::0::first_name',
      ],
      'index_last_name' => [
        'name' => 'index_last_name',
        'field' => [
          0 => 'last_name',
        ],
        'localizable' => FALSE,
        'sig' => 'civicrm_contact::0::last_name',
      ],
      'index_sort_name' => [
        'name' => 'index_sort_name',
        'field' => [
          0 => 'sort_name',
        ],
        'localizable' => FALSE,
        'sig' => 'civicrm_contact::0::sort_name',
      ],
      'index_preferred_communication_method' => [
        'name' => 'index_preferred_communication_method',
        'field' => [
          0 => 'preferred_communication_method',
        ],
        'localizable' => FALSE,
        'sig' => 'civicrm_contact::0::preferred_communication_method',
      ],
      'index_hash' => [
        'name' => 'index_hash',
        'field' => [
          0 => 'hash',
        ],
        'localizable' => FALSE,
        'sig' => 'civicrm_contact::0::hash',
      ],
      'index_api_key' => [
        'name' => 'index_api_key',
        'field' => [
          0 => 'api_key',
        ],
        'localizable' => FALSE,
        'sig' => 'civicrm_contact::0::api_key',
      ],
      'UI_prefix' => [
        'name' => 'UI_prefix',
        'field' => [
          0 => 'prefix_id',
        ],
        'localizable' => FALSE,
        'sig' => 'civicrm_contact::0::prefix_id',
      ],
      'UI_suffix' => [
        'name' => 'UI_suffix',
        'field' => [
          0 => 'suffix_id',
        ],
        'localizable' => FALSE,
        'sig' => 'civicrm_contact::0::suffix_id',
      ],
      'index_communication_style_id' => [
        'name' => 'index_communication_style_id',
        'field' => [
          0 => 'communication_style_id',
        ],
        'localizable' => FALSE,
        'sig' => 'civicrm_contact::0::communication_style_id',
      ],
      'UI_gender' => [
        'name' => 'UI_gender',
        'field' => [
          0 => 'gender_id',
        ],
        'localizable' => FALSE,
        'sig' => 'civicrm_contact::0::gender_id',
      ],
      'index_is_deceased' => [
        'name' => 'index_is_deceased',
        'field' => [
          0 => 'is_deceased',
        ],
        'localizable' => FALSE,
        'sig' => 'civicrm_contact::0::is_deceased',
      ],
      'index_household_name' => [
        'name' => 'index_household_name',
        'field' => [
          0 => 'household_name',
        ],
        'localizable' => FALSE,
        'sig' => 'civicrm_contact::0::household_name',
      ],
      'index_is_deleted_sort_name' => [
        'name' => 'index_is_deleted_sort_name',
        'field' => [
          0 => 'is_deleted',
          1 => 'sort_name',
          2 => 'id',
        ],
        'localizable' => FALSE,
        'sig' => 'civicrm_contact::0::is_deleted::sort_name::id',
      ],
      'index_created_date' => [
        'name' => 'index_created_date',
        'field' => [
          0 => 'created_date',
        ],
        'localizable' => FALSE,
        'sig' => 'civicrm_contact::0::created_date',
      ],
      'index_modified_date' => [
        'name' => 'index_modified_date',
        'field' => [
          0 => 'modified_date',
        ],
        'localizable' => FALSE,
        'sig' => 'civicrm_contact::0::modified_date',
      ],
    ];
    return ($localize && !empty($indices)) ? CRM_Core_DAO_AllCoreTables::multilingualize(__CLASS__, $indices) : $indices;
  }

}
