<?php

/**
 * @package CRM
 * @copyright CiviCRM LLC https://civicrm.org/licensing
 *
 * Generated from xml/schema/CRM/Contact/Group.xml
 * DO NOT EDIT.  Generated by CRM_Core_CodeGen
 * (GenCodeChecksum:921454d1f48dbba0feec6e1dcfd0fd76)
 */

/**
 * Database access object for the Group entity.
 */
class CRM_Contact_DAO_Group extends CRM_Core_DAO {
  const EXT = 'civicrm';
  const TABLE_ADDED = '1.1';

  /**
   * Static instance to hold the table name.
   *
   * @var string
   */
  public static $_tableName = 'civicrm_group';

  /**
   * Icon associated with this entity.
   *
   * @var string
   */
  public static $_icon = 'fa-users';

  /**
   * Field to show when displaying a record.
   *
   * @var string
   */
  public static $_labelField = 'title';

  /**
   * Should CiviCRM log any modifications to this table in the civicrm_log table.
   *
   * @var bool
   */
  public static $_log = TRUE;

  /**
   * Paths for accessing this entity in the UI.
   *
   * @var string[]
   */
  protected static $_paths = [
    'add' => 'civicrm/group/add?reset=1',
    'view' => 'civicrm/group/search?force=1&context=smog&gid=[id]&component_mode=1',
    'update' => 'civicrm/group/edit?reset=1&action=update&id=[id]',
    'delete' => 'civicrm/group/edit?reset=1&action=delete&id=[id]',
    'browse' => 'civicrm/group',
  ];

  /**
   * Group ID
   *
   * @var int|string|null
   *   (SQL type: int unsigned)
   *   Note that values will be retrieved from the database as a string.
   */
  public $id;

  /**
   * Internal name of Group.
   *
   * @var string
   *   (SQL type: varchar(64))
   *   Note that values will be retrieved from the database as a string.
   */
  public $name;

  /**
   * Name of Group.
   *
   * @var string
   *   (SQL type: varchar(255))
   *   Note that values will be retrieved from the database as a string.
   */
  public $title;

  /**
   * Optional verbose description of the group.
   *
   * @var string|null
   *   (SQL type: text)
   *   Note that values will be retrieved from the database as a string.
   */
  public $description;

  /**
   * Module or process which created this group.
   *
   * @var string|null
   *   (SQL type: varchar(64))
   *   Note that values will be retrieved from the database as a string.
   */
  public $source;

  /**
   * FK to saved search table.
   *
   * @var int|string|null
   *   (SQL type: int unsigned)
   *   Note that values will be retrieved from the database as a string.
   */
  public $saved_search_id;

  /**
   * Is this group active?
   *
   * @var bool|string
   *   (SQL type: tinyint)
   *   Note that values will be retrieved from the database as a string.
   */
  public $is_active;

  /**
   * In what context(s) is this field visible.
   *
   * @var string|null
   *   (SQL type: varchar(24))
   *   Note that values will be retrieved from the database as a string.
   */
  public $visibility;

  /**
   * the sql where clause if a saved search acl
   *
   * @var string|null
   *   (SQL type: text)
   *   Note that values will be retrieved from the database as a string.
   * @deprecated
   */
  public $where_clause;

  /**
   * the tables to be included in a select data
   *
   * @var string|null
   *   (SQL type: text)
   *   Note that values will be retrieved from the database as a string.
   * @deprecated
   */
  public $select_tables;

  /**
   * the tables to be included in the count statement
   *
   * @var string|null
   *   (SQL type: text)
   *   Note that values will be retrieved from the database as a string.
   * @deprecated
   */
  public $where_tables;

  /**
   * FK to group type
   *
   * @var string|null
   *   (SQL type: varchar(128))
   *   Note that values will be retrieved from the database as a string.
   */
  public $group_type;

  /**
   * Date when we created the cache for a smart group
   *
   * @var string
   *   (SQL type: timestamp)
   *   Note that values will be retrieved from the database as a string.
   */
  public $cache_date;

  /**
   * Seconds taken to fill smart group cache
   *
   * @var float|string
   *   (SQL type: double)
   *   Note that values will be retrieved from the database as a string.
   */
  public $cache_fill_took;

  /**
   * Unused deprecated column.
   *
   * @var string
   *   (SQL type: timestamp)
   *   Note that values will be retrieved from the database as a string.
   * @deprecated
   */
  public $refresh_date;

  /**
   * List of parent groups
   *
   * @var string|null
   *   (SQL type: text)
   *   Note that values will be retrieved from the database as a string.
   */
  public $parents;

  /**
   * List of child groups (calculated)
   *
   * @var string|null
   *   (SQL type: text)
   *   Note that values will be retrieved from the database as a string.
   */
  public $children;

  /**
   * Is this group hidden?
   *
   * @var bool|string
   *   (SQL type: tinyint)
   *   Note that values will be retrieved from the database as a string.
   */
  public $is_hidden;

  /**
   * @var bool|string
   *   (SQL type: tinyint)
   *   Note that values will be retrieved from the database as a string.
   */
  public $is_reserved;

  /**
   * FK to contact table.
   *
   * @var int|string|null
   *   (SQL type: int unsigned)
   *   Note that values will be retrieved from the database as a string.
   */
  public $created_id;

  /**
   * FK to contact table.
   *
   * @var int|string|null
   *   (SQL type: int unsigned)
   *   Note that values will be retrieved from the database as a string.
   */
  public $modified_id;

  /**
   * Alternative public title for this Group.
   *
   * @var string
   *   (SQL type: varchar(255))
   *   Note that values will be retrieved from the database as a string.
   */
  public $frontend_title;

  /**
   * Alternative public description of the group.
   *
   * @var string|null
   *   (SQL type: text)
   *   Note that values will be retrieved from the database as a string.
   */
  public $frontend_description;

  /**
   * Class constructor.
   */
  public function __construct() {
    $this->__table = 'civicrm_group';
    parent::__construct();
  }

  /**
   * Returns localized title of this entity.
   *
   * @param bool $plural
   *   Whether to return the plural version of the title.
   */
  public static function getEntityTitle($plural = FALSE) {
    return $plural ? ts('Groups') : ts('Group');
  }

  /**
   * Returns all the column names of this table
   *
   * @return array
   */
  public static function &fields() {
    if (!isset(Civi::$statics[__CLASS__]['fields'])) {
      Civi::$statics[__CLASS__]['fields'] = [
        'id' => [
          'name' => 'id',
          'type' => CRM_Utils_Type::T_INT,
          'title' => ts('Group ID'),
          'description' => ts('Group ID'),
          'required' => TRUE,
          'usage' => [
            'import' => FALSE,
            'export' => FALSE,
            'duplicate_matching' => FALSE,
            'token' => FALSE,
          ],
          'where' => 'civicrm_group.id',
          'table_name' => 'civicrm_group',
          'entity' => 'Group',
          'bao' => 'CRM_Contact_BAO_Group',
          'localizable' => 0,
          'html' => [
            'type' => 'Number',
          ],
          'readonly' => TRUE,
          'add' => '1.1',
        ],
        'name' => [
          'name' => 'name',
          'type' => CRM_Utils_Type::T_STRING,
          'title' => ts('Group Name'),
          'description' => ts('Internal name of Group.'),
          'required' => TRUE,
          'maxlength' => 64,
          'size' => CRM_Utils_Type::BIG,
          'usage' => [
            'import' => FALSE,
            'export' => FALSE,
            'duplicate_matching' => FALSE,
            'token' => FALSE,
          ],
          'where' => 'civicrm_group.name',
          'table_name' => 'civicrm_group',
          'entity' => 'Group',
          'bao' => 'CRM_Contact_BAO_Group',
          'localizable' => 0,
          'add' => '1.1',
        ],
        'title' => [
          'name' => 'title',
          'type' => CRM_Utils_Type::T_STRING,
          'title' => ts('Group Title'),
          'description' => ts('Name of Group.'),
          'required' => TRUE,
          'maxlength' => 255,
          'size' => CRM_Utils_Type::HUGE,
          'usage' => [
            'import' => FALSE,
            'export' => FALSE,
            'duplicate_matching' => FALSE,
            'token' => FALSE,
          ],
          'where' => 'civicrm_group.title',
          'table_name' => 'civicrm_group',
          'entity' => 'Group',
          'bao' => 'CRM_Contact_BAO_Group',
          'localizable' => 1,
          'html' => [
            'type' => 'Text',
          ],
          'add' => '1.1',
        ],
        'description' => [
          'name' => 'description',
          'type' => CRM_Utils_Type::T_TEXT,
          'title' => ts('Group Description'),
          'description' => ts('Optional verbose description of the group.'),
          'rows' => 2,
          'cols' => 60,
          'usage' => [
            'import' => FALSE,
            'export' => FALSE,
            'duplicate_matching' => FALSE,
            'token' => FALSE,
          ],
          'where' => 'civicrm_group.description',
          'table_name' => 'civicrm_group',
          'entity' => 'Group',
          'bao' => 'CRM_Contact_BAO_Group',
          'localizable' => 0,
          'html' => [
            'type' => 'TextArea',
          ],
          'add' => '1.1',
        ],
        'source' => [
          'name' => 'source',
          'type' => CRM_Utils_Type::T_STRING,
          'title' => ts('Group Source'),
          'description' => ts('Module or process which created this group.'),
          'maxlength' => 64,
          'size' => CRM_Utils_Type::BIG,
          'usage' => [
            'import' => FALSE,
            'export' => FALSE,
            'duplicate_matching' => FALSE,
            'token' => FALSE,
          ],
          'where' => 'civicrm_group.source',
          'table_name' => 'civicrm_group',
          'entity' => 'Group',
          'bao' => 'CRM_Contact_BAO_Group',
          'localizable' => 0,
          'add' => '1.1',
        ],
        'saved_search_id' => [
          'name' => 'saved_search_id',
          'type' => CRM_Utils_Type::T_INT,
          'title' => ts('Saved Search ID'),
          'description' => ts('FK to saved search table.'),
          'usage' => [
            'import' => FALSE,
            'export' => FALSE,
            'duplicate_matching' => FALSE,
            'token' => FALSE,
          ],
          'where' => 'civicrm_group.saved_search_id',
          'table_name' => 'civicrm_group',
          'entity' => 'Group',
          'bao' => 'CRM_Contact_BAO_Group',
          'localizable' => 0,
          'FKClassName' => 'CRM_Contact_DAO_SavedSearch',
          'FKColumnName' => 'id',
          'html' => [
            'label' => ts("Saved Search"),
          ],
          'add' => '1.1',
        ],
        'is_active' => [
          'name' => 'is_active',
          'type' => CRM_Utils_Type::T_BOOLEAN,
          'title' => ts('Group Enabled'),
          'description' => ts('Is this group active?'),
          'required' => TRUE,
          'usage' => [
            'import' => FALSE,
            'export' => FALSE,
            'duplicate_matching' => FALSE,
            'token' => FALSE,
          ],
          'where' => 'civicrm_group.is_active',
          'default' => '1',
          'table_name' => 'civicrm_group',
          'entity' => 'Group',
          'bao' => 'CRM_Contact_BAO_Group',
          'localizable' => 0,
          'html' => [
            'type' => 'CheckBox',
            'label' => ts("Enabled"),
          ],
          'add' => '1.1',
        ],
        'visibility' => [
          'name' => 'visibility',
          'type' => CRM_Utils_Type::T_STRING,
          'title' => ts('Group Visibility Setting'),
          'description' => ts('In what context(s) is this field visible.'),
          'maxlength' => 24,
          'size' => CRM_Utils_Type::MEDIUM,
          'usage' => [
            'import' => FALSE,
            'export' => FALSE,
            'duplicate_matching' => FALSE,
            'token' => FALSE,
          ],
          'where' => 'civicrm_group.visibility',
          'default' => 'User and User Admin Only',
          'table_name' => 'civicrm_group',
          'entity' => 'Group',
          'bao' => 'CRM_Contact_BAO_Group',
          'localizable' => 0,
          'html' => [
            'type' => 'Select',
          ],
          'pseudoconstant' => [
            'callback' => 'CRM_Core_SelectValues::groupVisibility',
          ],
          'add' => '1.2',
        ],
        'where_clause' => [
          'name' => 'where_clause',
          'type' => CRM_Utils_Type::T_TEXT,
          'title' => ts('Group Where Clause'),
          'description' => ts('the sql where clause if a saved search acl'),
          'usage' => [
            'import' => FALSE,
            'export' => FALSE,
            'duplicate_matching' => FALSE,
            'token' => FALSE,
          ],
          'where' => 'civicrm_group.where_clause',
          'table_name' => 'civicrm_group',
          'entity' => 'Group',
          'bao' => 'CRM_Contact_BAO_Group',
          'localizable' => 0,
          'deprecated' => TRUE,
          'readonly' => TRUE,
          'add' => '1.6',
        ],
        'select_tables' => [
          'name' => 'select_tables',
          'type' => CRM_Utils_Type::T_TEXT,
          'title' => ts('Tables For Select Clause'),
          'description' => ts('the tables to be included in a select data'),
          'usage' => [
            'import' => FALSE,
            'export' => FALSE,
            'duplicate_matching' => FALSE,
            'token' => FALSE,
          ],
          'where' => 'civicrm_group.select_tables',
          'table_name' => 'civicrm_group',
          'entity' => 'Group',
          'bao' => 'CRM_Contact_BAO_Group',
          'localizable' => 0,
          'serialize' => self::SERIALIZE_PHP,
          'deprecated' => TRUE,
          'readonly' => TRUE,
          'add' => '1.6',
        ],
        'where_tables' => [
          'name' => 'where_tables',
          'type' => CRM_Utils_Type::T_TEXT,
          'title' => ts('Tables For Where Clause'),
          'description' => ts('the tables to be included in the count statement'),
          'usage' => [
            'import' => FALSE,
            'export' => FALSE,
            'duplicate_matching' => FALSE,
            'token' => FALSE,
          ],
          'where' => 'civicrm_group.where_tables',
          'table_name' => 'civicrm_group',
          'entity' => 'Group',
          'bao' => 'CRM_Contact_BAO_Group',
          'localizable' => 0,
          'serialize' => self::SERIALIZE_PHP,
          'deprecated' => TRUE,
          'readonly' => TRUE,
          'add' => '1.6',
        ],
        'group_type' => [
          'name' => 'group_type',
          'type' => CRM_Utils_Type::T_STRING,
          'title' => ts('Group Type'),
          'description' => ts('FK to group type'),
          'maxlength' => 128,
          'size' => CRM_Utils_Type::HUGE,
          'usage' => [
            'import' => FALSE,
            'export' => FALSE,
            'duplicate_matching' => FALSE,
            'token' => FALSE,
          ],
          'where' => 'civicrm_group.group_type',
          'table_name' => 'civicrm_group',
          'entity' => 'Group',
          'bao' => 'CRM_Contact_BAO_Group',
          'localizable' => 0,
          'serialize' => self::SERIALIZE_SEPARATOR_BOOKEND,
          'html' => [
            'type' => 'Select',
          ],
          'pseudoconstant' => [
            'optionGroupName' => 'group_type',
            'optionEditPath' => 'civicrm/admin/options/group_type',
          ],
          'add' => '1.9',
        ],
        'cache_date' => [
          'name' => 'cache_date',
          'type' => CRM_Utils_Type::T_TIMESTAMP,
          'title' => ts('Group Cache Date'),
          'description' => ts('Date when we created the cache for a smart group'),
          'required' => FALSE,
          'usage' => [
            'import' => FALSE,
            'export' => FALSE,
            'duplicate_matching' => FALSE,
            'token' => FALSE,
          ],
          'where' => 'civicrm_group.cache_date',
          'table_name' => 'civicrm_group',
          'entity' => 'Group',
          'bao' => 'CRM_Contact_BAO_Group',
          'localizable' => 0,
          'readonly' => TRUE,
          'add' => '2.1',
        ],
        'cache_fill_took' => [
          'name' => 'cache_fill_took',
          'type' => CRM_Utils_Type::T_FLOAT,
          'title' => ts('Seconds taken by last cache fill'),
          'description' => ts('Seconds taken to fill smart group cache'),
          'required' => FALSE,
          'usage' => [
            'import' => FALSE,
            'export' => FALSE,
            'duplicate_matching' => FALSE,
            'token' => FALSE,
          ],
          'where' => 'civicrm_group.cache_fill_took',
          'table_name' => 'civicrm_group',
          'entity' => 'Group',
          'bao' => 'CRM_Contact_BAO_Group',
          'localizable' => 0,
          'readonly' => TRUE,
          'add' => '5.67',
        ],
        'refresh_date' => [
          'name' => 'refresh_date',
          'type' => CRM_Utils_Type::T_TIMESTAMP,
          'title' => ts('Next Group Refresh Time'),
          'description' => ts('Unused deprecated column.'),
          'required' => FALSE,
          'usage' => [
            'import' => FALSE,
            'export' => FALSE,
            'duplicate_matching' => FALSE,
            'token' => FALSE,
          ],
          'where' => 'civicrm_group.refresh_date',
          'table_name' => 'civicrm_group',
          'entity' => 'Group',
          'bao' => 'CRM_Contact_BAO_Group',
          'localizable' => 0,
          'deprecated' => TRUE,
          'readonly' => TRUE,
          'add' => '4.3',
        ],
        'parents' => [
          'name' => 'parents',
          'type' => CRM_Utils_Type::T_TEXT,
          'title' => ts('Group Parents'),
          'description' => ts('List of parent groups'),
          'usage' => [
            'import' => FALSE,
            'export' => FALSE,
            'duplicate_matching' => FALSE,
            'token' => FALSE,
          ],
          'where' => 'civicrm_group.parents',
          'table_name' => 'civicrm_group',
          'entity' => 'Group',
          'bao' => 'CRM_Contact_BAO_Group',
          'localizable' => 0,
          'serialize' => self::SERIALIZE_COMMA,
          'html' => [
            'type' => 'EntityRef',
            'label' => ts("Parent Groups"),
          ],
          'pseudoconstant' => [
            'table' => 'civicrm_group',
            'keyColumn' => 'id',
            'labelColumn' => 'title',
            'nameColumn' => 'name',
            'prefetch' => 'disabled',
          ],
          'add' => '2.1',
        ],
        'children' => [
          'name' => 'children',
          'type' => CRM_Utils_Type::T_TEXT,
          'title' => ts('Group Children'),
          'description' => ts('List of child groups (calculated)'),
          'usage' => [
            'import' => FALSE,
            'export' => FALSE,
            'duplicate_matching' => FALSE,
            'token' => FALSE,
          ],
          'where' => 'civicrm_group.children',
          'table_name' => 'civicrm_group',
          'entity' => 'Group',
          'bao' => 'CRM_Contact_BAO_Group',
          'localizable' => 0,
          'serialize' => self::SERIALIZE_COMMA,
          'html' => [
            'type' => 'EntityRef',
            'label' => ts("Child Groups"),
          ],
          'pseudoconstant' => [
            'table' => 'civicrm_group',
            'keyColumn' => 'id',
            'labelColumn' => 'title',
            'nameColumn' => 'name',
            'prefetch' => 'disabled',
          ],
          'readonly' => TRUE,
          'add' => '2.1',
        ],
        'is_hidden' => [
          'name' => 'is_hidden',
          'type' => CRM_Utils_Type::T_BOOLEAN,
          'title' => ts('Group is Hidden'),
          'description' => ts('Is this group hidden?'),
          'required' => TRUE,
          'usage' => [
            'import' => FALSE,
            'export' => FALSE,
            'duplicate_matching' => FALSE,
            'token' => FALSE,
          ],
          'where' => 'civicrm_group.is_hidden',
          'default' => '0',
          'table_name' => 'civicrm_group',
          'entity' => 'Group',
          'bao' => 'CRM_Contact_BAO_Group',
          'localizable' => 0,
          'add' => '2.2',
        ],
        'is_reserved' => [
          'name' => 'is_reserved',
          'type' => CRM_Utils_Type::T_BOOLEAN,
          'title' => ts('Group is Reserved'),
          'required' => TRUE,
          'usage' => [
            'import' => FALSE,
            'export' => FALSE,
            'duplicate_matching' => FALSE,
            'token' => FALSE,
          ],
          'where' => 'civicrm_group.is_reserved',
          'default' => '0',
          'table_name' => 'civicrm_group',
          'entity' => 'Group',
          'bao' => 'CRM_Contact_BAO_Group',
          'localizable' => 0,
          'add' => '4.2',
        ],
        'created_id' => [
          'name' => 'created_id',
          'type' => CRM_Utils_Type::T_INT,
          'title' => ts('Created By Contact ID'),
          'description' => ts('FK to contact table.'),
          'usage' => [
            'import' => FALSE,
            'export' => FALSE,
            'duplicate_matching' => FALSE,
            'token' => FALSE,
          ],
          'where' => 'civicrm_group.created_id',
          'table_name' => 'civicrm_group',
          'entity' => 'Group',
          'bao' => 'CRM_Contact_BAO_Group',
          'localizable' => 0,
          'FKClassName' => 'CRM_Contact_DAO_Contact',
          'FKColumnName' => 'id',
          'html' => [
            'label' => ts("Created By"),
          ],
          'add' => '4.3',
        ],
        'modified_id' => [
          'name' => 'modified_id',
          'type' => CRM_Utils_Type::T_INT,
          'title' => ts('Modified By Contact ID'),
          'description' => ts('FK to contact table.'),
          'usage' => [
            'import' => FALSE,
            'export' => FALSE,
            'duplicate_matching' => FALSE,
            'token' => FALSE,
          ],
          'where' => 'civicrm_group.modified_id',
          'table_name' => 'civicrm_group',
          'entity' => 'Group',
          'bao' => 'CRM_Contact_BAO_Group',
          'localizable' => 0,
          'FKClassName' => 'CRM_Contact_DAO_Contact',
          'FKColumnName' => 'id',
          'html' => [
            'label' => ts("Modified By"),
          ],
          'readonly' => TRUE,
          'add' => '4.5',
        ],
        'frontend_title' => [
          'name' => 'frontend_title',
          'type' => CRM_Utils_Type::T_STRING,
          'title' => ts('Public Group Title'),
          'description' => ts('Alternative public title for this Group.'),
          'required' => TRUE,
          'maxlength' => 255,
          'size' => CRM_Utils_Type::HUGE,
          'usage' => [
            'import' => FALSE,
            'export' => FALSE,
            'duplicate_matching' => FALSE,
            'token' => FALSE,
          ],
          'where' => 'civicrm_group.frontend_title',
          'table_name' => 'civicrm_group',
          'entity' => 'Group',
          'bao' => 'CRM_Contact_BAO_Group',
          'localizable' => 1,
          'html' => [
            'type' => 'Text',
          ],
          'add' => '5.31',
        ],
        'frontend_description' => [
          'name' => 'frontend_description',
          'type' => CRM_Utils_Type::T_TEXT,
          'title' => ts('Public Group Description'),
          'description' => ts('Alternative public description of the group.'),
          'rows' => 2,
          'cols' => 60,
          'usage' => [
            'import' => FALSE,
            'export' => FALSE,
            'duplicate_matching' => FALSE,
            'token' => FALSE,
          ],
          'where' => 'civicrm_group.frontend_description',
          'default' => NULL,
          'table_name' => 'civicrm_group',
          'entity' => 'Group',
          'bao' => 'CRM_Contact_BAO_Group',
          'localizable' => 1,
          'html' => [
            'type' => 'TextArea',
          ],
          'add' => '5.31',
        ],
      ];
      CRM_Core_DAO_AllCoreTables::invoke(__CLASS__, 'fields_callback', Civi::$statics[__CLASS__]['fields']);
    }
    return Civi::$statics[__CLASS__]['fields'];
  }

  /**
   * Returns the list of fields that can be imported
   *
   * @param bool $prefix
   *
   * @return array
   */
  public static function &import($prefix = FALSE) {
    $r = CRM_Core_DAO_AllCoreTables::getImports(__CLASS__, 'group', $prefix, []);
    return $r;
  }

  /**
   * Returns the list of fields that can be exported
   *
   * @param bool $prefix
   *
   * @return array
   */
  public static function &export($prefix = FALSE) {
    $r = CRM_Core_DAO_AllCoreTables::getExports(__CLASS__, 'group', $prefix, []);
    return $r;
  }

  /**
   * Returns the list of indices
   *
   * @param bool $localize
   *
   * @return array
   */
  public static function indices($localize = TRUE) {
    $indices = [
      'UI_cache_date' => [
        'name' => 'UI_cache_date',
        'field' => [
          0 => 'cache_date',
        ],
        'localizable' => FALSE,
        'sig' => 'civicrm_group::0::cache_date',
      ],
      'index_group_type' => [
        'name' => 'index_group_type',
        'field' => [
          0 => 'group_type',
        ],
        'localizable' => FALSE,
        'sig' => 'civicrm_group::0::group_type',
      ],
      'UI_title' => [
        'name' => 'UI_title',
        'field' => [
          0 => 'title',
        ],
        'localizable' => TRUE,
        'unique' => TRUE,
        'sig' => 'civicrm_group::1::title',
      ],
      'UI_name' => [
        'name' => 'UI_name',
        'field' => [
          0 => 'name',
        ],
        'localizable' => FALSE,
        'unique' => TRUE,
        'sig' => 'civicrm_group::1::name',
      ],
    ];
    return ($localize && !empty($indices)) ? CRM_Core_DAO_AllCoreTables::multilingualize(__CLASS__, $indices) : $indices;
  }

}
