<?php

/**
 * @package CRM
 * @copyright CiviCRM LLC https://civicrm.org/licensing
 *
 * Generated from xml/schema/CRM/Core/OptionGroup.xml
 * DO NOT EDIT.  Generated by CRM_Core_CodeGen
 * (GenCodeChecksum:f4b6fc8c5d5536073aa4a4d643031af4)
 */

/**
 * Database access object for the OptionGroup entity.
 */
class CRM_Core_DAO_OptionGroup extends CRM_Core_DAO {
  const EXT = 'civicrm';
  const TABLE_ADDED = '1.5';

  /**
   * Static instance to hold the table name.
   *
   * @var string
   */
  public static $_tableName = 'civicrm_option_group';

  /**
   * Field to show when displaying a record.
   *
   * @var string
   */
  public static $_labelField = 'title';

  /**
   * Should CiviCRM log any modifications to this table in the civicrm_log table.
   *
   * @var bool
   */
  public static $_log = TRUE;

  /**
   * Paths for accessing this entity in the UI.
   *
   * @var string[]
   */
  protected static $_paths = [
    'add' => 'civicrm/admin/options?action=add&reset=1',
    'update' => 'civicrm/admin/options?action=update&reset=1&id=[id]',
  ];

  /**
   * Option Group ID
   *
   * @var int|string|null
   *   (SQL type: int unsigned)
   *   Note that values will be retrieved from the database as a string.
   */
  public $id;

  /**
   * Option group name. Used as selection key by class properties which lookup options in civicrm_option_value.
   *
   * @var string
   *   (SQL type: varchar(64))
   *   Note that values will be retrieved from the database as a string.
   */
  public $name;

  /**
   * Option Group title.
   *
   * @var string|null
   *   (SQL type: varchar(255))
   *   Note that values will be retrieved from the database as a string.
   */
  public $title;

  /**
   * Option group description.
   *
   * @var string|null
   *   (SQL type: text)
   *   Note that values will be retrieved from the database as a string.
   */
  public $description;

  /**
   * Type of data stored by this option group.
   *
   * @var string|null
   *   (SQL type: varchar(128))
   *   Note that values will be retrieved from the database as a string.
   */
  public $data_type;

  /**
   * Is this a predefined system option group (i.e. it can not be deleted)?
   *
   * @var bool|string
   *   (SQL type: tinyint)
   *   Note that values will be retrieved from the database as a string.
   */
  public $is_reserved;

  /**
   * Is this option group active?
   *
   * @var bool|string
   *   (SQL type: tinyint)
   *   Note that values will be retrieved from the database as a string.
   */
  public $is_active;

  /**
   * A lock to remove the ability to add new options via the UI.
   *
   * @var bool|string
   *   (SQL type: tinyint)
   *   Note that values will be retrieved from the database as a string.
   */
  public $is_locked;

  /**
   * Which optional columns from the option_value table are in use by this group.
   *
   * @var string|null
   *   (SQL type: varchar(128))
   *   Note that values will be retrieved from the database as a string.
   */
  public $option_value_fields;

  /**
   * Class constructor.
   */
  public function __construct() {
    $this->__table = 'civicrm_option_group';
    parent::__construct();
  }

  /**
   * Returns localized title of this entity.
   *
   * @param bool $plural
   *   Whether to return the plural version of the title.
   */
  public static function getEntityTitle($plural = FALSE) {
    return $plural ? ts('Option Groups') : ts('Option Group');
  }

  /**
   * Returns all the column names of this table
   *
   * @return array
   */
  public static function &fields() {
    if (!isset(Civi::$statics[__CLASS__]['fields'])) {
      Civi::$statics[__CLASS__]['fields'] = [
        'id' => [
          'name' => 'id',
          'type' => CRM_Utils_Type::T_INT,
          'title' => ts('Option Group ID'),
          'description' => ts('Option Group ID'),
          'required' => TRUE,
          'usage' => [
            'import' => FALSE,
            'export' => FALSE,
            'duplicate_matching' => FALSE,
            'token' => FALSE,
          ],
          'where' => 'civicrm_option_group.id',
          'table_name' => 'civicrm_option_group',
          'entity' => 'OptionGroup',
          'bao' => 'CRM_Core_BAO_OptionGroup',
          'localizable' => 0,
          'html' => [
            'type' => 'Number',
          ],
          'readonly' => TRUE,
          'add' => '1.5',
        ],
        'name' => [
          'name' => 'name',
          'type' => CRM_Utils_Type::T_STRING,
          'title' => ts('Option Group Name'),
          'description' => ts('Option group name. Used as selection key by class properties which lookup options in civicrm_option_value.'),
          'required' => TRUE,
          'maxlength' => 64,
          'size' => CRM_Utils_Type::BIG,
          'usage' => [
            'import' => FALSE,
            'export' => FALSE,
            'duplicate_matching' => FALSE,
            'token' => FALSE,
          ],
          'where' => 'civicrm_option_group.name',
          'table_name' => 'civicrm_option_group',
          'entity' => 'OptionGroup',
          'bao' => 'CRM_Core_BAO_OptionGroup',
          'localizable' => 0,
          'html' => [
            'type' => 'Text',
          ],
          'add' => '1.5',
        ],
        'title' => [
          'name' => 'title',
          'type' => CRM_Utils_Type::T_STRING,
          'title' => ts('Option Group Title'),
          'description' => ts('Option Group title.'),
          'maxlength' => 255,
          'size' => CRM_Utils_Type::HUGE,
          'usage' => [
            'import' => FALSE,
            'export' => FALSE,
            'duplicate_matching' => FALSE,
            'token' => FALSE,
          ],
          'where' => 'civicrm_option_group.title',
          'table_name' => 'civicrm_option_group',
          'entity' => 'OptionGroup',
          'bao' => 'CRM_Core_BAO_OptionGroup',
          'localizable' => 1,
          'html' => [
            'type' => 'Text',
          ],
          'add' => '1.5',
        ],
        'description' => [
          'name' => 'description',
          'type' => CRM_Utils_Type::T_TEXT,
          'title' => ts('Option Group Description'),
          'description' => ts('Option group description.'),
          'usage' => [
            'import' => FALSE,
            'export' => FALSE,
            'duplicate_matching' => FALSE,
            'token' => FALSE,
          ],
          'where' => 'civicrm_option_group.description',
          'table_name' => 'civicrm_option_group',
          'entity' => 'OptionGroup',
          'bao' => 'CRM_Core_BAO_OptionGroup',
          'localizable' => 1,
          'html' => [
            'type' => 'Text',
          ],
          'add' => '1.5',
        ],
        'data_type' => [
          'name' => 'data_type',
          'type' => CRM_Utils_Type::T_STRING,
          'title' => ts('Data Type'),
          'description' => ts('Type of data stored by this option group.'),
          'maxlength' => 128,
          'size' => CRM_Utils_Type::HUGE,
          'usage' => [
            'import' => FALSE,
            'export' => FALSE,
            'duplicate_matching' => FALSE,
            'token' => FALSE,
          ],
          'where' => 'civicrm_option_group.data_type',
          'table_name' => 'civicrm_option_group',
          'entity' => 'OptionGroup',
          'bao' => 'CRM_Core_BAO_OptionGroup',
          'localizable' => 0,
          'pseudoconstant' => [
            'callback' => 'CRM_Utils_Type::dataTypes',
          ],
          'add' => '4.7',
        ],
        'is_reserved' => [
          'name' => 'is_reserved',
          'type' => CRM_Utils_Type::T_BOOLEAN,
          'title' => ts('Option Group Is Reserved'),
          'description' => ts('Is this a predefined system option group (i.e. it can not be deleted)?'),
          'required' => TRUE,
          'usage' => [
            'import' => FALSE,
            'export' => FALSE,
            'duplicate_matching' => FALSE,
            'token' => FALSE,
          ],
          'where' => 'civicrm_option_group.is_reserved',
          'default' => '1',
          'table_name' => 'civicrm_option_group',
          'entity' => 'OptionGroup',
          'bao' => 'CRM_Core_BAO_OptionGroup',
          'localizable' => 0,
          'html' => [
            'type' => 'CheckBox',
            'label' => ts("Reserved"),
          ],
          'add' => '1.5',
        ],
        'is_active' => [
          'name' => 'is_active',
          'type' => CRM_Utils_Type::T_BOOLEAN,
          'title' => ts('Enabled'),
          'description' => ts('Is this option group active?'),
          'required' => TRUE,
          'usage' => [
            'import' => FALSE,
            'export' => FALSE,
            'duplicate_matching' => FALSE,
            'token' => FALSE,
          ],
          'where' => 'civicrm_option_group.is_active',
          'default' => '1',
          'table_name' => 'civicrm_option_group',
          'entity' => 'OptionGroup',
          'bao' => 'CRM_Core_BAO_OptionGroup',
          'localizable' => 0,
          'html' => [
            'type' => 'CheckBox',
            'label' => ts("Enabled"),
          ],
          'add' => '1.5',
        ],
        'is_locked' => [
          'name' => 'is_locked',
          'type' => CRM_Utils_Type::T_BOOLEAN,
          'title' => ts('Option Group Is Locked'),
          'description' => ts('A lock to remove the ability to add new options via the UI.'),
          'required' => TRUE,
          'usage' => [
            'import' => FALSE,
            'export' => FALSE,
            'duplicate_matching' => FALSE,
            'token' => FALSE,
          ],
          'where' => 'civicrm_option_group.is_locked',
          'default' => '0',
          'table_name' => 'civicrm_option_group',
          'entity' => 'OptionGroup',
          'bao' => 'CRM_Core_BAO_OptionGroup',
          'localizable' => 0,
          'html' => [
            'type' => 'CheckBox',
            'label' => ts("Locked"),
          ],
          'add' => '4.5',
        ],
        'option_value_fields' => [
          'name' => 'option_value_fields',
          'type' => CRM_Utils_Type::T_STRING,
          'title' => ts('Option Value Fields'),
          'description' => ts('Which optional columns from the option_value table are in use by this group.'),
          'maxlength' => 128,
          'size' => CRM_Utils_Type::HUGE,
          'usage' => [
            'import' => FALSE,
            'export' => FALSE,
            'duplicate_matching' => FALSE,
            'token' => FALSE,
          ],
          'where' => 'civicrm_option_group.option_value_fields',
          'default' => 'name,label,description',
          'table_name' => 'civicrm_option_group',
          'entity' => 'OptionGroup',
          'bao' => 'CRM_Core_BAO_OptionGroup',
          'localizable' => 0,
          'serialize' => self::SERIALIZE_COMMA,
          'pseudoconstant' => [
            'callback' => 'CRM_Core_SelectValues::optionValueFields',
          ],
          'add' => '5.49',
        ],
      ];
      CRM_Core_DAO_AllCoreTables::invoke(__CLASS__, 'fields_callback', Civi::$statics[__CLASS__]['fields']);
    }
    return Civi::$statics[__CLASS__]['fields'];
  }

  /**
   * Returns the list of fields that can be imported
   *
   * @param bool $prefix
   *
   * @return array
   */
  public static function &import($prefix = FALSE) {
    $r = CRM_Core_DAO_AllCoreTables::getImports(__CLASS__, 'option_group', $prefix, []);
    return $r;
  }

  /**
   * Returns the list of fields that can be exported
   *
   * @param bool $prefix
   *
   * @return array
   */
  public static function &export($prefix = FALSE) {
    $r = CRM_Core_DAO_AllCoreTables::getExports(__CLASS__, 'option_group', $prefix, []);
    return $r;
  }

  /**
   * Returns the list of indices
   *
   * @param bool $localize
   *
   * @return array
   */
  public static function indices($localize = TRUE) {
    $indices = [
      'UI_name' => [
        'name' => 'UI_name',
        'field' => [
          0 => 'name',
        ],
        'localizable' => FALSE,
        'unique' => TRUE,
        'sig' => 'civicrm_option_group::1::name',
      ],
    ];
    return ($localize && !empty($indices)) ? CRM_Core_DAO_AllCoreTables::multilingualize(__CLASS__, $indices) : $indices;
  }

}
