<?php

/**
 * @package CRM
 * @copyright CiviCRM LLC https://civicrm.org/licensing
 *
 * Generated from xml/schema/CRM/Core/UFField.xml
 * DO NOT EDIT.  Generated by CRM_Core_CodeGen
 * (GenCodeChecksum:45539bf36116ed34298bc82188fc820c)
 */

/**
 * Database access object for the UFField entity.
 */
class CRM_Core_DAO_UFField extends CRM_Core_DAO {
  const EXT = 'civicrm';
  const TABLE_ADDED = '1.1';

  /**
   * Static instance to hold the table name.
   *
   * @var string
   */
  public static $_tableName = 'civicrm_uf_field';

  /**
   * Field to show when displaying a record.
   *
   * @var string
   */
  public static $_labelField = 'label';

  /**
   * Should CiviCRM log any modifications to this table in the civicrm_log table.
   *
   * @var bool
   */
  public static $_log = TRUE;

  /**
   * Paths for accessing this entity in the UI.
   *
   * @var string[]
   */
  protected static $_paths = [
    'add' => 'civicrm/admin/uf/group/field/add?reset=1&action=add&gid=[uf_group_id]',
    'preview' => 'civicrm/admin/uf/group/preview?reset=1&gid=[uf_group_id]&fieldId=[id]',
    'update' => 'civicrm/admin/uf/group/field/update?reset=1&action=update&id=[id]',
    'delete' => 'civicrm/admin/uf/group/field/update?reset=1&action=delete&id=[id]',
    'browse' => 'civicrm/admin/uf/group/field',
  ];

  /**
   * Unique table ID
   *
   * @var int|string|null
   *   (SQL type: int unsigned)
   *   Note that values will be retrieved from the database as a string.
   */
  public $id;

  /**
   * Which form does this field belong to.
   *
   * @var int|string
   *   (SQL type: int unsigned)
   *   Note that values will be retrieved from the database as a string.
   */
  public $uf_group_id;

  /**
   * Name for CiviCRM field which is being exposed for sharing.
   *
   * @var string
   *   (SQL type: varchar(64))
   *   Note that values will be retrieved from the database as a string.
   */
  public $field_name;

  /**
   * Is this field currently shareable? If false, hide the field for all sharing contexts.
   *
   * @var bool|string
   *   (SQL type: tinyint)
   *   Note that values will be retrieved from the database as a string.
   */
  public $is_active;

  /**
   * the field is view only and not editable in user forms.
   *
   * @var bool|string
   *   (SQL type: tinyint)
   *   Note that values will be retrieved from the database as a string.
   */
  public $is_view;

  /**
   * Is this field required when included in a user or registration form?
   *
   * @var bool|string
   *   (SQL type: tinyint)
   *   Note that values will be retrieved from the database as a string.
   */
  public $is_required;

  /**
   * Controls field display order when user framework fields are displayed in registration and account editing forms.
   *
   * @var int|string
   *   (SQL type: int)
   *   Note that values will be retrieved from the database as a string.
   */
  public $weight;

  /**
   * Description and/or help text to display after this field.
   *
   * @var string|null
   *   (SQL type: text)
   *   Note that values will be retrieved from the database as a string.
   */
  public $help_post;

  /**
   * Description and/or help text to display before this field.
   *
   * @var string|null
   *   (SQL type: text)
   *   Note that values will be retrieved from the database as a string.
   */
  public $help_pre;

  /**
   * In what context(s) is this field visible.
   *
   * @var string|null
   *   (SQL type: varchar(32))
   *   Note that values will be retrieved from the database as a string.
   */
  public $visibility;

  /**
   * Is this field included as a column in the selector table?
   *
   * @var bool|string
   *   (SQL type: tinyint)
   *   Note that values will be retrieved from the database as a string.
   */
  public $in_selector;

  /**
   * Is this field included search form of profile?
   *
   * @var bool|string
   *   (SQL type: tinyint)
   *   Note that values will be retrieved from the database as a string.
   */
  public $is_searchable;

  /**
   * Location type of this mapping, if required
   *
   * @var int|string|null
   *   (SQL type: int unsigned)
   *   Note that values will be retrieved from the database as a string.
   */
  public $location_type_id;

  /**
   * Phone Type ID, if required
   *
   * @var int|string|null
   *   (SQL type: int unsigned)
   *   Note that values will be retrieved from the database as a string.
   */
  public $phone_type_id;

  /**
   * Website Type ID, if required
   *
   * @var int|string|null
   *   (SQL type: int unsigned)
   *   Note that values will be retrieved from the database as a string.
   */
  public $website_type_id;

  /**
   * To save label for fields.
   *
   * @var string
   *   (SQL type: varchar(255))
   *   Note that values will be retrieved from the database as a string.
   */
  public $label;

  /**
   * This field saves field type (ie individual,household.. field etc).
   *
   * @var string|null
   *   (SQL type: varchar(255))
   *   Note that values will be retrieved from the database as a string.
   */
  public $field_type;

  /**
   * Is this field reserved for use by some other CiviCRM functionality?
   *
   * @var bool|string
   *   (SQL type: tinyint)
   *   Note that values will be retrieved from the database as a string.
   */
  public $is_reserved;

  /**
   * Include in multi-record listing?
   *
   * @var bool|string
   *   (SQL type: tinyint)
   *   Note that values will be retrieved from the database as a string.
   */
  public $is_multi_summary;

  /**
   * Class constructor.
   */
  public function __construct() {
    $this->__table = 'civicrm_uf_field';
    parent::__construct();
  }

  /**
   * Returns localized title of this entity.
   *
   * @param bool $plural
   *   Whether to return the plural version of the title.
   */
  public static function getEntityTitle($plural = FALSE) {
    return $plural ? ts('Profile Fields') : ts('Profile Field');
  }

  /**
   * Returns all the column names of this table
   *
   * @return array
   */
  public static function &fields() {
    if (!isset(Civi::$statics[__CLASS__]['fields'])) {
      Civi::$statics[__CLASS__]['fields'] = [
        'id' => [
          'name' => 'id',
          'type' => CRM_Utils_Type::T_INT,
          'title' => ts('Profile Field ID'),
          'description' => ts('Unique table ID'),
          'required' => TRUE,
          'usage' => [
            'import' => FALSE,
            'export' => FALSE,
            'duplicate_matching' => FALSE,
            'token' => FALSE,
          ],
          'where' => 'civicrm_uf_field.id',
          'table_name' => 'civicrm_uf_field',
          'entity' => 'UFField',
          'bao' => 'CRM_Core_BAO_UFField',
          'localizable' => 0,
          'html' => [
            'type' => 'Number',
          ],
          'readonly' => TRUE,
          'add' => '1.1',
        ],
        'uf_group_id' => [
          'name' => 'uf_group_id',
          'type' => CRM_Utils_Type::T_INT,
          'title' => ts('Profile ID'),
          'description' => ts('Which form does this field belong to.'),
          'required' => TRUE,
          'usage' => [
            'import' => FALSE,
            'export' => FALSE,
            'duplicate_matching' => FALSE,
            'token' => FALSE,
          ],
          'where' => 'civicrm_uf_field.uf_group_id',
          'table_name' => 'civicrm_uf_field',
          'entity' => 'UFField',
          'bao' => 'CRM_Core_BAO_UFField',
          'localizable' => 0,
          'FKClassName' => 'CRM_Core_DAO_UFGroup',
          'FKColumnName' => 'id',
          'html' => [
            'type' => 'Select',
            'label' => ts("Profile"),
          ],
          'pseudoconstant' => [
            'table' => 'civicrm_uf_group',
            'keyColumn' => 'id',
            'labelColumn' => 'title',
          ],
          'add' => '1.1',
        ],
        'field_name' => [
          'name' => 'field_name',
          'type' => CRM_Utils_Type::T_STRING,
          'title' => ts('Profile Field Name'),
          'description' => ts('Name for CiviCRM field which is being exposed for sharing.'),
          'required' => TRUE,
          'maxlength' => 64,
          'size' => CRM_Utils_Type::BIG,
          'usage' => [
            'import' => FALSE,
            'export' => FALSE,
            'duplicate_matching' => FALSE,
            'token' => FALSE,
          ],
          'where' => 'civicrm_uf_field.field_name',
          'table_name' => 'civicrm_uf_field',
          'entity' => 'UFField',
          'bao' => 'CRM_Core_BAO_UFField',
          'localizable' => 0,
          'pseudoconstant' => [
            'callback' => 'CRM_Core_BAO_UFField::getAvailableFieldOptions',
          ],
          'add' => '1.1',
        ],
        'is_active' => [
          'name' => 'is_active',
          'type' => CRM_Utils_Type::T_BOOLEAN,
          'title' => ts('Profile Field Is Active'),
          'description' => ts('Is this field currently shareable? If false, hide the field for all sharing contexts.'),
          'required' => TRUE,
          'usage' => [
            'import' => FALSE,
            'export' => FALSE,
            'duplicate_matching' => FALSE,
            'token' => FALSE,
          ],
          'where' => 'civicrm_uf_field.is_active',
          'default' => '1',
          'table_name' => 'civicrm_uf_field',
          'entity' => 'UFField',
          'bao' => 'CRM_Core_BAO_UFField',
          'localizable' => 0,
          'html' => [
            'type' => 'CheckBox',
            'label' => ts("Enabled"),
          ],
          'add' => '1.1',
        ],
        'is_view' => [
          'name' => 'is_view',
          'type' => CRM_Utils_Type::T_BOOLEAN,
          'title' => ts('Profile Is View Only'),
          'description' => ts('the field is view only and not editable in user forms.'),
          'required' => TRUE,
          'usage' => [
            'import' => FALSE,
            'export' => FALSE,
            'duplicate_matching' => FALSE,
            'token' => FALSE,
          ],
          'where' => 'civicrm_uf_field.is_view',
          'default' => '0',
          'table_name' => 'civicrm_uf_field',
          'entity' => 'UFField',
          'bao' => 'CRM_Core_BAO_UFField',
          'localizable' => 0,
          'add' => '1.1',
        ],
        'is_required' => [
          'name' => 'is_required',
          'type' => CRM_Utils_Type::T_BOOLEAN,
          'title' => ts('Profile Field Is Required'),
          'description' => ts('Is this field required when included in a user or registration form?'),
          'required' => TRUE,
          'usage' => [
            'import' => FALSE,
            'export' => FALSE,
            'duplicate_matching' => FALSE,
            'token' => FALSE,
          ],
          'where' => 'civicrm_uf_field.is_required',
          'default' => '0',
          'table_name' => 'civicrm_uf_field',
          'entity' => 'UFField',
          'bao' => 'CRM_Core_BAO_UFField',
          'localizable' => 0,
          'add' => '1.1',
        ],
        'weight' => [
          'name' => 'weight',
          'type' => CRM_Utils_Type::T_INT,
          'title' => ts('Order'),
          'description' => ts('Controls field display order when user framework fields are displayed in registration and account editing forms.'),
          'required' => TRUE,
          'usage' => [
            'import' => FALSE,
            'export' => FALSE,
            'duplicate_matching' => FALSE,
            'token' => FALSE,
          ],
          'where' => 'civicrm_uf_field.weight',
          'default' => '1',
          'table_name' => 'civicrm_uf_field',
          'entity' => 'UFField',
          'bao' => 'CRM_Core_BAO_UFField',
          'localizable' => 0,
          'add' => '1.1',
        ],
        'help_post' => [
          'name' => 'help_post',
          'type' => CRM_Utils_Type::T_TEXT,
          'title' => ts('Profile Field Post Help'),
          'description' => ts('Description and/or help text to display after this field.'),
          'usage' => [
            'import' => FALSE,
            'export' => FALSE,
            'duplicate_matching' => FALSE,
            'token' => FALSE,
          ],
          'where' => 'civicrm_uf_field.help_post',
          'table_name' => 'civicrm_uf_field',
          'entity' => 'UFField',
          'bao' => 'CRM_Core_BAO_UFField',
          'localizable' => 1,
          'add' => '1.1',
        ],
        'help_pre' => [
          'name' => 'help_pre',
          'type' => CRM_Utils_Type::T_TEXT,
          'title' => ts('Profile Field Pre Help'),
          'description' => ts('Description and/or help text to display before this field.'),
          'usage' => [
            'import' => FALSE,
            'export' => FALSE,
            'duplicate_matching' => FALSE,
            'token' => FALSE,
          ],
          'where' => 'civicrm_uf_field.help_pre',
          'table_name' => 'civicrm_uf_field',
          'entity' => 'UFField',
          'bao' => 'CRM_Core_BAO_UFField',
          'localizable' => 1,
          'add' => '3.2',
        ],
        'visibility' => [
          'name' => 'visibility',
          'type' => CRM_Utils_Type::T_STRING,
          'title' => ts('Profile Field Visibility'),
          'description' => ts('In what context(s) is this field visible.'),
          'maxlength' => 32,
          'size' => CRM_Utils_Type::MEDIUM,
          'usage' => [
            'import' => FALSE,
            'export' => FALSE,
            'duplicate_matching' => FALSE,
            'token' => FALSE,
          ],
          'where' => 'civicrm_uf_field.visibility',
          'default' => 'User and User Admin Only',
          'table_name' => 'civicrm_uf_field',
          'entity' => 'UFField',
          'bao' => 'CRM_Core_BAO_UFField',
          'localizable' => 0,
          'html' => [
            'type' => 'Select',
          ],
          'pseudoconstant' => [
            'callback' => 'CRM_Core_SelectValues::ufVisibility',
          ],
          'add' => '1.1',
        ],
        'in_selector' => [
          'name' => 'in_selector',
          'type' => CRM_Utils_Type::T_BOOLEAN,
          'title' => ts('Profile Field Is a Filter'),
          'description' => ts('Is this field included as a column in the selector table?'),
          'required' => TRUE,
          'usage' => [
            'import' => FALSE,
            'export' => FALSE,
            'duplicate_matching' => FALSE,
            'token' => FALSE,
          ],
          'where' => 'civicrm_uf_field.in_selector',
          'default' => '0',
          'table_name' => 'civicrm_uf_field',
          'entity' => 'UFField',
          'bao' => 'CRM_Core_BAO_UFField',
          'localizable' => 0,
          'add' => '1.2',
        ],
        'is_searchable' => [
          'name' => 'is_searchable',
          'type' => CRM_Utils_Type::T_BOOLEAN,
          'title' => ts('Profile Field Is Searchable'),
          'description' => ts('Is this field included search form of profile?'),
          'required' => TRUE,
          'usage' => [
            'import' => FALSE,
            'export' => FALSE,
            'duplicate_matching' => FALSE,
            'token' => FALSE,
          ],
          'where' => 'civicrm_uf_field.is_searchable',
          'default' => '0',
          'table_name' => 'civicrm_uf_field',
          'entity' => 'UFField',
          'bao' => 'CRM_Core_BAO_UFField',
          'localizable' => 0,
          'add' => '1.4',
        ],
        'location_type_id' => [
          'name' => 'location_type_id',
          'type' => CRM_Utils_Type::T_INT,
          'title' => ts('Location Type ID'),
          'description' => ts('Location type of this mapping, if required'),
          'usage' => [
            'import' => FALSE,
            'export' => FALSE,
            'duplicate_matching' => FALSE,
            'token' => FALSE,
          ],
          'where' => 'civicrm_uf_field.location_type_id',
          'table_name' => 'civicrm_uf_field',
          'entity' => 'UFField',
          'bao' => 'CRM_Core_BAO_UFField',
          'localizable' => 0,
          'FKClassName' => 'CRM_Core_DAO_LocationType',
          'FKColumnName' => 'id',
          'html' => [
            'label' => ts("Location Type"),
          ],
          'add' => '1.3',
        ],
        'phone_type_id' => [
          'name' => 'phone_type_id',
          'type' => CRM_Utils_Type::T_INT,
          'title' => ts('Profile Field Phone Type'),
          'description' => ts('Phone Type ID, if required'),
          'usage' => [
            'import' => FALSE,
            'export' => FALSE,
            'duplicate_matching' => FALSE,
            'token' => FALSE,
          ],
          'where' => 'civicrm_uf_field.phone_type_id',
          'table_name' => 'civicrm_uf_field',
          'entity' => 'UFField',
          'bao' => 'CRM_Core_BAO_UFField',
          'localizable' => 0,
          'pseudoconstant' => [
            'optionGroupName' => 'phone_type',
            'optionEditPath' => 'civicrm/admin/options/phone_type',
          ],
          'add' => '2.2',
        ],
        'website_type_id' => [
          'name' => 'website_type_id',
          'type' => CRM_Utils_Type::T_INT,
          'title' => ts('Profile Field Website Type'),
          'description' => ts('Website Type ID, if required'),
          'usage' => [
            'import' => FALSE,
            'export' => FALSE,
            'duplicate_matching' => FALSE,
            'token' => FALSE,
          ],
          'where' => 'civicrm_uf_field.website_type_id',
          'table_name' => 'civicrm_uf_field',
          'entity' => 'UFField',
          'bao' => 'CRM_Core_BAO_UFField',
          'localizable' => 0,
          'pseudoconstant' => [
            'optionGroupName' => 'website_type',
            'optionEditPath' => 'civicrm/admin/options/website_type',
          ],
          'add' => '4.5',
        ],
        'label' => [
          'name' => 'label',
          'type' => CRM_Utils_Type::T_STRING,
          'title' => ts('Profile Field Label'),
          'description' => ts('To save label for fields.'),
          'required' => TRUE,
          'maxlength' => 255,
          'size' => CRM_Utils_Type::HUGE,
          'usage' => [
            'import' => FALSE,
            'export' => FALSE,
            'duplicate_matching' => FALSE,
            'token' => FALSE,
          ],
          'where' => 'civicrm_uf_field.label',
          'table_name' => 'civicrm_uf_field',
          'entity' => 'UFField',
          'bao' => 'CRM_Core_BAO_UFField',
          'localizable' => 1,
          'add' => '1.4',
        ],
        'field_type' => [
          'name' => 'field_type',
          'type' => CRM_Utils_Type::T_STRING,
          'title' => ts('Profile Field Type'),
          'description' => ts('This field saves field type (ie individual,household.. field etc).'),
          'maxlength' => 255,
          'size' => CRM_Utils_Type::HUGE,
          'usage' => [
            'import' => FALSE,
            'export' => FALSE,
            'duplicate_matching' => FALSE,
            'token' => FALSE,
          ],
          'where' => 'civicrm_uf_field.field_type',
          'table_name' => 'civicrm_uf_field',
          'entity' => 'UFField',
          'bao' => 'CRM_Core_BAO_UFField',
          'localizable' => 0,
          'add' => '1.4',
        ],
        'is_reserved' => [
          'name' => 'is_reserved',
          'type' => CRM_Utils_Type::T_BOOLEAN,
          'title' => ts('Profile Field Is Reserved'),
          'description' => ts('Is this field reserved for use by some other CiviCRM functionality?'),
          'required' => TRUE,
          'usage' => [
            'import' => FALSE,
            'export' => FALSE,
            'duplicate_matching' => FALSE,
            'token' => FALSE,
          ],
          'where' => 'civicrm_uf_field.is_reserved',
          'default' => '0',
          'table_name' => 'civicrm_uf_field',
          'entity' => 'UFField',
          'bao' => 'CRM_Core_BAO_UFField',
          'localizable' => 0,
          'add' => '3.0',
        ],
        'is_multi_summary' => [
          'name' => 'is_multi_summary',
          'type' => CRM_Utils_Type::T_BOOLEAN,
          'title' => ts('Profile Field Supports Multiple'),
          'description' => ts('Include in multi-record listing?'),
          'required' => TRUE,
          'usage' => [
            'import' => FALSE,
            'export' => FALSE,
            'duplicate_matching' => FALSE,
            'token' => FALSE,
          ],
          'where' => 'civicrm_uf_field.is_multi_summary',
          'default' => '0',
          'table_name' => 'civicrm_uf_field',
          'entity' => 'UFField',
          'bao' => 'CRM_Core_BAO_UFField',
          'localizable' => 0,
          'add' => '4.3',
        ],
      ];
      CRM_Core_DAO_AllCoreTables::invoke(__CLASS__, 'fields_callback', Civi::$statics[__CLASS__]['fields']);
    }
    return Civi::$statics[__CLASS__]['fields'];
  }

  /**
   * Returns the list of fields that can be imported
   *
   * @param bool $prefix
   *
   * @return array
   */
  public static function &import($prefix = FALSE) {
    $r = CRM_Core_DAO_AllCoreTables::getImports(__CLASS__, 'uf_field', $prefix, []);
    return $r;
  }

  /**
   * Returns the list of fields that can be exported
   *
   * @param bool $prefix
   *
   * @return array
   */
  public static function &export($prefix = FALSE) {
    $r = CRM_Core_DAO_AllCoreTables::getExports(__CLASS__, 'uf_field', $prefix, []);
    return $r;
  }

  /**
   * Returns the list of indices
   *
   * @param bool $localize
   *
   * @return array
   */
  public static function indices($localize = TRUE) {
    $indices = [
      'IX_website_type_id' => [
        'name' => 'IX_website_type_id',
        'field' => [
          0 => 'website_type_id',
        ],
        'localizable' => FALSE,
        'sig' => 'civicrm_uf_field::0::website_type_id',
      ],
    ];
    return ($localize && !empty($indices)) ? CRM_Core_DAO_AllCoreTables::multilingualize(__CLASS__, $indices) : $indices;
  }

}
