<?php

/**
 * @package CRM
 * @copyright CiviCRM LLC https://civicrm.org/licensing
 *
 * Generated from xml/schema/CRM/Dedupe/DedupeRule.xml
 * DO NOT EDIT.  Generated by CRM_Core_CodeGen
 * (GenCodeChecksum:303154da214602fe1fc2d69525e6c57b)
 */

/**
 * Database access object for the DedupeRule entity.
 */
class CRM_Dedupe_DAO_DedupeRule extends CRM_Core_DAO {
  const EXT = 'civicrm';
  const TABLE_ADDED = '1.8';

  /**
   * Static instance to hold the table name.
   *
   * @var string
   */
  public static $_tableName = 'civicrm_dedupe_rule';

  /**
   * Should CiviCRM log any modifications to this table in the civicrm_log table.
   *
   * @var bool
   */
  public static $_log = FALSE;

  /**
   * Unique dedupe rule id
   *
   * @var int|string|null
   *   (SQL type: int unsigned)
   *   Note that values will be retrieved from the database as a string.
   */
  public $id;

  /**
   * The id of the rule group this rule belongs to
   *
   * @var int|string
   *   (SQL type: int unsigned)
   *   Note that values will be retrieved from the database as a string.
   */
  public $dedupe_rule_group_id;

  /**
   * The name of the table this rule is about
   *
   * @var string
   *   (SQL type: varchar(64))
   *   Note that values will be retrieved from the database as a string.
   */
  public $rule_table;

  /**
   * The name of the field of the table referenced in rule_table
   *
   * @var string
   *   (SQL type: varchar(64))
   *   Note that values will be retrieved from the database as a string.
   */
  public $rule_field;

  /**
   * The length of the matching substring
   *
   * @var int|string|null
   *   (SQL type: int unsigned)
   *   Note that values will be retrieved from the database as a string.
   */
  public $rule_length;

  /**
   * The weight of the rule
   *
   * @var int|string
   *   (SQL type: int)
   *   Note that values will be retrieved from the database as a string.
   */
  public $rule_weight;

  /**
   * Class constructor.
   */
  public function __construct() {
    $this->__table = 'civicrm_dedupe_rule';
    parent::__construct();
  }

  /**
   * Returns localized title of this entity.
   *
   * @param bool $plural
   *   Whether to return the plural version of the title.
   */
  public static function getEntityTitle($plural = FALSE) {
    return $plural ? ts('Dedupe Rules') : ts('Dedupe Rule');
  }

  /**
   * Returns all the column names of this table
   *
   * @return array
   */
  public static function &fields() {
    if (!isset(Civi::$statics[__CLASS__]['fields'])) {
      Civi::$statics[__CLASS__]['fields'] = [
        'id' => [
          'name' => 'id',
          'type' => CRM_Utils_Type::T_INT,
          'title' => ts('Dedupe Rule ID'),
          'description' => ts('Unique dedupe rule id'),
          'required' => TRUE,
          'usage' => [
            'import' => FALSE,
            'export' => FALSE,
            'duplicate_matching' => FALSE,
            'token' => FALSE,
          ],
          'where' => 'civicrm_dedupe_rule.id',
          'table_name' => 'civicrm_dedupe_rule',
          'entity' => 'DedupeRule',
          'bao' => 'CRM_Dedupe_BAO_DedupeRule',
          'localizable' => 0,
          'html' => [
            'type' => 'Number',
          ],
          'readonly' => TRUE,
          'add' => '1.8',
        ],
        'dedupe_rule_group_id' => [
          'name' => 'dedupe_rule_group_id',
          'type' => CRM_Utils_Type::T_INT,
          'title' => ts('Group ID'),
          'description' => ts('The id of the rule group this rule belongs to'),
          'required' => TRUE,
          'usage' => [
            'import' => FALSE,
            'export' => FALSE,
            'duplicate_matching' => FALSE,
            'token' => FALSE,
          ],
          'where' => 'civicrm_dedupe_rule.dedupe_rule_group_id',
          'table_name' => 'civicrm_dedupe_rule',
          'entity' => 'DedupeRule',
          'bao' => 'CRM_Dedupe_BAO_DedupeRule',
          'localizable' => 0,
          'FKClassName' => 'CRM_Dedupe_DAO_DedupeRuleGroup',
          'FKColumnName' => 'id',
          'html' => [
            'label' => ts("Group"),
          ],
          'add' => '1.8',
        ],
        'rule_table' => [
          'name' => 'rule_table',
          'type' => CRM_Utils_Type::T_STRING,
          'title' => ts('Rule Table'),
          'description' => ts('The name of the table this rule is about'),
          'required' => TRUE,
          'maxlength' => 64,
          'size' => CRM_Utils_Type::BIG,
          'usage' => [
            'import' => FALSE,
            'export' => FALSE,
            'duplicate_matching' => FALSE,
            'token' => FALSE,
          ],
          'where' => 'civicrm_dedupe_rule.rule_table',
          'table_name' => 'civicrm_dedupe_rule',
          'entity' => 'DedupeRule',
          'bao' => 'CRM_Dedupe_BAO_DedupeRule',
          'localizable' => 0,
          'add' => '1.8',
        ],
        'rule_field' => [
          'name' => 'rule_field',
          'type' => CRM_Utils_Type::T_STRING,
          'title' => ts('Rule Field'),
          'description' => ts('The name of the field of the table referenced in rule_table'),
          'required' => TRUE,
          'maxlength' => 64,
          'size' => CRM_Utils_Type::BIG,
          'usage' => [
            'import' => FALSE,
            'export' => FALSE,
            'duplicate_matching' => FALSE,
            'token' => FALSE,
          ],
          'where' => 'civicrm_dedupe_rule.rule_field',
          'table_name' => 'civicrm_dedupe_rule',
          'entity' => 'DedupeRule',
          'bao' => 'CRM_Dedupe_BAO_DedupeRule',
          'localizable' => 0,
          'add' => '1.8',
        ],
        'rule_length' => [
          'name' => 'rule_length',
          'type' => CRM_Utils_Type::T_INT,
          'title' => ts('Rule Length'),
          'description' => ts('The length of the matching substring'),
          'usage' => [
            'import' => FALSE,
            'export' => FALSE,
            'duplicate_matching' => FALSE,
            'token' => FALSE,
          ],
          'where' => 'civicrm_dedupe_rule.rule_length',
          'table_name' => 'civicrm_dedupe_rule',
          'entity' => 'DedupeRule',
          'bao' => 'CRM_Dedupe_BAO_DedupeRule',
          'localizable' => 0,
          'html' => [
            'type' => 'Text',
          ],
          'add' => '1.8',
        ],
        'rule_weight' => [
          'name' => 'rule_weight',
          'type' => CRM_Utils_Type::T_INT,
          'title' => ts('Order'),
          'description' => ts('The weight of the rule'),
          'required' => TRUE,
          'usage' => [
            'import' => FALSE,
            'export' => FALSE,
            'duplicate_matching' => FALSE,
            'token' => FALSE,
          ],
          'where' => 'civicrm_dedupe_rule.rule_weight',
          'table_name' => 'civicrm_dedupe_rule',
          'entity' => 'DedupeRule',
          'bao' => 'CRM_Dedupe_BAO_DedupeRule',
          'localizable' => 0,
          'html' => [
            'type' => 'Text',
          ],
          'add' => '1.8',
        ],
      ];
      CRM_Core_DAO_AllCoreTables::invoke(__CLASS__, 'fields_callback', Civi::$statics[__CLASS__]['fields']);
    }
    return Civi::$statics[__CLASS__]['fields'];
  }

  /**
   * Returns the list of fields that can be imported
   *
   * @param bool $prefix
   *
   * @return array
   */
  public static function &import($prefix = FALSE) {
    $r = CRM_Core_DAO_AllCoreTables::getImports(__CLASS__, 'dedupe_rule', $prefix, []);
    return $r;
  }

  /**
   * Returns the list of fields that can be exported
   *
   * @param bool $prefix
   *
   * @return array
   */
  public static function &export($prefix = FALSE) {
    $r = CRM_Core_DAO_AllCoreTables::getExports(__CLASS__, 'dedupe_rule', $prefix, []);
    return $r;
  }

  /**
   * Returns the list of indices
   *
   * @param bool $localize
   *
   * @return array
   */
  public static function indices($localize = TRUE) {
    $indices = [];
    return ($localize && !empty($indices)) ? CRM_Core_DAO_AllCoreTables::multilingualize(__CLASS__, $indices) : $indices;
  }

}
