<?php

/**
 * @package CRM
 * @copyright CiviCRM LLC https://civicrm.org/licensing
 *
 * Generated from xml/schema/CRM/Event/ParticipantStatusType.xml
 * DO NOT EDIT.  Generated by CRM_Core_CodeGen
 * (GenCodeChecksum:347f317d7b8a3cb912c7274b62f7f555)
 */

/**
 * Database access object for the ParticipantStatusType entity.
 */
class CRM_Event_DAO_ParticipantStatusType extends CRM_Core_DAO {
  const EXT = 'civicrm';
  const TABLE_ADDED = '3.0';
  const COMPONENT = 'CiviEvent';

  /**
   * Static instance to hold the table name.
   *
   * @var string
   */
  public static $_tableName = 'civicrm_participant_status_type';

  /**
   * Field to show when displaying a record.
   *
   * @var string
   */
  public static $_labelField = 'label';

  /**
   * Should CiviCRM log any modifications to this table in the civicrm_log table.
   *
   * @var bool
   */
  public static $_log = TRUE;

  /**
   * Paths for accessing this entity in the UI.
   *
   * @var string[]
   */
  protected static $_paths = [
    'add' => 'civicrm/admin/participant_status?action=add&reset=1',
    'update' => 'civicrm/admin/participant_status?action=update&id=[id]&reset=1',
    'delete' => 'civicrm/admin/participant_status?action=delete&id=[id]&reset=1',
  ];

  /**
   * unique participant status type id
   *
   * @var int|string|null
   *   (SQL type: int unsigned)
   *   Note that values will be retrieved from the database as a string.
   */
  public $id;

  /**
   * non-localized name of the status type
   *
   * @var string|null
   *   (SQL type: varchar(64))
   *   Note that values will be retrieved from the database as a string.
   */
  public $name;

  /**
   * localized label for display of this status type
   *
   * @var string|null
   *   (SQL type: varchar(255))
   *   Note that values will be retrieved from the database as a string.
   */
  public $label;

  /**
   * the general group of status type this one belongs to
   *
   * @var string|null
   *   (SQL type: varchar(8))
   *   Note that values will be retrieved from the database as a string.
   */
  public $class;

  /**
   * whether this is a status type required by the system
   *
   * @var bool|string
   *   (SQL type: tinyint)
   *   Note that values will be retrieved from the database as a string.
   */
  public $is_reserved;

  /**
   * whether this status type is active
   *
   * @var bool|string
   *   (SQL type: tinyint)
   *   Note that values will be retrieved from the database as a string.
   */
  public $is_active;

  /**
   * whether this status type is counted against event size limit
   *
   * @var bool|string
   *   (SQL type: tinyint)
   *   Note that values will be retrieved from the database as a string.
   */
  public $is_counted;

  /**
   * controls sort order
   *
   * @var int|string
   *   (SQL type: int unsigned)
   *   Note that values will be retrieved from the database as a string.
   */
  public $weight;

  /**
   * whether the status type is visible to the public, an implicit foreign key to option_value.value related to the `visibility` option_group
   *
   * @var int|string|null
   *   (SQL type: int unsigned)
   *   Note that values will be retrieved from the database as a string.
   */
  public $visibility_id;

  /**
   * Class constructor.
   */
  public function __construct() {
    $this->__table = 'civicrm_participant_status_type';
    parent::__construct();
  }

  /**
   * Returns localized title of this entity.
   *
   * @param bool $plural
   *   Whether to return the plural version of the title.
   */
  public static function getEntityTitle($plural = FALSE) {
    return $plural ? ts('Participant Status Types') : ts('Participant Status Type');
  }

  /**
   * Returns all the column names of this table
   *
   * @return array
   */
  public static function &fields() {
    if (!isset(Civi::$statics[__CLASS__]['fields'])) {
      Civi::$statics[__CLASS__]['fields'] = [
        'id' => [
          'name' => 'id',
          'type' => CRM_Utils_Type::T_INT,
          'title' => ts('Participant Status Type ID'),
          'description' => ts('unique participant status type id'),
          'required' => TRUE,
          'usage' => [
            'import' => FALSE,
            'export' => FALSE,
            'duplicate_matching' => FALSE,
            'token' => FALSE,
          ],
          'where' => 'civicrm_participant_status_type.id',
          'table_name' => 'civicrm_participant_status_type',
          'entity' => 'ParticipantStatusType',
          'bao' => 'CRM_Event_BAO_ParticipantStatusType',
          'localizable' => 0,
          'html' => [
            'type' => 'Number',
          ],
          'readonly' => TRUE,
          'add' => '3.0',
        ],
        'participant_status' => [
          'name' => 'name',
          'type' => CRM_Utils_Type::T_STRING,
          'title' => ts('Participant Status'),
          'description' => ts('non-localized name of the status type'),
          'maxlength' => 64,
          'size' => CRM_Utils_Type::BIG,
          'usage' => [
            'import' => TRUE,
            'export' => TRUE,
            'duplicate_matching' => TRUE,
            'token' => FALSE,
          ],
          'import' => TRUE,
          'where' => 'civicrm_participant_status_type.name',
          'export' => TRUE,
          'table_name' => 'civicrm_participant_status_type',
          'entity' => 'ParticipantStatusType',
          'bao' => 'CRM_Event_BAO_ParticipantStatusType',
          'localizable' => 0,
          'add' => '3.0',
        ],
        'label' => [
          'name' => 'label',
          'type' => CRM_Utils_Type::T_STRING,
          'title' => ts('Participant Status Label'),
          'description' => ts('localized label for display of this status type'),
          'maxlength' => 255,
          'size' => CRM_Utils_Type::HUGE,
          'usage' => [
            'import' => FALSE,
            'export' => FALSE,
            'duplicate_matching' => FALSE,
            'token' => FALSE,
          ],
          'where' => 'civicrm_participant_status_type.label',
          'table_name' => 'civicrm_participant_status_type',
          'entity' => 'ParticipantStatusType',
          'bao' => 'CRM_Event_BAO_ParticipantStatusType',
          'localizable' => 1,
          'add' => '3.0',
        ],
        'class' => [
          'name' => 'class',
          'type' => CRM_Utils_Type::T_STRING,
          'title' => ts('Participant Status Class'),
          'description' => ts('the general group of status type this one belongs to'),
          'maxlength' => 8,
          'size' => CRM_Utils_Type::EIGHT,
          'usage' => [
            'import' => FALSE,
            'export' => FALSE,
            'duplicate_matching' => FALSE,
            'token' => FALSE,
          ],
          'where' => 'civicrm_participant_status_type.class',
          'table_name' => 'civicrm_participant_status_type',
          'entity' => 'ParticipantStatusType',
          'bao' => 'CRM_Event_BAO_ParticipantStatusType',
          'localizable' => 0,
          'html' => [
            'type' => 'Select',
          ],
          'pseudoconstant' => [
            'callback' => 'CRM_Event_PseudoConstant::participantStatusClassOptions',
          ],
          'add' => '3.0',
        ],
        'is_reserved' => [
          'name' => 'is_reserved',
          'type' => CRM_Utils_Type::T_BOOLEAN,
          'title' => ts('Participant Status Is Reserved?>'),
          'description' => ts('whether this is a status type required by the system'),
          'required' => TRUE,
          'usage' => [
            'import' => FALSE,
            'export' => FALSE,
            'duplicate_matching' => FALSE,
            'token' => FALSE,
          ],
          'where' => 'civicrm_participant_status_type.is_reserved',
          'default' => '0',
          'table_name' => 'civicrm_participant_status_type',
          'entity' => 'ParticipantStatusType',
          'bao' => 'CRM_Event_BAO_ParticipantStatusType',
          'localizable' => 0,
          'add' => '3.0',
        ],
        'is_active' => [
          'name' => 'is_active',
          'type' => CRM_Utils_Type::T_BOOLEAN,
          'title' => ts('Participant Status is Active'),
          'description' => ts('whether this status type is active'),
          'required' => TRUE,
          'usage' => [
            'import' => FALSE,
            'export' => FALSE,
            'duplicate_matching' => FALSE,
            'token' => FALSE,
          ],
          'where' => 'civicrm_participant_status_type.is_active',
          'default' => '1',
          'table_name' => 'civicrm_participant_status_type',
          'entity' => 'ParticipantStatusType',
          'bao' => 'CRM_Event_BAO_ParticipantStatusType',
          'localizable' => 0,
          'html' => [
            'type' => 'CheckBox',
            'label' => ts("Enabled"),
          ],
          'add' => '3.0',
        ],
        'is_counted' => [
          'name' => 'is_counted',
          'type' => CRM_Utils_Type::T_BOOLEAN,
          'title' => ts('Participant Status Counts?'),
          'description' => ts('whether this status type is counted against event size limit'),
          'required' => TRUE,
          'usage' => [
            'import' => FALSE,
            'export' => FALSE,
            'duplicate_matching' => FALSE,
            'token' => FALSE,
          ],
          'where' => 'civicrm_participant_status_type.is_counted',
          'default' => '0',
          'table_name' => 'civicrm_participant_status_type',
          'entity' => 'ParticipantStatusType',
          'bao' => 'CRM_Event_BAO_ParticipantStatusType',
          'localizable' => 0,
          'add' => '3.0',
        ],
        'weight' => [
          'name' => 'weight',
          'type' => CRM_Utils_Type::T_INT,
          'title' => ts('Order'),
          'description' => ts('controls sort order'),
          'required' => TRUE,
          'usage' => [
            'import' => FALSE,
            'export' => FALSE,
            'duplicate_matching' => FALSE,
            'token' => FALSE,
          ],
          'where' => 'civicrm_participant_status_type.weight',
          'table_name' => 'civicrm_participant_status_type',
          'entity' => 'ParticipantStatusType',
          'bao' => 'CRM_Event_BAO_ParticipantStatusType',
          'localizable' => 0,
          'add' => '3.0',
        ],
        'visibility_id' => [
          'name' => 'visibility_id',
          'type' => CRM_Utils_Type::T_INT,
          'title' => ts('Participant Status Visibility'),
          'description' => ts('whether the status type is visible to the public, an implicit foreign key to option_value.value related to the `visibility` option_group'),
          'usage' => [
            'import' => FALSE,
            'export' => FALSE,
            'duplicate_matching' => FALSE,
            'token' => FALSE,
          ],
          'where' => 'civicrm_participant_status_type.visibility_id',
          'table_name' => 'civicrm_participant_status_type',
          'entity' => 'ParticipantStatusType',
          'bao' => 'CRM_Event_BAO_ParticipantStatusType',
          'localizable' => 0,
          'html' => [
            'type' => 'Select',
          ],
          'pseudoconstant' => [
            'optionGroupName' => 'visibility',
            'optionEditPath' => 'civicrm/admin/options/visibility',
          ],
          'add' => '3.0',
        ],
      ];
      CRM_Core_DAO_AllCoreTables::invoke(__CLASS__, 'fields_callback', Civi::$statics[__CLASS__]['fields']);
    }
    return Civi::$statics[__CLASS__]['fields'];
  }

  /**
   * Returns the list of fields that can be imported
   *
   * @param bool $prefix
   *
   * @return array
   */
  public static function &import($prefix = FALSE) {
    $r = CRM_Core_DAO_AllCoreTables::getImports(__CLASS__, 'participant_status_type', $prefix, []);
    return $r;
  }

  /**
   * Returns the list of fields that can be exported
   *
   * @param bool $prefix
   *
   * @return array
   */
  public static function &export($prefix = FALSE) {
    $r = CRM_Core_DAO_AllCoreTables::getExports(__CLASS__, 'participant_status_type', $prefix, []);
    return $r;
  }

  /**
   * Returns the list of indices
   *
   * @param bool $localize
   *
   * @return array
   */
  public static function indices($localize = TRUE) {
    $indices = [];
    return ($localize && !empty($indices)) ? CRM_Core_DAO_AllCoreTables::multilingualize(__CLASS__, $indices) : $indices;
  }

}
