-- +--------------------------------------------------------------------+
-- | Copyright CiviCRM LLC. All rights reserved.                        |
-- |                                                                    |
-- | This work is published under the GNU AGPLv3 license with some      |
-- | permitted exceptions and without any warranty. For full license    |
-- | and copyright information, see https://civicrm.org/licensing       |
-- +--------------------------------------------------------------------+
--
-- Generated from schema.tpl
-- DO NOT EDIT.  Generated by CRM_Core_CodeGen
--
-- /*******************************************************
-- *
-- * Clean up the existing tables - this section generated from drop.tpl
-- *
-- *******************************************************/

SET FOREIGN_KEY_CHECKS=0;

DROP TABLE IF EXISTS `civicrm_grant`;

SET FOREIGN_KEY_CHECKS=1;
-- /*******************************************************
-- *
-- * Create new tables
-- *
-- *******************************************************/

-- /*******************************************************
-- *
-- * civicrm_grant
-- *
-- * This table stores information about grants given to a contact.
-- *
-- *******************************************************/
CREATE TABLE `civicrm_grant` (
  `id` int unsigned NOT NULL AUTO_INCREMENT COMMENT 'Unique Grant id',
  `contact_id` int unsigned NOT NULL COMMENT 'Contact ID of contact record given grant belongs to.',
  `application_received_date` date COMMENT 'Date on which grant application was received by donor.',
  `decision_date` date COMMENT 'Date on which grant decision was made.',
  `money_transfer_date` date COMMENT 'Date on which grant money transfer was made.',
  `grant_due_date` date COMMENT 'Date on which grant report is due.',
  `grant_report_received` tinyint NOT NULL DEFAULT 0 COMMENT 'Yes/No field stating whether grant report was received by donor.',
  `grant_type_id` int unsigned NOT NULL COMMENT 'Type of grant. Implicit FK to civicrm_option_value in grant_type option_group.',
  `amount_total` decimal(20,2) NOT NULL COMMENT 'Requested grant amount, in default currency.',
  `amount_requested` decimal(20,2) COMMENT 'Requested grant amount, in original currency (optional).',
  `amount_granted` decimal(20,2) COMMENT 'Granted amount, in default currency.',
  `currency` varchar(3) NOT NULL COMMENT '3 character string, value from config setting or input via user.',
  `rationale` text COMMENT 'Grant rationale.',
  `status_id` int unsigned NOT NULL COMMENT 'ID of Grant status.',
  `financial_type_id` int unsigned DEFAULT NULL COMMENT 'FK to Financial Type.',
  PRIMARY KEY (`id`),
  INDEX `index_grant_type_id`(grant_type_id),
  INDEX `index_status_id`(status_id),
  CONSTRAINT FK_civicrm_grant_contact_id FOREIGN KEY (`contact_id`) REFERENCES `civicrm_contact`(`id`) ON DELETE CASCADE,
  CONSTRAINT FK_civicrm_grant_financial_type_id FOREIGN KEY (`financial_type_id`) REFERENCES `civicrm_financial_type`(`id`) ON DELETE SET NULL
)
ENGINE=InnoDB DEFAULT CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci ROW_FORMAT=DYNAMIC;
