<?php
use CRM_Standaloneusers_ExtensionUtil as E;

return [
  [
    'name' => 'SavedSearch_Users',
    'entity' => 'SavedSearch',
    'cleanup' => 'always',
    'update' => 'unmodified',
    'params' => [
      'version' => 4,
      'values' => [
        'name' => 'Users',
        'label' => E::ts('Administer User accounts'),
        'api_entity' => 'User',
        'api_params' => [
          'version' => 4,
          'select' => [
            'id',
            'username',
            'uf_name',
            'contact_id',
            'contact_id.display_name',
            'is_active',
            'when_created',
            'when_last_accessed',
            'roles:label',
          ],
          'orderBy' => [],
          'where' => [],
          'groupBy' => [],
          'join' => [],
          'having' => [],
        ],
      ],
      'match' => [
        'name',
      ],
    ],
  ],
  [
    'name' => 'SavedSearch_Users_SearchDisplay_Users',
    'entity' => 'SearchDisplay',
    'cleanup' => 'always',
    'update' => 'unmodified',
    'params' => [
      'version' => 4,
      'values' => [
        'name' => 'Users',
        'label' => E::ts('Administer User accounts'),
        'saved_search_id.name' => 'Users',
        'type' => 'table',
        'settings' => [
          'description' => NULL,
          'sort' => [
            [
              'username',
              'ASC',
            ],
          ],
          'limit' => 50,
          'pager' => [],
          'placeholder' => 5,
          'columns' => [
            [
              'type' => 'field',
              'key' => 'username',
              'dataType' => 'String',
              'label' => E::ts('Username'),
              'sortable' => TRUE,
              'link' => [
                'entity' => 'User',
                'action' => 'update',
                'join' => '',
                'target' => 'crm-popup',
              ],
            ],
            [
              'type' => 'field',
              'key' => 'uf_name',
              'dataType' => 'String',
              'label' => E::ts('Email'),
              'sortable' => TRUE,
            ],
            [
              'type' => 'field',
              'key' => 'roles:label',
              'dataType' => 'String',
              'label' => E::ts('Roles'),
              'sortable' => TRUE,
            ],
            [
              'type' => 'field',
              'key' => 'contact_id.display_name',
              'dataType' => 'String',
              'label' => E::ts('Linked Contact'),
              'sortable' => TRUE,
              'link' => [
                'entity' => 'Contact',
                'action' => 'view',
                'join' => 'contact_id',
                'target' => '_blank',
              ],
            ],
            [
              'type' => 'field',
              'key' => 'is_active',
              'dataType' => 'Boolean',
              'label' => E::ts('Enabled'),
              'sortable' => TRUE,
              'editable' => TRUE,
            ],
            [
              'type' => 'field',
              'key' => 'when_created',
              'dataType' => 'Timestamp',
              'label' => E::ts('Created'),
              'sortable' => TRUE,
            ],
            [
              'type' => 'field',
              'key' => 'when_last_accessed',
              'dataType' => 'Timestamp',
              'label' => E::ts('Last Accessed'),
              'sortable' => TRUE,
            ],
            [
              'text' => '',
              'style' => 'default',
              'size' => 'btn-xs',
              'icon' => 'fa-bars',
              'links' => [
                [
                  'entity' => 'User',
                  'action' => 'update',
                  'join' => '',
                  'target' => 'crm-popup',
                  'icon' => 'fa-pencil',
                  'text' => E::ts('Edit'),
                  'style' => 'default',
                  'path' => '',
                  'task' => '',
                  'condition' => [],
                ],
                [
                  'task' => 'disable',
                  'entity' => 'User',
                  'join' => '',
                  'target' => 'crm-popup',
                  'icon' => 'fa-toggle-off',
                  'text' => E::ts('Disable'),
                  'style' => 'default',
                  'path' => '',
                  'action' => '',
                  'condition' => [],
                ],
                [
                  'task' => 'enable',
                  'entity' => 'User',
                  'join' => '',
                  'target' => 'crm-popup',
                  'icon' => 'fa-toggle-on',
                  'text' => E::ts('Enable'),
                  'style' => 'default',
                  'path' => '',
                  'action' => '',
                  'condition' => [],
                ],
                [
                  'task' => 'delete',
                  'entity' => 'User',
                  'join' => '',
                  'target' => 'crm-popup',
                  'icon' => 'fa-trash',
                  'text' => E::ts('Delete'),
                  'style' => 'danger',
                  'path' => '',
                  'action' => '',
                  'condition' => [],
                ],
              ],
              'type' => 'menu',
              'alignment' => 'text-right',
            ],
          ],
          'actions' => [
            'delete',
            'disable',
            'download',
            'enable',
          ],
          'classes' => [
            'table',
            'table-striped',
          ],
          'toolbar' => [
            [
              'path' => '/civicrm/admin/user#',
              'text' => E::ts('Add User'),
              'icon' => 'fa-plus',
              'style' => 'primary',
              'task' => '',
              'entity' => '',
              'action' => '',
              'join' => '',
              'target' => '',
              'condition' => [],
            ],
          ],
          'button' => NULL,
        ],
      ],
      'match' => [
        'saved_search_id',
        'name',
      ],
    ],
  ],
];
